/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel;

import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDump;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpClassCache;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpHandler;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpRecord;
import com.ibm.jvm.j9.dump.systemdump.J9Object;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LongObjectRecord
extends PortableHeapDumpRecord {
    public static final byte MAGIC_NUMBER = 4;
    protected byte gapSize;
    protected byte sizeOfReference;
    protected boolean pinned;
    protected boolean dosed;
    protected boolean hashedandmoved;
    protected boolean hashed;
    protected long addressofClass;
    protected long gapPreceding;

    public LongObjectRecord(J9Object current, J9Object previous) {
        this.tag = (byte)4;
        this.setReferences(current);
        this.addressofClass = current.getClassForObject().getClassAddress();
        this.gapPreceding = LongObjectRecord.getAddressDifference(current, previous);
        this.gapSize = LongObjectRecord.sizeofReference(this.gapPreceding);
    }

    public void writeHeapDump(DataOutput dos) throws IOException {
        dos.writeByte(this.tag);
        int flag = 0;
        flag = (byte)(flag | this.gapSize << 6);
        if (PortableHeapDump.DEBUG) {
            PortableHeapDump.DEBUG_STREAM.print("gapSize = " + this.gapSize);
        }
        flag = (byte)(flag | this.referenceSize << 4);
        if (this.pinned) {
            flag = (byte)(flag | 8);
        }
        if (this.dosed) {
            flag = (byte)(flag | 4);
        }
        if (this.hashedandmoved) {
            flag = (byte)(flag | 2);
        }
        if (this.hashed) {
            flag = (byte)(flag | 1);
        }
        dos.writeByte(flag);
        this.writeReference(dos, this.gapSize, this.gapPreceding);
        if (PortableHeapDump.is32bit()) {
            dos.writeInt((int)this.addressofClass);
        } else {
            dos.writeLong(this.addressofClass);
        }
        if (PortableHeapDump.DEBUG) {
            PortableHeapDump.DEBUG_STREAM.print(" addressOfClass = " + this.addressofClass);
        }
        if (PortableHeapDump.isJ9()) {
            dos.writeShort(this.hashCode);
        } else if (this.hashedandmoved || this.hashed) {
            dos.writeInt(this.hashCode);
        }
        dos.writeInt(this.References.length);
        if (PortableHeapDump.DEBUG) {
            PortableHeapDump.DEBUG_STREAM.println("num of ref = " + this.References.length);
        }
        this.writeReferences(dos);
    }

    public static long readHeapDump(DataInput dis, byte magic, PortableHeapDumpHandler phdh, long previousAddress, PortableHeapDumpClassCache phdcc) {
        long result = 0L;
        try {
            byte flag = dis.readByte();
            byte gapSize = (byte)((flag & 0xC0) >>> 6);
            byte referenceSize = (byte)((flag & 0x30) >>> 4);
            result = PortableHeapDumpRecord.readReference(dis, gapSize, previousAddress);
            long classAddress = 0L;
            classAddress = PortableHeapDump.is32bit() ? (long)dis.readInt() : dis.readLong();
            phdcc.setClassCacheIndex(classAddress);
            dis.readShort();
            int lengthofRef = dis.readInt();
            long[] references = PortableHeapDumpRecord.readReferences(dis, result, referenceSize, lengthofRef);
            phdh.object(result, classAddress, references);
        }
        catch (Exception e) {
            phdh.exceptionDetected(e);
        }
        return result;
    }
}

