/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command;

import com.ibm.jvm.j9.dump.command.Command;
import com.ibm.jvm.j9.dump.command.CommandDetails;
import com.ibm.jvm.j9.dump.command.CommandPlugin;
import com.ibm.jvm.j9.dump.command.DumpBaseCmds;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpBaseCmds;
import com.ibm.jvm.j9.dump.command.trace.J9JVMBaseTraceCommands;
import com.ibm.jvm.j9.dump.commandconsole.Console;
import com.ibm.jvm.j9.dump.commandconsole.DumpConsole;
import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.commandconsole.DvNamesIndexFile;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.commandconsole.J9XMLHandler;
import com.ibm.jvm.j9.dump.saxhandler.GenericSaxHandler;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.GenericThread;
import com.ibm.jvm.j9.dump.systemdump.J9Class;
import com.ibm.jvm.j9.dump.systemdump.J9Heap;
import com.ibm.jvm.j9.dump.systemdump.J9Jvm;
import com.ibm.jvm.j9.dump.systemdump.J9Method;
import com.ibm.jvm.j9.dump.systemdump.J9Monitor;
import com.ibm.jvm.j9.dump.systemdump.J9Object;
import com.ibm.jvm.j9.dump.systemdump.J9ObjectIterator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Observer;
import java.util.Set;
import java.util.Vector;
import org.xml.sax.SAXException;

public class J9JVMBaseCmds
extends CommandPlugin {
    private boolean JUSTATEST = false;
    private Observer observer;
    private J9JVMBaseCmds mySelf = this;
    private Command[] myCommands;
    private Command[] commandsPostSetMetadata;
    private static boolean allocBitsDone;
    private static boolean setMetaDataDone;
    private static J9JVMBaseTraceCommands traceProcessor;

    public J9JVMBaseCmds() {
        int numCommands = 1;
        this.myCommands = new Command[numCommands];
        this.myCommands[0] = new Command("set", "metadata", this.mySelf, true, true, false, "Identifies xml metadata file - rarely needed)");
        numCommands = 9;
        this.commandsPostSetMetadata = new Command[numCommands];
        this.commandsPostSetMetadata[0] = new Command("dis", "class", this.mySelf, true, true, false, "Display details for a  class (fields,methods,statics)");
        this.commandsPostSetMetadata[1] = new Command("dis", "object", this.mySelf, true, true, true, "Display details of an object instance");
        this.commandsPostSetMetadata[2] = new Command("dis", "cls", this.mySelf, true, true, false, "Display class summary ");
        this.commandsPostSetMetadata[3] = new Command("dis", "os", this.mySelf, true, true, false, "Identify and record all objects in known heaps");
        this.commandsPostSetMetadata[4] = new Command("dis", "ls", this.mySelf, true, true, false, "Display a summary of all the locks");
        this.commandsPostSetMetadata[5] = new Command("dis", "lo", this.mySelf, true, true, false, "Display locked objects");
        this.commandsPostSetMetadata[6] = new Command("deadlock", "*", this.mySelf, true, true, true, "Analyse locks to detect deadlock");
        this.commandsPostSetMetadata[7] = new Command("trace", "*", this.mySelf, true, true, false, "Trace commands - use \"help trace\" for more info");
        this.commandsPostSetMetadata[8] = new Command("dis", "jitm", this.mySelf, true, true, true, "Display jitted methods");
    }

    public String go(String input, String origInput) {
        String retString = null;
        CommandDetails cd = new CommandDetails(input);
        String verb = cd.getVerb();
        String noun = cd.getNoun();
        if (verb.equals("SET") && noun.equals("METADATA")) {
            retString = this.doSetMetadata(cd.getRest());
        } else if (verb.equals("DIS") && noun.equals("CLASS")) {
            retString = this.doDisplayClass(cd.getRest());
        } else if (verb.equals("DIS") && noun.equals("CLS")) {
            retString = this.doDisplayClassSummary(cd.getRest());
        } else if (verb.equals("DIS") && noun.equals("OBJECT")) {
            retString = this.doDisplayObject(cd.getRest());
        } else if (verb.equals("DIS") && noun.equals("OS")) {
            retString = null == cd.getRest() || cd.getRest().equals("") ? this.doDisplayObjectSummary() : this.doDisplayObjectSummary(cd.getRest());
        } else if (verb.equals("DIS") && noun.equals("LS")) {
            retString = this.doDisplayMonitorSummary();
        } else if (verb.equals("DIS") && noun.equals("JITM")) {
            retString = this.doDisplayJittedMethods();
        } else if (verb.equals("DEADLOCK")) {
            retString = this.doDeadlock();
        } else if (verb.equals("DIS") && noun.equals("LO")) {
            retString = this.doDisplayMonitorDetail(cd.getRest());
        } else if (verb.equals("TRACE")) {
            retString = this.doTrace(cd);
        }
        return retString;
    }

    public String cleanUp() {
        DvNamesIndexFile.closeDataFile();
        return null;
    }

    public Command[] getCommandSet() {
        return this.myCommands;
    }

    private String doSetMetadata(String filename) {
        String retString = null;
        if (setMetaDataDone) {
            return "\"set metadata\" has already been done for this session";
        }
        try {
            File gshFile = new File(filename);
            if (J9JVMBaseCmds.checkXML(gshFile)) {
                GenericSaxHandler gsh = new GenericSaxHandler(gshFile, new J9XMLHandler(), this);
                Console.setProperty("metadata", filename);
                setMetaDataDone = true;
            } else {
                retString = " File not valid xml - needs to exist and start \"<?xml version=\"";
            }
        }
        catch (SAXException saxExeption) {
            retString = "*** Fatal SAXException detected\n    This may affect the viability of commands that depend on xml (such as \"dis os\").";
            setMetaDataDone = true;
        }
        catch (FileNotFoundException fnfe) {
            String workdir = Console.getProperty("WORKDIR");
            retString = null != workdir && !filename.startsWith(workdir) ? this.doSetMetadata(workdir + File.separator + filename) : "File \"" + filename + "\" not found";
        }
        if (setMetaDataDone) {
            Vector threads;
            Dump theDump = DumpConsole.getTheDump();
            J9Jvm jvm = theDump.getCurrentJvm();
            if (null != jvm && (threads = jvm.getThreads()).size() > 0) {
                String failingThreadID = J9JVMConsole.getFailingThreadId();
                GenericThread failingThread = null;
                if (null != failingThreadID) {
                    for (GenericThread t : threads) {
                        String tid = t.getThreadId().toUpperCase();
                        if (!tid.equals(failingThreadID)) continue;
                        failingThread = t;
                        break;
                    }
                } else {
                    failingThread = (GenericThread)threads.get(0);
                }
                DumpBaseCmds.setCurrentThread(failingThread);
            }
            if (null != GenericSaxHandler.getGpfSb()) {
                this.notifyObservers("\n\nGPF details\n=====================\n\n");
                this.notifyObservers(GenericSaxHandler.getGpfSb());
                this.notifyObservers("\n\n!!!! WARNING - WARNING - WARNING !!!!\n");
                this.notifyObservers("As this dump was produced due to a General Protection Fault (gpf)");
                this.notifyObservers("it is possible that there will have been errors found when analysing");
                this.notifyObservers("the dump with jextract. Jdmpview may also encounter errors in its analysis.");
                this.notifyObservers("You may observe other error messages being issued within this session");
                this.notifyObservers("\n!!!! WARNING - WARNING - WARNING !!!!\n");
            }
            DumpConsole.addInAdditionalCommands(this.commandsPostSetMetadata, this);
        }
        return retString;
    }

    private String doDisplayClass(String whatClass) {
        String retString = null;
        J9Class theClass = J9JVMConsole.getClass(whatClass);
        if (null == theClass) {
            retString = " Cannot find a class called \"" + whatClass + "\"";
        } else {
            String s = theClass.toString();
            this.notifyObservers(s);
        }
        return retString;
    }

    private String doDisplayObject(String whatClass) {
        String retString = null;
        long[] classInstances = null;
        String incoming = whatClass.trim().toUpperCase();
        boolean bItsAddress = false;
        long address = 0L;
        if (incoming.startsWith("0X")) {
            incoming = DumpUtils.stripOff0x(incoming);
            try {
                address = DumpUtils.parseLongHex(incoming);
                bItsAddress = true;
            }
            catch (NumberFormatException nfe) {
                this.notifyObservers(" " + whatClass + " is invalid");
                return retString;
            }
        }
        String className = whatClass.trim();
        classInstances = J9JVMConsole.getNamesFile().getInstancesForClass(className);
        if (null != classInstances) {
            bItsAddress = false;
        } else {
            try {
                address = DumpUtils.parseLongHex(className);
                bItsAddress = true;
            }
            catch (NumberFormatException nfe) {
                this.notifyObservers(" " + whatClass + " is invalid");
                return retString;
            }
        }
        if (bItsAddress) {
            J9Object object = J9Heap.checkForObject(address);
            if (null != object) {
                this.notifyObservers(object.toString());
            } else {
                this.notifyObservers("\n 0x" + Long.toHexString(address) + " not recognized as a valid object");
            }
        } else {
            for (int i = 0; i < classInstances.length; ++i) {
                J9Object object = J9Heap.checkForObject(classInstances[i]);
                if (null != object) {
                    this.notifyObservers(object.toString());
                } else {
                    this.notifyObservers("\n 0x" + Long.toHexString(address) + " not recognized as a valid object");
                }
                this.notifyObservers("\n====================================================");
            }
        }
        return retString;
    }

    private String doDisplayMonitorSummary() {
        String retString = null;
        StringBuffer sb = new StringBuffer();
        sb.append(" Monitor Summary\n ==============");
        Vector v = J9JVMConsole.getKnownMonitors();
        Iterator<Object> iter = v.iterator();
        this.notifyObservers("\n Known Monitors....\n");
        while (iter.hasNext()) {
            J9Monitor monitor = (J9Monitor)iter.next();
            this.notifyObservers(monitor.toString());
        }
        this.notifyObservers("\n\n Locked Objects.....\n");
        iter = J9JVMConsole.getLockedObjectsByAddress().keySet().iterator();
        while (iter.hasNext()) {
            long lockedObjAddr = (Long)iter.next();
            J9Object lockedObj = new J9Object(lockedObjAddr, -1);
            this.notifyObservers(lockedObj.getClassForObject().getName() + "@0x" + Long.toHexString(lockedObj.getObjectAddress()) + " is Locked by thread with id 0x" + Long.toHexString(lockedObj.getLockInfo() >>> 4 << 4));
        }
        this.notifyObservers("\n Finished lock summary");
        return retString;
    }

    private String doDisplayMonitorDetail(String whatMonitor) {
        String retString = null;
        return retString;
    }

    private String doDisplayJittedMethods() {
        Set classes = J9JVMConsole.getKnownClassesByName().keySet();
        Object[] sa = new String[classes.size()];
        Iterator iter = classes.iterator();
        int i = 0;
        while (iter.hasNext()) {
            sa[i] = (String)iter.next();
            ++i;
        }
        Arrays.sort(sa);
        for (i = 0; i < sa.length; ++i) {
            J9Class theClass = (J9Class)J9JVMConsole.getKnownClassesByName().get(sa[i]);
            Vector v = theClass.getMethods();
            if (v == null) continue;
            for (J9Method j9m : v) {
                if (j9m.getJitStart() == 0L) continue;
                StringBuffer sb = new StringBuffer();
                sb.append("\t" + (String)sa[i] + "::" + j9m.getMethodName() + j9m.getSignature() + "  start=0x");
                sb.append(Long.toHexString(j9m.getJitStart()) + "  end=0x");
                sb.append(Long.toHexString(j9m.getJitEnd()));
                this.notifyObservers(sb.toString());
            }
        }
        return "finished \"dis jitm\"";
    }

    private String doTrace(CommandDetails cd) {
        String retString = null;
        String[] traceOptions = new String[]{"FORMAT", "EXTRACT", "SUMMARY", "HELP", "DISPLAY", "THREADS", "ENTRIES", "INDENT", "VERBOSE", "SYMBOLIC", "DATADIR", "SET", "OUTFILENAME", "DIS"};
        String noun = cd.getNoun();
        if (null == noun) {
            noun = "HELP";
        }
        int selection = -1;
        for (int i = 0; i < traceOptions.length && selection == -1; ++i) {
            if (!noun.equals(traceOptions[i])) continue;
            selection = i;
        }
        if (-1 != selection && null == traceProcessor) {
            traceProcessor = new J9JVMBaseTraceCommands(this);
        }
        switch (selection) {
            case 0: {
                retString = traceProcessor.traceFormat(cd.getRest());
                break;
            }
            case 1: {
                retString = traceProcessor.traceExtract(cd.getRest());
                break;
            }
            case 2: {
                retString = traceProcessor.traceSummary(cd.getRest());
                break;
            }
            case 3: {
                retString = "\n\n" + Console.getHelp("TRACE");
                break;
            }
            case 4: 
            case 13: {
                retString = traceProcessor.traceDisplay(cd.getRest());
                break;
            }
            case 5: {
                retString = traceProcessor.traceThreads(cd.getRest());
                break;
            }
            case 6: {
                retString = traceProcessor.traceEntries(cd.getRest());
                break;
            }
            case 7: {
                retString = traceProcessor.traceIVS(noun, cd.getRest());
                break;
            }
            case 8: {
                retString = traceProcessor.traceIVS(noun, cd.getRest());
                break;
            }
            case 9: {
                retString = traceProcessor.traceIVS(noun, cd.getRest());
                break;
            }
            case 10: {
                retString = traceProcessor.traceDatadir(cd.getRest());
                break;
            }
            case 11: {
                retString = traceProcessor.traceSet(cd.getRest());
                break;
            }
            case 12: {
                retString = traceProcessor.traceOutfilename(cd.getRest());
                break;
            }
            default: {
                retString = " Unrecognised TRACE subcommand \"" + noun + "\"\n\n";
                retString = retString + Console.getHelp("TRACE");
            }
        }
        return retString;
    }

    private String doDeadlock() {
        String retString = null;
        Vector<GenericThread> candidates = new Vector<GenericThread>();
        J9Jvm jvm = DumpConsole.getTheDump().getCurrentJvm();
        Vector v = jvm.getThreads();
        for (int i = 0; i < v.size(); ++i) {
            long monId;
            J9Monitor monitor;
            GenericThread t = (GenericThread)v.get(i);
            if (!t.getState().equals("Blocked")) continue;
            String monIdAsString = t.getMonitorId();
            if (null == t.getMonitorId() || 0L == (monitor = J9JVMConsole.getMonitor(monId = DumpUtils.parseLongHex(monIdAsString))).getOwner()) continue;
            candidates.add(t);
        }
        if (candidates.size() == 0) {
            this.notifyObservers("\n\tNo deadlocks detected\n");
        } else {
            boolean bSomethingOutput = false;
            for (int i = 0; i < candidates.size(); ++i) {
                String out = this.checkDeadlockCandidate((GenericThread)candidates.get(i));
                if (null == out) continue;
                this.notifyObservers(out);
                bSomethingOutput = true;
            }
            if (!bSomethingOutput) {
                this.notifyObservers("\n\tNo deadlocks detected\n");
            }
        }
        return retString;
    }

    private String checkDeadlockCandidate(GenericThread thread) {
        String retString = null;
        Vector<GenericThread> chainOfThreads = new Vector<GenericThread>();
        Vector chainOfMonitors = new Vector();
        boolean bFinished = false;
        boolean bLoopFound = false;
        String monIdAsString = thread.getMonitorId();
        long monId = DumpUtils.parseLongHex(monIdAsString);
        J9Monitor monitor = J9JVMConsole.getMonitor(monId);
        chainOfThreads.add(thread);
        int loopPosition = 0;
        while (!bFinished) {
            long owner = monitor.getOwner();
            if (owner == 0L) continue;
            GenericThread t1 = J9JVMConsole.getKnownThread(owner);
            if (null == t1.getMonitorId()) {
                bFinished = true;
                continue;
            }
            for (int i = 0; i < chainOfThreads.size(); ++i) {
                if (t1 != (GenericThread)chainOfThreads.get(i)) continue;
                bLoopFound = true;
                bFinished = true;
                loopPosition = i;
                i = 0x7FFFFFFE;
            }
            if (bLoopFound) {
                retString = this.formulateDeadlockOutput(chainOfThreads, loopPosition);
                continue;
            }
            if (bFinished) continue;
            chainOfThreads.add(t1);
            monId = DumpUtils.parseLongHex(t1.getMonitorId());
            monitor = J9JVMConsole.getMonitor(monId);
        }
        return retString;
    }

    private String formulateDeadlockOutput(Vector chainOfThreads, int loopPosition) {
        StringBuffer sb = new StringBuffer();
        GenericThread thisThread = (GenericThread)chainOfThreads.get(0);
        String monIdAsString = thisThread.getMonitorId();
        long monId = DumpUtils.parseLongHex(monIdAsString);
        J9Monitor monitor = J9JVMConsole.getMonitor(monId);
        String monObject = monitor.getObjectAddrAsString();
        String name = thisThread.getThreadName();
        name = null == name ? "" : " (" + name + ")";
        if (loopPosition != 0) {
            sb.append("\nThread " + thisThread.getThreadId() + name + " \n\t has become hung on a deadlock between two (or more) other threads.");
            sb.append("\n It is trying to obtain a lock on object " + monObject + " using monitor " + monIdAsString);
            Vector v = J9JVMConsole.getLockedObjectsByThread(thisThread);
            if (v != null) {
                sb.append("\n\nThread " + thisThread.getThreadId() + " has locks on the following objects:");
                for (int i = 0; i < v.size(); ++i) {
                    J9Object o = (J9Object)v.get(i);
                    sb.append("\n\t" + o.getClassForObject().getName() + "@0x" + Long.toHexString(o.getObjectAddress()));
                }
            }
        } else {
            sb.append("\nThread " + thisThread.getThreadId() + name + " is participating in a deadlock with " + (chainOfThreads.size() - 1) + " other thread(s).");
            sb.append("\n It is trying to obtain a lock on object " + monObject + " using monitor " + monIdAsString);
            sb.append("\n\nThe other participating thread(s): ");
            for (int i = 1; i < chainOfThreads.size(); ++i) {
                GenericThread partThread = (GenericThread)chainOfThreads.get(i);
                String name1 = partThread.getThreadName();
                name1 = name1 == null ? "" : " (" + name1 + ")";
                sb.append("\n\t\t" + partThread.getThreadId() + "  " + name1);
            }
            Vector v = J9JVMConsole.getLockedObjectsByThread(thisThread);
            if (v != null) {
                sb.append("\n\nThread " + thisThread.getThreadId() + " has locks on the following objects:");
                for (int i = 0; i < v.size(); ++i) {
                    J9Object o = (J9Object)v.get(i);
                    sb.append("\n\t" + o.getClassForObject().getName() + "@0x" + Long.toHexString(o.getObjectAddress()));
                }
            }
            sb.append("\n======================================================");
        }
        return sb.toString();
    }

    private String doDisplayObjectSummary(String className) {
        String retString = null;
        int perLine = 10;
        if (!J9JVMConsole.getTheDump().is32bit()) {
            perLine = 5;
        }
        String dumpName = J9JVMConsole.getTheDump().getDumpName();
        DvNamesIndexFile nif = J9JVMConsole.getNamesFile();
        if (null != nif && nif.isComplete) {
            int count = nif.getInstanceCountForClass(className);
            if (0 == count) {
                retString = "0 object instances for class \"" + className + "\"";
            } else {
                this.notifyObservers("\nThere are " + count + " instances of " + className + " ....\n");
                long[] addresses = nif.getInstancesForClass(className);
                StringBuffer sb = null;
                int lineCount = 0;
                for (int i = 0; i < addresses.length; ++i) {
                    if (null == sb) {
                        sb = new StringBuffer();
                    }
                    sb.append("  0x" + Long.toHexString(addresses[i]));
                    if (perLine != ++lineCount) continue;
                    this.notifyObservers(sb.toString());
                    sb.setLength(0);
                    lineCount = 0;
                }
                if (lineCount > 0) {
                    this.notifyObservers(sb.toString());
                }
            }
        } else {
            retString = "\"dis os\" needs to be run first ";
        }
        return retString;
    }

    private String doDisplayObjectSummary() {
        String retString = null;
        long totalObjectCount = 0L;
        long totalObjectSize = 0L;
        long totalClassCount = 0L;
        long totalClassSize = 0L;
        int totalLockedObjectCount = 0;
        J9Heap[] theHeaps = J9Heap.getTheHeaps();
        if (null == theHeaps) {
            return "\n!!! Error !!! \n   No heaps available to scan. This suggests a problem with the xml file\n   generated by jextract (i.e. no <objects> elements within the xml).\n!!! Error !!! \n";
        }
        String dumpName = J9JVMConsole.getTheDump().getDumpName();
        DvNamesIndexFile nif = J9JVMConsole.getNamesFile();
        if (null == nif || !nif.isComplete) {
            try {
                nif = new DvNamesIndexFile(dumpName, 123456L);
            }
            catch (IOException e) {
                Console.reportError("Unable to create names index file", null);
            }
        }
        J9JVMConsole.setNamesFile(nif);
        this.notifyObservers("\n Names index file in use is: " + J9JVMConsole.getNamesFile().getName() + "\n\n");
        StringBuffer sb = new StringBuffer();
        sb.append(" Heap Summary\n ============");
        sb.append("\n\n  WARNING: It can take a long time to traverse the heaps. - Please be patient");
        this.notifyObservers(sb.toString());
        J9ObjectIterator iter1 = J9ObjectIterator.getObjectIterator(this);
        while (iter1.hasNext()) {
            long addrOfLockInfo;
            long lockerId;
            J9Object o = (J9Object)iter1.next();
            if (o.isInstanceOfClass()) {
                ++totalClassCount;
                totalClassSize += (long)o.getInstanceSize();
            } else {
                ++totalObjectCount;
                totalObjectSize += (long)o.getInstanceSize();
            }
            if (!nif.isComplete) {
                nif.write(o);
            }
            if (!allocBitsDone && o.getHeapId() != -1) {
                theHeaps[o.getHeapId()].recordObjectPosition(o.getObjectAddress());
            }
            if ((lockerId = (addrOfLockInfo = o.getLockInfo()) >>> 8 << 8) == 0L) continue;
            J9JVMConsole.addLockedObject(o);
            ++totalLockedObjectCount;
        }
        allocBitsDone = true;
        nif.commit();
        Vector v = nif.getAllClassNames();
        this.notifyObservers("\n\nObject Summary");
        for (int i = 0; i < v.size(); ++i) {
            String className = (String)v.get(i);
            int count = nif.getInstanceCountForClass(className);
            long size = nif.getInstanceSizeForClass(className);
            className = J9JVMBaseCmds.convertArrayName(className);
            this.notifyObservers("  " + className + "  has " + count + " instances (total size= " + (long)count * size + ")");
        }
        this.notifyObservers("\n\n\tTotal number of class instances = " + totalClassCount);
        this.notifyObservers("\tTotal size of class instances   = " + totalClassSize + " bytes");
        this.notifyObservers("\n\tTotal number of objects = " + totalObjectCount);
        this.notifyObservers("\tTotal size of objects   = " + totalObjectSize + " bytes");
        this.notifyObservers("\n\tTotal locked objects    = " + totalLockedObjectCount);
        nif.isComplete = true;
        HeapDumpBaseCmds hdbc = new HeapDumpBaseCmds();
        DumpConsole.addInAdditionalCommands(hdbc.getCommandSet(), hdbc);
        return retString;
    }

    private String doDisplayClassSummary(String whatClass) {
        String retString = null;
        Set classes = J9JVMConsole.getKnownClassesByName().keySet();
        Object[] sa = new String[classes.size()];
        DvNamesIndexFile nif = J9JVMConsole.getNamesFile();
        boolean bAddCount = false;
        if (nif != null && nif.isComplete) {
            bAddCount = true;
        }
        if (whatClass == null || whatClass.equals("*") || whatClass.equals("")) {
            Iterator iter = classes.iterator();
            int i = 0;
            while (iter.hasNext()) {
                sa[i] = (String)iter.next();
                ++i;
            }
            Arrays.sort(sa);
            for (i = 0; i < sa.length; ++i) {
                J9Class theClass = (J9Class)J9JVMConsole.getKnownClassesByName().get(sa[i]);
                String out = theClass.getName();
                long size = theClass.getInstanceSize();
                out = out + "    instance size=" + size;
                if (bAddCount) {
                    int count = nif.getInstanceCountForClass(theClass.getName());
                    out = out + "    object count=" + count;
                }
                this.notifyObservers(out);
            }
        } else {
            J9Class theClass = J9JVMConsole.getClass(whatClass);
            if (theClass != null) {
                long size = theClass.getInstanceSize();
                String out = whatClass + "    instance size=" + size;
                if (bAddCount) {
                    int count = nif.getInstanceCountForClass(whatClass);
                    out = out + "    object count=" + count;
                }
                this.notifyObservers(out);
                if (bAddCount) {
                    out = "  ";
                    long[] instances = J9JVMConsole.getNamesFile().getInstancesForClass(whatClass);
                    if (instances != null) {
                        for (int i = 0; i < instances.length; ++i) {
                            if (i % 6 == 0) {
                                this.notifyObservers(out);
                                out = "  ";
                            }
                            out = out + "  0x" + Long.toHexString(instances[i]);
                        }
                    } else {
                        out = "\n No objects instances for this class";
                    }
                    this.notifyObservers(out);
                }
            } else {
                retString = "Cannot find specified class (\"" + whatClass + "\")";
            }
        }
        return retString;
    }

    public String checkCommandValidity(Command cmd) {
        String retString;
        StringBuffer sb = new StringBuffer();
        if (cmd.isSetDumpRun() && null == DumpConsole.getTheDump()) {
            sb.append("\n \"Set dump\" needs to be run before this command! (no dump file established)");
        }
        if (cmd.isSetMetadataRun() && null == J9JVMConsole.getKnownHeaps()) {
            sb.append("\n \"Set metadata\" needs to be run before this command! (no known heaps)");
        }
        if (cmd.isDisOsRun() && null == J9JVMConsole.getNamesFile()) {
            sb.append("\n \"Dis os\" needs to be run before this command! (no names index file)");
        }
        if ((retString = sb.toString()).equals("")) {
            retString = null;
        }
        return retString;
    }

    public static String whatis(String whatAsString, long what, CommandPlugin whoIsCalling) {
        J9Class j9c;
        HashMap hm;
        String retString = null;
        int heapId = J9Heap.whatHeap(what);
        if (-1 == heapId) {
            whoIsCalling.notifyObservers("\t\"" + whatAsString + " is NOT within any known heap segment (heapId = " + heapId + ")");
            int within = 24;
            if (DumpConsole.getTheDump().is32bit()) {
                within = 12;
            }
            hm = J9JVMConsole.getKnownClassesByName();
            Iterator iter = hm.keySet().iterator();
            while (iter.hasNext()) {
                j9c = (J9Class)hm.get(iter.next());
                long classAddr = j9c.getClassAddress();
                if (classAddr - what > (long)within || classAddr - what < 0L) continue;
                if (classAddr == what) {
                    whoIsCalling.notifyObservers("\t\"" + whatAsString + " is the address of the java/lang/Class object ....");
                } else {
                    whoIsCalling.notifyObservers("\t\"" + whatAsString + " is within the java/lang/Class object ....");
                }
                whoIsCalling.notifyObservers("\t\t .... for: " + j9c.getName());
            }
        } else {
            J9Heap theHeap = J9Heap.getAHeap(heapId);
            whoIsCalling.notifyObservers("\t\"" + whatAsString + " is within a heap segment (heapId=" + heapId + " which starts at 0x" + Long.toHexString(theHeap.getStart()) + ")");
            J9Object object = J9Heap.checkForObject(what);
            if (null != object) {
                String className = J9JVMBaseCmds.convertArrayName(object.getClassForObject().getName());
                whoIsCalling.notifyObservers("\t\"" + whatAsString + " is start of an object - an instance of " + className);
            } else {
                object = J9Heap.checkForObjectBeforeAddress(what);
                if (null != object) {
                    long objStart = object.getObjectAddress();
                    int objLength = object.getInstanceSize();
                    String objName = object.getClassForObject().getName();
                    String className = J9JVMBaseCmds.convertArrayName(object.getClassForObject().getName());
                    if (objStart + (long)objLength >= what) {
                        whoIsCalling.notifyObservers("\t\"" + whatAsString + " is within an object on the heap.  " + "Offset " + (what - objStart) + " within " + className + "instance @ 0x" + Long.toHexString(objStart));
                    } else {
                        whoIsCalling.notifyObservers("\t\"" + whatAsString + " is ORPHANED on the heap.  " + "Offset " + (what - objStart) + " from " + className + "instance @ 0x" + Long.toHexString(objStart));
                    }
                }
            }
        }
        Object o = J9JVMConsole.isThisAMonitor(what);
        if (null != o) {
            if (o instanceof String) {
                whoIsCalling.notifyObservers("\t\"" + whatAsString + "\": " + (String)o);
            } else {
                whoIsCalling.notifyObservers("\t\"" + whatAsString + "\" is a monitor: " + ((J9Monitor)o).getName());
            }
        }
        hm = J9JVMConsole.getKnownClassesByName();
        Iterator iter = hm.keySet().iterator();
        while (iter.hasNext()) {
            j9c = (J9Class)hm.get(iter.next());
            Iterator iter1 = null;
            if (j9c.getMethods() == null) continue;
            for (J9Method j9m : j9c.getMethods()) {
                long bcStart = j9m.getBcStart();
                long jitStart = j9m.getJitStart();
                if (bcStart != 0L && what >= bcStart && what <= j9m.getBcEnd()) {
                    whoIsCalling.notifyObservers("\t\"" + whatAsString + "\" is within the byte code range (0x" + Long.toHexString(bcStart) + " thru 0x" + Long.toHexString(j9m.getBcEnd()) + ")...\n\t\tfor method \"" + j9m.getMethodName() + "\"...\n\t\twith signature \"" + j9m.getSignature() + "\"... \n\t\tin class \"" + j9c.getName() + "\"");
                }
                if (jitStart == 0L || what < jitStart || what > j9m.getJitEnd()) continue;
                whoIsCalling.notifyObservers("\t\"" + whatAsString + "\" is within the jitted code range (0x" + Long.toHexString(jitStart) + " thru 0x" + Long.toHexString(j9m.getJitEnd()) + ") for method \"" + j9m.getMethodName() + "\" with signature \"" + j9m.getSignature() + "\" in class \"" + j9c.getName() + "\"");
            }
        }
        return retString;
    }

    public static boolean isSetMetaDataDone() {
        return setMetaDataDone;
    }

    private static String convertArrayName(String className) {
        int posLast;
        String classId;
        String retString = className;
        if (className.startsWith("[") && (classId = className.substring((posLast = className.lastIndexOf("[")) + 1)).startsWith("0x")) {
            J9Class j9c = J9JVMConsole.getClass(DumpUtils.parseLongHex(classId));
            retString = className.substring(0, posLast + 1) + j9c.getName();
        }
        return retString;
    }

    private static String reConvertArrayName(String className) {
        int posLast;
        String name;
        J9Class j9c;
        String retString = className;
        if (className.startsWith("[") && (j9c = J9JVMConsole.getClass(name = className.substring((posLast = className.lastIndexOf("[")) + 1))) != null) {
            retString = className.substring(0, posLast + 1) + j9c.getId();
        }
        return retString;
    }

    private static boolean checkXML(File file) {
        boolean bRet = false;
        char[] ca = new char[]{'<', '?', 'x', 'm', 'l'};
        char[] caZOS = new char[]{'\u0014', '\u001a', '\u00cc', '_', '%'};
        Object checkString = null;
        try {
            FileReader fr = new FileReader(file);
            try {
                int i;
                char[] start = new char[100];
                fr.read(start);
                boolean assumedGood = true;
                for (i = 0; i < ca.length; ++i) {
                    if (start[i] == ca[i]) continue;
                    assumedGood = false;
                }
                if (!assumedGood) {
                    assumedGood = true;
                    for (i = 0; i < caZOS.length; ++i) {
                        if (start[i] == caZOS[i]) continue;
                        assumedGood = false;
                    }
                }
                bRet = assumedGood;
            }
            catch (IOException ioe) {}
        }
        catch (FileNotFoundException fnfe) {
            // empty catch block
        }
        return bRet;
    }

    static {
        traceProcessor = null;
    }
}

