/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command;

import com.ibm.jvm.j9.dump.command.Command;
import com.ibm.jvm.j9.dump.command.CommandDetails;
import com.ibm.jvm.j9.dump.command.CommandPlugin;
import com.ibm.jvm.j9.dump.commandconsole.Console;
import com.ibm.jvm.j9.dump.commandconsole.ConsoleOutput;
import com.ibm.jvm.j9.dump.commandconsole.ConsoleOutputToFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Observer;
import java.util.Set;
import java.util.Vector;

public class BaseCommands
extends CommandPlugin {
    private Observer observer;
    private BaseCommands mySelf = this;
    private Command[] myCommands;

    public BaseCommands() {
        int numCommands = 11;
        this.myCommands = new Command[numCommands];
        this.myCommands[0] = new Command("quit", null, this.mySelf, false, false, false, "Terminates jdmpview session");
        this.myCommands[1] = new Command("help", "*", this.mySelf, false, false, false, "Provides generic and specific help");
        this.myCommands[2] = new Command("cmds", "*", this.mySelf, false, false, false, "Shows available commands");
        this.myCommands[3] = new Command("synonyms", "*", this.mySelf, false, false, false, "Shows substitutions and short forms for commands");
        this.myCommands[4] = new Command("set", "out", this.mySelf, false, false, false, "Sets the output destination (terminal or file)");
        this.myCommands[5] = new Command("add", "out", this.mySelf, false, false, false, "Appends additional output destination");
        this.myCommands[6] = new Command("rem", "out", this.mySelf, false, false, false, "Removes an output destination");
        this.myCommands[7] = new Command("dis", "out", this.mySelf, false, false, false, "Displays output destinations");
        this.myCommands[8] = new Command("set", "workdir", this.mySelf, false, false, false, "Defines a writeable location for work files");
        this.myCommands[9] = new Command("set", "*", this.mySelf, false, false, false, "Generic command - use \"help set\" for more details");
        this.myCommands[10] = new Command("ex", "*", this.mySelf, false, false, false, "Execute commands from a file");
    }

    public String go(String input, String origInput) {
        String retString = null;
        CommandDetails cd = new CommandDetails(input);
        if (null == origInput) {
            origInput = new String(input);
        }
        cd.equalFound = BaseCommands.analyseOriginalInput(origInput, cd.getNoun());
        String verb = cd.getVerb();
        String noun = cd.getNoun();
        if (verb.equals("SET")) {
            retString = this.goSet(noun, cd);
        }
        if (verb.equals("HELP")) {
            String theRest = cd.getRest().toUpperCase().trim();
            if (!theRest.equals("")) {
                String key = cd.getRest().toUpperCase();
                String value = (String)Console.getCmdConversions().get(key);
                if (value != null) {
                    key = value;
                }
                retString = this.doHelpCmd(noun + "_" + key);
            } else {
                retString = this.doHelpCmd(noun);
            }
        }
        if (verb.equals("QUIT") || verb.equals("Q")) {
            retString = this.doQuitCmd();
        }
        if (verb.equals("REGCP")) {
            retString = this.doRegisterCommandPlugin(cd.getNounOriginal());
        }
        if (verb.equals("CMDS")) {
            this.doListAvailableCommands();
        }
        if (verb.equals("SYNONYMS")) {
            this.doShowSynonyms();
        }
        if (verb.equals("ADD") && noun.equals("OUT")) {
            retString = this.doSetOut(cd.getRest(), true);
        }
        if (verb.equals("DIS") && noun.equals("OUT")) {
            retString = this.doDisOut();
        }
        if (verb.equals("EX")) {
            retString = this.doExecute(cd);
        }
        return retString;
    }

    public String cleanUp() {
        return null;
    }

    private String goSet(String noun, CommandDetails cd) {
        String retString = null;
        String theRest = cd.getRest();
        if (null == noun || noun.equals("")) {
            retString = Console.getProperty(null);
        } else if (noun.equals("OUT")) {
            retString = this.doSetOut(theRest, false);
        } else if (!noun.equals("IN")) {
            if (noun.equals("WORKDIR")) {
                retString = this.doSetWorkdir(theRest, cd);
            } else if (null != theRest && !theRest.equals("")) {
                retString = Console.setProperty(noun, theRest);
            } else if (cd.equalFound && (theRest.equals("") || null == theRest)) {
                retString = Console.removeProperty(noun);
            } else {
                retString = Console.getProperty(noun);
                if (retString == null) {
                    retString = noun + " is not set";
                }
            }
        }
        return retString;
    }

    public Command[] getCommandSet() {
        return this.myCommands;
    }

    private String doQuitCmd() {
        Console.quitConsole();
        return null;
    }

    private String doExecute(CommandDetails cd) {
        String retString = null;
        String filename = (cd.getNounOriginal() + " " + cd.getRest()).trim();
        if (filename == "") {
            retString = "No filename specified";
        } else {
            File file = new File(filename);
            if (file.isFile() && file.exists() && file.canRead()) {
                try {
                    int linecount = 0;
                    this.notifyObservers("Starting execution of \"" + filename + "\"\n");
                    BufferedReader br = new BufferedReader(new FileReader(file));
                    String line = br.readLine();
                    while (line != null) {
                        if (!line.startsWith("#")) {
                            if (line.startsWith("!")) {
                                this.notifyObservers(line);
                            } else {
                                this.notifyObservers("Attempting execution of: " + line);
                                Console.handleInput(line, true);
                                ++linecount;
                            }
                        }
                        line = br.readLine();
                    }
                    this.notifyObservers("\nEnding execution of \"" + filename + "\" (" + linecount + " command lines processed)\n");
                }
                catch (Exception e) {}
            } else {
                retString = "File \"" + filename + "\" not found , not readable, or directory";
            }
        }
        return retString;
    }

    private String doHelpCmd(String name) {
        String retString = null;
        String helpString = null;
        if (null == name) {
            helpString = Console.getHelp("GENERAL");
            this.notifyObservers(helpString);
        } else {
            helpString = Console.getHelp(name);
            this.notifyObservers(helpString);
        }
        return retString;
    }

    private String doListAvailableCommands() {
        StringBuffer sb = new StringBuffer();
        this.notifyObservers("Known Commands\n==============\n");
        Vector list = Console.getCommandList();
        for (int i = 0; i < list.size(); ++i) {
            Command cmd = (Command)list.get(i);
            sb.append(cmd.toString() + "\n");
        }
        sb.append("\n\n\t\"help command\" shows details of each command");
        sb.append("\n\n\tNote: some supported commands may not be shown in the above\n\t");
        sb.append("list as they only become available after successful issuance\n\t");
        sb.append("of other commands (such as \"set dump\" or \"dis os\")");
        this.notifyObservers(sb);
        return null;
    }

    private String doRegisterCommandPlugin(String name) {
        this.notifyObservers("Registering " + name);
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        try {
            Class<?> c = cl.loadClass(name);
            CommandPlugin cp = (CommandPlugin)c.newInstance();
            Command[] commandSet = cp.getCommandSet();
            Console.registerCommandSet(commandSet);
        }
        catch (ClassNotFoundException cnfe) {
            Console.reportError("doRegisterCommandPlugin caught exception", cnfe);
        }
        catch (IllegalAccessException iae) {
            Console.reportError("doRegisterCommandPlugin caught exception", iae);
        }
        catch (InstantiationException ine) {
            Console.reportError("doRegisterCommandPlugin caught exception", ine);
        }
        this.notifyObservers("Finished registering ........");
        return null;
    }

    private void doShowSynonyms() {
        Set keys = Console.getCmdConversions().keySet();
        for (String key : keys) {
            String value = (String)Console.getCmdConversions().get(key);
            this.notifyObservers(key + " ==> " + value);
        }
    }

    private String doSetWorkdir(String whatTo, CommandDetails cd) {
        String retString;
        block9: {
            retString = null;
            if (null == whatTo && cd.equalFound) {
                Console.removeProperty("WORKDIR");
            } else if (null == whatTo) {
                this.notifyObservers(Console.getProperty("WORKDIR"));
            } else {
                File dir = new File(whatTo);
                if (dir.isDirectory()) {
                    try {
                        File tempFile = File.createTempFile("jformat", "tmp", dir);
                        tempFile.delete();
                        String currentWorkdir = Console.getProperty("WORKDIR");
                        Console.setProperty("WORKDIR", whatTo);
                        if (null == currentWorkdir) {
                            this.notifyObservers("WORKDIR set to " + whatTo);
                            break block9;
                        }
                        this.notifyObservers("WORKDIR changed from " + currentWorkdir + " to " + whatTo);
                    }
                    catch (IOException ioe) {
                        retString = "\"" + whatTo + "\" is not an existing valid directory or cannot be written to";
                    }
                } else {
                    retString = "\"" + whatTo + "\" is not an existing valid directory or cannot be written to";
                }
            }
        }
        return retString;
    }

    private String doSetOut(String whereTo, boolean addIt) {
        File file;
        String retString = null;
        if (whereTo.equals("*")) {
            if (addIt) {
                this.notifyObservers(" output being directed to console");
            } else {
                this.notifyObservers(" output being re-directed to console only");
            }
            Console.setOutput(null, addIt);
            Console.setBCommandEcho(false);
            return retString;
        }
        if (!whereTo.toUpperCase().startsWith("FILE:") && null != (file = new File(whereTo))) {
            whereTo = "FILE:" + whereTo;
        }
        if (whereTo.toUpperCase().startsWith("FILE:")) {
            if (addIt) {
                this.notifyObservers(" output being  directed to \"" + whereTo + "\"");
            } else {
                this.notifyObservers(" output being  re-directed to \"" + whereTo + "\" only");
            }
            ConsoleOutputToFile cco = new ConsoleOutputToFile();
            if (cco.init(whereTo)) {
                Console.setOutput(cco, addIt);
                Console.setBCommandEcho(true);
            } else {
                retString = " set output failure: is \"" + whereTo + "\" a valid location?";
            }
        } else {
            retString = " set output failure: \"" + whereTo + "\" not recognised as valid location";
        }
        return retString;
    }

    private String doDisOut() {
        ConsoleOutput[] cco = Console.getOutput();
        for (int i = 0; i < cco.length; ++i) {
            this.notifyObservers("#" + i + "  " + cco[i].toString());
        }
        return null;
    }

    public String checkCommandValidity(Command cmd) {
        String retString = null;
        return retString;
    }

    private static boolean analyseOriginalInput(String origInput, String noun) {
        boolean bRet = false;
        if (noun != null) {
            String lookfor = noun.toUpperCase() + "=";
            if (-1 != origInput.toUpperCase().indexOf(lookfor)) {
                bRet = true;
            }
        }
        return bRet;
    }
}

