/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.converter.engine;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.StringTokenizer;
import sun.plugin.converter.engine.AppletPieces;
import sun.plugin.converter.engine.ParsingState;
import sun.plugin.converter.util.StdUtils;

public class ConvertFile {
    private byte[] templateBuffer;
    private File source;
    private File destination;
    private int appletsFound = 0;
    private int errors = 0;
    private int token;
    private String upperWord;
    private String eolStr;
    private String inEncoding = null;
    private String outEncoding = null;
    private ParsingState pState = new ParsingState();
    private String cabFileLocation = null;
    private String nsFileLocation = null;
    private String smartUpdateLocation = null;
    private String mimeType = null;
    private String classId = null;
    private boolean stdout = false;
    private static final String PARAMTAG = "APPLETPARAMS";
    private static final String EMBEDPARAMTAG = "EMBEDPARAMS";
    private static final String ALTERNATEHTMLTAG = "ALTERNATEHTML";
    private static final String APPLETATTRSTAG = "APPLETATTRIBUTES";
    private static final String OBJECTPARAMSTAG = "OBJECTPARAMS";
    private static final String OBJECTATTRIBUTES = "OBJECTATTRIBUTES";
    private static final String APPLETTEXTTAG = "ORIGINALAPPLET";
    private static final String EMBEDATTRIBUTESTAG = "EMBEDATTRIBUTES";
    private static final String CABFILELOCATIONTAG = "CABFILELOCATION";
    private static final String NSFILELOCATIONTAG = "NSFILELOCATION";
    private static final String SMARTUPDATETAG = "SMARTUPDATE";
    private static final String MIMETYPETAG = "MIMETYPE";
    private static final String CLASSID = "CLASSID";
    private static final String conversionTagBegin = "<!--\"CONVERTED_APPLET\"-->";
    private static final String conversionTagEnd = "<!--\"END_CONVERTED_APPLET\"-->";

    public ConvertFile(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[2048];
        int n = 0;
        while ((n = inputStream.read(byArray, 0, 2048)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        this.templateBuffer = byteArrayOutputStream.toByteArray();
    }

    public void setSource(File file) {
        this.source = file;
    }

    public File getSource() {
        return this.source;
    }

    public void setDestination(File file) {
        this.destination = file;
    }

    public File getDestination() {
        return this.destination;
    }

    public String getCabFileLocation() {
        return this.cabFileLocation;
    }

    public void setCabFileLocation(String string) {
        this.cabFileLocation = string;
    }

    public String getNSFileLocation() {
        return this.nsFileLocation;
    }

    public void setNSFileLocation(String string) {
        this.nsFileLocation = string;
    }

    public String getSmartUpdateLocation() {
        return this.smartUpdateLocation;
    }

    public void setSmartUpdateLocation(String string) {
        this.smartUpdateLocation = string;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String string) {
        this.mimeType = string;
    }

    public String getClassId() {
        return this.classId;
    }

    public void setClassId(String string) {
        this.classId = string;
    }

    public int getAppletsFound() {
        return this.appletsFound;
    }

    public int getErrors() {
        return this.errors;
    }

    public void setEncoding(String string) {
        this.outEncoding = this.inEncoding = string;
    }

    public void setStandardOutput(boolean bl) {
        this.stdout = bl;
    }

    public String getEncoding() {
        return this.inEncoding;
    }

    public String parseCharset(String string) {
        int n = string.indexOf("charset");
        if (n < 0) {
            return null;
        }
        String string2 = string.substring(n);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " =\t\n\r");
        stringTokenizer.nextToken();
        return stringTokenizer.nextToken();
    }

    public void guessEncoding() {
        int n = 0;
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(new BufferedInputStream(new FileInputStream(this.source)));
            StreamTokenizer streamTokenizer = new StreamTokenizer(inputStreamReader);
            streamTokenizer.wordChars(60, 62);
            streamTokenizer.whitespaceChars(61, 61);
            streamTokenizer.lowerCaseMode(true);
            while (true) {
                int n2 = streamTokenizer.nextToken();
                block1 : switch (n2) {
                    case -3: {
                        if (streamTokenizer.sval.equals("</head>")) {
                            return;
                        }
                        switch (n) {
                            case 0: {
                                if (!streamTokenizer.sval.equals("<head>")) break;
                                n = 1;
                                break block1;
                            }
                            case 1: {
                                if (!streamTokenizer.sval.equals("content")) break;
                                streamTokenizer.nextToken();
                                this.setEncoding(this.parseCharset(streamTokenizer.sval));
                                return;
                            }
                        }
                        break;
                    }
                    case -1: {
                        return;
                    }
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Something bad happened: " + exception);
            return;
        }
    }

    public boolean convert() throws Exception {
        this.eolStr = StdUtils.getEOLs(new FileInputStream(this.source), this.getEncoding());
        if (this.inEncoding == null && this.outEncoding == null) {
            this.guessEncoding();
        }
        BufferedWriter bufferedWriter = this.stdout ? (this.outEncoding == null ? new BufferedWriter(new FileWriter(FileDescriptor.out)) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FileDescriptor.out), this.outEncoding))) : (this.outEncoding == null ? new BufferedWriter(new FileWriter(this.destination)) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.destination), this.outEncoding)));
        BufferedReader bufferedReader = this.inEncoding == null ? new BufferedReader(new FileReader(this.source)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.source), this.inEncoding));
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        this.setTagSearch(streamTokenizer);
        while ((this.token = streamTokenizer.nextToken()) != -1) {
            if (this.token == -3) {
                this.upperWord = streamTokenizer.sval.toUpperCase().trim();
                if (this.pState.isPotentialTag()) {
                    if (this.upperWord.equals(this.pState.getTarget())) {
                        AppletPieces appletPieces = this.getAppletPieces(streamTokenizer);
                        if (appletPieces != null) {
                            ++this.appletsFound;
                        }
                        String string = this.convertToOBJECT(appletPieces);
                        bufferedWriter.write(conversionTagBegin + this.eolStr);
                        bufferedWriter.write(string);
                        bufferedWriter.write(conversionTagEnd + this.eolStr);
                        this.setTagSearch(streamTokenizer);
                        this.token = streamTokenizer.nextToken();
                        if (this.token != -1 && (char)this.token != this.pState.getPotentialTagChar()) {
                            continue;
                        }
                    } else if (this.upperWord.equals("!--")) {
                        boolean bl = false;
                        bufferedWriter.write(this.pState.getPotentialTagChar() + "!--");
                        this.setCommentScan(streamTokenizer);
                        while ((this.token = streamTokenizer.nextToken()) != -1) {
                            if (this.token == -3) {
                                this.upperWord = streamTokenizer.sval.toUpperCase().trim();
                                bufferedWriter.write(streamTokenizer.sval);
                                if (this.upperWord.indexOf("-->") < 0 || bl) continue;
                                break;
                            }
                            if (this.token == 34) {
                                this.upperWord = streamTokenizer.sval.toUpperCase().trim();
                                if (this.upperWord.equals("CONVERTED_APPLET")) {
                                    bl = true;
                                }
                                if (this.upperWord.equals("END_CONVERTED_APPLET")) {
                                    bl = false;
                                }
                                bufferedWriter.write("\"" + streamTokenizer.sval + "\"");
                                continue;
                            }
                            bufferedWriter.write(String.valueOf((char)this.token));
                        }
                        this.setTagSearch(streamTokenizer);
                    } else if (this.pState.isPotentialTag()) {
                        bufferedWriter.write(this.pState.getPotentialTagChar() + streamTokenizer.sval);
                    } else {
                        bufferedWriter.write(streamTokenizer.sval);
                    }
                } else if (this.pState.isPotentialTag()) {
                    bufferedWriter.write(this.pState.getPotentialTagChar() + streamTokenizer.sval);
                } else {
                    bufferedWriter.write(streamTokenizer.sval);
                }
                this.pState.clearPotentialTag();
                continue;
            }
            if ((char)this.token == this.pState.getPotentialTagChar()) {
                this.pState.setPotentialTag();
                continue;
            }
            if (this.pState.isPotentialTag()) {
                bufferedWriter.write(this.pState.getPotentialTagChar() + String.valueOf((char)this.token));
            } else {
                bufferedWriter.write(String.valueOf((char)this.token));
            }
            this.pState.clearPotentialTag();
        }
        bufferedReader.close();
        bufferedWriter.flush();
        bufferedWriter.close();
        return this.appletsFound > 0;
    }

    private void setCommentScan(StreamTokenizer streamTokenizer) {
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(45, 45);
        streamTokenizer.wordChars(62, 62);
        streamTokenizer.quoteChar(34);
        this.pState.setCommentState();
    }

    private void setTagSearch(StreamTokenizer streamTokenizer) {
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(65, 65);
        streamTokenizer.wordChars(97, 97);
        streamTokenizer.wordChars(80, 80);
        streamTokenizer.wordChars(112, 112);
        streamTokenizer.wordChars(76, 76);
        streamTokenizer.wordChars(108, 108);
        streamTokenizer.wordChars(69, 69);
        streamTokenizer.wordChars(101, 101);
        streamTokenizer.wordChars(84, 84);
        streamTokenizer.wordChars(116, 116);
        streamTokenizer.wordChars(45, 45);
        streamTokenizer.wordChars(33, 33);
        this.pState.setScanState();
    }

    private void setAppletScan(StreamTokenizer streamTokenizer) {
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(33, 255);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.ordinaryChar(62);
        streamTokenizer.ordinaryChar(61);
        streamTokenizer.quoteChar(34);
        this.pState.setAppletScanState();
    }

    private void setParamOrEndScan(StreamTokenizer streamTokenizer) {
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(65, 65);
        streamTokenizer.wordChars(97, 97);
        streamTokenizer.wordChars(80, 80);
        streamTokenizer.wordChars(112, 112);
        streamTokenizer.wordChars(76, 76);
        streamTokenizer.wordChars(108, 108);
        streamTokenizer.wordChars(69, 69);
        streamTokenizer.wordChars(101, 101);
        streamTokenizer.wordChars(84, 84);
        streamTokenizer.wordChars(116, 116);
        streamTokenizer.wordChars(82, 82);
        streamTokenizer.wordChars(114, 114);
        streamTokenizer.wordChars(77, 77);
        streamTokenizer.wordChars(109, 109);
        streamTokenizer.wordChars(47, 47);
        this.pState.setAltOrEndScanState();
    }

    private void setParamScan(StreamTokenizer streamTokenizer) {
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(33, 255);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.ordinaryChar(62);
        streamTokenizer.whitespaceChars(61, 61);
        streamTokenizer.quoteChar(34);
        this.pState.setParamScanState();
    }

    public void getAppletPortion(StreamTokenizer streamTokenizer, AppletPieces appletPieces) throws Exception {
        this.setAppletScan(streamTokenizer);
        while ((this.token = streamTokenizer.nextToken()) != -1) {
            if (this.token == -3) {
                this.upperWord = streamTokenizer.sval.toUpperCase().trim();
                if (this.upperWord.equals("CODEBASE")) {
                    appletPieces.setCODEBASE("CODEBASE = " + this.getAttributeValue(this.pState, streamTokenizer));
                } else if (this.upperWord.equals("ARCHIVE")) {
                    appletPieces.setARCHIVE("ARCHIVE = " + this.getAttributeValue(this.pState, streamTokenizer));
                } else if (this.upperWord.equals("CODE")) {
                    appletPieces.setCODE("CODE = " + this.getAttributeValue(this.pState, streamTokenizer));
                } else if (this.upperWord.equals("OBJECT")) {
                    appletPieces.setOBJECT("OBJECT = " + this.getAttributeValue(this.pState, streamTokenizer));
                } else if (this.upperWord.equals("ALT")) {
                    appletPieces.setALT("ALT = " + this.getAttributeValue(this.pState, streamTokenizer));
                } else if (this.upperWord.equals("NAME")) {
                    appletPieces.setNAME("NAME = " + this.getAttributeValue(this.pState, streamTokenizer));
                } else if (this.upperWord.equals("WIDTH")) {
                    appletPieces.setWIDTH("WIDTH = " + this.getAttributeValue(this.pState, streamTokenizer));
                } else if (this.upperWord.equals("HEIGHT")) {
                    appletPieces.setHEIGHT("HEIGHT = " + this.getAttributeValue(this.pState, streamTokenizer));
                } else if (this.upperWord.equals("ALIGN")) {
                    appletPieces.setALIGN("ALIGN = " + this.getAttributeValue(this.pState, streamTokenizer));
                } else if (this.upperWord.equals("VSPACE")) {
                    appletPieces.setVSPACE("VSPACE = " + this.getAttributeValue(this.pState, streamTokenizer));
                } else if (this.upperWord.equals("HSPACE")) {
                    appletPieces.setHSPACE("HSPACE = " + this.getAttributeValue(this.pState, streamTokenizer));
                } else if (this.upperWord.equals("MAYSCRIPT")) {
                    appletPieces.setMAYSCRIPT("MAYSCRIPT = " + this.getAttributeValueForMAYSCRIPT(this.pState, streamTokenizer));
                }
                if (!this.pState.isStateClear()) continue;
                return;
            }
            if ((char)this.token != '>') continue;
            this.pState.clearScanState();
            return;
        }
    }

    public AppletPieces getAppletPieces(StreamTokenizer streamTokenizer) throws Exception {
        AppletPieces appletPieces = new AppletPieces(this.eolStr);
        this.getAppletPortion(streamTokenizer, appletPieces);
        this.getParamsAndAlt(streamTokenizer, appletPieces);
        return appletPieces;
    }

    public void getParamsAndAlt(StreamTokenizer streamTokenizer, AppletPieces appletPieces) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        this.setParamOrEndScan(streamTokenizer);
        while ((this.token = streamTokenizer.nextToken()) != -1) {
            if (this.token != -3) {
                if ((char)this.token == this.pState.getPotentialTagChar()) {
                    this.pState.setPotentialTag();
                    continue;
                }
                if (this.pState.isPotentialTag()) {
                    stringBuffer.append(this.pState.getPotentialTagChar() + String.valueOf((char)this.token));
                } else {
                    stringBuffer.append(String.valueOf((char)this.token));
                    if (bl) {
                        if (stringBuffer.indexOf("-->") >= 0) {
                            bl = false;
                            stringBuffer = new StringBuffer("");
                        }
                    } else if (stringBuffer.indexOf("<!--") >= 0) {
                        bl = true;
                        stringBuffer = new StringBuffer("");
                    }
                }
                this.pState.clearPotentialTag();
                continue;
            }
            this.upperWord = streamTokenizer.sval.toUpperCase().trim();
            if (this.upperWord.equals("-->") && bl) {
                bl = false;
                this.setParamOrEndScan(streamTokenizer);
            }
            if (this.pState.isPotentialTag()) {
                if (this.upperWord.equals(this.pState.getTarget())) {
                    this.pState.clearScanState();
                    appletPieces.setAlternateHTML(stringBuffer.toString().trim());
                    this.setTagSearch(streamTokenizer);
                    return;
                }
                if (this.upperWord.equals("PARAM")) {
                    if (!bl) {
                        appletPieces.addParam(this.getParamString(streamTokenizer, this.pState));
                        this.setParamOrEndScan(streamTokenizer);
                    }
                } else if (this.upperWord.equals("!--")) {
                    bl = true;
                    this.setCommentScan(streamTokenizer);
                } else {
                    stringBuffer.append(this.pState.getPotentialTagChar() + streamTokenizer.sval);
                }
            } else {
                stringBuffer.append(streamTokenizer.sval);
            }
            this.pState.clearPotentialTag();
        }
    }

    public String getAttributeValue(ParsingState parsingState, StreamTokenizer streamTokenizer) throws Exception {
        String string;
        boolean bl = false;
        this.token = streamTokenizer.nextToken();
        this.token = streamTokenizer.nextToken();
        if (this.token == 34) {
            bl = true;
            string = streamTokenizer.sval;
        } else if (this.token == -3) {
            string = streamTokenizer.sval;
            if (string.endsWith(">")) {
                string = string.substring(0, string.length() - 1);
                parsingState.clearScanState();
            }
        } else {
            string = String.valueOf(this.token);
        }
        if (bl) {
            string = "\"" + string + "\"";
        }
        return string;
    }

    public String getAttributeValueForMAYSCRIPT(ParsingState parsingState, StreamTokenizer streamTokenizer) throws Exception {
        String string;
        this.token = streamTokenizer.nextToken();
        if (this.token == 61) {
            String string2;
            boolean bl = false;
            this.token = streamTokenizer.nextToken();
            if (this.token == 34) {
                bl = true;
                string2 = streamTokenizer.sval;
            } else if (this.token == -3) {
                string2 = streamTokenizer.sval;
                if (string2.endsWith(">")) {
                    string2 = string2.substring(0, string2.length() - 1);
                    parsingState.clearScanState();
                }
            } else {
                string2 = String.valueOf(this.token);
            }
            if (bl) {
                string2 = "\"" + string2 + "\"";
            }
            return string2;
        }
        if (this.token == 62) {
            string = "true";
            parsingState.clearScanState();
        } else {
            streamTokenizer.pushBack();
            string = "true";
        }
        return string;
    }

    public String getParamString(StreamTokenizer streamTokenizer, ParsingState parsingState) throws Exception {
        String string;
        this.setParamScan(streamTokenizer);
        boolean bl = false;
        boolean bl2 = false;
        this.token = streamTokenizer.nextToken();
        this.token = streamTokenizer.nextToken();
        if (this.token == 34) {
            string = streamTokenizer.sval;
            bl = true;
        } else {
            string = this.token == -3 ? streamTokenizer.sval : String.valueOf(this.token);
        }
        String string2 = string;
        this.token = streamTokenizer.nextToken();
        streamTokenizer.resetSyntax();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl3 = false;
        while ((this.token = streamTokenizer.nextToken()) != -1 && (this.token != 62 || bl3)) {
            if (this.token == 34) {
                boolean bl4 = bl3 = !bl3;
            }
            if (this.token == -3) {
                stringBuffer.append(streamTokenizer.sval);
                continue;
            }
            if (this.token == -2) {
                stringBuffer.append(streamTokenizer.nval);
                continue;
            }
            stringBuffer.append((char)this.token);
        }
        String string3 = stringBuffer.toString();
        this.setParamScan(streamTokenizer);
        return "<PARAM NAME = " + (bl ? "\"" : "") + string2 + (bl ? "\"" : "") + " VALUE" + string3 + ">";
    }

    public String convertToOBJECT(AppletPieces appletPieces) throws Exception {
        int n;
        StreamTokenizer streamTokenizer = new StreamTokenizer(new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.templateBuffer))));
        streamTokenizer.resetSyntax();
        streamTokenizer.quoteChar(36);
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        String string2 = new String();
        String string3 = "    ";
        String string4 = "            ";
        String string5 = "\n";
        String string6 = " \\";
        string = StdUtils.getEOLs(new ByteArrayInputStream(this.templateBuffer), this.getEncoding());
        while ((n = streamTokenizer.nextToken()) != -1) {
            if ((char)n == '$') {
                CharSequence charSequence;
                Enumeration enumeration;
                string2 = streamTokenizer.sval.toUpperCase().trim();
                if (string2.equals(APPLETATTRSTAG)) {
                    stringBuffer.append(appletPieces.getAttributes(false));
                    continue;
                }
                if (string2.equals(OBJECTPARAMSTAG)) {
                    stringBuffer.append(appletPieces.getObjectTagParams(false));
                    continue;
                }
                if (string2.equals(OBJECTATTRIBUTES)) {
                    stringBuffer.append(appletPieces.getObjectTagAttributes(false));
                    continue;
                }
                if (string2.equals(APPLETTEXTTAG)) {
                    stringBuffer.append(appletPieces.getAppletText(false));
                    continue;
                }
                if (string2.equals(EMBEDATTRIBUTESTAG)) {
                    stringBuffer.append(appletPieces.getEmbedTagAttributes());
                    continue;
                }
                if (string2.equals(ALTERNATEHTMLTAG)) {
                    stringBuffer.append(appletPieces.getAlternateHTML());
                    continue;
                }
                if (string2.equals(CABFILELOCATIONTAG)) {
                    stringBuffer.append(this.cabFileLocation);
                    continue;
                }
                if (string2.equals(NSFILELOCATIONTAG)) {
                    stringBuffer.append(this.nsFileLocation);
                    continue;
                }
                if (string2.equals(SMARTUPDATETAG)) {
                    stringBuffer.append(this.smartUpdateLocation);
                    continue;
                }
                if (string2.equals(MIMETYPETAG)) {
                    stringBuffer.append(this.mimeType);
                    continue;
                }
                if (string2.equals(CLASSID)) {
                    stringBuffer.append(this.classId);
                    continue;
                }
                if (string2.equals(PARAMTAG)) {
                    enumeration = appletPieces.getParamEnumeration();
                    while (enumeration.hasMoreElements()) {
                        charSequence = (String)enumeration.nextElement();
                        stringBuffer.append(string3 + (String)charSequence + this.eolStr);
                    }
                    continue;
                }
                if (string2.equals(EMBEDPARAMTAG)) {
                    enumeration = appletPieces.getParamEnumeration();
                    charSequence = new StringBuffer();
                    while (enumeration.hasMoreElements()) {
                        String string7 = (String)enumeration.nextElement();
                        String string8 = "";
                        String string9 = "";
                        StringTokenizer stringTokenizer = new StringTokenizer(string7, " \t\n\r=", false);
                        while (stringTokenizer.hasMoreTokens()) {
                            String string10 = stringTokenizer.nextToken("\t\n\r=").trim();
                            if (string10.toUpperCase().indexOf("NAME") >= 0) {
                                String string11 = stringTokenizer.nextToken(" ");
                                if (string11.equals("=")) {
                                    string11 = stringTokenizer.nextToken(" ");
                                } else if (string11.charAt(0) == '=') {
                                    string11 = string11.substring(1, string11.length());
                                }
                                string8 = AppletPieces.convertEscapes(string11);
                                if (string8.startsWith("\"")) {
                                    string8 = string8.substring(1, string8.length());
                                }
                                if (!string8.endsWith("\"")) continue;
                                string8 = string8.substring(0, string8.length() - 1);
                                continue;
                            }
                            if (!string10.toUpperCase().equals("VALUE")) continue;
                            string9 = AppletPieces.convertEscapes(this.setAttribute(stringTokenizer));
                        }
                        if (string9.endsWith(">")) {
                            string9 = string9.substring(0, string9.length() - 1);
                        }
                        ((StringBuffer)charSequence).append(string6 + string5 + string4 + string8 + " =" + string9);
                    }
                    stringBuffer.append(new String((StringBuffer)charSequence));
                    continue;
                }
                stringBuffer.append(String.valueOf((char)n));
                continue;
            }
            stringBuffer.append(String.valueOf((char)n));
        }
        return stringBuffer.toString();
    }

    public String setAttribute(StringTokenizer stringTokenizer) {
        String string = "";
        string = stringTokenizer.nextToken(">");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken(">");
            if (string2.length() <= 0) continue;
            string = string + ">" + string2;
        }
        if ((string = string.trim()).indexOf("=") == 0) {
            string = string.substring(1, string.length());
        }
        return string;
    }
}

