/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.Util;

class LsortCmd
implements Command {
    private static final String[] validOpts = new String[]{"-ascii", "-command", "-decreasing", "-dictionary", "-increasing", "-index", "-integer", "-real"};

    LsortCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "?options? list");
        }
        String command = null;
        int sortMode = 0;
        int sortIndex = -1;
        boolean sortIncreasing = true;
        block12: for (int i = 1; i < argv.length - 1; ++i) {
            int index = TclIndex.get(interp, argv[i], validOpts, "option", 0);
            switch (index) {
                case 0: {
                    sortMode = 0;
                    continue block12;
                }
                case 1: {
                    if (i == argv.length - 2) {
                        throw new TclException(interp, "\"-command\" option must be followed by comparison command");
                    }
                    sortMode = 3;
                    command = argv[i + 1].toString();
                    ++i;
                    continue block12;
                }
                case 2: {
                    sortIncreasing = false;
                    continue block12;
                }
                case 3: {
                    sortMode = 4;
                    continue block12;
                }
                case 4: {
                    sortIncreasing = true;
                    continue block12;
                }
                case 5: {
                    if (i == argv.length - 2) {
                        throw new TclException(interp, "\"-index\" option must be followed by list index");
                    }
                    sortIndex = Util.getIntForIndex(interp, argv[i + 1], -2);
                    command = argv[i + 1].toString();
                    ++i;
                    continue block12;
                }
                case 6: {
                    sortMode = 1;
                    continue block12;
                }
                case 7: {
                    sortMode = 2;
                }
            }
        }
        TclObject list = argv[argv.length - 1];
        boolean isDuplicate = false;
        if (list.isShared()) {
            list = list.duplicate();
            isDuplicate = true;
        }
        try {
            TclList.sort(interp, list, sortMode, sortIndex, sortIncreasing, command);
            interp.setResult(list);
        }
        catch (TclException e) {
            if (isDuplicate) {
                list.release();
            }
            throw e;
        }
    }
}

