/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Enumeration;
import tcl.lang.AssocData;
import tcl.lang.Channel;
import tcl.lang.CommandWithDispose;
import tcl.lang.Interp;
import tcl.lang.InterpAliasCmd;
import tcl.lang.InterpCmd;
import tcl.lang.NamespaceCmd;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.WrappedCommand;

class InterpSlaveCmd
implements CommandWithDispose,
AssocData {
    private static final String[] options = new String[]{"alias", "aliases", "eval", "expose", "hide", "hidden", "issafe", "invokehidden", "marktrusted"};
    private static final int OPT_ALIAS = 0;
    private static final int OPT_ALIASES = 1;
    private static final int OPT_EVAL = 2;
    private static final int OPT_EXPOSE = 3;
    private static final int OPT_HIDE = 4;
    private static final int OPT_HIDDEN = 5;
    private static final int OPT_ISSAFE = 6;
    private static final int OPT_INVOKEHIDDEN = 7;
    private static final int OPT_MARKTRUSTED = 8;
    private static final String[] hiddenOptions = new String[]{"-global", "--"};
    private static final int OPT_HIDDEN_GLOBAL = 0;
    private static final int OPT_HIDDEN_LAST = 1;
    Interp masterInterp;
    String path;
    Interp slaveInterp;
    WrappedCommand interpCmd;

    InterpSlaveCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length < 2) {
            throw new TclNumArgsException(interp, 1, objv, "cmd ?arg ...?");
        }
        int cmd = TclIndex.get(interp, objv[1], options, "option", 0);
        switch (cmd) {
            case 0: {
                if (objv.length == 3) {
                    InterpAliasCmd.describe(interp, this.slaveInterp, objv[2]);
                    return;
                }
                if ("".equals(objv[3].toString())) {
                    if (objv.length == 4) {
                        InterpAliasCmd.delete(interp, this.slaveInterp, objv[2]);
                        return;
                    }
                } else {
                    InterpAliasCmd.create(interp, this.slaveInterp, interp, objv[2], objv[3], 4, objv);
                    return;
                }
                throw new TclNumArgsException(interp, 2, objv, "aliasName ?targetName? ?args..?");
            }
            case 1: {
                InterpAliasCmd.list(interp, this.slaveInterp);
                break;
            }
            case 2: {
                if (objv.length < 3) {
                    throw new TclNumArgsException(interp, 2, objv, "arg ?arg ...?");
                }
                InterpSlaveCmd.eval(interp, this.slaveInterp, 2, objv);
                break;
            }
            case 3: {
                if (objv.length < 3 || objv.length > 4) {
                    throw new TclNumArgsException(interp, 2, objv, "hiddenCmdName ?cmdName?");
                }
                InterpSlaveCmd.expose(interp, this.slaveInterp, 2, objv);
                break;
            }
            case 4: {
                if (objv.length < 3 || objv.length > 4) {
                    throw new TclNumArgsException(interp, 2, objv, "cmdName ?hiddenCmdName?");
                }
                InterpSlaveCmd.hide(interp, this.slaveInterp, 2, objv);
                break;
            }
            case 5: {
                if (objv.length != 2) {
                    throw new TclNumArgsException(interp, 2, objv, null);
                }
                InterpSlaveCmd.hidden(interp, this.slaveInterp);
                break;
            }
            case 6: {
                interp.setResult(this.slaveInterp.isSafe);
                break;
            }
            case 7: {
                int i;
                boolean global = false;
                for (i = 2; i < objv.length && objv[i].toString().charAt(0) == '-'; ++i) {
                    int index = TclIndex.get(interp, objv[i], hiddenOptions, "option", 0);
                    if (index != 0) {
                        ++i;
                        break;
                    }
                    global = true;
                }
                if (objv.length - i < 1) {
                    throw new TclNumArgsException(interp, 2, objv, "?-global? ?--? cmd ?arg ..?");
                }
                InterpSlaveCmd.invokeHidden(interp, this.slaveInterp, global, i, objv);
                break;
            }
            case 8: {
                if (objv.length != 2) {
                    throw new TclNumArgsException(interp, 2, objv, null);
                }
                InterpSlaveCmd.markTrusted(interp, this.slaveInterp);
            }
        }
    }

    public void disposeCmd() {
        this.masterInterp.slaveTable.remove(this.path);
        this.interpCmd = null;
        if (this.slaveInterp != null) {
            this.slaveInterp.dispose();
        }
    }

    public void disposeAssocData(Interp interp) {
        if (!interp.slaveTable.isEmpty()) {
            System.err.println("InterpInfoDeleteProc: still exist commands");
        }
        interp.slaveTable = null;
        Enumeration targets = interp.targetTable.keys();
        while (targets.hasMoreElements()) {
            WrappedCommand slaveCmd = (WrappedCommand)targets.nextElement();
            Interp slaveInterp = (Interp)interp.targetTable.get(slaveCmd);
            slaveInterp.deleteCommandFromToken(slaveCmd);
        }
        interp.targetTable = null;
        if (interp.interpChanTable != null) {
            Enumeration channels = interp.interpChanTable.elements();
            while (channels.hasMoreElements()) {
                Channel channel = (Channel)channels.nextElement();
                TclIO.unregisterChannel(interp, channel);
            }
        }
        if (interp.slave.interpCmd != null) {
            interp.slave.slaveInterp = null;
            interp.slave.masterInterp.deleteCommandFromToken(interp.slave.interpCmd);
        }
        if (!interp.aliasTable.isEmpty()) {
            System.err.println("InterpInfoDeleteProc: still exist aliases");
        }
        interp.aliasTable = null;
    }

    static Interp create(Interp interp, TclObject path, boolean safe) throws TclException {
        InterpSlaveCmd slave;
        String pathString;
        Interp masterInterp;
        TclObject[] objv = TclList.getElements(interp, path);
        if (objv.length < 2) {
            masterInterp = interp;
            pathString = path.toString();
        } else {
            TclObject obj = TclList.newInstance();
            TclList.insert(interp, obj, 0, objv, 0, objv.length - 2);
            masterInterp = InterpCmd.getInterp(interp, obj);
            pathString = objv[objv.length - 1].toString();
        }
        if (!safe) {
            safe = masterInterp.isSafe;
        }
        if (masterInterp.slaveTable.containsKey(pathString)) {
            throw new TclException(interp, "interpreter named \"" + pathString + "\" already exists, cannot create");
        }
        Interp slaveInterp = new Interp();
        slaveInterp.slave = slave = new InterpSlaveCmd();
        slaveInterp.setAssocData("InterpSlaveCmd", slave);
        slave.masterInterp = masterInterp;
        slave.path = pathString;
        slave.slaveInterp = slaveInterp;
        masterInterp.createCommand(pathString, slaveInterp.slave);
        slaveInterp.slave.interpCmd = NamespaceCmd.findCommand(masterInterp, pathString, null, 0);
        masterInterp.slaveTable.put(pathString, slaveInterp.slave);
        slaveInterp.setVar("tcl_interactive", "0", 1);
        slaveInterp.maxNestingDepth = masterInterp.maxNestingDepth;
        if (safe) {
            try {
                InterpSlaveCmd.makeSafe(slaveInterp);
            }
            catch (TclException e) {
                e.printStackTrace();
            }
        }
        return slaveInterp;
    }

    static void eval(Interp interp, Interp slaveInterp, int objIx, TclObject[] objv) throws TclException {
        int result;
        slaveInterp.preserve();
        slaveInterp.allowExceptions();
        try {
            if (objIx + 1 == objv.length) {
                slaveInterp.eval(objv[objIx], 0);
            } else {
                TclObject obj = TclList.newInstance();
                for (int ix = objIx; ix < objv.length; ++ix) {
                    TclList.append(interp, obj, objv[ix]);
                }
                obj.preserve();
                slaveInterp.eval(obj, 0);
                obj.release();
            }
            result = slaveInterp.returnCode;
        }
        catch (TclException e) {
            result = e.getCompletionCode();
        }
        slaveInterp.release();
        interp.transferResult(slaveInterp, result);
    }

    static void expose(Interp interp, Interp slaveInterp, int objIx, TclObject[] objv) throws TclException {
        if (interp.isSafe) {
            throw new TclException(interp, "permission denied: safe interpreter cannot expose commands");
        }
        int nameIdx = objv.length - objIx == 1 ? objIx : objIx + 1;
        try {
            slaveInterp.exposeCommand(objv[objIx].toString(), objv[nameIdx].toString());
        }
        catch (TclException e) {
            interp.transferResult(slaveInterp, e.getCompletionCode());
            throw e;
        }
    }

    static void hide(Interp interp, Interp slaveInterp, int objIx, TclObject[] objv) throws TclException {
        if (interp.isSafe) {
            throw new TclException(interp, "permission denied: safe interpreter cannot hide commands");
        }
        int nameIdx = objv.length - objIx == 1 ? objIx : objIx + 1;
        try {
            slaveInterp.hideCommand(objv[objIx].toString(), objv[nameIdx].toString());
        }
        catch (TclException e) {
            interp.transferResult(slaveInterp, e.getCompletionCode());
            throw e;
        }
    }

    static void hidden(Interp interp, Interp slaveInterp) throws TclException {
        if (slaveInterp.hiddenCmdTable == null) {
            return;
        }
        TclObject result = TclList.newInstance();
        interp.setResult(result);
        Enumeration hiddenCmds = slaveInterp.hiddenCmdTable.keys();
        while (hiddenCmds.hasMoreElements()) {
            String cmdName = (String)hiddenCmds.nextElement();
            TclList.append(interp, result, TclString.newInstance(cmdName));
        }
    }

    static void invokeHidden(Interp interp, Interp slaveInterp, boolean global, int objIx, TclObject[] objv) throws TclException {
        int result;
        if (interp.isSafe) {
            throw new TclException(interp, "not allowed to invoke hidden commands from safe interpreter");
        }
        slaveInterp.preserve();
        slaveInterp.allowExceptions();
        TclObject[] localObjv = new TclObject[objv.length - objIx];
        for (int i = 0; i < objv.length - objIx; ++i) {
            localObjv[i] = objv[i + objIx];
        }
        try {
            if (global) {
                slaveInterp.invokeGlobal(localObjv, 1);
            } else {
                slaveInterp.invoke(localObjv, 1);
            }
            result = slaveInterp.returnCode;
        }
        catch (TclException e) {
            result = e.getCompletionCode();
        }
        slaveInterp.release();
        interp.transferResult(slaveInterp, result);
    }

    static void markTrusted(Interp interp, Interp slaveInterp) throws TclException {
        if (interp.isSafe) {
            throw new TclException(interp, "permission denied: safe interpreter cannot mark trusted");
        }
        slaveInterp.isSafe = false;
    }

    private static void makeSafe(Interp interp) throws TclException {
        interp.hideUnsafeCommands();
        interp.isSafe = true;
        try {
            interp.unsetVar("env", 1);
        }
        catch (TclException e) {
            // empty catch block
        }
        try {
            interp.unsetVar("tcl_platform", "os", 1);
        }
        catch (TclException e) {
            // empty catch block
        }
        try {
            interp.unsetVar("tcl_platform", "osVersion", 1);
        }
        catch (TclException e) {
            // empty catch block
        }
        try {
            interp.unsetVar("tcl_platform", "machine", 1);
        }
        catch (TclException e) {
            // empty catch block
        }
        try {
            interp.unsetVar("tcl_platform", "user", 1);
        }
        catch (TclException e) {
            // empty catch block
        }
        try {
            interp.unsetVar("tclDefaultLibrary", 1);
        }
        catch (TclException e) {
            // empty catch block
        }
        try {
            interp.unsetVar("tcl_library", 1);
        }
        catch (TclException e) {
            // empty catch block
        }
        try {
            interp.unsetVar("tcl_pkgPath", 1);
        }
        catch (TclException tclException) {
            // empty catch block
        }
        Channel chan = TclIO.getStdChannel(0);
        if (chan != null) {
            TclIO.unregisterChannel(interp, chan);
        }
        if ((chan = TclIO.getStdChannel(1)) != null) {
            TclIO.unregisterChannel(interp, chan);
        }
        if ((chan = TclIO.getStdChannel(2)) != null) {
            TclIO.unregisterChannel(interp, chan);
        }
    }
}

