/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.Var;

class ForeachCmd
implements Command {
    ForeachCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        int nSize;
        int i;
        if (objv.length < 4 || objv.length % 2 != 0) {
            throw new TclNumArgsException(interp, 1, objv, "varList list ?varList list ...? command");
        }
        TclObject[] name = new TclObject[(objv.length - 2) / 2];
        TclObject[] value = new TclObject[(objv.length - 2) / 2];
        int maxIter = 0;
        TclObject command = objv[objv.length - 1];
        boolean done = false;
        for (i = 0; i < objv.length - 2; i += 2) {
            int x = i / 2;
            name[x] = objv[i + 1];
            value[x] = objv[i + 2];
            nSize = TclList.getLength(interp, name[x]);
            int vSize = TclList.getLength(interp, value[x]);
            if (nSize == 0) {
                throw new TclException(interp, "foreach varlist is empty");
            }
            int iter = (vSize + nSize - 1) / nSize;
            if (maxIter >= iter) continue;
            maxIter = iter;
        }
        block10: for (int c = 0; !done && c < maxIter; ++c) {
            for (i = 0; i < objv.length - 2; i += 2) {
                int x = i / 2;
                nSize = TclList.getLength(interp, name[x]);
                int base = nSize * c;
                for (int j = 0; j < nSize; ++j) {
                    Var[] result = Var.lookupVar(interp, name[x].toString(), null, 0, null, false, false);
                    Var var = null;
                    if (result != null) {
                        var = result[1] != null ? result[1] : result[0];
                    }
                    try {
                        if (base + j >= TclList.getLength(interp, value[x])) {
                            interp.setVar(TclList.index(interp, name[x], j), TclString.newInstance(""), 0);
                            continue;
                        }
                        interp.setVar(TclList.index(interp, name[x], j), TclList.index(interp, value[x], base + j), 0);
                        continue;
                    }
                    catch (TclException e) {
                        throw new TclException(interp, "couldn't set loop variable: \"" + TclList.index(interp, name[x], j) + "\"");
                    }
                }
            }
            try {
                interp.eval(command, 0);
                continue;
            }
            catch (TclException e) {
                switch (e.getCompletionCode()) {
                    case 3: {
                        done = true;
                        continue block10;
                    }
                    case 4: {
                        continue block10;
                    }
                    case 1: {
                        interp.addErrorInfo("\n    (\"foreach\" body line " + interp.errorLine + ")");
                        throw e;
                    }
                    default: {
                        throw e;
                    }
                }
            }
        }
        interp.resetResult();
    }
}

