/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.util.CacheEntry;
import org.python.util.PythonInterpreter;

public class PyServlet
extends HttpServlet {
    private PythonInterpreter interp;
    private Hashtable cache = new Hashtable();
    private String rootPath;
    private static /* synthetic */ Class class$Ljavax$servlet$http$HttpServlet;

    public void init() {
        String name;
        this.rootPath = this.getServletContext().getRealPath("/");
        if (!this.rootPath.endsWith(File.separator)) {
            this.rootPath = this.rootPath + File.separator;
        }
        Properties props = new Properties();
        ServletContext context = this.getServletContext();
        Enumeration e = context.getInitParameterNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            ((Hashtable)props).put(name, context.getInitParameter(name));
        }
        e = this.getInitParameterNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            ((Hashtable)props).put(name, this.getInitParameter(name));
        }
        if (props.getProperty("python.home") == null && System.getProperty("python.home") == null) {
            ((Hashtable)props).put("python.home", this.rootPath + "WEB-INF" + File.separator + "lib");
        }
        PythonInterpreter.initialize(System.getProperties(), props, new String[0]);
        this.reset();
        PySystemState sys = Py.getSystemState();
        PySystemState.add_package("javax.servlet");
        PySystemState.add_package("javax.servlet.http");
        PySystemState.add_package("javax.servlet.jsp");
        PySystemState.add_package("javax.servlet.jsp.tagext");
        PySystemState.add_classdir(this.rootPath + "WEB-INF" + File.separator + "classes");
        PySystemState.add_extdir(this.rootPath + "WEB-INF" + File.separator + "lib", true);
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        req.setAttribute("pyservlet", this);
        String spath = (String)req.getAttribute("javax.servlet.include.servlet_path");
        if (spath == null && ((spath = ((HttpServletRequest)req).getServletPath()) == null || spath.length() == 0)) {
            spath = ((HttpServletRequest)req).getPathInfo();
        }
        String rpath = this.getServletContext().getRealPath(spath);
        this.interp.set("__file__", rpath);
        HttpServlet servlet = this.getServlet(rpath);
        if (servlet == null) {
            throw new ServletException("No python servlet found at:" + spath);
        }
        servlet.service(req, res);
    }

    public void reset() {
        this.destroyCache();
        this.interp = new PythonInterpreter(null, new PySystemState());
        this.cache.clear();
        PySystemState sys = Py.getSystemState();
        sys.path.append(new PyString(this.rootPath));
        String modulesDir = this.rootPath + "WEB-INF" + File.separator + "jython";
        sys.path.append(new PyString(modulesDir));
    }

    private final synchronized HttpServlet getServlet(String path) throws ServletException, IOException {
        CacheEntry entry = (CacheEntry)this.cache.get(path);
        if (entry == null) {
            return this.loadServlet(path);
        }
        File file = new File(path);
        if (file.lastModified() > entry.date) {
            return this.loadServlet(path);
        }
        return entry.servlet;
    }

    private final HttpServlet loadServlet(String path) throws ServletException, IOException {
        HttpServlet servlet = null;
        File file = new File(path);
        int start = path.lastIndexOf(File.separator);
        start = start < 0 ? 0 : ++start;
        int end = path.lastIndexOf(46);
        if (end < 0 || end <= start) {
            end = path.length();
        }
        String name = path.substring(start, end);
        try {
            this.interp.execfile(path);
            PyObject cls = this.interp.get(name);
            if (cls == null) {
                throw new ServletException("No callable (class or function) named " + name + " in " + path);
            }
            PyObject pyServlet = cls.__call__();
            Object o = pyServlet.__tojava__(class$Ljavax$servlet$http$HttpServlet != null ? class$Ljavax$servlet$http$HttpServlet : (class$Ljavax$servlet$http$HttpServlet = PyServlet.class$("javax.servlet.http.HttpServlet")));
            if (o == Py.NoConversion) {
                throw new ServletException("The value from " + name + "must extend HttpServlet");
            }
            servlet = (HttpServlet)o;
            servlet.init(this.getServletConfig());
        }
        catch (PyException e) {
            throw new ServletException("Could not create Jython servlet" + e.toString());
        }
        CacheEntry entry = new CacheEntry(servlet, file.lastModified());
        this.cache.put(path, entry);
        return servlet;
    }

    public void destroy() {
        this.destroyCache();
    }

    private final void destroyCache() {
        Enumeration e = this.cache.elements();
        while (e.hasMoreElements()) {
            CacheEntry entry = (CacheEntry)e.nextElement();
            entry.servlet.destroy();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

