/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.operations.WorkbenchReporter;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public final class InternalValidatorManager {
    private static InternalValidatorManager _inst = null;
    private static final String OP_GROUP = "ValidationOperation";

    private InternalValidatorManager() {
    }

    public static InternalValidatorManager getManager() {
        if (_inst == null) {
            _inst = new InternalValidatorManager();
        }
        return _inst;
    }

    public static Set wrapInSet(Object[] obj) {
        HashSet<Object> result = new HashSet<Object>();
        if (obj == null || obj.length == 0) {
            return result;
        }
        int i = 0;
        while (i < obj.length) {
            result.add(obj[i]);
            ++i;
        }
        return result;
    }

    public void addInternalErrorTask(IProject project, ValidatorMetaData vmd, Throwable exc) {
        this.addOperationTask(project, vmd, "VBF_EXC_INTERNAL", new String[]{project.getName(), vmd.getValidatorDisplayName(), exc.getMessage() == null ? "" : exc.getMessage()});
    }

    public void addOperationTask(IProject project, ValidatorMetaData vmd, String messageId, String[] parms) {
        Message message = ValidationPlugin.getMessage();
        message.setSeverity(4);
        message.setId(messageId);
        message.setParams(parms);
        message.setGroupName(OP_GROUP);
        WorkbenchReporter.addMessage((IResource)project, vmd.getValidatorUniqueName(), this.getClass().getClassLoader(), (IMessage)message);
    }

    public void removeOperationTasks(IProject project, ValidatorMetaData vmd) {
        WorkbenchReporter.removeMessageSubset((IResource)project, vmd.getValidatorUniqueName(), OP_GROUP);
    }

    public String[] getValidatorNames(ValidatorMetaData[] vmds) {
        HashSet<String> temp = new HashSet<String>();
        int i = 0;
        while (i < vmds.length) {
            String[] names = vmds[i].getValidatorNames();
            int j = 0;
            while (j < names.length) {
                temp.add(names[j]);
                ++j;
            }
            ++i;
        }
        String[] vmdNames = new String[temp.size()];
        temp.toArray(vmdNames);
        return vmdNames;
    }

    public String[] getValidatorNames(Collection vmds) {
        HashSet<String> temp = new HashSet<String>();
        Iterator iterator = vmds.iterator();
        while (iterator.hasNext()) {
            ValidatorMetaData vmd = (ValidatorMetaData)iterator.next();
            String[] names = vmd.getValidatorNames();
            int j = 0;
            while (j < names.length) {
                temp.add(names[j]);
                ++j;
            }
        }
        String[] vmdNames = new String[temp.size()];
        temp.toArray(vmdNames);
        return vmdNames;
    }

    public ValidatorMetaData[] getValidatorsForExtension(IProject project, String fileExtension) {
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            ValidatorMetaData[] vmds = prjp.getValidators();
            StringBuffer buffer = new StringBuffer(project.getName());
            buffer.append('/');
            buffer.append(fileExtension);
            Path path = new Path(buffer.toString());
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            ValidatorMetaData[] temp = new ValidatorMetaData[vmds.length];
            int count = 0;
            int i = 0;
            while (i < vmds.length) {
                ValidatorMetaData vmd = vmds[i];
                if (vmd.isApplicableTo((IResource)file)) {
                    temp[count++] = vmd;
                }
                ++i;
            }
            ValidatorMetaData[] result = new ValidatorMetaData[count];
            System.arraycopy(temp, 0, result, 0, count);
            return result;
        }
        catch (InvocationTargetException exc) {
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("InternalValidatorManager::getValidatorsForExtension(" + project.getName() + ", " + fileExtension + ")");
                entry.setTargetException(exc);
                logger.write(Level.SEVERE, entry);
                if (exc.getTargetException() != null) {
                    entry.setTargetException(exc);
                    logger.write(Level.SEVERE, entry);
                }
            }
            return new ValidatorMetaData[0];
        }
    }

    public String[] getValidatorNamesForExtension(IProject project, String fileExtension) {
        ValidatorMetaData[] vmds = this.getValidatorsForExtension(project, fileExtension);
        String[] names = new String[vmds.length];
        int i = 0;
        while (i < names.length) {
            names[i] = vmds[i].getValidatorUniqueName();
            ++i;
        }
        return names;
    }
}

