/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.resource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.eclipse.wst.common.internal.emf.resource.J2EESchemaUtility;

public class J2EESchemaUtilityTest {
    public static final String[][] TEST_DATA = new String[][]{{"Test WebModule that already has complete information", "web.xml", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<web-app id=\"WebApp_ID\" version=\"2.4\" xmlns=\"http://java.sun.com/xml/ns/j2ee\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd\">\n</web-app>\n", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<web-app id=\"WebApp_ID\" version=\"2.4\" xmlns=\"http://java.sun.com/xml/ns/j2ee\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd\">\n</web-app>\n"}, {"Test WebModule with incomplete information", "web.xml", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<web-app id=\"WebApp_ID\" version=\"2.4\" xmlns=\"http://java.sun.com/xml/ns/j2ee\">\n</web-app>\n", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<web-app id=\"WebApp_ID\" version=\"2.4\" xmlns=\"http://java.sun.com/xml/ns/j2ee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd\">\n</web-app>\n"}, {"Test WebModule with a possible comment match, and with incomplete information.", "web.xml", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!-- <web-app id=\"WebApp_ID\" version=\"2.4\"></web-app>-->\n<web-app id=\"WebApp_ID\" version=\"2.4\" xmlns=\"http://java.sun.com/xml/ns/j2ee\">\n</web-app>\n", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!-- <web-app id=\"WebApp_ID\" version=\"2.4\"></web-app>-->\n<web-app id=\"WebApp_ID\" version=\"2.4\" xmlns=\"http://java.sun.com/xml/ns/j2ee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd\">\n</web-app>\n"}, {"Test WebModule with a possible comment match, and with complete information.", "web.xml", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!-- <web-app id=\"WebApp_ID\" version=\"2.4\"></web-app>-->\n<web-app id=\"WebApp_ID\" version=\"2.4\" xmlns=\"http://java.sun.com/xml/ns/j2ee\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd\">\n</web-app>\n", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!-- <web-app id=\"WebApp_ID\" version=\"2.4\"></web-app>-->\n<web-app id=\"WebApp_ID\" version=\"2.4\" xmlns=\"http://java.sun.com/xml/ns/j2ee\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd\">\n</web-app>\n"}, {"Test WebModule with a possible comment match, with complex comment structure, and with incomplete information.", "web.xml", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!-- <web-app id=\"WebApp_ID\" version=\"2.4\"></web-app>-->\n<web-app <!-- --> id=\"WebApp_ID\" <!-- --> version=\"2.4\" <!-- --> xmlns=\"http://java.sun.com/xml/ns/j2ee\"\n<!-- -->\n>\n</web-app>\n", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!-- <web-app id=\"WebApp_ID\" version=\"2.4\"></web-app>-->\n<web-app <!-- --> id=\"WebApp_ID\" <!-- --> version=\"2.4\" <!-- --> xmlns=\"http://java.sun.com/xml/ns/j2ee\"\n<!-- -->\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd\">\n</web-app>\n"}};
    public static final String TEST_COMMENTS = "<!-- --> <!-- <!-- --> <!--";
    public static int[][] TEST_COMMENT_REGIONS;

    static {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[2];
        nArray[1] = 8;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{9, 22};
        nArrayArray[2] = new int[]{23, 27};
        TEST_COMMENT_REGIONS = nArrayArray;
    }

    public static void main(String[] args) {
        J2EESchemaUtilityTest.testComments(TEST_COMMENTS, TEST_COMMENT_REGIONS);
        try {
            int testNo = 0;
            while (testNo < TEST_DATA.length) {
                String testDescription = TEST_DATA[testNo][0];
                String testLocation = TEST_DATA[testNo][1];
                String testText = TEST_DATA[testNo][2];
                String testOutput = TEST_DATA[testNo][3];
                J2EESchemaUtilityTest.testConvert(testText, testLocation, testDescription, testOutput);
                ++testNo;
            }
        }
        catch (IOException e) {
            System.out.println("Unexpected test exception [ " + e + " ]");
            e.printStackTrace(System.out);
        }
    }

    public static String testConvert(String testText, String testLocation, String description, String expectedOutput) throws IOException {
        System.out.println("========================================");
        System.out.println(description);
        System.out.println("Input [ " + testText + " ]");
        System.out.println("Location [ " + testLocation + " ]");
        byte[] testBytes = J2EESchemaUtility.getBytes(testText);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(testBytes);
        ByteArrayInputStream convertedStream = J2EESchemaUtility.forceSchema(inputStream, testLocation);
        byte[] convertedBytes = J2EESchemaUtility.load(convertedStream);
        String convertedText = new String(convertedBytes, "UTF-8");
        System.out.println("Output [ " + convertedText + " ]");
        if (convertedText.equals(expectedOutput)) {
            System.out.println("PASSED");
        } else {
            System.out.println("Expected [ " + expectedOutput + " ]");
            System.out.println("FAILED");
        }
        System.out.println("========================================");
        return convertedText;
    }

    public static int[][] testComments(String commentText, int[][] expectedRegions) {
        System.out.println("Input [ " + commentText + " ]");
        int[][] actualRegions = J2EESchemaUtility.locateComments(J2EESchemaUtility.getBytes(commentText));
        int numRegions = actualRegions.length;
        System.out.println("Expected Regions: [ " + expectedRegions.length + " ] actual [ " + numRegions + " ]");
        int regionMax = numRegions > expectedRegions.length ? numRegions : expectedRegions.length;
        int regionNo = 0;
        while (regionNo < regionMax) {
            int expectedEnd;
            int expectedStart;
            int actualEnd;
            int actualStart;
            if (regionNo < numRegions) {
                actualStart = actualRegions[regionNo][0];
                actualEnd = actualRegions[regionNo][1];
            } else {
                actualStart = -1;
                actualEnd = -1;
            }
            if (regionNo < expectedRegions.length) {
                expectedStart = expectedRegions[regionNo][0];
                expectedEnd = expectedRegions[regionNo][1];
            } else {
                expectedStart = -1;
                expectedEnd = -1;
            }
            System.out.println("  Actual [ " + actualStart + ", " + actualEnd + " ] expected [ " + expectedStart + ", " + expectedEnd + " ]");
            ++regionNo;
        }
        return actualRegions;
    }
}

