/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.wst.common.internal.emf.resource.AbstractRendererImpl;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMAdapter;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMAdapterImpl;
import org.eclipse.wst.common.internal.emf.resource.EMF2SAXRenderer;
import org.eclipse.wst.common.internal.emf.resource.Renderer;
import org.eclipse.wst.common.internal.emf.resource.TranslatorResource;
import org.eclipse.wst.common.internal.emf.resource.TranslatorResourceImpl;
import org.eclipse.wst.common.internal.emf.utilities.DOMLoadOptions;
import org.eclipse.wst.common.internal.emf.utilities.DOMUtilities;
import org.eclipse.wst.common.internal.emf.utilities.Revisit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EMF2DOMRenderer
extends AbstractRendererImpl
implements Renderer {
    public static final String CONFIG_WTP_LOGGER = "com.ibm.config.eclipse.wtp";
    public static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    public static final String CLASS_NAME = EMF2DOMRenderer.class.getName();
    protected Map domAdapterRegistry;
    protected boolean needsToCreateDOM = true;
    protected Document document;

    public EMF2DOMRenderer() {
        logger.logp(Level.FINER, CLASS_NAME, "EMF2DOMRenderer()", "Constructor [ No Args ]");
        if (this.managesDOMAdapters()) {
            logger.logp(Level.FINER, CLASS_NAME, "EMF2DOMRenderer()", "DOM Adapters are enabled");
            this.initDOMAdapterRegistry();
        }
    }

    public int getVersionID() {
        return this.getResource().getVersionID();
    }

    protected boolean managesDOMAdapters() {
        return true;
    }

    protected void initDOMAdapterRegistry() {
        if (this.domAdapterRegistry == null) {
            this.domAdapterRegistry = new HashMap();
        }
    }

    public void registerDOMAdapter(Node node, EMF2DOMAdapter adapter) {
        this.domAdapterRegistry.put(node, adapter);
    }

    public EMF2DOMAdapter getExistingDOMAdapter(Node node) {
        return (EMF2DOMAdapter)this.domAdapterRegistry.get(node);
    }

    public void removeDOMAdapter(Node node, EMF2DOMAdapter adapter) {
        this.domAdapterRegistry.remove(node);
    }

    public void doLoad(InputStream in, Map options) throws IOException {
        String methodName = "doLoad";
        logger.entering(CLASS_NAME, methodName);
        if (in != null || !this.useStreamsForIO()) {
            logger.finer("Loading document ... done");
            this.loadDocument(in, options);
            logger.finer("Loading document ... done");
            TranslatorResource rawResource = this.getResource();
            if (rawResource instanceof TranslatorResourceImpl) {
                TranslatorResourceImpl implResource = (TranslatorResourceImpl)rawResource;
                boolean bl = implResource.setModuleVersionID(this.document);
            }
            logger.finer("Mashalling model elements ...");
            this.createRootDOMAdapter().updateMOF();
            logger.finer("Mashalling model elements ... done");
        } else {
            logger.warning("No input stream, and stream are marked for input!");
            logger.warning("No load was performed!");
        }
        logger.exiting(CLASS_NAME, methodName);
    }

    protected void loadDocument(InputStream in, Map options) throws IOException {
        String methodName = "loadDocument";
        logger.entering(CLASS_NAME, methodName);
        try {
            DOMLoadOptions domOpts = new DOMLoadOptions();
            domOpts.setAllowJavaEncodings(true);
            this.setDOMOption("AllowJavaEncodings", "true");
            domOpts.setExpandEntityRefererences(true);
            this.setDOMOption("ExpandEntityReferences", "true");
            if (this.isValidating()) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "Disabled validation to support external entity processing.");
            }
            domOpts.setValidate(false);
            this.setDOMOption("Validate", "false");
            URI useSystemId = EMF2SAXRenderer.getSystemId(options);
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Parsing with system ID [ {0} ]", new Object[]{useSystemId});
            if (useSystemId != null) {
                domOpts.setSystemId(useSystemId);
            }
            logger.finer("Loading document ...");
            this.document = DOMUtilities.loadDocument(in, domOpts, this.getResource().getEntityResolver());
            logger.finer("Loading document ... done");
            this.needsToCreateDOM = false;
        }
        catch (RuntimeException t_rex) {
            String message = "Failed to create document [ " + TranslatorResourceImpl.getResourceMessage(this.getResource()) + " ]" + " [ " + t_rex + " ]";
            logger.severe(message);
            logger.exiting(CLASS_NAME, methodName);
            throw t_rex;
        }
        catch (IOException iox) {
            String message = "Failed to create document [ " + TranslatorResourceImpl.getResourceMessage(this.getResource()) + " ]" + " [ " + iox + " ]";
            logger.severe(message);
            logger.exiting(CLASS_NAME, methodName);
            throw iox;
        }
        catch (Exception ex) {
            String message = "Failed to create document [ " + TranslatorResourceImpl.getResourceMessage(this.getResource()) + " ]" + " [ " + ex + " ]";
            logger.severe(message);
            logger.exiting(CLASS_NAME, methodName);
            throw new WrappedException(ex);
        }
        logger.exiting(CLASS_NAME, methodName);
    }

    protected void setDOMOption(String key, String value) {
        logger.logp(Level.FINER, CLASS_NAME, "setDOMOption", "Key [ {0} ] Value [ {1} ]", new Object[]{key, value});
    }

    public void doSave(OutputStream outputStream, Map options) throws IOException {
        String methodName = "doSave";
        logger.entering(CLASS_NAME, methodName);
        this.createDOMTreeIfNecessary();
        this.serializeDocument(outputStream);
        logger.exiting(CLASS_NAME, methodName);
    }

    public void prepareToAddContents() {
    }

    protected void createDOMTreeIfNecessary() {
        if (this.needsToCreateDOM) {
            this.createDOMTree();
        }
    }

    protected Node createDOMTree() {
        this.createDocument();
        this.createRootDOMAdapter().updateDOM();
        this.needsToCreateDOM = false;
        return this.document;
    }

    protected EMF2DOMAdapter createRootDOMAdapter() {
        EMF2DOMAdapterImpl root = new EMF2DOMAdapterImpl(this.getResource(), this.document, this, this.getResource().getRootTranslator());
        this.registerDOMAdapter(this.document, root);
        return root;
    }

    protected void createDocument() {
        String methodName = "createDocument";
        logger.entering(CLASS_NAME, methodName);
        TranslatorResource res = this.getResource();
        int versionId = res.getVersionID();
        String doctype = res.getDoctype();
        String publicId = res.getPublicId();
        String systemId = res.getSystemId();
        logger.logp(Level.FINER, CLASS_NAME, methodName, "Version ID [ {0} ]", new Object[]{new Integer(versionId)});
        logger.logp(Level.FINER, CLASS_NAME, methodName, "Document Type [ {0} ]", new Object[]{doctype});
        logger.logp(Level.FINER, CLASS_NAME, methodName, "Public ID [ {0} ]", new Object[]{publicId});
        logger.logp(Level.FINER, CLASS_NAME, methodName, "SystemID [ {0} ]", new Object[]{systemId});
        Exception boundException = null;
        try {
            this.document = DOMUtilities.createNewDocument(doctype, publicId, systemId);
        }
        catch (ParserConfigurationException e) {
            boundException = e;
        }
        catch (SAXException e) {
            boundException = e;
        }
        catch (IOException e) {
            boundException = e;
        }
        if (boundException != null) {
            String message = "Failed to create document [ " + TranslatorResourceImpl.getResourceMessage(this.getResource()) + " ]" + " [ " + boundException + " ]";
            logger.severe(message);
            logger.exiting(CLASS_NAME, methodName);
            throw new WrappedException(boundException);
        }
        logger.exiting(CLASS_NAME, methodName);
    }

    public void serializeDocument(OutputStream out) throws IOException {
        String methodName = "serializeDocument";
        logger.entering(CLASS_NAME, methodName);
        Throwable boundException = null;
        try {
            Transformer transformer = this.createTransformer();
            logger.finer("Created transformer");
            DOMSource source = new DOMSource(this.document.getDocumentElement());
            logger.finer("Created DOM source");
            transformer.transform(source, new StreamResult(out));
            logger.finer("Completed transform");
        }
        catch (TransformerConfigurationException e) {
            boundException = e;
        }
        catch (TransformerFactoryConfigurationError e) {
            boundException = e;
        }
        catch (TransformerException e) {
            boundException = e;
        }
        if (boundException != null) {
            String message = "Failed to create document [ " + TranslatorResourceImpl.getResourceMessage(this.getResource()) + " ]" + " [ " + boundException + " ]";
            logger.severe(message);
        }
        logger.exiting(CLASS_NAME, methodName);
    }

    protected Transformer createTransformer() throws TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        this.setOutputProperty(transformer, "encoding", this.getResource().getEncoding());
        this.setOutputProperty(transformer, "version", this.getResource().getXMLVersion());
        this.setOutputProperty(transformer, "method", "xml");
        this.setOutputProperty(transformer, "omit-xml-declaration", "no");
        if (this.getResource().getPublicId() != null) {
            this.setOutputProperty(transformer, "doctype-public", this.getResource().getPublicId());
        }
        if (this.getResource().getSystemId() != null) {
            this.setOutputProperty(transformer, "doctype-system", this.getResource().getSystemId());
        }
        this.setOutputProperty(transformer, "indent", "yes");
        this.setOutputProperty(transformer, "{http://xml.apache.org/xslt}indent-amount", "4");
        return transformer;
    }

    protected void setOutputProperty(Transformer transformer, String key, String value) {
        logger.logp(Level.FINER, CLASS_NAME, "setOutputProperty", "Key [ {0} ] Value [ {1} ]", new Object[]{key, value});
        transformer.setOutputProperty(key, value);
    }

    public void preUnload() {
        EMF2DOMAdapter adapter = (EMF2DOMAdapter)EcoreUtil.getAdapter(this.resource.eAdapters(), EMF2DOMAdapter.ADAPTER_CLASS);
        if (adapter != null) {
            adapter.removeAdapters(adapter.getNode());
        }
    }

    public void replaceDocumentType(String docTypeName, String publicId, String systemId) {
        Document newDoc;
        String methodName = "replaceDocumentType";
        logger.entering(CLASS_NAME, methodName);
        logger.logp(Level.FINER, CLASS_NAME, methodName, "New DocType Name [ {0} ]", new Object[]{docTypeName});
        logger.logp(Level.FINER, CLASS_NAME, methodName, "New Public ID [ {0} ]", new Object[]{publicId});
        logger.logp(Level.FINER, CLASS_NAME, methodName, "New System ID [ {0} ]", new Object[]{systemId});
        Revisit.revisit();
        try {
            newDoc = DOMUtilities.createNewDocument(docTypeName, publicId, systemId);
        }
        catch (ParserConfigurationException e) {
            logger.exiting(CLASS_NAME, methodName);
            throw new WrappedException(e);
        }
        catch (SAXException e) {
            logger.exiting(CLASS_NAME, methodName);
            throw new WrappedException(e);
        }
        catch (IOException e) {
            logger.exiting(CLASS_NAME, methodName);
            throw new WrappedException(e);
        }
        this.replaceNode(this.document.getDocumentElement(), newDoc, newDoc);
        this.readapt(this.document, newDoc);
        this.document = newDoc;
        logger.exiting(CLASS_NAME, methodName);
    }

    protected void replaceNode(Node oldChild, Node newParent, Document newDoc) {
        Node newChild = newDoc.importNode(oldChild, false);
        newParent.appendChild(newChild);
        this.readapt(oldChild, newChild);
        NodeList children = oldChild.getChildNodes();
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            this.replaceNode(children.item(i), newChild, newDoc);
            ++i;
        }
    }

    protected void readapt(Node oldChild, Node newChild) {
        logger.finest("Entering");
        EMF2DOMAdapter adapter = this.getExistingDOMAdapter(oldChild);
        if (adapter != null) {
            logger.finest("An adapter was selected");
            this.registerDOMAdapter(newChild, adapter);
            if (adapter.getNode() == oldChild) {
                logger.finest("Updated adapter node");
                adapter.setNode(newChild);
            }
        } else {
            logger.finest("No adaptor was selected");
        }
        logger.finest("Exiting");
    }
}

