/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.conformance;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.ws.internal.conformance.IJavaBeanProperty;
import org.eclipse.jst.ws.internal.conformance.IJavaWebServiceRule;
import org.eclipse.jst.ws.internal.conformance.IJavaWebServiceRuleEngine;

public class JavaWebServiceRuleSet {
    private Set enabledRules_ = new HashSet();
    private Set disabledRules_ = new HashSet();

    public JavaWebServiceRuleSet() {
    }

    public JavaWebServiceRuleSet(IJavaWebServiceRule[] rules) {
        this.addRules(rules);
    }

    public void addRule(IJavaWebServiceRule rule) {
        this.enabledRules_.add(rule);
    }

    public void addRules(IJavaWebServiceRule[] rules) {
        this.enabledRules_.addAll(Arrays.asList(rules));
    }

    public boolean setRuleDisabled(IJavaWebServiceRule rule, boolean disabled) {
        if (disabled) {
            if (this.enabledRules_.remove(rule)) {
                this.disabledRules_.add(rule);
                return true;
            }
        } else if (this.disabledRules_.remove(rule)) {
            this.enabledRules_.add(rule);
            return true;
        }
        return false;
    }

    public int size() {
        return this.enabledRules_.size() + this.disabledRules_.size();
    }

    public int numberEnabled() {
        return this.enabledRules_.size();
    }

    public int numberDisabled() {
        return this.disabledRules_.size();
    }

    public IJavaWebServiceRule[] getEnabledRules() {
        return this.enabledRules_.toArray(new IJavaWebServiceRule[0]);
    }

    public IJavaWebServiceRule[] getDisabledRules() {
        return this.disabledRules_.toArray(new IJavaWebServiceRule[0]);
    }

    public void init(IJavaWebServiceRuleEngine engine2) {
        Iterator i = this.enabledRules_.iterator();
        while (i.hasNext()) {
            IJavaWebServiceRule rule = (IJavaWebServiceRule)i.next();
            rule.init(engine2);
        }
    }

    public void visitClass(IType jdtClass, Stack peanutTrail) {
        Iterator i = this.enabledRules_.iterator();
        while (i.hasNext()) {
            IJavaWebServiceRule rule = (IJavaWebServiceRule)i.next();
            rule.visitClass(jdtClass, peanutTrail);
        }
    }

    public void visitException(IType jdtClass, Stack peanutTrail) {
        Iterator i = this.enabledRules_.iterator();
        while (i.hasNext()) {
            IJavaWebServiceRule rule = (IJavaWebServiceRule)i.next();
            rule.visitException(jdtClass, peanutTrail);
        }
    }

    public void visitField(IField jdtField, Stack peanutTrail) {
        Iterator i = this.enabledRules_.iterator();
        while (i.hasNext()) {
            IJavaWebServiceRule rule = (IJavaWebServiceRule)i.next();
            rule.visitField(jdtField, peanutTrail);
        }
    }

    public void visitProperty(IJavaBeanProperty beanProperty, Stack peanutTrail) {
        Iterator i = this.enabledRules_.iterator();
        while (i.hasNext()) {
            IJavaWebServiceRule rule = (IJavaWebServiceRule)i.next();
            rule.visitProperty(beanProperty, peanutTrail);
        }
    }

    public void visitMethod(IMethod jdtMethod, Stack peanutTrail) {
        Iterator i = this.enabledRules_.iterator();
        while (i.hasNext()) {
            IJavaWebServiceRule rule = (IJavaWebServiceRule)i.next();
            rule.visitMethod(jdtMethod, peanutTrail);
        }
    }

    public IStatus getResults(String rootMessage) {
        LinkedList<IStatus> list = new LinkedList<IStatus>();
        Iterator e = this.enabledRules_.iterator();
        while (e.hasNext()) {
            IJavaWebServiceRule rule = (IJavaWebServiceRule)e.next();
            IStatus status = rule.getResults();
            if (status.isOK()) continue;
            list.add(status);
        }
        if (list.size() > 0) {
            MultiStatus multiStatus = new MultiStatus("org.eclipse.jst.ws", 0, rootMessage, null);
            Iterator l = list.iterator();
            while (l.hasNext()) {
                IStatus status = (IStatus)l.next();
                multiStatus.addAll(status);
            }
            return multiStatus;
        }
        return new Status(0, "org.eclipse.jst.ws", 0, "", null);
    }
}

