/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.common;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.util.emf.workbench.nature.EMFNature;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;

public final class JavaMOFUtils {
    public static boolean isClassLoadable(String className, IProject project) throws CoreException {
        return JavaMOFUtils.isClassLoadable(JavaMOFUtils.getJavaClass(className, project));
    }

    public static boolean isClassLoadable(JavaClass javaClass) {
        return javaClass.isExistingType();
    }

    public static boolean hasPublicDefaultCtor(String className, IProject project) throws CoreException {
        return JavaMOFUtils.hasPublicDefaultCtor(JavaMOFUtils.getJavaClass(className, project));
    }

    public static boolean hasPublicDefaultCtor(JavaClass javaClass) {
        EList methodList = javaClass.getMethods();
        if (methodList == null) {
            return true;
        }
        Iterator iMethods = methodList.iterator();
        boolean userDefinedCtor = false;
        while (iMethods.hasNext()) {
            EList paramList;
            Method thisMethod = (Method)iMethods.next();
            if (!thisMethod.isConstructor()) continue;
            userDefinedCtor = true;
            if (thisMethod.getJavaVisibility().getValue() != 0 || !(paramList = thisMethod.getParameters()).isEmpty()) continue;
            return true;
        }
        return !userDefinedCtor;
    }

    public static boolean implementsInterface(String className, String interfaceName, IProject project) throws CoreException {
        return JavaMOFUtils.implementsInterface(JavaMOFUtils.getJavaClass(className, project), JavaMOFUtils.getJavaClass(interfaceName, project));
    }

    public static boolean implementsInterface(JavaClass javaClass, JavaClass interfaceClass) {
        if (!javaClass.isExistingType()) {
            return false;
        }
        if (!interfaceClass.isExistingType()) {
            return false;
        }
        return javaClass.implementsInterface(interfaceClass);
    }

    public static boolean extendsClass(String className, String superClassName, IProject project) throws CoreException {
        return JavaMOFUtils.extendsClass(JavaMOFUtils.getJavaClass(className, project), JavaMOFUtils.getJavaClass(superClassName, project));
    }

    public static boolean extendsClass(JavaClass javaClass, JavaClass superClass) {
        return superClass.isAssignableFrom(javaClass);
    }

    public static boolean isInterface(String className, IProject project) throws CoreException {
        return JavaMOFUtils.isInterface(JavaMOFUtils.getJavaClass(className, project));
    }

    public static boolean isInterface(JavaClass javaClass) {
        return javaClass.isInterface();
    }

    public static boolean hasAbstractMethods(String className, IProject project) throws CoreException {
        return JavaMOFUtils.hasAbstractMethods(JavaMOFUtils.getJavaClass(className, project));
    }

    public static boolean hasAbstractMethods(JavaClass javaClass) {
        EList methodList = javaClass.getMethods();
        if (methodList == null) {
            return false;
        }
        Iterator iMethods = methodList.iterator();
        while (iMethods.hasNext()) {
            Method thisMethod = (Method)iMethods.next();
            if (!thisMethod.isAbstract()) continue;
            return true;
        }
        return false;
    }

    public static JavaClass getJavaClass(String classQName, IProject project) throws CoreException {
        EMFNature jMOF = JemProjectUtilities.getJEM_EMF_Nature((IProject)project, (boolean)true);
        return (JavaClass)JavaRefFactory.eINSTANCE.reflectType(classQName, jMOF.getResourceSet());
    }

    public static JavaClass getJavaClass(String packageName, String typeName, IProject project) throws CoreException {
        EMFNature jMOF = JemProjectUtilities.getJEM_EMF_Nature((IProject)project, (boolean)true);
        return (JavaClass)JavaRefFactory.eINSTANCE.reflectType(packageName, typeName, jMOF.getResourceSet());
    }

    public static boolean isValidSEIFile(JavaClass beanClass, JavaClass seiClass) {
        if (!seiClass.isInterface()) {
            return false;
        }
        Vector<String> beanMethodsList = new Vector<String>();
        EList beanMethods = beanClass.getMethods();
        Iterator beanMethodsIterator = beanMethods.iterator();
        while (beanMethodsIterator.hasNext()) {
            Method thisMethod = (Method)beanMethodsIterator.next();
            beanMethodsList.add(thisMethod.getMethodElementSignature());
        }
        EList seiMethods = seiClass.getMethods();
        if (beanMethods == null) {
            return seiMethods == null;
        }
        if (seiMethods == null) {
            return false;
        }
        Iterator seiMethodsIterator = seiMethods.iterator();
        while (seiMethodsIterator.hasNext()) {
            Method thisMethod = (Method)seiMethodsIterator.next();
            if (beanMethodsList.contains(thisMethod.getMethodElementSignature())) continue;
            return false;
        }
        return true;
    }
}

