/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.server.core.IJavaRuntime;
import org.eclipse.jst.server.core.internal.JavaServerPlugin;
import org.eclipse.jst.server.core.internal.RuntimeClasspathProviderWrapper;
import org.eclipse.jst.server.core.internal.RuntimeComponentProviderWrapper;
import org.eclipse.jst.server.core.internal.RuntimeFacetMapping;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeBridge;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.Runtime;

public class RuntimeBridge
implements IRuntimeBridge {
    protected static final String CLASSPATH = "classpath";
    protected static Map mappings = new HashMap();

    static {
        RuntimeBridge.initialize();
    }

    private static void addMapping(String id, String id2, String version) {
        try {
            mappings.put(id, RuntimeManager.getRuntimeComponentType((String)id2).getVersion(version));
        }
        catch (Exception exception) {}
    }

    private static void initialize() {
        RuntimeFacetMapping[] rfms = JavaServerPlugin.getRuntimeFacetMapping();
        int size = rfms.length;
        int i = 0;
        while (i < size) {
            RuntimeBridge.addMapping(rfms[i].getRuntimeTypeId(), rfms[i].getRuntimeComponent(), rfms[i].getVersion());
            ++i;
        }
        RuntimeBridge.addMapping("org.eclipse.jst.server.generic.runtime.weblogic81", "org.eclipse.jst.server.generic.runtime.weblogic", "8.1");
        RuntimeBridge.addMapping("org.eclipse.jst.server.generic.runtime.weblogic90", "org.eclipse.jst.server.generic.runtime.weblogic", "9.0");
        RuntimeBridge.addMapping("org.eclipse.jst.server.generic.runtime.jboss323", "org.eclipse.jst.server.generic.runtime.jboss", "3.2.3");
        RuntimeBridge.addMapping("org.eclipse.jst.server.generic.runtime.jonas4", "org.eclipse.jst.server.generic.runtime.jonas", "4.0");
        RuntimeBridge.addMapping("org.eclipse.jst.server.generic.runtime.oracle1013", "org.eclipse.jst.server.generic.runtime.oracle", "10.1.3");
        RuntimeBridge.addMapping("org.eclipse.jst.server.generic.runtime.websphere.6", "org.eclipse.jst.server.generic.runtime.websphere", "6.0");
    }

    public Set getExportedRuntimeNames() throws CoreException {
        IRuntime[] runtimes = ServerCore.getRuntimes();
        HashSet<String> result = new HashSet<String>(runtimes.length);
        int i = 0;
        while (i < runtimes.length) {
            IRuntime runtime2 = runtimes[i];
            IRuntimeType runtimeType = runtime2.getRuntimeType();
            if (runtimeType != null && mappings.containsKey(runtimeType.getId())) {
                result.add(runtime2.getName());
            }
            ++i;
        }
        return result;
    }

    public IRuntimeBridge.IStub bridge(String name) throws CoreException {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        IRuntime[] runtimes = ServerCore.getRuntimes();
        int size = runtimes.length;
        int i = 0;
        while (i < size) {
            if (runtimes[i].getName().equals(name)) {
                return new Stub(runtimes[i]);
            }
            ++i;
        }
        return null;
    }

    protected static boolean isUsingDefaultJRE(IJavaRuntime javaRuntime) {
        try {
            Method m = javaRuntime.getClass().getMethod("isUsingDefaultJRE", null);
            Object o = m.invoke((Object)javaRuntime, null);
            Boolean b = (Boolean)o;
            return b;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static class Stub
    implements IRuntimeBridge.IStub {
        private IRuntime runtime;
        protected int timestamp = -1;
        protected IVMInstall vmInstall;
        protected String jvmver;
        static /* synthetic */ Class class$0;

        public Stub(IRuntime runtime2) {
            this.runtime = runtime2;
        }

        public List getRuntimeComponents() {
            List list;
            RuntimeComponentProviderWrapper componentProvider;
            IJavaRuntime javaRuntime;
            ArrayList<IRuntimeComponent> components = new ArrayList<IRuntimeComponent>(2);
            if (this.runtime == null) {
                return components;
            }
            String typeId = this.runtime.getRuntimeType().getId();
            IRuntimeComponentVersion mapped = (IRuntimeComponentVersion)mappings.get(typeId);
            HashMap<String, String> properties = new HashMap<String, String>(5);
            if (this.runtime.getLocation() != null) {
                properties.put("location", this.runtime.getLocation().toPortableString());
            } else {
                properties.put("location", "");
            }
            properties.put("name", this.runtime.getName());
            properties.put("type", this.runtime.getRuntimeType().getName());
            properties.put("id", this.runtime.getId());
            RuntimeClasspathProviderWrapper rcpw = JavaServerPlugin.findRuntimeClasspathProvider(this.runtime.getRuntimeType());
            if (rcpw != null) {
                Object path = new Path("org.eclipse.jst.server.core.container");
                path = path.append(rcpw.getId()).append(this.runtime.getId());
                properties.put(RuntimeBridge.CLASSPATH, path.toPortableString());
            }
            components.add(RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)mapped, properties));
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jst.server.core.IJavaRuntime");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((javaRuntime = (IJavaRuntime)this.runtime.loadAdapter((Class)clazz, null)) != null) {
                IRuntimeComponentVersion rcv;
                IVMInstall2 vmInstall2;
                if (this.timestamp != ((Runtime)this.runtime).getTimestamp()) {
                    this.vmInstall = null;
                    this.jvmver = null;
                    this.timestamp = ((Runtime)this.runtime).getTimestamp();
                }
                if (this.vmInstall == null) {
                    this.vmInstall = javaRuntime.getVMInstall();
                }
                if (this.jvmver == null && (vmInstall2 = (IVMInstall2)this.vmInstall) != null) {
                    this.jvmver = vmInstall2.getJavaVersion();
                }
                String vmInstallName = this.vmInstall != null ? this.vmInstall.getName() : "Unknown";
                if (this.jvmver == null) {
                    JavaServerPlugin.logWarning("Could not determine VM version for: " + vmInstallName);
                    rcv = RuntimeManager.getRuntimeComponentType((String)"standard.jre").getVersion("6.0");
                } else if (this.jvmver.startsWith("1.3")) {
                    rcv = RuntimeManager.getRuntimeComponentType((String)"standard.jre").getVersion("1.3");
                } else if (this.jvmver.startsWith("1.4")) {
                    rcv = RuntimeManager.getRuntimeComponentType((String)"standard.jre").getVersion("1.4");
                } else if (this.jvmver.startsWith("1.5") || this.jvmver.startsWith("5.0")) {
                    rcv = RuntimeManager.getRuntimeComponentType((String)"standard.jre").getVersion("5.0");
                } else if (this.jvmver.startsWith("1.6") || this.jvmver.startsWith("6.0")) {
                    rcv = RuntimeManager.getRuntimeComponentType((String)"standard.jre").getVersion("6.0");
                } else {
                    JavaServerPlugin.logWarning("Invalid Java version: " + vmInstallName + ", " + this.jvmver);
                    rcv = RuntimeManager.getRuntimeComponentType((String)"standard.jre").getVersion("6.0");
                }
                properties = new HashMap(3);
                if (vmInstallName != null) {
                    properties.put("name", vmInstallName);
                } else {
                    properties.put("name", "-");
                }
                if (this.vmInstall == null || RuntimeBridge.isUsingDefaultJRE(javaRuntime)) {
                    properties.put(RuntimeBridge.CLASSPATH, new Path(JavaRuntime.JRE_CONTAINER).toPortableString());
                } else {
                    properties.put(RuntimeBridge.CLASSPATH, JavaRuntime.newJREContainerPath((IVMInstall)this.vmInstall).toPortableString());
                }
                components.add(RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)rcv, properties));
            }
            if ((componentProvider = JavaServerPlugin.findRuntimeComponentProvider(this.runtime.getRuntimeType())) != null && (list = componentProvider.getComponents(this.runtime)) != null) {
                components.addAll(list);
            }
            return components;
        }

        public Map getProperties() {
            if (this.runtime == null) {
                return new HashMap(0);
            }
            return Collections.singletonMap("id", this.runtime.getId());
        }
    }
}

