/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.project.facet;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.application.internal.operations.AddComponentToEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.internal.earcreation.EarFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.internal.project.ManifestFileCreationAction;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.operation.FacetProjectCreationOperation;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public abstract class J2EEFacetInstallDelegate {
    protected static void addToClasspath(IJavaProject jproj, IClasspathEntry entry) throws CoreException {
        IClasspathEntry[] current = jproj.getRawClasspath();
        IClasspathEntry[] updated = new IClasspathEntry[current.length + 1];
        System.arraycopy(current, 0, updated, 0, current.length);
        updated[current.length] = entry;
        jproj.setRawClasspath(updated, null);
    }

    protected void installEARFacet(String j2eeVersionText, String earProjectName, IRuntime runtime2, IProgressMonitor monitor) {
        IProject project = ProjectUtilities.getProject(earProjectName);
        if (project.exists()) {
            return;
        }
        try {
            IFacetedProject facetProj = ProjectFacetsManager.create((String)earProjectName, null, (IProgressMonitor)monitor);
            if (runtime2 != null) {
                facetProj.setRuntime(runtime2, monitor);
            }
            IDataModel earFacetInstallDataModel = DataModelFactory.createDataModel((IDataModelProvider)((Object)new EarFacetInstallDataModelProvider()));
            earFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", earProjectName);
            earFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", j2eeVersionText);
            HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
            actions.add(new IFacetedProject.Action((IFacetedProject.Action.Type)earFacetInstallDataModel.getProperty("IFacetDataModelProperties.FACET_TYPE"), (IProjectFacetVersion)earFacetInstallDataModel.getProperty("IFacetDataModelPropeties.FACET_VERSION"), (Object)earFacetInstallDataModel));
            facetProj.modify(actions, null);
            try {
                FacetProjectCreationOperation.addDefaultFactets((IFacetedProject)facetProj, (IRuntime)runtime2);
            }
            catch (ExecutionException e) {
                Logger.getLogger().logError(e);
            }
        }
        catch (CoreException e) {
            Logger.getLogger().logError(e);
        }
    }

    protected void createManifest(IProject project, IContainer aFolder, IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        IFile file = aFolder.getFile((IPath)new Path("META-INF/MANIFEST.MF"));
        if (file.exists()) {
            return;
        }
        try {
            ManifestFileCreationAction.createManifestFile(file, project);
        }
        catch (CoreException e) {
            Logger.getLogger().log(e);
        }
        catch (IOException e) {
            Logger.getLogger().log(e);
        }
    }

    protected void addToEar(IVirtualComponent earComp, IVirtualComponent j2eeComp, String moduleURI) {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)((Object)new AddComponentToEnterpriseApplicationDataModelProvider()));
        Map map = (Map)dataModel.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP");
        map.put(j2eeComp, moduleURI);
        dataModel.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", earComp);
        List modList = (List)dataModel.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        modList.add(j2eeComp);
        dataModel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", modList);
        try {
            dataModel.getDefaultOperation().execute(null, null);
        }
        catch (ExecutionException e) {
            Logger.getLogger().logError(e);
        }
    }

    protected void installAndAddModuletoEAR(String j2eeVersionText, String earProjectName, IRuntime runtime2, IProject moduleProject, String moduleURI, IProgressMonitor monitor) {
        this.installEARFacet(j2eeVersionText, earProjectName, runtime2, monitor);
        IVirtualComponent c = ComponentCore.createComponent((IProject)moduleProject);
        IProject earProject = ProjectUtilities.getProject(earProjectName);
        IVirtualComponent earComp = ComponentCore.createComponent((IProject)earProject);
        this.addToEar(earComp, c, moduleURI);
    }
}

