/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.model.internal.validation.AValidateHome;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.IMessagePrefixEjb11Constants;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRuleList;
import org.eclipse.jst.j2ee.model.internal.validation.InvalidInputException;
import org.eclipse.jst.j2ee.model.internal.validation.MessageUtility;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationRuleUtility;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class ValidateSessionHome
extends AValidateHome
implements IMessagePrefixEjb11Constants {
    private boolean hasDefaultCreateMethod = false;
    private Set createMethods = new HashSet();
    private static final String MSSGID = ".sh";
    private static final String EXT = ".sh.ejb11";
    private static final String BEXT = ".sh.i.ejb11";
    private static final String MEXT = ".sh.m.ejb11";
    private static final Object ID = IValidationRuleList.EJB11_SESSION_HOME;
    private static final Object[] DEPENDS_ON = new Object[]{IValidationRuleList.EJB11_SESSION_BEANCLASS, IValidationRuleList.EJB11_SESSION_REMOTE};
    private static final Map MESSAGE_IDS = new HashMap();

    public void reset() {
        super.reset();
        this.createMethods.clear();
    }

    public final Map getMessageIds() {
        return MESSAGE_IDS;
    }

    public final Object[] getDependsOn() {
        return DEPENDS_ON;
    }

    public final Object getId() {
        return ID;
    }

    protected boolean hasCreateMethod() {
        if (this.hasDefaultCreateMethod) {
            return true;
        }
        return this.createMethods.size() > 0;
    }

    protected void incrementCreateMethodCount(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method2) {
        if (method2 == null) {
            return;
        }
        if (method2.listParametersWithoutReturn().length == 0 && !this.hasDefaultCreateMethod) {
            this.hasDefaultCreateMethod = true;
        } else {
            this.createMethods.add(method2);
        }
    }

    public void primValidate(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method hiMethod) throws InvalidInputException {
        vc.terminateIfCancelled();
        String name = hiMethod.getName();
        if (name.equals("create")) {
            this.validateCreateMethod(vc, bean, clazz, hiMethod);
        } else {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2419", 1, bean, clazz, hiMethod, (IValidationRule)this);
            vc.addMessage(message);
        }
        vc.terminateIfCancelled();
    }

    protected void primValidateExistence(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method ejbMethod) throws InvalidInputException {
        if ("create".equals(ejbMethod.getName())) {
            this.incrementCreateMethodCount(vc, bean, clazz, ejbMethod);
        }
    }

    public void validateClass(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
        vc.terminateIfCancelled();
        super.validateClass(vc, bean, clazz);
    }

    protected void validateCreateMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method2) throws InvalidInputException {
        if (method2 == null) {
            return;
        }
        this.validateLegalRMIMethod(vc, bean, clazz, method2);
        this.validateCreateMethod_beanDep(vc, bean, clazz, method2);
        if (!ValidationRuleUtility.throwsCreateException(bean, method2)) {
            String[] msgParm = new String[]{"javax.ejb.CreateException"};
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2414", 1, bean, clazz, method2, msgParm, (IValidationRule)this);
            vc.addMessage(message);
        }
        this.validateCreateMethod_remoteDep(vc, bean, clazz, method2);
    }

    protected void validateMethodExists(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
        String[] modelObjectName = new String[]{clazz.getQualifiedName()};
        if (!this.hasCreateMethod()) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2010", 1, bean, clazz, modelObjectName, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (ValidationRuleUtility.isStateless(bean) && this.createMethods.size() > 0) {
            Iterator iterator = this.createMethods.iterator();
            while (iterator.hasNext()) {
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2024", 1, bean, clazz, (Method)iterator.next(), modelObjectName, (IValidationRule)this);
                vc.addMessage(message);
            }
        }
    }

    public void preValidate(IEJBValidationContext vc, Object targetParent, Object target) throws ValidationCancelledException, ValidationException {
        super.preValidate(vc, targetParent, target);
        this.hasDefaultCreateMethod = false;
    }

    static {
        MESSAGE_IDS.put("CHKJ2005", new String[]{"CHKJ2005.sh.i.ejb11", "CHKJ2005.sh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2010", new String[]{"CHKJ2010.sh.ejb11"});
        MESSAGE_IDS.put("CHKJ2011", new String[]{"CHKJ2011.sh.ejb11"});
        MESSAGE_IDS.put("CHKJ2012", new String[]{"CHKJ2012.sh.ejb11"});
        MESSAGE_IDS.put("CHKJ2017", new String[]{"CHKJ2017.sh.ejb11"});
        MESSAGE_IDS.put("CHKJ2024", new String[]{"CHKJ2024.sh.i.ejb11", "CHKJ2024.sh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2026", new String[]{"CHKJ2026.sh.i.ejb11", "CHKJ2026.sh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2104", new String[]{"CHKJ2104.ejb11"});
        MESSAGE_IDS.put("CHKJ2402", new String[]{"CHKJ2402.sh.i.ejb11", "CHKJ2402.sh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2403", new String[]{"CHKJ2403.sh.i.ejb11", "CHKJ2403.sh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2405", new String[]{"CHKJ2405.sh.i.ejb11", "CHKJ2405.sh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2412", new String[]{"CHKJ2412.sh.i.ejb11", "CHKJ2412.sh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2413", new String[]{"CHKJ2413.sh.i.ejb11", "CHKJ2413.sh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2414", new String[]{"CHKJ2414.sh.i.ejb11", "CHKJ2414.sh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2415", new String[]{"CHKJ2415.sh.i.ejb11", "CHKJ2415.sh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2419", new String[]{"CHKJ2419.sh.i.ejb11", "CHKJ2419.sh.m.ejb11"});
        MESSAGE_IDS.put("CHKJ2041", new String[]{"CHKJ2041"});
        MESSAGE_IDS.put("CHKJ2433", new String[]{"CHKJ2433"});
        MESSAGE_IDS.put("CHKJ2907", new String[]{"CHKJ2907"});
    }
}

