/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jst.j2ee.ejb.CommonRelationshipRole;
import org.eclipse.jst.j2ee.internal.EjbModuleExtensionHelper;

public class RoleHelper {
    static final String KEY_GETTER_NAME_PATTERN = "get{0}Key";
    static final String KEY_SETTER_NAME_PATTERN = "privateSet{0}Key";
    static final String LINK_GETTER_NAME_PATTERN = "get{0}Link";
    static final String ADD_NAME_PREFIX = "add";
    static final String GETTER_NAME_PREFIX = "get";
    static final String REMOVE_NAME_PREFIX = "remove";
    static final String SECONDARY_ADD_NAME_PREFIX = "secondaryAdd";
    static final String SECONDARY_REMOVE_NAME_PREFIX = "secondaryRemove";
    static final String SECONDARY_SETTER_NAME_PREFIX = "secondarySet";
    static final String SETTER_NAME_PREFIX = "set";
    protected EjbModuleExtensionHelper modHelper;

    public static void collectRoleMethodNames(CommonRelationshipRole aRole, List aList) {
        block14: {
            if (aRole == null || aList == null) {
                return;
            }
            aList.add(RoleHelper.getLinkGetterName(aRole));
            if (aRole.isForward()) {
                aList.add(RoleHelper.getKeyGetterName(aRole));
                aList.add(RoleHelper.getKeySetterName(aRole));
            }
            if (aRole.isNavigable()) {
                aList.add(RoleHelper.getGetterName(aRole));
            }
            if (!RoleHelper.isMany(aRole)) {
                try {
                    if (aRole.getOppositeAsCommonRole() == null) break block14;
                    if (!aRole.getOppositeAsCommonRole().isKey()) {
                        aList.add(RoleHelper.getSetterName(aRole));
                    }
                    if (!aRole.isKey()) {
                        aList.add(RoleHelper.getSecondarySetterName(aRole));
                    }
                }
                catch (NullPointerException exc) {}
            } else {
                aList.add(RoleHelper.getSecondaryAddName(aRole));
                aList.add(RoleHelper.getSecondaryRemoveName(aRole));
                if (aRole.isNavigable()) {
                    try {
                        if (aRole.getOppositeAsCommonRole() != null && !aRole.getOppositeAsCommonRole().isKey()) {
                            aList.add(RoleHelper.getAddName(aRole));
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    if (aRole.getOppositeAsCommonRole() != null && !aRole.getOppositeAsCommonRole().isRequired()) {
                        aList.add(RoleHelper.getRemoveName(aRole));
                    }
                }
            }
        }
    }

    public static final String firstAsUppercase(String aString) {
        if (aString != null && aString.length() > 0 && !Character.isUpperCase(aString.charAt(0))) {
            char[] chars = aString.toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            return String.valueOf(chars);
        }
        return aString;
    }

    protected static String format(String pattern, String[] replacements) {
        return MessageFormat.format(pattern, replacements);
    }

    public static String getAddName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleHelper.firstAsUppercase(aRole.getName());
        return ADD_NAME_PREFIX + arg;
    }

    public static String getGetterName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleHelper.firstAsUppercase(aRole.getName());
        return GETTER_NAME_PREFIX + arg;
    }

    public static String getKeyGetterName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleHelper.firstAsUppercase(aRole.getName());
        return RoleHelper.format(KEY_GETTER_NAME_PATTERN, new String[]{arg});
    }

    public static String getKeySetterName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleHelper.firstAsUppercase(aRole.getName());
        return RoleHelper.format(KEY_SETTER_NAME_PATTERN, new String[]{arg});
    }

    public static String getLinkGetterName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleHelper.firstAsUppercase(aRole.getName());
        return RoleHelper.format(LINK_GETTER_NAME_PATTERN, new String[]{arg});
    }

    public static String getRemoveName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleHelper.firstAsUppercase(aRole.getName());
        return REMOVE_NAME_PREFIX + arg;
    }

    public static String getSecondaryAddName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleHelper.firstAsUppercase(aRole.getName());
        return SECONDARY_ADD_NAME_PREFIX + arg;
    }

    public static String getSecondaryRemoveName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleHelper.firstAsUppercase(aRole.getName());
        return SECONDARY_REMOVE_NAME_PREFIX + arg;
    }

    public static String getSecondarySetterName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleHelper.firstAsUppercase(aRole.getName());
        return SECONDARY_SETTER_NAME_PREFIX + arg;
    }

    public static String getSetterName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleHelper.firstAsUppercase(aRole.getName());
        return SETTER_NAME_PREFIX + arg;
    }

    public static boolean isMany(CommonRelationshipRole aRole) {
        return aRole != null && aRole.isMany();
    }
}

