/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.HashSet;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.model.internal.validation.AValidateHome;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.InvalidInputException;
import org.eclipse.jst.j2ee.model.internal.validation.MessageUtility;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationRuleUtility;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public abstract class AValidateEntityHome
extends AValidateHome {
    private HashSet findByPKMethods = new HashSet();

    public void reset() {
        super.reset();
        this.findByPKMethods.clear();
    }

    protected void incrementFindByPrimaryKeyCount(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method2) {
        if (method2 == null) {
            return;
        }
        if (method2.getName().equals("findByPrimaryKey")) {
            this.findByPKMethods.add(method2);
        }
    }

    public boolean isSingleObjectFinder(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method2) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (method2 == null) {
            return false;
        }
        JavaClass remoteIntf = bean.getRemoteInterface();
        ValidationRuleUtility.isValidTypeHierarchy(bean, remoteIntf);
        return ValidationRuleUtility.isAssignableFrom(method2.getReturnType(), remoteIntf);
    }

    public void primValidate(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method hiMethod) throws InvalidInputException {
        vc.terminateIfCancelled();
        String name = hiMethod.getName();
        if (name.equals("create")) {
            this.validateCreateMethod(vc, bean, clazz, hiMethod);
        } else if (name.startsWith("find")) {
            this.validateFindMethod(vc, bean, clazz, hiMethod);
        } else {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2005", 1, bean, clazz, hiMethod, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    protected void primValidateExistence(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method ejbMethod) throws InvalidInputException {
        if ("findByPrimaryKey".equals(ejbMethod.getName())) {
            this.incrementFindByPrimaryKeyCount(vc, bean, clazz, ejbMethod);
        }
    }

    public void validateClass(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
        super.validateClass(vc, bean, clazz);
    }

    public void validateCreateMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method2) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (method2 == null) {
            return;
        }
        this.validateCreateMethod_beanDep(vc, bean, clazz, method2);
        vc.terminateIfCancelled();
        this.validateCreateMethod_remoteDep(vc, bean, clazz, method2);
        if (!ValidationRuleUtility.throwsCreateException(bean, method2)) {
            String[] msgParm = new String[]{"javax.ejb.CreateException"};
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2414", 1, bean, clazz, method2, msgParm, (IValidationRule)this);
            vc.addMessage(message);
        }
        this.validateLegalRMIMethod(vc, bean, clazz, method2);
    }

    public void validateCreateMethod_beanDep(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method2) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (method2 == null) {
            return;
        }
        super.validateCreateMethod_beanDep(vc, bean, clazz, method2);
        this.validateMatchingBeanPostCreateMethod(vc, bean, clazz, method2);
    }

    public void validateFindByPrimaryKeyMethod_keyDep(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method2) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (method2 == null) {
            return;
        }
        boolean hasValidFBPKMethod = false;
        Entity entityBean = (Entity)bean;
        JavaClass keyClass = entityBean.getPrimaryKey();
        ValidationRuleUtility.isValidTypeHierarchy(bean, keyClass);
        vc.terminateIfCancelled();
        JavaParameter[] parms = method2.listParametersWithoutReturn();
        if (parms.length == 1) {
            JavaHelpers type = parms[0].getJavaType();
            if (ValidationRuleUtility.isAssignableFrom(type, keyClass)) {
                if (this.isSingleObjectFinder(vc, bean, clazz, method2)) {
                    hasValidFBPKMethod = true;
                }
            } else if (ValidationRuleUtility.isSameType(type, ValidationRuleUtility.getType("java.lang.Object", entityBean))) {
                hasValidFBPKMethod = true;
            }
        }
        if (!hasValidFBPKMethod) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2405", 2, bean, clazz, method2, new String[]{keyClass.getQualifiedName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    public void validateFindByPrimaryKeyMethod_remoteDep(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method2) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (!this.isSingleObjectFinder(vc, bean, clazz, method2)) {
            String remoteIntfName = bean.getRemoteInterface().getName();
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2403", 2, bean, clazz, method2, new String[]{remoteIntfName}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    public void validateFindMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method2) throws InvalidInputException {
        JavaHelpers retType;
        vc.terminateIfCancelled();
        if (method2 == null) {
            return;
        }
        this.validateFindMethod_remoteDep(vc, bean, clazz, method2);
        if (!ValidationRuleUtility.throwsFinderException(bean, method2)) {
            String[] msgParm = new String[]{"javax.ejb.FinderException"};
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2414", 1, bean, clazz, method2, msgParm, (IValidationRule)this);
            vc.addMessage(message);
        }
        boolean validateRMIParameters = true;
        boolean validateRMIRetType = true;
        if (method2.getName().equals("findByPrimaryKey")) {
            this.validateFindByPrimaryKeyMethod_keyDep(vc, bean, clazz, method2);
            if (ValidationRuleUtility.usesUnknownPrimaryKey(bean)) {
                validateRMIParameters = false;
            }
        }
        boolean bl = validateRMIRetType = !ValidationRuleUtility.isAssignableFrom(retType = method2.getReturnType(), ValidationRuleUtility.getType("java.util.Enumeration", bean)) && !ValidationRuleUtility.isAssignableFrom(retType, ValidationRuleUtility.getType("java.util.Collection", bean));
        if (validateRMIParameters) {
            this.validateLegalRMIMethodArguments(vc, bean, clazz, method2);
        }
        if (validateRMIRetType) {
            this.validateLegalRMIMethodReturnType(vc, bean, clazz, method2);
        }
        this.validateLegalRMIMethodExceptions(vc, bean, clazz, method2);
    }

    public void validateFindMethod_remoteDep(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method2) throws InvalidInputException {
        JavaHelpers returnType;
        vc.terminateIfCancelled();
        if (method2 == null) {
            return;
        }
        JavaClass remoteIntf = bean.getRemoteInterface();
        ValidationRuleUtility.isValidTypeHierarchy(bean, remoteIntf);
        if (!(method2.getName().equals("findByPrimaryKey") || ValidationRuleUtility.isAssignableFromCollection(returnType = method2.getReturnType(), bean) || ValidationRuleUtility.isAssignableFromEnumeration(returnType, bean) || ValidationRuleUtility.isAssignableFrom(returnType, remoteIntf))) {
            String[] msgParm = new String[]{remoteIntf.getName()};
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2403", 2, bean, clazz, method2, msgParm, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (method2.getName().equals("findByPrimaryKey")) {
            this.validateFindByPrimaryKeyMethod_remoteDep(vc, bean, clazz, method2);
        }
    }

    public void validateMatchingBeanCreateMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method2) throws InvalidInputException {
        vc.terminateIfCancelled();
        super.validateMatchingBeanCreateMethod(vc, bean, clazz, method2);
        JavaClass beanClass = bean.getEjbClass();
        Method ejbCreateMethod = ValidationRuleUtility.getMethodExtended(beanClass, method2, "ejbCreate");
        if (ejbCreateMethod == null) {
            return;
        }
    }

    public void validateMatchingBeanFindMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method homeMethod) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (homeMethod == null) {
            return;
        }
        String findMethodName = "ejbF" + homeMethod.getName().substring(1);
        JavaClass beanClass = bean.getEjbClass();
        ValidationRuleUtility.isValidTypeHierarchy(bean, beanClass);
        Method beanMethod = ValidationRuleUtility.getMethodExtended(beanClass, homeMethod, findMethodName);
        if (beanMethod == null) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2030", 1, bean, clazz, homeMethod, new String[]{beanClass.getName()}, (IValidationRule)this);
            vc.addMessage(message);
            return;
        }
        vc.terminateIfCancelled();
        JavaHelpers homeRetType = homeMethod.getReturnType();
        JavaHelpers beanRetType = beanMethod.getReturnType();
        if (!ValidationRuleUtility.isAssignableFrom(homeRetType, beanRetType)) {
            boolean homeRetTypeIsRemote = ValidationRuleUtility.isAssignableFrom(homeRetType, bean.getRemoteInterface());
            boolean beanRetTypeIsKey = ValidationRuleUtility.isAssignableFrom(beanRetType, ((Entity)bean).getPrimaryKey());
            if (!homeRetTypeIsRemote || !beanRetTypeIsKey) {
                JavaHelpers retType = beanRetTypeIsKey ? bean.getRemoteInterface() : beanRetType;
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2415", 1, bean, clazz, homeMethod, new String[]{retType.getJavaName(), beanClass.getName()}, (IValidationRule)this);
                vc.addMessage(message);
            }
        }
    }

    public void validateMatchingBeanPostCreateMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method homeMethod) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (homeMethod == null) {
            return;
        }
        JavaClass beanClass = bean.getEjbClass();
        ValidationRuleUtility.isValidTypeHierarchy(bean, beanClass);
        Method beanMethod = ValidationRuleUtility.getMethodExtended(beanClass, homeMethod, "ejbPostCreate");
        if (beanMethod == null) {
            return;
        }
    }

    protected void validateMethodExists(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
        if (this.findByPKMethods.size() == 0) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2011", 1, bean, clazz, new String[]{clazz.getQualifiedName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }
}

