/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.model.internal.validation.ATypeVRule;
import org.eclipse.jst.j2ee.model.internal.validation.ClassUtility;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBInterfaceType;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.InvalidInputException;
import org.eclipse.jst.j2ee.model.internal.validation.MessageUtility;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationRuleUtility;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public abstract class AInterfaceTypeVRule
extends ATypeVRule
implements IEJBInterfaceType {
    public static final List getBeanClassMethodsExtended(List[] methodsExtendedList) {
        return methodsExtendedList[0];
    }

    public final List[] getMethodsExtended(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
        JavaClass beanClass = bean.getEjbClass();
        if (beanClass == null) {
            throw new InvalidInputException();
        }
        List[] result = new List[]{beanClass.getMethodsExtended()};
        return result;
    }

    public final List[] getFieldsExtended(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) {
        return null;
    }

    public void validate(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Field field, List[] fieldsExtendedLists) throws ValidationCancelledException, InvalidInputException, ValidationException {
    }

    public void validate(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) throws ValidationCancelledException, InvalidInputException, ValidationException {
        this.validateApplicationExceptionRules(vc, bean, clazz, method2);
    }

    public final boolean isEJBInterfaceMethod(EnterpriseBean bean, Method method2) throws InvalidInputException {
        long[] superTypes = this.getSupertypes();
        for (int i = 0; i < superTypes.length; ++i) {
            if (!ClassUtility.getUtility().isClassType(bean, method2.getJavaClass(), superTypes[i])) continue;
            return true;
        }
        return false;
    }

    public final JavaHelpers getOverExposedLocalType(EnterpriseBean bean, JavaClass clazz, Method method2) {
        if ((this.isRemote() & 1) == 1) {
            JavaHelpers parm;
            JavaParameter[] parms = method2.listParametersWithoutReturn();
            if (parms != null) {
                for (int i = 0; i < parms.length; ++i) {
                    JavaParameter parm2 = parms[i];
                    if (!ValidationRuleUtility.isLocalType(bean, parm2.getJavaType())) continue;
                    return parm2.getJavaType();
                }
            }
            if (ValidationRuleUtility.isLocalType(bean, parm = method2.getReturnType())) {
                return parm;
            }
            return null;
        }
        return null;
    }

    public long getFieldType(EnterpriseBean bean, JavaClass clazz, Field field) {
        if (field == null) {
            return EXCLUDED_FIELD;
        }
        if (field.getName().equals("serialVersionUID")) {
            return SERIALVERSIONUID;
        }
        return OTHER_FIELD;
    }

    public void validateApplicationExceptionRules(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method2) throws ValidationCancelledException {
        EList exceptions2 = method2.getJavaExceptions();
        if (exceptions2.size() == 0) {
            return;
        }
        Iterator iterator = exceptions2.iterator();
        try {
            JavaHelpers javaLangException = ValidationRuleUtility.getType("java.lang.Exception", bean);
            JavaHelpers javaLangRuntimeException = ValidationRuleUtility.getType("java.lang.RuntimeException", bean);
            while (iterator.hasNext()) {
                IMessage message;
                JavaClass exception = (JavaClass)iterator.next();
                if (!ValidationRuleUtility.isApplicationException(exception, bean)) continue;
                if (!ValidationRuleUtility.isAssignableFrom(exception, javaLangException)) {
                    message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2404", 2, bean, clazz, method2, new String[]{exception.getName()}, (IValidationRule)this);
                    vc.addMessage(message);
                    continue;
                }
                if (!ValidationRuleUtility.isAssignableFrom(exception, javaLangRuntimeException)) continue;
                message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2416", 2, bean, clazz, method2, new String[]{exception.getName()}, (IValidationRule)this);
                vc.addMessage(message);
            }
            return;
        }
        catch (InvalidInputException exc) {
            return;
        }
    }
}

