/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.model.internal.validation.AInterfaceTypeVRule;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.IMethodType;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.InvalidInputException;
import org.eclipse.jst.j2ee.model.internal.validation.MessageUtility;
import org.eclipse.jst.j2ee.model.internal.validation.MethodUtility;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationRuleUtility;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public abstract class AHomeVRule
extends AInterfaceTypeVRule {
    public Object getTarget(Object parent, Object clazz) {
        if (parent == null) {
            return null;
        }
        if ((this.isRemote() & 1) == 1) {
            return ((EnterpriseBean)parent).getHomeInterface();
        }
        return ((EnterpriseBean)parent).getLocalHomeInterface();
    }

    public void validateFindMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method2) throws ValidationCancelledException, InvalidInputException, ValidationException {
    }

    public boolean followsCreateExceptionRules(EnterpriseBean bean, Method method2) throws InvalidInputException, ValidationCancelledException {
        return ValidationRuleUtility.throwsCreateException(bean, method2);
    }

    public void validate(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws ValidationCancelledException, InvalidInputException, ValidationException {
        if (!ValidationRuleUtility.isLegalRMI_IIOPInheritance(clazz)) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2461", 4, bean, clazz, (IValidationRule)this);
            vc.addMessage(message);
        }
        this.validateAppendixB(vc, bean, clazz);
    }

    public final void validate(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) throws ValidationCancelledException, InvalidInputException, ValidationException {
        IMessage message;
        StringBuffer buffer;
        super.validate(vc, bean, clazz, method2, methodsExtendedLists);
        long methodType = MethodUtility.getUtility().getMethodTypeId(bean, clazz, method2, methodsExtendedLists, this);
        String nameOfMethodToFind = method2.getName();
        boolean validateReturnTypeMatches = false;
        if ((methodType & CREATE) == CREATE) {
            this.validateCreateMethod(vc, bean, clazz, method2);
            buffer = new StringBuffer("ejbC");
            buffer.append(method2.getName().substring(1));
            nameOfMethodToFind = buffer.toString();
        } else if ((methodType & FIND) == FIND) {
            this.validateFindMethod(vc, bean, clazz, method2);
            buffer = new StringBuffer("ejbF");
            buffer.append(method2.getName().substring(1));
            nameOfMethodToFind = buffer.toString();
            validateReturnTypeMatches = true;
        } else if ((methodType & HOME) == HOME) {
            this.validateHomeMethod(vc, bean, clazz, method2);
            String methodName = method2.getName();
            StringBuffer buffer2 = new StringBuffer("ejbHome");
            buffer2.append(Character.toUpperCase(methodName.charAt(0)));
            buffer2.append(method2.getName().substring(1));
            nameOfMethodToFind = buffer2.toString();
            validateReturnTypeMatches = true;
        } else {
            return;
        }
        if (!this.followRemoteExceptionRules(bean, method2)) {
            IMethodType mType = MethodUtility.getUtility().getMethodType(bean, clazz, method2, methodsExtendedLists, this);
            if (mType == null) {
                Logger logger = vc.getMsgLogger();
                if (logger != null && logger.isLoggingLevel(Level.FINEST)) {
                    LogEntry entry = vc.getLogEntry();
                    entry.setSourceID("AHomeVRule - validate method which must not exist");
                    entry.setText("Method type is null: " + clazz.getQualifiedName() + "::" + method2.getName());
                    logger.write(Level.FINEST, entry);
                }
            } else {
                message = MessageUtility.getUtility().getMessage(vc, (Object)mType.getMessageId_messageRemoteException(), this.getMessageRemoteExceptionSeverity(), bean, clazz, method2, (IValidationRule)this);
                vc.addMessage(message);
            }
        }
        this.validateRMI_IIOPTypeRules(vc, bean, clazz, method2, methodsExtendedLists, (methodType & FIND) != FIND);
        JavaHelpers local = this.getOverExposedLocalType(bean, clazz, method2);
        if (local != null) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2466", 4, bean, clazz, method2, new String[]{local.getQualifiedName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (this.findMatchingMethod(methodType)) {
            this.validateMatchingBeanMethod(vc, bean, clazz, method2, nameOfMethodToFind, validateReturnTypeMatches, methodsExtendedLists);
        }
    }

    public boolean findMatchingMethod(long methodType) {
        return true;
    }

    public final void validateMatchingBeanMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method2, String nameOfMethodToFind, boolean validateReturnTypeMatches, List[] methodsExtendedLists) throws ValidationCancelledException, InvalidInputException, ValidationException {
        Method match = ValidationRuleUtility.getMethod(method2, nameOfMethodToFind, AHomeVRule.getBeanClassMethodsExtended(methodsExtendedLists));
        if (match == null) {
            IMethodType mType = MethodUtility.getUtility().getMethodType(bean, clazz, method2, methodsExtendedLists, this);
            if (mType == null) {
                Logger logger = vc.getMsgLogger();
                if (logger != null && logger.isLoggingLevel(Level.FINEST)) {
                    LogEntry entry = vc.getLogEntry();
                    entry.setSourceID("AHomeVRule - validate method");
                    entry.setText("Method type is null: " + bean.getName() + "::" + clazz.getJavaName() + "::" + method2.getMethodElementSignature());
                    logger.write(Level.FINEST, entry);
                }
            } else {
                JavaClass beanClass = bean.getEjbClass();
                String beanClassName = beanClass == null ? "<ejb-class>" : beanClass.getJavaName();
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)mType.getMessageId_messageMissingMatching(), 2, bean, clazz, method2, new String[]{nameOfMethodToFind, beanClassName}, (IValidationRule)this);
                vc.addMessage(message);
            }
        } else {
            if (validateReturnTypeMatches) {
                this.validateMatchingReturnTypeMatches(vc, bean, clazz, method2, match, methodsExtendedLists);
            }
            Set exceptions2 = ValidationRuleUtility.getNotSubsetExceptions(bean, match, method2);
            for (JavaClass exception : exceptions2) {
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2465", 2, bean, clazz, method2, new String[]{exception.getJavaName(), match.getMethodElementSignature()}, (IValidationRule)this);
                vc.addMessage(message);
            }
        }
    }

    public void validateMatchingReturnTypeMatches(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method homeMethod, Method beanMethod, List[] methodsExtendedMethod) {
        if (!ValidationRuleUtility.isAssignableFrom(homeMethod.getReturnType(), beanMethod.getReturnType())) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2402", 1, bean, clazz, homeMethod, new String[]{beanMethod.getReturnType().getJavaName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    public void validateCreateMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method2) throws ValidationCancelledException, InvalidInputException, ValidationException {
        if (!this.followsCreateExceptionRules(bean, method2)) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2467", 4, bean, clazz, method2, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (!this.returnsComponentInterface(vc, bean, clazz, method2)) {
            JavaClass componentInterface = this.getComponentInterface(bean);
            String className = null;
            className = componentInterface != null ? componentInterface.getJavaName() : ((this.isRemote() & 1) == 1 ? "<remote>" : "<local>");
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2402", 1, bean, clazz, method2, new String[]{className}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    public void validateHomeMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method2) throws ValidationCancelledException, ValidationException {
    }

    protected boolean returnsComponentInterface(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method2) throws ValidationCancelledException {
        JavaClass componentInterface = this.getComponentInterface(bean);
        return ValidationRuleUtility.isAssignableFrom(method2.getReturnType(), componentInterface);
    }

    protected boolean returnsComponentInterfaceOrCollection(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method2) throws ValidationCancelledException, InvalidInputException {
        JavaHelpers javaUtilEnumeration;
        if (this.returnsComponentInterface(vc, bean, clazz, method2)) {
            return true;
        }
        JavaHelpers returnParm = method2.getReturnType();
        if (ValidationRuleUtility.isAssignableFrom(returnParm, javaUtilEnumeration = ValidationRuleUtility.getType("java.util.Enumeration", bean))) {
            return true;
        }
        JavaHelpers javaUtilCollection = ValidationRuleUtility.getType("java.util.Collection", bean);
        return ValidationRuleUtility.isAssignableFrom(returnParm, javaUtilCollection);
    }

    protected void validateAppendixB(IEJBValidationContext vc, EnterpriseBean bean, JavaClass thisHome) {
        if (bean == null) {
            return;
        }
        EnterpriseBean supertype = this.getSuperType(bean);
        JavaClass parentHome = null;
        if (supertype != null) {
            parentHome = this.getHomeInterface(supertype);
            if (parentHome == null) {
                return;
            }
            try {
                ValidationRuleUtility.isValidType(thisHome);
                ValidationRuleUtility.isValidType(parentHome);
                if (ValidationRuleUtility.isAssignableFrom(thisHome, parentHome)) {
                    String[] msgParm = new String[]{thisHome.getQualifiedName(), parentHome.getQualifiedName()};
                    IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2104", 1, bean, thisHome, msgParm, (IValidationRule)this);
                    vc.addMessage(message);
                }
            }
            catch (InvalidInputException e) {
                String[] msgParm = new String[]{e.getJavaClass().getQualifiedName(), bean.getName()};
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2849", 2, bean, msgParm, (IValidationRule)this);
                vc.addMessage(message);
            }
        }
    }
}

