/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jst.j2ee.common.Description;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.common.internal.impl.J2EEEObjectImpl;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.MethodPermission;

public class MethodPermissionImpl
extends J2EEEObjectImpl
implements MethodPermission {
    protected static final String DESCRIPTION_EDEFAULT = null;
    protected String description = DESCRIPTION_EDEFAULT;
    protected static final boolean UNCHECKED_EDEFAULT = false;
    protected boolean unchecked = false;
    protected boolean uncheckedESet = false;
    protected EList roles = null;
    protected EList methodElements = null;
    protected EList descriptions = null;

    protected EClass eStaticClass() {
        return EjbPackage.Literals.METHOD_PERMISSION;
    }

    public List getMethodElements(EnterpriseBean anEJB) {
        if (anEJB == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<MethodElement> result = new ArrayList<MethodElement>();
        EList elements = this.getMethodElements();
        for (int i = 0; i < elements.size(); ++i) {
            MethodElement me = (MethodElement)elements.get(i);
            if (!anEJB.equals(me.getEnterpriseBean())) continue;
            result.add(me);
        }
        return result;
    }

    public SecurityRole getSecurityRole(String aRoleName) {
        if (aRoleName == null) {
            return null;
        }
        EList myRoles = this.getRoles();
        int size = myRoles.size();
        for (int i = 0; i < size; ++i) {
            SecurityRole role = (SecurityRole)myRoles.get(i);
            if (!aRoleName.equals(role.getRoleName())) continue;
            return role;
        }
        return null;
    }

    public boolean hasSecurityRole(SecurityRole aSecurityRole) {
        if (aSecurityRole == null) {
            return false;
        }
        EList myRoles = this.getRoles();
        int size = myRoles.size();
        for (int i = 0; i < size; ++i) {
            if (aSecurityRole != myRoles.get(i)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSecurityRole(String aRoleName) {
        return this.getSecurityRole(aRoleName) != null;
    }

    public boolean isEquivalent(MethodPermission anotherMethodPermission) {
        if (anotherMethodPermission == null) {
            return false;
        }
        return this.getRoles().size() == anotherMethodPermission.getRoles().size() && this.getRoles().containsAll(anotherMethodPermission.getRoles());
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescription) {
        String oldDescription = this.description;
        this.description = newDescription;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldDescription, (Object)this.description));
        }
    }

    public boolean isUnchecked() {
        return this.unchecked;
    }

    public void setUnchecked(boolean newUnchecked) {
        boolean oldUnchecked = this.unchecked;
        this.unchecked = newUnchecked;
        boolean oldUncheckedESet = this.uncheckedESet;
        this.uncheckedESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 1, oldUnchecked, this.unchecked, !oldUncheckedESet));
        }
    }

    public void unsetUnchecked() {
        boolean oldUnchecked = this.unchecked;
        boolean oldUncheckedESet = this.uncheckedESet;
        this.unchecked = false;
        this.uncheckedESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 2, 1, oldUnchecked, false, oldUncheckedESet));
        }
    }

    public boolean isSetUnchecked() {
        return this.uncheckedESet;
    }

    public AssemblyDescriptor getAssemblyDescriptor() {
        if (this.eContainerFeatureID != 2) {
            return null;
        }
        return (AssemblyDescriptor)this.eContainer();
    }

    public NotificationChain basicSetAssemblyDescriptor(AssemblyDescriptor newAssemblyDescriptor, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)((Object)newAssemblyDescriptor), 2, msgs);
        return msgs;
    }

    public void setAssemblyDescriptor(AssemblyDescriptor newAssemblyDescriptor) {
        if (newAssemblyDescriptor != this.eInternalContainer() || this.eContainerFeatureID != 2 && newAssemblyDescriptor != null) {
            if (EcoreUtil.isAncestor(this, (EObject)newAssemblyDescriptor)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newAssemblyDescriptor != null) {
                msgs = ((InternalEObject)((Object)newAssemblyDescriptor)).eInverseAdd(this, 0, AssemblyDescriptor.class, msgs);
            }
            if ((msgs = this.basicSetAssemblyDescriptor(newAssemblyDescriptor, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 2, (Object)newAssemblyDescriptor, (Object)newAssemblyDescriptor));
        }
    }

    public EList getRoles() {
        if (this.roles == null) {
            this.roles = new EObjectResolvingEList(SecurityRole.class, this, 3);
        }
        return this.roles;
    }

    public EList getMethodElements() {
        if (this.methodElements == null) {
            this.methodElements = new EObjectContainmentEList(MethodElement.class, this, 4);
        }
        return this.methodElements;
    }

    public EList getDescriptions() {
        if (this.descriptions == null) {
            this.descriptions = new EObjectContainmentEList(Description.class, this, 5);
        }
        return this.descriptions;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetAssemblyDescriptor((AssemblyDescriptor)((Object)otherEnd), msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return this.basicSetAssemblyDescriptor(null, msgs);
            }
            case 4: {
                return ((InternalEList)this.getMethodElements()).basicRemove(otherEnd, msgs);
            }
            case 5: {
                return ((InternalEList)this.getDescriptions()).basicRemove(otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID) {
            case 2: {
                return this.eInternalContainer().eInverseRemove(this, 0, AssemblyDescriptor.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getDescription();
            }
            case 1: {
                return this.isUnchecked() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 2: {
                return this.getAssemblyDescriptor();
            }
            case 3: {
                return this.getRoles();
            }
            case 4: {
                return this.getMethodElements();
            }
            case 5: {
                return this.getDescriptions();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setDescription((String)newValue);
                return;
            }
            case 1: {
                this.setUnchecked((Boolean)newValue);
                return;
            }
            case 2: {
                this.setAssemblyDescriptor((AssemblyDescriptor)newValue);
                return;
            }
            case 3: {
                this.getRoles().clear();
                this.getRoles().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getMethodElements().clear();
                this.getMethodElements().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getDescriptions().clear();
                this.getDescriptions().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setDescription(DESCRIPTION_EDEFAULT);
                return;
            }
            case 1: {
                this.unsetUnchecked();
                return;
            }
            case 2: {
                this.setAssemblyDescriptor(null);
                return;
            }
            case 3: {
                this.getRoles().clear();
                return;
            }
            case 4: {
                this.getMethodElements().clear();
                return;
            }
            case 5: {
                this.getDescriptions().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return DESCRIPTION_EDEFAULT == null ? this.description != null : !DESCRIPTION_EDEFAULT.equals(this.description);
            }
            case 1: {
                return this.isSetUnchecked();
            }
            case 2: {
                return this.getAssemblyDescriptor() != null;
            }
            case 3: {
                return this.roles != null && !this.roles.isEmpty();
            }
            case 4: {
                return this.methodElements != null && !this.methodElements.isEmpty();
            }
            case 5: {
                return this.descriptions != null && !this.descriptions.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (description: ");
        result.append(this.description);
        result.append(", unchecked: ");
        if (this.uncheckedESet) {
            result.append(this.unchecked);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }
}

