/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.JavaRefPackage;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.j2ee.common.EJBLocalRef;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.common.ResourceEnvRef;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.common.SecurityIdentity;
import org.eclipse.jst.j2ee.common.SecurityRoleRef;
import org.eclipse.jst.j2ee.common.internal.impl.JNDIEnvRefsGroupImpl;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.ejb.EjbMethodElementComparator;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.MethodElementKind;
import org.eclipse.jst.j2ee.ejb.MethodPermission;
import org.eclipse.jst.j2ee.ejb.MethodTransaction;
import org.eclipse.jst.j2ee.ejb.internal.impl.EjbFactoryImpl;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionResource;
import org.eclipse.wst.common.internal.emf.utilities.Revisit;

public abstract class EnterpriseBeanImpl
extends JNDIEnvRefsGroupImpl
implements EnterpriseBean {
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    private static String className = EnterpriseBeanImpl.class.getName();
    protected static final Method[] EMPTY_METHOD_ARRAY = new Method[0];
    protected static final String METHOD_ELEMENT_NAME = "MethodElement";
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected EList securityRoleRefs = null;
    protected JavaClass ejbClass = null;
    protected JavaClass homeInterface = null;
    protected JavaClass remoteInterface = null;
    protected SecurityIdentity securityIdentity = null;
    protected JavaClass localHomeInterface = null;
    protected JavaClass localInterface = null;
    protected static final String MAPPED_NAME_EDEFAULT = "";
    protected String mappedName = "";
    protected EjbMethodElementComparator defaultMethodElementComparator;
    private boolean _VersionIDStored = false;
    private int _storedVersionID;

    protected EClass eStaticClass() {
        return EjbPackage.Literals.ENTERPRISE_BEAN;
    }

    public JavaClass createClassRef(String targetName) {
        return this.getJavaRefFactory().createClassRef(targetName);
    }

    protected List createMethodElements(List signatures, Enumerator aType) {
        return this.createMethodElements(METHOD_ELEMENT_NAME, signatures, aType);
    }

    protected List createMethodElements(String meTypeName, List signatures, Enumerator aType) {
        int size = signatures.size();
        ArrayList<MethodElement> methodElements = new ArrayList<MethodElement>(size);
        for (int i = 0; i < size; ++i) {
            String signature = (String)signatures.get(i);
            MethodElement me = (MethodElement)this.getEjbFactory().create((EClass)this.getEjbPackage().getEClassifier(meTypeName));
            me.initializeFromSignature(signature);
            me.setEnterpriseBean(this);
            me.setType((MethodElementKind)aType);
            methodElements.add(me);
        }
        return methodElements;
    }

    public List createMethodElements(List someMethods, JavaClass anInterface) {
        return this.createMethodElements(METHOD_ELEMENT_NAME, someMethods, anInterface);
    }

    public List createMethodElements(String meTypeName, List someMethods, JavaClass anInterface) {
        if (anInterface == null) {
            return Collections.EMPTY_LIST;
        }
        List signatures = this.getMethodElementSignatures(someMethods);
        Collections.sort(signatures);
        Enumerator enumerator = this.getMethodElementKindLiteral(anInterface);
        return this.createMethodElements(meTypeName, signatures, enumerator);
    }

    protected Enumerator getMethodElementKindLiteral(JavaClass anInterface) {
        MethodElementKind enumerator = MethodElementKind.UNSPECIFIED_LITERAL;
        if (anInterface == this.getHomeInterface()) {
            enumerator = MethodElementKind.HOME_LITERAL;
        } else if (anInterface == this.getRemoteInterface()) {
            enumerator = MethodElementKind.REMOTE_LITERAL;
        } else if (anInterface == this.getLocalHomeInterface()) {
            enumerator = MethodElementKind.LOCAL_HOME_LITERAL;
        } else if (anInterface == this.getLocalInterface()) {
            enumerator = MethodElementKind.LOCAL_LITERAL;
        }
        return enumerator;
    }

    protected List getMethodElementSignatures(List someMethods) {
        int size = someMethods.size();
        ArrayList<String> signatures = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            Method method2 = (Method)someMethods.get(i);
            signatures.add(method2.getMethodElementSignature());
        }
        return signatures;
    }

    public List getAvailableCommonMethodElements() {
        return this.getAvailableUnspecifiedMethodElements();
    }

    public List getAvailableUnspecifiedMethodElements() {
        List commonSigs = this.getAvailableUnspecifiedMethodElementSignatures();
        return this.createMethodElements(commonSigs, MethodElementKind.UNSPECIFIED_LITERAL);
    }

    protected List gatherCommonSignatures(List sigCollections) {
        if (sigCollections.isEmpty()) {
            return sigCollections;
        }
        List first = (List)sigCollections.get(0);
        if (sigCollections.size() == 1) {
            return first;
        }
        ArrayList<String> result = new ArrayList<String>(first.size());
        sigCollections.remove(0);
        String sig = null;
        boolean contains = false;
        for (int i = 0; i < first.size(); ++i) {
            contains = false;
            sig = (String)first.get(i);
            List list = null;
            for (int j = 0; j < sigCollections.size(); ++j) {
                list = (List)sigCollections.get(j);
                if (!list.contains(sig)) continue;
                contains = true;
            }
            if (!contains) continue;
            result.add(sig);
        }
        return result;
    }

    protected List getExistingMethodElements(EObject refObject) {
        if (refObject != null) {
            EjbPackage pack = this.getEjbPackage();
            if (refObject.eClass() == pack.getMethodTransaction()) {
                return ((MethodTransaction)refObject).getMethodElements(this);
            }
            if (refObject.eClass() == pack.getMethodPermission()) {
                return ((MethodPermission)refObject).getMethodElements(this);
            }
        }
        return Collections.EMPTY_LIST;
    }

    public List getAvailableCommonMethodElementSignatures() {
        return this.getAvailableUnspecifiedMethodElementSignatures();
    }

    public List getAvailableUnspecifiedMethodElementSignatures() {
        ArrayList<List> sigCollections = new ArrayList<List>();
        if (this.getHomeInterface() != null) {
            sigCollections.add(this.getHomeInterface().getMethodElementSignatures());
        }
        if (this.getRemoteInterface() != null) {
            sigCollections.add(this.getRemoteInterface().getMethodElementSignatures());
        }
        if (this.getLocalHomeInterface() != null) {
            sigCollections.add(this.getLocalHomeInterface().getMethodElementSignatures());
        }
        if (this.getLocalInterface() != null) {
            sigCollections.add(this.getLocalInterface().getMethodElementSignatures());
        }
        return this.gatherCommonSignatures(sigCollections);
    }

    public List getAvailableHomeMethodElements() {
        return this.getAvailableMethodElements(this.getHomeInterface(), MethodElementKind.HOME_LITERAL);
    }

    public List getAvailableLocalHomeMethodElements() {
        return this.getAvailableMethodElements(this.getLocalHomeInterface(), MethodElementKind.LOCAL_HOME_LITERAL);
    }

    public List getAvailableLocalMethodElements() {
        return this.getAvailableMethodElements(this.getLocalInterface(), MethodElementKind.LOCAL_LITERAL);
    }

    public List getAvailableServiceEndpointMethodElements() {
        return this.getAvailableMethodElements(this.getServiceEndpoint(), MethodElementKind.SERVICE_ENDPOINT_LITERAL);
    }

    protected List getAvailableMethodElements(JavaClass anInterface, Enumerator aType) {
        if (anInterface == null) {
            return Collections.EMPTY_LIST;
        }
        List signatures = anInterface.getMethodElementSignatures();
        return this.createMethodElements(signatures, aType);
    }

    public List getAvailableRemoteMethodElements() {
        return this.getAvailableMethodElements(this.getRemoteInterface(), MethodElementKind.REMOTE_LITERAL);
    }

    public List getExistingOrAvailableMethodElements(EObject refObject, Comparator comparator) {
        ArrayList result = new ArrayList();
        result.addAll(this.getAvailableHomeMethodElements());
        result.addAll(this.getAvailableRemoteMethodElements());
        result.addAll(this.getAvailableLocalHomeMethodElements());
        result.addAll(this.getAvailableLocalMethodElements());
        result.addAll(this.getAvailableServiceEndpointMethodElements());
        result.addAll(this.getAvailableUnspecifiedMethodElements());
        EList list = this.getEjbClass().getImplementsInterfaces();
        for (JavaClass interfaceClass : list) {
            String interfaceName = interfaceClass.getQualifiedName();
            if (interfaceName.equals("javax.ejb.MessageDrivenBean") || interfaceName.equals("javax.ejb.EntityBean") || interfaceName.equals("javax.ejb.SessionBean")) continue;
            result.addAll(this.getAvailableMethodElements(interfaceClass, MethodElementKind.UNSPECIFIED_LITERAL));
        }
        this.unionMethodElements(result, this.getExistingMethodElements(refObject));
        Collections.sort(result, comparator);
        return result;
    }

    public List getExistingOrAvailableMethodElements(EObject refObject) {
        return this.getExistingOrAvailableMethodElements(refObject, this.getDefaultMethodElementComparator());
    }

    protected EjbMethodElementComparator getDefaultMethodElementComparator() {
        if (this.defaultMethodElementComparator == null) {
            this.defaultMethodElementComparator = new EjbMethodElementComparator();
        }
        return this.defaultMethodElementComparator;
    }

    protected void unionMethodElements(List sourceMethodElements, List additionalMethodElements) {
        int sourceSize = sourceMethodElements.size();
        int addSize = additionalMethodElements.size();
        ArrayList<MethodElement> foundElements = new ArrayList<MethodElement>(addSize);
        boolean found = false;
        for (int i = 0; i < addSize; ++i) {
            found = false;
            MethodElement additionalME = (MethodElement)additionalMethodElements.get(i);
            MethodElement sourceME = null;
            for (int ii = 0; ii < sourceSize; ++ii) {
                sourceME = (MethodElement)sourceMethodElements.get(ii);
                if (!sourceME.isEquivalent(additionalME)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            foundElements.add(sourceME);
        }
        sourceMethodElements.removeAll(foundElements);
        sourceMethodElements.addAll(additionalMethodElements);
    }

    public String getEjbClassName() {
        this.getEjbClass();
        return this.ejbClass == null ? null : this.ejbClass.getQualifiedName();
    }

    protected EjbPackage getEjbPackage() {
        return EjbFactoryImpl.getPackage();
    }

    protected EjbFactory getEjbFactory() {
        return ((EjbPackage)EPackage.Registry.INSTANCE.getEPackage("ejb.xmi")).getEjbFactory();
    }

    public EjbRef getEquivalentEjbRef(EjbRef anEjbRef) {
        return this.getEquivalentEjbRef(anEjbRef, this.getEjbRefs());
    }

    public EJBLocalRef getEquivalentEJBLocalRef(EJBLocalRef anEjbLocalRef) {
        return (EJBLocalRef)this.getEquivalentEjbRef(anEjbLocalRef, this.getEjbLocalRefs());
    }

    private EjbRef getEquivalentEjbRef(EjbRef anEjbRef, List someRefs) {
        if (anEjbRef == null) {
            return null;
        }
        int size = someRefs.size();
        for (int i = 0; i < size; ++i) {
            EjbRef ref = (EjbRef)someRefs.get(i);
            if (!ref.isEquivalent(anEjbRef)) continue;
            return ref;
        }
        return null;
    }

    public String getHomeInterfaceName() {
        this.getHomeInterface();
        return this.homeInterface == null ? null : this.homeInterface.getQualifiedName();
    }

    public Method[] getHomeMethodsForDeployment() {
        return this.getHomeInterface() != null ? EnterpriseBeanImpl.getMethods(this.getHomeInterface()) : EMPTY_METHOD_ARRAY;
    }

    private JavaRefFactory getJavaRefFactory() {
        return ((JavaRefPackage)EPackage.Registry.INSTANCE.getEPackage("java.xmi")).getJavaRefFactory();
    }

    public EjbRef getLinkedEJBReference(EnterpriseBean anEJB) {
        return this.getLinkedEJBReference(anEJB, this.getEjbRefs());
    }

    public EJBLocalRef getLinkedEJBLocalReference(EnterpriseBean anEJB) {
        return (EJBLocalRef)this.getLinkedEJBReference(anEJB, this.getEjbLocalRefs());
    }

    private EjbRef getLinkedEJBReference(EnterpriseBean anEJB, List someRefs) {
        if (anEJB == null) {
            return null;
        }
        int size = someRefs.size();
        for (int i = 0; i < size; ++i) {
            EjbRef ref = (EjbRef)someRefs.get(i);
            if (!ref.isLinked(anEJB)) continue;
            return ref;
        }
        return null;
    }

    public String getLocalHomeInterfaceName() {
        this.getLocalHomeInterface();
        return this.localHomeInterface == null ? null : this.localHomeInterface.getQualifiedName();
    }

    public Method[] getLocalHomeMethodsForDeployment() {
        return this.getLocalHomeInterface() != null ? EnterpriseBeanImpl.getMethods(this.getLocalHomeInterface()) : EMPTY_METHOD_ARRAY;
    }

    public String getLocalInterfaceName() {
        this.getLocalInterface();
        return this.localInterface == null ? null : this.localInterface.getQualifiedName();
    }

    public static Method[] getMethods(JavaClass intf) {
        Method[] allMethods = intf.listMethodExtended();
        Vector<Method> resultVector = new Vector<Method>(allMethods.length);
        Hashtable<String, Method> methodNameTable = new Hashtable<String, Method>();
        Object[] result = null;
        for (int i = 0; i < allMethods.length; ++i) {
            Method m = allMethods[i];
            if (m.isStatic()) continue;
            String mKey = EnterpriseBeanImpl.methodKey(m);
            String interfaceName = m.getContainingJavaClass().getJavaName();
            if (interfaceName.equals("javax.ejb.EJBObject")) continue;
            Method synonym = (Method)methodNameTable.get(mKey);
            if (synonym == null) {
                methodNameTable.put(mKey, m);
                resultVector.addElement(m);
                continue;
            }
            JavaClass mClass = m.getContainingJavaClass();
            JavaClass sClass = synonym.getContainingJavaClass();
            if (!sClass.implementsInterface(mClass)) continue;
            resultVector.removeElement(synonym);
            methodNameTable.put(mKey, m);
            resultVector.addElement(m);
        }
        result = new Method[resultVector.size()];
        resultVector.copyInto(result);
        return EnterpriseBeanImpl.sortMethods((Method[])result);
    }

    public String getRemoteInterfaceName() {
        this.getRemoteInterface();
        return this.remoteInterface == null ? null : this.remoteInterface.getQualifiedName();
    }

    public Method[] getRemoteMethodsForDeployment() {
        return EnterpriseBeanImpl.getMethods(this.getRemoteInterface());
    }

    public boolean hasJavaReference(JavaClass aJavaClass) {
        if (aJavaClass != null) {
            return aJavaClass.equals(this.getEjbClass()) || aJavaClass.equals(this.getRemoteInterface()) || aJavaClass.equals(this.getHomeInterface()) || aJavaClass.equals(this.getLocalInterface()) || aJavaClass.equals(this.getLocalHomeInterface());
        }
        return false;
    }

    public boolean isBeanManagedEntity() {
        return this.isEntity() && !this.isContainerManagedEntity();
    }

    public boolean isContainerManagedEntity() {
        return false;
    }

    public boolean isEntity() {
        return false;
    }

    public boolean isMessageDriven() {
        return false;
    }

    public boolean isSession() {
        return false;
    }

    public boolean isVersion1_X() {
        if (this.getEjbJar() != null) {
            return this.getEjbJar().getVersionID() <= 11;
        }
        Revisit.revisit();
        return false;
    }

    public boolean isVersion2_X() {
        if (this.getEjbJar() != null) {
            return this.getEjbJar().getVersionID() >= 11;
        }
        Revisit.revisit();
        return false;
    }

    public void storeVersionID(J2EEVersionResource res) {
        String methodName = "storeVersionID";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        if (res == null) {
            logger.logp(Level.FINER, className, methodName, "RETURN Throwing IllegalStateException as resource is null");
            throw new IllegalStateException("XMLResource is null");
        }
        this._storedVersionID = res.getModuleVersionID();
        this._VersionIDStored = true;
        logger.logp(Level.FINER, className, methodName, "RETURN Stored [ {0} ]", this._storedVersionID);
    }

    public void storeVersionID() throws IllegalStateException {
        J2EEVersionResource res = (J2EEVersionResource)((Object)this.eResource());
        this.storeVersionID(res);
    }

    public int getVersionID() throws IllegalStateException {
        if (!this._VersionIDStored) {
            this.storeVersionID();
        }
        return this._storedVersionID;
    }

    public boolean hasLocalClient() {
        return this.getLocalInterface() != null && this.getLocalHomeInterface() != null;
    }

    public boolean hasRemoteClient() {
        return this.getRemoteInterface() != null && this.getHomeInterface() != null;
    }

    private static String methodKey(Method m) {
        StringBuffer result = new StringBuffer(m.getName());
        result.append("(");
        EList args = m.getParameters();
        for (int i = 0; i < args.size(); ++i) {
            JavaParameter arg = (JavaParameter)args.get(i);
            result.append(((JavaHelpers)arg.getEType()).getJavaName());
            result.append(",");
        }
        result.append(")");
        return result.toString();
    }

    public Object primRefValue(EObject feature) {
        switch (this.eDerivedStructuralFeatureID(((EStructuralFeature)feature).getFeatureID(), ((EStructuralFeature)feature).getContainerClass())) {
            case 5: {
                return this.getDescription();
            }
            case 6: {
                return this.getDisplayName();
            }
            case 3: {
                return this.getSmallIcon();
            }
            case 4: {
                return this.getLargeIcon();
            }
            case 8: {
                return this.getResourceRefs();
            }
            case 20: {
                return this.getEjbClass();
            }
            case 21: {
                return this.getHomeInterface();
            }
            case 22: {
                return this.getRemoteInterface();
            }
            case 7: {
                return this.getEnvironmentProperties();
            }
            case 19: {
                return this.getSecurityRoleRefs();
            }
            case 9: {
                return this.getEjbRefs();
            }
            case 10: {
                return this.getEjbLocalRefs();
            }
            case 13: {
                return this.getResourceEnvRefs();
            }
            case 24: {
                return this.getSecurityIdentity();
            }
            case 18: {
                return this.getName();
            }
        }
        return null;
    }

    public void reSyncSecurityRoleRef(String existingRoleName, String newRoleName) {
        EList roleRefs = this.getSecurityRoleRefs();
        for (int i = 0; i < roleRefs.size(); ++i) {
            SecurityRoleRef roleRef = (SecurityRoleRef)roleRefs.get(i);
            if (roleRef.getLink() == null || !roleRef.getLink().equals(existingRoleName)) continue;
            roleRef.setLink(newRoleName);
        }
    }

    public void setEjbClassName(String ejbClassName) {
        this.eSet(EjbPackage.eINSTANCE.getEnterpriseBean_EjbClass(), (Object)this.createClassRef(ejbClassName));
    }

    public void setHomeInterfaceName(String homeInterfaceName) {
        this.eSet(EjbPackage.eINSTANCE.getEnterpriseBean_HomeInterface(), (Object)this.createClassRef(homeInterfaceName));
    }

    public void setLocalHomeInterfaceName(String localHomeInterfaceName) {
        this.eSet(EjbPackage.eINSTANCE.getEnterpriseBean_LocalHomeInterface(), (Object)this.createClassRef(localHomeInterfaceName));
    }

    public void setLocalInterfaceName(String localInterfaceName) {
        this.eSet(EjbPackage.eINSTANCE.getEnterpriseBean_LocalInterface(), (Object)this.createClassRef(localInterfaceName));
    }

    public void setRemoteInterfaceName(String remoteInterfaceName) {
        this.eSet(EjbPackage.eINSTANCE.getEnterpriseBean_RemoteInterface(), (Object)this.createClassRef(remoteInterfaceName));
    }

    private static Method[] sortMethods(Method[] methods) {
        Method[] result = new Method[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            Method currMethod = methods[i];
            String currMethodName = currMethod.getSignature();
            for (int insertIndex = 0; insertIndex < i && currMethodName.compareTo(result[insertIndex].getSignature()) > 0; ++insertIndex) {
            }
            for (int j = insertIndex; j <= i; ++j) {
                Method tmpMethod = result[j];
                result[j] = currMethod;
                currMethod = tmpMethod;
            }
        }
        return result;
    }

    public String toString() {
        EList rer;
        StringBuffer result = new StringBuffer("\n    Enterprise Bean   [ ");
        result.append(this.getClass().getName() + '@' + Integer.toHexString(this.hashCode())).append(" ]\n");
        result.append("    Name              [ " + this.name + " ]\n");
        try {
            result.append("    Version ID        [ " + this.getVersionID() + " ]\n");
        }
        catch (IllegalStateException e) {
            result.append("    Version ID        [ ERROR: cannot be calculated - IllegalStateException ]\n");
        }
        EList rr = this.resourceRefs;
        if (rr != null) {
            result.append("    Num ResourceRefs  [ " + rr.size() + " ]\n");
            Iterator rri = rr.iterator();
            while (rri.hasNext()) {
                result.append("      ResourceRef     [ " + ((ResourceRef)rri.next()).getName() + " ]\n");
            }
        }
        if ((rer = this.resourceEnvRefs) != null) {
            result.append("    Num ResrceEnvRefs [ " + rer.size() + " ]\n");
            Iterator reri = rer.iterator();
            while (reri.hasNext()) {
                result.append("      ResourceEnvRef  [ " + ((ResourceEnvRef)reri.next()).getName() + " ]\n");
            }
        }
        return result.toString();
    }

    public void setDisplayName(String newDisplayName) {
        super.setDisplayName(newDisplayName);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 18, (Object)oldName, (Object)this.name));
        }
    }

    public EList getSecurityRoleRefs() {
        if (this.securityRoleRefs == null) {
            this.securityRoleRefs = new EObjectContainmentEList(SecurityRoleRef.class, this, 19);
        }
        return this.securityRoleRefs;
    }

    public JavaClass getEjbClass() {
        if (this.ejbClass != null && this.ejbClass.eIsProxy()) {
            JavaClass oldEjbClass = this.ejbClass;
            JavaClass resolved = (JavaClass)EcoreUtil.resolve((EObject)this.ejbClass, this);
            this.resolved(this.ejbClass, resolved);
            this.ejbClass = resolved;
            if (this.ejbClass != oldEjbClass && this.eNotificationRequired()) {
                this.eNotify(new ENotificationImpl((InternalEObject)this, 9, 20, (Object)oldEjbClass, (Object)this.ejbClass));
            }
        }
        return this.ejbClass;
    }

    public void setEjbClass(JavaClass newEjbClass) {
        JavaClass oldEjbClass = this.ejbClass;
        this.ejbClass = newEjbClass;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 20, (Object)oldEjbClass, (Object)this.ejbClass));
        }
    }

    public JavaClass getHomeInterface() {
        if (this.homeInterface != null && this.homeInterface.eIsProxy()) {
            InternalEObject oldHomeInterface = (InternalEObject)((Object)this.homeInterface);
            this.homeInterface = (JavaClass)this.eResolveProxy(oldHomeInterface);
            if (this.homeInterface != oldHomeInterface && this.eNotificationRequired()) {
                this.eNotify(new ENotificationImpl((InternalEObject)this, 9, 21, (Object)oldHomeInterface, (Object)this.homeInterface));
            }
        }
        return this.homeInterface;
    }

    public JavaClass basicGetHomeInterface() {
        return this.homeInterface;
    }

    public void setHomeInterface(JavaClass newHomeInterface) {
        JavaClass oldHomeInterface = this.homeInterface;
        this.homeInterface = newHomeInterface;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 21, (Object)oldHomeInterface, (Object)this.homeInterface));
        }
    }

    public JavaClass getRemoteInterface() {
        if (this.remoteInterface != null && this.remoteInterface.eIsProxy()) {
            InternalEObject oldRemoteInterface = (InternalEObject)((Object)this.remoteInterface);
            this.remoteInterface = (JavaClass)this.eResolveProxy(oldRemoteInterface);
            if (this.remoteInterface != oldRemoteInterface && this.eNotificationRequired()) {
                this.eNotify(new ENotificationImpl((InternalEObject)this, 9, 22, (Object)oldRemoteInterface, (Object)this.remoteInterface));
            }
        }
        return this.remoteInterface;
    }

    public JavaClass basicGetRemoteInterface() {
        return this.remoteInterface;
    }

    public void setRemoteInterface(JavaClass newRemoteInterface) {
        JavaClass oldRemoteInterface = this.remoteInterface;
        this.remoteInterface = newRemoteInterface;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 22, (Object)oldRemoteInterface, (Object)this.remoteInterface));
        }
    }

    public EJBJar getEjbJar() {
        if (this.eContainerFeatureID != 23) {
            return null;
        }
        return (EJBJar)this.eContainer();
    }

    public NotificationChain basicSetEjbJar(EJBJar newEjbJar, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)((Object)newEjbJar), 23, msgs);
        return msgs;
    }

    public void setEjbJar(EJBJar newEjbJar) {
        if (newEjbJar != this.eInternalContainer() || this.eContainerFeatureID != 23 && newEjbJar != null) {
            if (EcoreUtil.isAncestor(this, (EObject)newEjbJar)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newEjbJar != null) {
                msgs = ((InternalEObject)((Object)newEjbJar)).eInverseAdd(this, 10, EJBJar.class, msgs);
            }
            if ((msgs = this.basicSetEjbJar(newEjbJar, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 23, (Object)newEjbJar, (Object)newEjbJar));
        }
    }

    public SecurityIdentity getSecurityIdentity() {
        return this.securityIdentity;
    }

    public NotificationChain basicSetSecurityIdentity(SecurityIdentity newSecurityIdentity, NotificationChain msgs) {
        SecurityIdentity oldSecurityIdentity = this.securityIdentity;
        this.securityIdentity = newSecurityIdentity;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 24, (Object)oldSecurityIdentity, (Object)newSecurityIdentity);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add(notification);
            }
        }
        return msgs;
    }

    public void setSecurityIdentity(SecurityIdentity newSecurityIdentity) {
        if (newSecurityIdentity != this.securityIdentity) {
            NotificationChain msgs = null;
            if (this.securityIdentity != null) {
                msgs = ((InternalEObject)((Object)this.securityIdentity)).eInverseRemove(this, -25, null, msgs);
            }
            if (newSecurityIdentity != null) {
                msgs = ((InternalEObject)((Object)newSecurityIdentity)).eInverseAdd(this, -25, null, msgs);
            }
            if ((msgs = this.basicSetSecurityIdentity(newSecurityIdentity, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 24, (Object)newSecurityIdentity, (Object)newSecurityIdentity));
        }
    }

    public JavaClass getLocalHomeInterface() {
        if (this.localHomeInterface != null && this.localHomeInterface.eIsProxy()) {
            InternalEObject oldLocalHomeInterface = (InternalEObject)((Object)this.localHomeInterface);
            this.localHomeInterface = (JavaClass)this.eResolveProxy(oldLocalHomeInterface);
            if (this.localHomeInterface != oldLocalHomeInterface && this.eNotificationRequired()) {
                this.eNotify(new ENotificationImpl((InternalEObject)this, 9, 25, (Object)oldLocalHomeInterface, (Object)this.localHomeInterface));
            }
        }
        return this.localHomeInterface;
    }

    public JavaClass getServiceEndpoint() {
        return null;
    }

    public JavaClass basicGetLocalHomeInterface() {
        return this.localHomeInterface;
    }

    public void setLocalHomeInterface(JavaClass newLocalHomeInterface) {
        JavaClass oldLocalHomeInterface = this.localHomeInterface;
        this.localHomeInterface = newLocalHomeInterface;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 25, (Object)oldLocalHomeInterface, (Object)this.localHomeInterface));
        }
    }

    public JavaClass getLocalInterface() {
        if (this.localInterface != null && this.localInterface.eIsProxy()) {
            InternalEObject oldLocalInterface = (InternalEObject)((Object)this.localInterface);
            this.localInterface = (JavaClass)this.eResolveProxy(oldLocalInterface);
            if (this.localInterface != oldLocalInterface && this.eNotificationRequired()) {
                this.eNotify(new ENotificationImpl((InternalEObject)this, 9, 26, (Object)oldLocalInterface, (Object)this.localInterface));
            }
        }
        return this.localInterface;
    }

    public JavaClass basicGetLocalInterface() {
        return this.localInterface;
    }

    public void setLocalInterface(JavaClass newLocalInterface) {
        JavaClass oldLocalInterface = this.localInterface;
        this.localInterface = newLocalInterface;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 26, (Object)oldLocalInterface, (Object)this.localInterface));
        }
    }

    public String getMappedName() {
        return this.mappedName;
    }

    public void setMappedName(String newMappedName) {
        String oldMappedName = this.mappedName;
        this.mappedName = newMappedName;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 27, (Object)oldMappedName, (Object)this.mappedName));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 23: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetEjbJar((EJBJar)((Object)otherEnd), msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 19: {
                return ((InternalEList)this.getSecurityRoleRefs()).basicRemove(otherEnd, msgs);
            }
            case 23: {
                return this.basicSetEjbJar(null, msgs);
            }
            case 24: {
                return this.basicSetSecurityIdentity(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID) {
            case 23: {
                return this.eInternalContainer().eInverseRemove(this, 10, EJBJar.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 18: {
                return this.getName();
            }
            case 19: {
                return this.getSecurityRoleRefs();
            }
            case 20: {
                if (resolve) {
                    return this.getEjbClass();
                }
                return this.basicGetEjbClass();
            }
            case 21: {
                if (resolve) {
                    return this.getHomeInterface();
                }
                return this.basicGetHomeInterface();
            }
            case 22: {
                if (resolve) {
                    return this.getRemoteInterface();
                }
                return this.basicGetRemoteInterface();
            }
            case 23: {
                return this.getEjbJar();
            }
            case 24: {
                return this.getSecurityIdentity();
            }
            case 25: {
                if (resolve) {
                    return this.getLocalHomeInterface();
                }
                return this.basicGetLocalHomeInterface();
            }
            case 26: {
                if (resolve) {
                    return this.getLocalInterface();
                }
                return this.basicGetLocalInterface();
            }
            case 27: {
                return this.getMappedName();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 18: {
                this.setName((String)newValue);
                return;
            }
            case 19: {
                this.getSecurityRoleRefs().clear();
                this.getSecurityRoleRefs().addAll((Collection)newValue);
                return;
            }
            case 20: {
                this.setEjbClass((JavaClass)newValue);
                return;
            }
            case 21: {
                this.setHomeInterface((JavaClass)newValue);
                return;
            }
            case 22: {
                this.setRemoteInterface((JavaClass)newValue);
                return;
            }
            case 23: {
                this.setEjbJar((EJBJar)newValue);
                return;
            }
            case 24: {
                this.setSecurityIdentity((SecurityIdentity)newValue);
                return;
            }
            case 25: {
                this.setLocalHomeInterface((JavaClass)newValue);
                return;
            }
            case 26: {
                this.setLocalInterface((JavaClass)newValue);
                return;
            }
            case 27: {
                this.setMappedName((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 18: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 19: {
                this.getSecurityRoleRefs().clear();
                return;
            }
            case 20: {
                this.setEjbClass(null);
                return;
            }
            case 21: {
                this.setHomeInterface(null);
                return;
            }
            case 22: {
                this.setRemoteInterface(null);
                return;
            }
            case 23: {
                this.setEjbJar(null);
                return;
            }
            case 24: {
                this.setSecurityIdentity(null);
                return;
            }
            case 25: {
                this.setLocalHomeInterface(null);
                return;
            }
            case 26: {
                this.setLocalInterface(null);
                return;
            }
            case 27: {
                this.setMappedName(MAPPED_NAME_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 18: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 19: {
                return this.securityRoleRefs != null && !this.securityRoleRefs.isEmpty();
            }
            case 20: {
                return this.ejbClass != null;
            }
            case 21: {
                return this.homeInterface != null;
            }
            case 22: {
                return this.remoteInterface != null;
            }
            case 23: {
                return this.getEjbJar() != null;
            }
            case 24: {
                return this.securityIdentity != null;
            }
            case 25: {
                return this.localHomeInterface != null;
            }
            case 26: {
                return this.localInterface != null;
            }
            case 27: {
                return MAPPED_NAME_EDEFAULT == null ? this.mappedName != null : !MAPPED_NAME_EDEFAULT.equals(this.mappedName);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toStringGen() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", mappedName: ");
        result.append(this.mappedName);
        result.append(')');
        return result.toString();
    }

    protected void resolved(EObject originalObject, EObject resolvedObject) {
        EList col;
        if (originalObject != null && resolvedObject != null && originalObject != resolvedObject && !(col = originalObject.eAdapters()).isEmpty()) {
            for (Adapter a : col) {
                if (a == null) continue;
                resolvedObject.eAdapters().add(a);
            }
        }
    }

    public JavaClass getEjbClassGen() {
        if (this.ejbClass != null && this.ejbClass.eIsProxy()) {
            InternalEObject oldEjbClass = (InternalEObject)((Object)this.ejbClass);
            this.ejbClass = (JavaClass)this.eResolveProxy(oldEjbClass);
            if (this.ejbClass != oldEjbClass && this.eNotificationRequired()) {
                this.eNotify(new ENotificationImpl((InternalEObject)this, 9, 20, (Object)oldEjbClass, (Object)this.ejbClass));
            }
        }
        return this.ejbClass;
    }

    public JavaClass basicGetEjbClass() {
        return this.ejbClass;
    }

    public EAnnotation getEAnnotation(String source) {
        return null;
    }

    public EList getEAnnotations() {
        return null;
    }
}

