/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.internal.impl;

import org.eclipse.emf.common.util.URI;
import org.eclipse.jst.j2ee.common.internal.impl.XMLResourceImpl;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EJBResource;
import org.eclipse.jst.j2ee.internal.model.translator.ejb.EJBJarTranslator;
import org.eclipse.wst.common.internal.emf.resource.J2EESchemaUtility;
import org.eclipse.wst.common.internal.emf.resource.Renderer;
import org.eclipse.wst.common.internal.emf.resource.Translator;

public class EJBResourceImpl
extends XMLResourceImpl
implements EJBResource {
    public static final String CLASS_NAME = EJBResourceImpl.class.getName();

    public EJBResourceImpl(URI uri, Renderer aRenderer) {
        super(uri, aRenderer);
    }

    public EJBResourceImpl(Renderer aRenderer) {
        super(aRenderer);
    }

    public void setBatchMode(boolean isBatch) {
        this.renderer.setBatchMode(isBatch);
    }

    public boolean isBatchMode() {
        return this.renderer.isBatchMode();
    }

    public EJBJar getEJBJar() {
        return (EJBJar)this.getRootObject();
    }

    public Translator getRootTranslator() {
        return EJBJarTranslator.INSTANCE;
    }

    public int getType() {
        return 3;
    }

    public boolean isEJB1_1() {
        return this.getModuleVersionID() == 11;
    }

    public boolean isEJB2_0() {
        return this.getModuleVersionID() == 20;
    }

    public String getDoctype() {
        int j2eeVersionId = this.getJ2EEVersionID();
        if (j2eeVersionId == 12) {
            return "ejb-jar";
        }
        if (j2eeVersionId == 13) {
            return "ejb-jar";
        }
        return null;
    }

    public String getJ2EE_1_2_PublicID() {
        return "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN";
    }

    public String getJ2EE_1_2_SystemID() {
        return "http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd";
    }

    public String getJ2EE_Alt_1_2_SystemID() {
        return "http://java.sun.com/j2ee/dtds/ejb-jar_1.1.dtd";
    }

    public String getJ2EE_1_3_PublicID() {
        return "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN";
    }

    public String getJ2EE_1_3_SystemID() {
        return "http://java.sun.com/dtd/ejb-jar_2_0.dtd";
    }

    public String getJ2EE_Alt_1_3_SystemID() {
        return "http://java.sun.com/dtd/ejb-jar_2.0.dtd";
    }

    public int getJ2EEVersionID() {
        int moduleVersionId = this.getModuleVersionID();
        if (moduleVersionId == 10) {
            return 12;
        }
        if (moduleVersionId == 11) {
            return 12;
        }
        if (moduleVersionId == 20) {
            return 13;
        }
        if (moduleVersionId == 21) {
            return 14;
        }
        if (moduleVersionId == 30) {
            return 50;
        }
        this.unrecognizedModuleVersionID(CLASS_NAME, "getJ2EEVersionID", moduleVersionId);
        return 50;
    }

    public void setModuleVersionID(int moduleVersionId) {
        this.primSetVersionID(moduleVersionId);
        if (moduleVersionId == 30) {
            this.primSetDoctypeValues(null, null);
        } else if (moduleVersionId == 21) {
            this.primSetDoctypeValues(null, null);
        } else if (moduleVersionId == 20) {
            this.primSetDoctypeValues(this.getJ2EE_1_3_PublicID(), this.getJ2EE_1_3_SystemID());
        } else if (moduleVersionId == 11) {
            this.primSetDoctypeValues(this.getJ2EE_1_2_PublicID(), this.getJ2EE_1_2_SystemID());
        } else if (moduleVersionId == 10) {
            this.primSetDoctypeValues(this.getJ2EE_1_2_PublicID(), this.getJ2EE_1_2_SystemID());
        } else {
            this.primSetDoctypeValues(null, null);
            this.unrecognizedModuleVersionID(CLASS_NAME, "setModuleVersionID", moduleVersionId);
        }
        this.syncVersionOfRootObject();
    }

    public void setJ2EEVersionID(int j2eeVersionId) {
        if (j2eeVersionId == 50) {
            this.primSetDoctypeValues(null, null);
            this.primSetVersionID(30);
        } else if (j2eeVersionId == 14) {
            this.primSetDoctypeValues(null, null);
            this.primSetVersionID(21);
        } else if (j2eeVersionId == 13) {
            this.primSetDoctypeValues(this.getJ2EE_1_3_PublicID(), this.getJ2EE_1_3_SystemID());
            this.primSetVersionID(20);
        } else if (j2eeVersionId == 12) {
            this.primSetDoctypeValues(this.getJ2EE_1_2_PublicID(), this.getJ2EE_1_2_SystemID());
            this.primSetVersionID(11);
        } else {
            this.setModuleVersionID(this.getDefaultModuleVersionID());
            this.unrecognizedJ2EEVersionID(CLASS_NAME, "setJ2EEVersionID", j2eeVersionId);
        }
        this.syncVersionOfRootObject();
    }

    protected int getDefaultVersionID() {
        return this.getDefaultModuleVersionID();
    }

    protected int getDefaultModuleVersionID() {
        return 30;
    }

    protected void syncVersionOfRootObject() {
        EJBJar ejbJar = this.getEJBJar();
        if (ejbJar == null) {
            return;
        }
        String version = ejbJar.getVersion();
        String newVersion = this.getModuleVersionString();
        if (!newVersion.equals(version)) {
            ejbJar.setVersion(newVersion);
        }
    }

    protected byte[] getElementBytes() {
        return J2EESchemaUtility.EJB_JAR_BYTES;
    }

    protected byte[] getVersionBytes() {
        return J2EESchemaUtility.VERSION_2_1_BYTES;
    }

    protected byte[] getSchemaLocationBytes() {
        return J2EESchemaUtility.EJB_JAR_2_1_BYTES;
    }

    public int lookupModuleVersionId(String schemaName) {
        if (schemaName == null) {
            return -1;
        }
        if (schemaName.indexOf("http://java.sun.com/xml/ns/j2ee/ejb-jar_2_1.xsd") != -1) {
            return 21;
        }
        if (schemaName.indexOf("http://java.sun.com/xml/ns/javaee/ejb-jar_3_0.xsd") != -1) {
            return 30;
        }
        return -1;
    }

    public int lookupModuleVersionId(String publicId, String systemId) {
        if (publicId == null || systemId == null) {
            return -1;
        }
        if (publicId.equals("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN") && (systemId.equals("http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd") || systemId.equals("http://java.sun.com/j2ee/dtds/ejb-jar_1.1.dtd"))) {
            return 11;
        }
        if (publicId.equals("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN") && (systemId.equals("http://java.sun.com/dtd/ejb-jar_2_0.dtd") || systemId.equals("http://java.sun.com/dtd/ejb-jar_2.0.dtd"))) {
            return 20;
        }
        return -1;
    }

    public int parseModuleVersionId(String versionString) {
        if (versionString == null) {
            return -1;
        }
        if (versionString.equals("1.0")) {
            return 10;
        }
        if (versionString.equals("1.1")) {
            return 11;
        }
        if (versionString.equals("2.0")) {
            return 20;
        }
        if (versionString.equals("2.1")) {
            return 21;
        }
        if (versionString.equals("3.0")) {
            return 30;
        }
        return -1;
    }
}

