/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;

public class ArchiveFileDynamicClassLoader
extends ClassLoader {
    public static final String CONFIG_WTP_CLASSLOADING_LOGGER = "com.ibm.config.eclipse.wtp.classloading";
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp.classloading");
    private static String className = ArchiveFileDynamicClassLoader.class.getName();
    private static final String URL_PROTOCOL = "archive";
    protected Archive archive;
    protected Archive[] childArchives;
    protected String[] manifestClassPath;
    protected boolean archiveIsChildOfEAR;
    protected Archive[] libArchivesOfEAR;
    protected String libArchivesOfEARText;
    protected Archive[] manifestArchivesInEAR;
    protected String manifestArchivesInEARText;
    protected Archive[] childArchivesOfEAR;
    protected boolean isRar;
    protected boolean isWar;
    protected boolean allowLoadingFromWAR;
    protected Archive[] warLibs;
    protected ClassLoader extraClassLoader;
    protected ProtectionDomain protectionDomain;

    public ArchiveFileDynamicClassLoader(Archive anArchive, ClassLoader parentCl, ClassLoader extraCl, ProtectionDomain pDomain) {
        super(parentCl);
        if (logger.isLoggable(Level.FINER)) {
            String methodName = "ArchiveFileDynamicClassLoader()";
            logger.logp(Level.FINER, className, methodName, "This [ {0} ]; Archive [ {1} ]", new Object[]{this, anArchive});
            logger.logp(Level.FINER, className, methodName, "Archive container [ {0} ]", anArchive.getContainer());
            logger.logp(Level.FINER, className, methodName, "Parent container is EAR [ {0} ]", new Boolean(anArchive.getContainer() != null && anArchive.getContainer().isEARFile()));
            logger.logp(Level.FINER, className, methodName, "Parent classloader [ {0} ]", parentCl);
            logger.logp(Level.FINER, className, methodName, "Extra classloader [ {0} ]", extraCl);
            logger.logp(Level.FINER, className, methodName, "Protection domain [ {0} ]", pDomain);
        }
        this.setArchive(anArchive);
        this.setExtraClassLoader(extraCl);
        this.setProtectionDomain(pDomain);
    }

    public ArchiveFileDynamicClassLoader(Archive anArchive, ClassLoader parentCl, ClassLoader extraCl) {
        this(anArchive, parentCl, extraCl, null);
    }

    protected synchronized Class loadClass(String name, Set visitedArchives) throws ClassNotFoundException {
        String methodName = "loadClass(String, Set)";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ] [ {1} ]", new Object[]{name, this});
        }
        if (visitedArchives.contains(this.getArchive())) {
            logger.logp(Level.FINER, className, methodName, "Already visited!");
            throw new ClassNotFoundException(name);
        }
        logger.logp(Level.FINER, className, methodName, "New visit");
        visitedArchives.add(this.getArchive());
        try {
            Class<?> loadedClass = super.loadClass(name, false);
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", loadedClass);
            return loadedClass;
        }
        catch (ClassNotFoundException ex) {
            Class loadedClass = this.getClassInDependentJarInEAR(name, visitedArchives);
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", loadedClass);
            return loadedClass;
        }
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        String methodName = "loadClass(String, boolean)";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ] [ {1} ] [ {2} ]", new Object[]{name, this, new Boolean(resolve)});
        }
        try {
            Class<?> loadedClass = super.loadClass(name, resolve);
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", loadedClass);
            return loadedClass;
        }
        catch (ClassNotFoundException ex) {
            if (this.getArchiveIsChildOfEAR()) {
                logger.logp(Level.FINER, className, methodName, "Child of EAR case");
                Class loadedClass = this.getClassInDependentJarInEAR(name, this.createSelfSet());
                logger.logp(Level.FINER, className, methodName, "RETURN dependency [ {0} ]", loadedClass);
                return loadedClass;
            }
            if (this.getExtraClassLoader() != null) {
                logger.logp(Level.FINER, className, methodName, "Extra classloader case");
                Class<?> loadedClass = this.getExtraClassLoader().loadClass(name);
                logger.logp(Level.FINER, className, methodName, "RETURN extra [ {0} ]", loadedClass);
                return loadedClass;
            }
            logger.logp(Level.FINER, className, methodName, "Not child of EAR, and no extra classloader; failing.");
            throw new ClassNotFoundException(name);
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        byte[] bytes;
        String methodName = "findClass";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ] [ {1} ]", new Object[]{name, this});
        }
        if (name == null) {
            logger.logp(Level.FINER, className, methodName, "Null name: Failing");
            throw new ClassNotFoundException(name);
        }
        String fileName = ArchiveUtil.classNameToUri(name);
        logger.logp(Level.FINER, className, methodName, "Target file name [ {0} ]", fileName);
        File targetFile = this.getFile(fileName);
        if (targetFile == null) {
            logger.logp(Level.FINER, className, methodName, "File not found: Failing");
            throw new ClassNotFoundException(name);
        }
        try {
            bytes = ArchiveUtil.inputStreamToBytes(targetFile.getInputStream());
        }
        catch (FileNotFoundException e) {
            logger.logp(Level.FINER, className, methodName, "File not found: Failing");
            throw new ClassNotFoundException(name);
        }
        catch (IOException e) {
            logger.logp(Level.FINER, className, methodName, "IOException: Failing");
            logger.throwing(className, methodName, e);
            throw new ArchiveRuntimeException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.io_ex_loading_EXC_, new Object[]{targetFile.getName()}), e);
        }
        Class<?> definedClass = this.defineClass(name, bytes, 0, bytes.length, this.protectionDomain);
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", definedClass);
        return definedClass;
    }

    public File getResourceAsFile(String name) {
        return this.getFile(name);
    }

    protected File getFile(String name) {
        if (this.getIsRar()) {
            return this.getFile_Rar(name);
        }
        if (this.getIsWar()) {
            return this.getFile_War(name);
        }
        if (this.getArchiveIsChildOfEAR()) {
            return this.getFile_Module(name);
        }
        return this.getFile_Default(name);
    }

    protected File getFile_Default(String name) {
        String methodName = "getFile_Default";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY Archive [ {0} ] target [ {1} ]", new Object[]{this.getArchive().getURI(), name});
        }
        logger.logp(Level.FINER, className, methodName, "Searching for direct file");
        File file = this.getFileFromArchive(name);
        logger.logp(Level.FINER, className, methodName, "RETURN Direct file [ {0} ]", file);
        return file;
    }

    protected File getFile_Module(String name) {
        String methodName = "getFile_Module";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY Archive [ {0} ] target [ {1} ]", new Object[]{this.getArchive().getURI(), name});
        }
        logger.logp(Level.FINER, className, methodName, "Searching for direct file");
        File file = this.getFileFromArchive(name);
        if (file != null) {
            logger.logp(Level.FINER, className, methodName, "RETURN Direct file [ {0} ]", file);
            return file;
        }
        logger.logp(Level.FINER, className, methodName, "Searching dependency jars");
        file = this.getFileInDependentJarInEAR(name, this.createSelfSet());
        logger.logp(Level.FINER, className, methodName, "RETURN From dependent jar [ {0} ]", file);
        return file;
    }

    protected File getFile_Rar(String name) {
        String methodName = "getFile_Rar";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY Archive [ {0} ] target [ {1} ]", new Object[]{this.getArchive().getURI(), name});
        }
        logger.logp(Level.FINER, className, methodName, "Searching child jars");
        Archive[] useChildArchives = this.getChildArchives();
        for (int archiveNo = 0; archiveNo < useChildArchives.length; ++archiveNo) {
            Archive nextChildJar = useChildArchives[archiveNo];
            logger.logp(Level.FINER, className, methodName, "Searching child jar [ {0} ]", nextChildJar.getURI());
            try {
                File targetFile = nextChildJar.getFile(name);
                logger.logp(Level.FINER, className, methodName, "RETURN From child jar [ {0} ]", targetFile);
                return targetFile;
            }
            catch (FileNotFoundException ex) {
                continue;
            }
        }
        logger.logp(Level.FINER, className, methodName, "Searching dependency jars");
        File targetFile = this.getFileInDependentJarInEAR(name, this.createSelfSet());
        if (targetFile != null || this.getArchive().getLoadStrategy().getLooseArchive() == null) {
            logger.logp(Level.FINER, className, methodName, "RETURN From dependent jar [ {0} ]", targetFile);
            return targetFile;
        }
        logger.logp(Level.FINER, className, methodName, "Searching for direct file (loose module case)");
        targetFile = this.getFileFromArchive(name);
        logger.logp(Level.FINER, className, methodName, "RETURN Direct file (loose module case) [ {0} ]", targetFile);
        return targetFile;
    }

    protected File getFile_War(String name) {
        String methodName = "getFile_War";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY Archive [ {0} ] target [ {1} ]", new Object[]{this.getArchive().getURI(), name});
        }
        String swizzledName = ArchiveUtil.concatUri("WEB-INF/classes/", name, '/');
        logger.logp(Level.FINER, className, methodName, "Adjusted name [ {0} ]", swizzledName);
        File file = this.getFileFromArchive(swizzledName);
        if (file != null) {
            logger.logp(Level.FINER, className, methodName, "RETURN Adjusted file [ {0} ]", file);
            return file;
        }
        if (this.allowLoadingFromWAR) {
            logger.logp(Level.FINER, className, methodName, "Searching for direct file: allowLoadingFromWAR is true)");
            file = this.getFileFromArchive(name);
            if (file != null) {
                logger.logp(Level.FINER, className, methodName, "RETURN Direct file [ {0} ]", file);
                return file;
            }
        }
        logger.logp(Level.FINER, className, methodName, "Searching lib jars");
        Archive[] useWarLibs = this.getWarLibs();
        for (int archiveNo = 0; archiveNo < useWarLibs.length; ++archiveNo) {
            Archive nextWarLib = useWarLibs[archiveNo];
            logger.logp(Level.FINER, className, methodName, "Searching lib jar [ {0} ]", nextWarLib);
            try {
                file = nextWarLib.getFile(name);
                logger.logp(Level.FINER, className, methodName, "RETURN From lib jar [ {0} ]", file);
                return file;
            }
            catch (FileNotFoundException ex) {
                continue;
            }
        }
        logger.logp(Level.FINER, className, methodName, "Searching dependency jars");
        file = this.getFileInDependentJarInEAR(name, this.createSelfSet());
        logger.logp(Level.FINER, className, methodName, "RETURN From dependent jar [ {0} ]", file);
        return file;
    }

    protected Set createSelfSet() {
        HashSet<Archive> visitedArchives = new HashSet<Archive>(5);
        visitedArchives.add(this.getArchive());
        return visitedArchives;
    }

    protected Class getClassInDependentJarInEAR(String name, Set visitedArchives) throws ClassNotFoundException {
        String methodName = "getClassInDependentJarInEAR";
        boolean isFinerLoggable = logger.isLoggable(Level.FINER);
        if (isFinerLoggable) {
            logger.logp(Level.FINER, className, methodName, "ENTRY Archive [ {0} ] target [ {1} ]", new Object[]{this.getArchive().getURI(), name});
        }
        if (!this.getArchiveIsChildOfEAR()) {
            logger.logp(Level.FINER, className, methodName, "Not a child of an ear; failing search.");
            throw new ClassNotFoundException(name);
        }
        String useManifestArchivesText = isFinerLoggable ? this.getManifestArchivesInEARText() : null;
        Class targetClass = this.getClassInDependentJarInEAR(name, visitedArchives, this.getManifestArchivesInEAR(), useManifestArchivesText);
        if (targetClass != null) {
            logger.logp(Level.FINER, className, methodName, "RETURN Manifest class [ {0} ] ", targetClass);
            return targetClass;
        }
        String useEarLibJarsText = isFinerLoggable ? this.getLibArchivesOfEARText() : null;
        targetClass = this.getClassInDependentJarInEAR(name, visitedArchives, this.getLibArchivesOfEAR(), useEarLibJarsText);
        if (targetClass != null) {
            logger.logp(Level.FINER, className, methodName, "RETURN lib class [ {0} ] ", targetClass);
            return targetClass;
        }
        logger.logp(Level.FINER, className, methodName, "Compatibitility search across all jars of the EAR.");
        Archive[] useSimpleChildArchives = this.getChildArchivesOfEAR();
        for (int archiveNo = 0; archiveNo < useSimpleChildArchives.length; ++archiveNo) {
            Archive nextChildJar = useSimpleChildArchives[archiveNo];
            String nextChildURI = nextChildJar.getURI();
            if (visitedArchives.contains(nextChildJar)) {
                logger.logp(Level.FINER, className, methodName, "Skipping jar (already visited)[ {0} ]", nextChildURI);
                continue;
            }
            logger.logp(Level.FINER, className, methodName, "Searching jar [ {0} ]", nextChildURI);
            visitedArchives.add(nextChildJar);
            try {
                targetClass = ((ArchiveFileDynamicClassLoader)nextChildJar.getArchiveClassLoader()).loadClass(name, visitedArchives);
                logger.logp(Level.FINER, className, methodName, "RETURN From all jars [ {0} ]", targetClass);
                return targetClass;
            }
            catch (ClassNotFoundException noDice) {
                // empty catch block
            }
        }
        logger.logp(Level.FINER, className, methodName, "Compatibitility search did not locate target.");
        throw new ClassNotFoundException(name);
    }

    protected File getFileInDependentJarInEAR(String name, Set visitedArchives) {
        String methodName = "getFileInDependentJarInEAR";
        boolean isFinerLoggable = logger.isLoggable(Level.FINER);
        if (isFinerLoggable) {
            logger.logp(Level.FINER, className, methodName, "ENTRY Archive [ {0} ] target [ {1} ]", new Object[]{this.getArchive().getURI(), name});
        }
        if (!this.getArchiveIsChildOfEAR()) {
            logger.logp(Level.FINER, className, methodName, "RETURN [ null ] Not a child of an EAR");
            return null;
        }
        String useManifestArchivesText = isFinerLoggable ? this.getManifestArchivesInEARText() : null;
        File targetFile = this.getFileInDependentJarInEAR(name, visitedArchives, this.getManifestArchivesInEAR(), useManifestArchivesText);
        if (targetFile != null) {
            logger.logp(Level.FINER, className, methodName, "RETURN Manifest file [ {0} ] ", targetFile);
            return targetFile;
        }
        String useEarLibJarsText = isFinerLoggable ? this.getLibArchivesOfEARText() : null;
        targetFile = this.getFileInDependentJarInEAR(name, visitedArchives, this.getLibArchivesOfEAR(), useEarLibJarsText);
        if (targetFile != null) {
            logger.logp(Level.FINER, className, methodName, "RETURN lib file [ {0} ] ", targetFile);
            return targetFile;
        }
        logger.logp(Level.FINER, className, methodName, "Compatibitility search across all jars of the EAR.");
        Archive[] useSimpleChildArchives = this.getChildArchivesOfEAR();
        for (int archiveNo = 0; archiveNo < useSimpleChildArchives.length; ++archiveNo) {
            Archive nextChildJar = useSimpleChildArchives[archiveNo];
            String nextChildURI = nextChildJar.getURI();
            if (visitedArchives.contains(nextChildJar)) {
                logger.logp(Level.FINER, className, methodName, "Skipping jar (already visited)[ {0} ]", nextChildURI);
                continue;
            }
            logger.logp(Level.FINER, className, methodName, "Searching jar [ {0} ]", nextChildURI);
            visitedArchives.add(nextChildJar);
            try {
                targetFile = nextChildJar.getFile(name);
                logger.logp(Level.FINER, className, methodName, "RETURN From all jars [ {0} ]", targetFile);
                return targetFile;
            }
            catch (FileNotFoundException noDice) {
                // empty catch block
            }
        }
        logger.logp(Level.FINER, className, methodName, "Compatibitility search did not locate target.");
        logger.logp(Level.FINER, className, methodName, "RETURN [ null ]");
        return null;
    }

    private Class getClassInDependentJarInEAR(String name, Set visitedArchives, Archive[] archiveList, String archiveListText) {
        String methodName = "getClassInDependentJarInEAR";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY Archive [ {0} ] target [ {1} ]", new Object[]{this.getArchive().getURI(), name});
            logger.logp(Level.FINER, className, methodName, "ClassPath [ {0} ]", archiveListText);
        }
        for (int i = 0; i < archiveList.length; ++i) {
            Archive nextArchive = archiveList[i];
            String nextArchiveURI = nextArchive.getURI();
            if (visitedArchives.contains(nextArchive)) {
                logger.logp(Level.FINER, className, methodName, "Skipping jar (already visited)[ {0} ]", nextArchiveURI);
                continue;
            }
            logger.logp(Level.FINER, className, methodName, "Searching jar [ {0} ]", nextArchiveURI);
            visitedArchives.add(nextArchive);
            try {
                Class targetClass = ((ArchiveFileDynamicClassLoader)nextArchive.getArchiveClassLoader()).loadClass(name, visitedArchives);
                logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", targetClass);
                return targetClass;
            }
            catch (ClassNotFoundException noDice) {
                // empty catch block
            }
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ null ]");
        return null;
    }

    private File getFileInDependentJarInEAR(String name, Set visitedArchives, Archive[] archiveList, String archiveListText) {
        String methodName = "getFileInDependentJarInEAR";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY Archive [ {0} ] target [ {1} ]", new Object[]{this.getArchive().getURI(), name});
            logger.logp(Level.FINER, className, methodName, "ClassPath [ {0} ]", archiveListText);
        }
        for (int i = 0; i < archiveList.length; ++i) {
            Archive nextArchive = archiveList[i];
            String nextArchiveURI = nextArchive.getURI();
            if (visitedArchives.contains(nextArchive)) {
                logger.logp(Level.FINER, className, methodName, "Skipping jar (already visited)[ {0} ]", nextArchiveURI);
                continue;
            }
            logger.logp(Level.FINER, className, methodName, "Searching jar [ {0} ]", nextArchiveURI);
            visitedArchives.add(nextArchive);
            try {
                File targetFile = nextArchive.getFile(name);
                logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", targetFile);
                return targetFile;
            }
            catch (FileNotFoundException noDice) {
                // empty catch block
            }
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ null ]");
        return null;
    }

    public InputStream getResourceAsStream(String name) {
        File file = this.getFile(name);
        if (file == null) {
            return null;
        }
        try {
            return file.getInputStream();
        }
        catch (IOException e) {
            throw new ArchiveRuntimeException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.io_ex_loading_EXC_, new Object[]{name}), e);
        }
    }

    protected URL findResource(String name) {
        File targetFile = this.getFile(name);
        if (targetFile == null) {
            return null;
        }
        try {
            return new URL(null, "archive://" + name, new ArchiveURLStreamHandler(targetFile));
        }
        catch (MalformedURLException e) {
            RuntimeException re2 = new RuntimeException(e);
            logger.throwing(className, "findResource", re2);
            throw re2;
        }
    }

    public void setArchive(Archive newArchive) {
        this.archive = newArchive;
        this.childArchives = null;
        this.manifestClassPath = null;
        this.archiveIsChildOfEAR = newArchive.getContainer() != null && newArchive.getContainer().isEARFile();
        this.libArchivesOfEAR = null;
        this.libArchivesOfEARText = null;
        this.childArchivesOfEAR = null;
        this.manifestArchivesInEAR = null;
        this.manifestArchivesInEARText = null;
        this.isRar = newArchive.isRARFile();
        this.isWar = newArchive.isWARFile();
        this.allowLoadingFromWAR = this.isWar && newArchive.getOptions().getClassLoadingMode() == 0;
        this.warLibs = null;
    }

    public Archive getArchive() {
        return this.archive;
    }

    protected File getFileFromArchive(String name) {
        try {
            return this.getArchive().getFile(name);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    protected Archive[] getChildArchives() {
        if (this.childArchives == null) {
            List useChildArchives = this.getArchive().getArchiveFiles();
            this.childArchives = useChildArchives.toArray(new Archive[useChildArchives.size()]);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, className, "getChildArchives", "Computed [ {0} ]", this.getArchiveListText(this.childArchives));
            }
        }
        return this.childArchives;
    }

    protected String[] getManifestClassPath() {
        if (this.manifestClassPath == null) {
            this.manifestClassPath = this.getArchive().getManifest().getClassPathTokenized();
        }
        return this.manifestClassPath;
    }

    protected boolean getArchiveIsChildOfEAR() {
        return this.archiveIsChildOfEAR;
    }

    protected EARFile getEARFile() {
        return (EARFile)this.getArchive().getContainer();
    }

    protected File getFileFromEAR(String name) {
        try {
            return this.getEARFile().getFile(name);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    protected boolean getIsRar() {
        return this.isRar;
    }

    protected boolean getIsWar() {
        return this.isWar;
    }

    private WARFile getWarFile() {
        return (WARFile)this.getArchive();
    }

    protected boolean getAllowLoadingFromWAR() {
        return this.allowLoadingFromWAR;
    }

    protected Archive[] getWarLibs() {
        if (this.warLibs == null) {
            ArrayList<File> useWarLibs = new ArrayList<File>();
            for (File nextChild : this.getWarFile().getLibs()) {
                if (!(nextChild instanceof Archive)) continue;
                useWarLibs.add(nextChild);
            }
            this.warLibs = useWarLibs.toArray(new Archive[useWarLibs.size()]);
        }
        return this.warLibs;
    }

    protected String getLibNameOfEAR() {
        String methodName = "getLibNameOfEAR";
        String libName = this.getEARFile().getLibraryDirectoryName();
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ] from parent EAR", libName);
        return libName;
    }

    protected Archive[] getLibArchivesOfEAR() {
        String methodName = "getLibArchivesOfEAR";
        String libName = this.getLibNameOfEAR();
        if (libName == null) {
            logger.logp(Level.FINER, className, methodName, "Pre-EE5: Setting empty EAR LIB list");
            this.libArchivesOfEAR = new Archive[0];
        } else {
            logger.logp(Level.FINER, className, methodName, "Selecting EAR LIB list from [ {0} ] ...", libName);
            ArrayList<File> libArchives = new ArrayList<File>();
            for (File file : this.getEARFile().filterFilesByPrefix(libName)) {
                if (!file.isArchive() || file.isDirectoryEntry() || !file.getURI().endsWith(".jar")) continue;
                logger.logp(Level.FINER, className, methodName, "Adding [ {0} ] to EAR LIB list", file.getURI());
                libArchives.add(file);
            }
            this.libArchivesOfEAR = libArchives.toArray(new Archive[libArchives.size()]);
            logger.logp(Level.FINER, className, methodName, "Selecting EAR LIB list from [ {0} ] ... done", libName);
        }
        return this.libArchivesOfEAR;
    }

    protected String getLibArchivesOfEARText() {
        if (this.libArchivesOfEARText == null) {
            this.libArchivesOfEARText = this.getArchiveListText(this.getLibArchivesOfEAR());
        }
        return this.libArchivesOfEARText;
    }

    protected Archive[] getManifestArchivesInEAR() {
        String methodName = "getManifestArchivesInEAR";
        if (this.manifestArchivesInEAR == null) {
            logger.logp(Level.FINER, className, methodName, "Setting manifest archive list ...");
            String[] useManifestClassPath = this.getManifestClassPath();
            ArrayList<File> useManifestArchives = new ArrayList<File>();
            for (int entryNo = 0; entryNo < this.manifestClassPath.length; ++entryNo) {
                File nextFile;
                String nextEntry = useManifestClassPath[entryNo];
                if (nextEntry == null) {
                    logger.logp(Level.FINER, className, methodName, "Skipping null entry");
                    continue;
                }
                try {
                    nextFile = this.getEARFile().getFile(nextEntry);
                }
                catch (FileNotFoundException e) {
                    nextFile = null;
                }
                if (nextFile != null) {
                    if (nextFile.isArchive()) {
                        logger.logp(Level.FINER, className, methodName, "Added [ {0} ] as [ {1} ] to manifest archives", new Object[]{nextEntry, nextFile});
                        useManifestArchives.add(nextFile);
                        continue;
                    }
                    logger.logp(Level.FINER, className, methodName, "Skipping [ {0} ] as [ {1} ] for manifest archives: Not an archive", new Object[]{nextEntry, nextFile});
                    continue;
                }
                logger.logp(Level.FINER, className, methodName, "Skipping [ {0} ] for manifest archives: Entry not found", nextEntry);
            }
            this.manifestArchivesInEAR = useManifestArchives.toArray(new Archive[useManifestArchives.size()]);
            logger.logp(Level.FINER, className, methodName, "Setting manifest archive list ... done");
        }
        return this.manifestArchivesInEAR;
    }

    protected String getManifestArchivesInEARText() {
        if (this.manifestArchivesInEARText == null) {
            this.manifestArchivesInEARText = this.getArchiveListText(this.getManifestArchivesInEAR());
        }
        return this.manifestArchivesInEARText;
    }

    protected String getArchiveListText(Archive[] archives) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < archives.length; ++i) {
            if (i > 0) {
                sb.append(";");
            }
            sb.append(archives[i].getURI());
        }
        return sb.toString();
    }

    protected Archive[] getChildArchivesOfEAR() {
        String methodName = "getChildArchivesOfEAR";
        if (this.childArchivesOfEAR == null) {
            logger.logp(Level.FINER, className, methodName, "Starting scan of archives ...");
            ArrayList<Archive> useEarChildArchives = new ArrayList<Archive>();
            for (Archive nextChildArchive : this.getEARFile().getArchiveFiles()) {
                String nextChildURI = nextChildArchive.getURI();
                if (nextChildArchive.isSimpleJavaArchive()) {
                    logger.logp(Level.FINER, className, methodName, "Adding as simple archive [ {0} ]", nextChildURI);
                    useEarChildArchives.add(nextChildArchive);
                    continue;
                }
                logger.logp(Level.FINER, className, methodName, "Skipping non-simple archive [ {0} ]", nextChildURI);
            }
            this.childArchivesOfEAR = useEarChildArchives.toArray(new Archive[useEarChildArchives.size()]);
            logger.logp(Level.FINER, className, methodName, "Completed scan of archives");
        }
        return this.childArchivesOfEAR;
    }

    public void setExtraClassLoader(ClassLoader newExtraClassLoader) {
        this.extraClassLoader = newExtraClassLoader;
    }

    public ClassLoader getExtraClassLoader() {
        return this.extraClassLoader;
    }

    public ProtectionDomain setProtectionDomain(ProtectionDomain protectionDomain) {
        ProtectionDomain priorDomain = this.protectionDomain;
        this.protectionDomain = protectionDomain;
        return priorDomain;
    }

    public ProtectionDomain getProtectionDomain() {
        return this.protectionDomain;
    }

    private class ArchiveURLConnection
    extends URLConnection {
        private String resourceName;
        protected File targetFile;

        protected ArchiveURLConnection(URL url, File targetFile) {
            super(url);
            this.resourceName = url.toString().substring(ArchiveFileDynamicClassLoader.URL_PROTOCOL.length() + 3);
            this.targetFile = targetFile;
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, className, "ArchiveURLConnection(URL, File)", "Resource Name [ {0} ] File URI [ {1} ]", new Object[]{this.resourceName, targetFile.getURI()});
            }
        }

        public void connect() throws IOException {
        }

        public InputStream getInputStream() throws IOException {
            logger.logp(Level.FINER, className, "getInputStream", "Target file [ {0} ]", this.targetFile);
            return this.targetFile.getInputStream();
        }
    }

    private class ArchiveURLStreamHandler
    extends URLStreamHandler {
        protected File targetFile;

        public ArchiveURLStreamHandler(File targetFile) {
            this.targetFile = targetFile;
        }

        protected URLConnection openConnection(URL url) throws IOException {
            return new ArchiveURLConnection(url, this.targetFile);
        }
    }
}

