/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jem.internal.java.adapters.jdk.JavaJDKAdapterFactory;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ArchiveTypeDiscriminatorRegistry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ReadOnlyDirectory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ManifestException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ReopenException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.AndSaveFilter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIterator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.RuntimeClasspathEntry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.RuntimeClasspathEntryImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.SaveFilter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.CommonarchiveFactoryImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ContainerImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.DirectoryArchiveLoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.DirectorySaveStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.NestedArchiveLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.TempZipFileLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipFileLoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipFileLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipStreamSaveStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveFileDynamicClassLoader;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ClasspathUtil;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseArchive;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseConfigRegister;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;
import org.eclipse.wst.common.internal.emf.utilities.ExtendedEcoreUtil;

public class ArchiveImpl
extends ContainerImpl
implements Archive {
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    protected static Logger loggerLCT = Logger.getLogger("com.ibm.config.eclipse.wtp.lct");
    private static String className = ArchiveImpl.class.getName();
    protected EList types = null;
    protected ArchiveManifest manifest;
    protected SaveStrategy saveStrategy;
    protected SaveFilter saveFilter;
    protected String xmlEncoding = "UTF-8";
    protected ClassLoader archiveClassLoader;
    protected String extraClasspath;
    protected ArchiveOptions options;
    protected static final int TRANSFER_SIZE = 131072;
    public static final boolean DO_NORMALIZE = true;
    public static final boolean DONT_NORMALIZE = false;
    private boolean _binariesPathCached = false;
    private String _binariesPath;
    protected Set<Archive.ModuleVersionEnum> isSetCanImportModuleVersion = EnumSet.noneOf(Archive.ModuleVersionEnum.class);
    protected Set<Archive.ModuleVersionEnum> canImportModuleVersion = EnumSet.noneOf(Archive.ModuleVersionEnum.class);

    public ArchiveImpl() {
        this.getCommonArchiveFactory().archiveOpened(this);
    }

    protected EClass eStaticClass() {
        return CommonarchivePackage.Literals.ARCHIVE;
    }

    public EList getTypes() {
        if (this.types == null) {
            this.types = new EDataTypeUniqueEList(String.class, this, 8);
        }
        return this.types;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return this.getTypes();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.getTypes().clear();
                this.getTypes().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.getTypes().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.types != null && !this.types.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (types: ");
        result.append(this.types);
        result.append(')');
        return result.toString();
    }

    public Archive addCopy(Archive anArchive) throws DuplicateObjectException {
        this.checkAddValid(anArchive);
        Archive copy = this.getCommonArchiveFactory().copy(anArchive);
        this.getFiles().add(copy);
        return copy;
    }

    public File addCopy(File aFile) throws DuplicateObjectException {
        if (aFile.isReadOnlyDirectory()) {
            this.addCopy((ReadOnlyDirectory)aFile);
            return null;
        }
        this.checkAddValid(aFile);
        File copy = this.copy(aFile);
        this.getFiles().add(copy);
        return copy;
    }

    public List addCopy(ReadOnlyDirectory dir) throws DuplicateObjectException {
        return this.addCopyFiles(dir.getFilesRecursive());
    }

    public List addCopyFiles(List list) throws DuplicateObjectException {
        this.getFiles();
        ArrayList<File> copyList = new ArrayList<File>();
        for (int i = 0; i < list.size(); ++i) {
            File aFile = (File)list.get(i);
            this.checkAddValid(aFile);
            copyList.add(this.copy(aFile));
        }
        this.getFiles().addAll(copyList);
        return copyList;
    }

    public void addOrReplaceMofResource(Resource aResource) {
        this.getLoadStrategy().addOrReplaceMofResource(aResource);
    }

    public boolean canClose() {
        return !this.getCommonArchiveFactory().getOpenArchivesDependingOn(this).isEmpty();
    }

    protected void checkAddValid(File aFile) throws DuplicateObjectException {
        this.checkAddValid(aFile.getURI());
    }

    protected void checkAddValid(String aUri) throws DuplicateObjectException {
        try {
            File f = this.getFile(aUri);
            if (f != null) {
                throw new DuplicateObjectException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.duplicate_file_EXC_, new Object[]{this.getURI(), aUri}), f);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void setLoadStrategy(LoadStrategy newLoadStrategy) {
        super.setLoadStrategy(newLoadStrategy);
        this.clearBinariesPath();
        if (this.loadStrategy != null && this.isModuleFile()) {
            this.getJavaAdapterFactory();
        }
    }

    protected void cleanupAfterTempSave(String aUri, java.io.File original, java.io.File destination) throws SaveFailureException {
        String methodName = "cleanupAfterTempSave";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY URI = [ {0} ]", aUri);
            logger.logp(Level.FINER, className, methodName, "Target (Final Target) [ {0} ]", original);
            logger.logp(Level.FINER, className, methodName, "Source (Intermediate Target) [ {0} ]", destination);
        }
        this.checkWriteable(original);
        boolean deleteWorked = false;
        String originalPath = original.getAbsolutePath();
        logger.logp(Level.FINER, className, methodName, "Original file to be deleted [ {0} ]", originalPath);
        boolean originalIsDirectory = original.isDirectory();
        logger.logp(Level.FINER, className, methodName, "Original file a directory [ {0} ]", Boolean.toString(originalIsDirectory));
        if (!this.canRename(original)) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.SEVERE, className, methodName, "Cannot rename target [ {0} ]", original);
            }
            if (loggerLCT.isLoggable(Level.FINER)) {
                loggerLCT.logp(Level.WARNING, className, methodName, ZipFileLoadStrategyImpl.lct.printHash(originalPath));
            }
            if (originalIsDirectory) {
                logger.logp(Level.FINER, className, methodName, "Unable to perform direct transfer - directory");
            } else if (!this.transfer(destination, original)) {
                logger.logp(Level.WARNING, className, methodName, "Rename failure during final save; transfer failure failure during final save;this may result in a failure to save updates to the archive, or in a corruption of the original archive.", originalPath);
            } else {
                logger.logp(Level.FINER, className, methodName, "RETURN - success with direct transfer");
                return;
            }
            logger.logp(Level.FINER, className, methodName, "RETURN Throwing SaveFailureException because original file cannot be renamed");
            throw new SaveFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.unable_replace_EXC_, new Object[]{originalPath}));
        }
        for (int i = 0; i < 10; ++i) {
            if (ArchiveUtil.delete(original)) {
                logger.logp(Level.FINER, className, methodName, "Successfully deleted original file [ {0} ]", originalPath);
                if (i > 0) {
                    logger.logp(Level.FINER, className, methodName, "Number of times slept [ {0} ]", Integer.toString(i));
                }
                deleteWorked = true;
                break;
            }
            try {
                Thread.sleep(250L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        String destinationPath = destination.getAbsolutePath();
        logger.logp(Level.FINER, className, methodName, "File to be renamed [ {0} ]", destinationPath);
        if (deleteWorked) {
            if (this.renameToWithRetry(destination, original)) {
                logger.logp(Level.FINER, className, methodName, "RETURN - Successful renamed");
                return;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.SEVERE, className, methodName, "Could not rename file to original name [ {0} ]", originalPath);
            }
        } else if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.SEVERE, className, methodName, "Could not delete original file [ {0} ]", originalPath);
        }
        if (loggerLCT.isLoggable(Level.FINER)) {
            loggerLCT.logp(Level.WARNING, className, methodName, ZipFileLoadStrategyImpl.lct.printHash(originalPath));
        }
        if (originalIsDirectory) {
            logger.logp(Level.FINER, className, methodName, "Unable to perform direct transfer - directory");
        } else if (!this.transfer(destination, original)) {
            logger.logp(Level.WARNING, className, methodName, "Rename failure during final save; transfer failure failure during final save;this may result in a failure to save updates to the archive, or in a corruption of the original archive.", originalPath);
        } else {
            logger.logp(Level.FINER, className, methodName, "RETURN - success with direct transfer");
            return;
        }
        logger.logp(Level.FINER, className, methodName, "RETURN Throwing SaveFailureException");
        throw new SaveFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.unable_replace_EXC_, new Object[]{originalPath}));
    }

    protected boolean transfer(java.io.File sourceFile, java.io.File targetFile) {
        String methodName = "transfer";
        logger.logp(Level.FINER, className, methodName, "ENTRY Source [ {0} ] Target [ {1} ]", new Object[]{sourceFile, targetFile});
        try {
            this.basicTransfer(sourceFile, targetFile);
        }
        catch (IOException e) {
            logger.throwing(className, methodName, e);
            logger.logp(Level.FINER, className, methodName, "RETURN [ false ] - IOException on base transfer");
            return false;
        }
        boolean didDelete = sourceFile.delete();
        logger.logp(Level.FINER, className, methodName, "Did delete intermediate [ {0} ]", new Boolean(didDelete));
        logger.logp(Level.FINER, className, methodName, "RETURN [ true ]");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long basicTransfer(java.io.File sourceFile, java.io.File targetFile) throws IOException {
        String methodName = "basicTransfer";
        logger.logp(Level.FINER, className, methodName, "ENTRY Source [ {0} ] Target [ {1} ]", new Object[]{sourceFile, targetFile});
        long totalRead = 0L;
        FileInputStream sourceStream = new FileInputStream(sourceFile);
        try {
            FileOutputStream targetStream = new FileOutputStream(targetFile);
            try {
                int nextRead;
                byte[] transferBuffer = new byte[131072];
                while ((nextRead = sourceStream.read(transferBuffer)) > 0) {
                    totalRead += (long)nextRead;
                    targetStream.write(transferBuffer, 0, nextRead);
                }
            }
            finally {
                targetStream.close();
            }
        }
        finally {
            sourceStream.close();
            logger.logp(Level.FINER, className, methodName, "RETURN Total Read [ {0} ]", new Long(totalRead));
        }
        return totalRead;
    }

    public void close() {
        String methodName = "close";
        String archiveURI = this.getURI();
        logger.logp(Level.FINER, className, methodName, "ENTRY URI = [ {0} ]", archiveURI);
        this.getLoadStrategy().close();
        this.releaseClassLoader();
        this.getCommonArchiveFactory().archiveClosed(this);
        logger.logp(Level.FINER, className, methodName, "Archive [ {0} ] closed.");
        if (this.isIndexed()) {
            logger.logp(Level.FINER, className, methodName, "An index is present: performing nested closes.");
            List archives = this.getArchiveFiles();
            for (int i = 0; i < archives.size(); ++i) {
                Archive a = (Archive)archives.get(i);
                logger.logp(Level.FINER, className, methodName, "Close nested archive file [ {0} ]", a.getURI());
                a.close();
            }
        } else {
            logger.logp(Level.FINER, className, methodName, "No index: Skipping nested closes.");
        }
        logger.logp(Level.FINER, className, methodName, "RETURN closed [ {0} ]", archiveURI);
    }

    protected File copy(File aFile) {
        String methodName = "copy";
        logger.logp(Level.FINER, className, methodName, "ENTRY file = [ {0} ]", aFile);
        File copy = null;
        copy = aFile.isArchive() ? this.getCommonArchiveFactory().copy((Archive)aFile) : (File)EtoolsCopyUtility.createCopy(aFile);
        logger.logp(Level.FINER, className, methodName, "RETURN copy [ {0} ]", copy);
        return copy;
    }

    protected LoadStrategy createLoadStrategyForReopen(Archive parent) throws IOException {
        LoadStrategy newStrategy;
        String methodName = "createLoadStrategyForReopen";
        String aUri = this.getURI();
        LoadStrategy currentStrategy = this.getLoadStrategy();
        LooseArchive loose = this.getLoadStrategy().getLooseArchive();
        if (logger.isLoggable(Level.FINER)) {
            String useResources;
            String useBinaries;
            logger.logp(Level.FINER, className, methodName, "ENTRY URI [ {0} ] Parent [ {1} ] Strategy [ {2} ] Loose [ {3} ]", new Object[]{aUri, parent, currentStrategy, loose});
            try {
                useBinaries = this.getBinariesPath();
            }
            catch (FileNotFoundException e) {
                useBinaries = "***UNKNOWN***";
            }
            try {
                useResources = this.getResourcesPath();
            }
            catch (FileNotFoundException e) {
                useResources = "***UNKNOWN***";
            }
            logger.logp(Level.FINER, className, methodName, "Archive Binaries [ {0} ] Archive Resources [ {1} ]", new Object[]{useBinaries, useResources});
            try {
                useBinaries = currentStrategy.getBinariesPath();
            }
            catch (FileNotFoundException e) {
                useBinaries = "***UNKNOWN***";
            }
            try {
                useResources = currentStrategy.getResourcesPath();
            }
            catch (FileNotFoundException e) {
                useResources = "***UNKNOWN***";
            }
            logger.logp(Level.FINER, className, methodName, "Strategy Binaries [ {0} ] Strategy Resources [ {1} ]", new Object[]{useBinaries, useResources});
            if (loose != null) {
                logger.logp(Level.FINER, className, methodName, "Loose URI [ {0} ] Loose Binaries [ {1} ] Loose Resources [ {2} ]", new Object[]{loose.getUri(), loose.getBinariesPath(), loose.getResourcesPath()});
            }
        }
        if (currentStrategy instanceof TempZipFileLoadStrategyImpl) {
            logger.logp(Level.FINER, className, methodName, "Detected temporary zip file strategy");
            newStrategy = ArchiveUtil.createExpandedLoadStrategy(aUri, parent);
            if (loose != null) {
                logger.logp(Level.FINER, className, methodName, "Strange: Temporary strategy with a non-null loose archive.");
                newStrategy.setLooseArchivePrim(loose);
            }
        } else if (loose != null) {
            logger.logp(Level.FINER, className, methodName, "Detected loose archive, and not using temporary zip file strategy");
            newStrategy = this.getCommonArchiveFactory().createLoadStrategy(loose.getBinariesPath());
            newStrategy.setLooseArchive(loose);
        } else if (parent != null) {
            logger.logp(Level.FINER, className, methodName, "No temporary zip file, no loose archive, but have a parent.");
            boolean isBinariesBased = false;
            LoadStrategy parentLoadStrategy = parent.getLoadStrategy();
            try {
                if (parentLoadStrategy instanceof DirectoryArchiveLoadStrategy && this.getBinariesPath().equals(this.getResourcesPath())) {
                    isBinariesBased = true;
                }
            }
            catch (FileNotFoundException e) {
                logger.logp(Level.FINER, className, methodName, "Could not evaluate binaries or resources path");
            }
            CommonarchiveFactoryImpl factory = (CommonarchiveFactoryImpl)CommonarchiveFactory.eINSTANCE;
            newStrategy = factory.createChildLoadStrategy(aUri, parentLoadStrategy, isBinariesBased);
        } else {
            logger.logp(Level.FINER, className, methodName, "No temporary zip file strategy, no loose archive, no parent archive");
            newStrategy = this.getCommonArchiveFactory().createLoadStrategy(aUri);
        }
        return newStrategy;
    }

    protected RuntimeClasspathEntry createRuntimeClasspathEntry(String absolutePath) {
        RuntimeClasspathEntryImpl entry = new RuntimeClasspathEntryImpl();
        entry.setAbsolutePath(absolutePath);
        return entry;
    }

    protected List createRuntimeClasspathEntries(String[] entries, String parentPath) {
        String methodName = "createRuntimeClasspathEntries";
        logger.logp(Level.FINER, className, methodName, "ENTRY parentPath [ {0} ]", parentPath);
        ArrayList<RuntimeClasspathEntry> aList = new ArrayList<RuntimeClasspathEntry>(entries.length);
        for (int entryNo = 0; entryNo < entries.length; ++entryNo) {
            String entry = entries[entryNo];
            logger.logp(Level.FINER, className, methodName, "Entry [ {0} ]", entry);
            Archive archive = this.resolveClasspathEntryInEAR(entry);
            logger.logp(Level.FINER, className, methodName, "Dependent JAR [ {0} ]", archive);
            if (archive != null) {
                try {
                    RuntimeClasspathEntry runEntry;
                    if (archive.isSimpleJavaArchive()) {
                        logger.logp(Level.FINER, className, methodName, "Dependent JAR is a simple archive - forcing expansion");
                        runEntry = archive.forceExpansionAndCreate(entry);
                    } else {
                        runEntry = this.createRuntimeClasspathEntry(archive.getBinariesPath(), entry);
                        logger.logp(Level.FINER, className, methodName, "Dependent JAR is NOT a simple archive.");
                    }
                    if (runEntry == null) continue;
                    runEntry.setReferencedArchive(archive);
                    aList.add(runEntry);
                    continue;
                }
                catch (FileNotFoundException shouldntHappenInRuntime) {
                    logger.logp(Level.FINER, className, methodName, "Ignoring FileNotFoundException for entry [ {0} ]", entry);
                }
            }
            java.io.File aFile = new java.io.File(entry);
            String absPath = null;
            if (aFile.isAbsolute()) {
                absPath = aFile.getAbsolutePath();
            } else {
                absPath = ArchiveUtil.getOSUri(parentPath, entry);
                absPath = ClasspathUtil.normalizePath(absPath);
            }
            aList.add(this.createRuntimeClasspathEntry(absPath, entry));
        }
        if (logger.isLoggable(Level.FINER)) {
            StringBuffer sb = new StringBuffer("RETURN [ ");
            sb.append(aList.size()).append(" elements");
            for (RuntimeClasspathEntryImpl runtimeClasspathEntryImpl : aList) {
                sb.append("\n  ").append(runtimeClasspathEntryImpl);
            }
            logger.logp(Level.FINER, className, methodName, sb.toString());
        }
        return aList;
    }

    protected RuntimeClasspathEntry createRuntimeClasspathEntry(String absolutePath, String manifestValue) {
        String methodName = "createRuntimeClasspathEntry";
        logger.logp(Level.FINER, className, methodName, "Absolute Path [ {0} ]; Manifest Value [ {1} ]", new Object[]{absolutePath, manifestValue});
        RuntimeClasspathEntry entry = this.createRuntimeClasspathEntry(absolutePath);
        entry.setManifestValue(manifestValue);
        return entry;
    }

    protected SaveStrategy createSaveStrategyForDirectory(java.io.File dir, int expansionFlags) {
        return new DirectorySaveStrategyImpl(dir.getAbsolutePath(), expansionFlags);
    }

    protected SaveStrategy createSaveStrategyForDirectory(String aUri, int expansionFlags) {
        return new DirectorySaveStrategyImpl(aUri, expansionFlags);
    }

    protected SaveStrategy createSaveStrategyForJar(java.io.File aFile) throws IOException {
        return this.createSaveStrategyForJar(aFile, false);
    }

    protected SaveStrategy createSaveStrategyForJar(java.io.File aFile, boolean forceIteration) throws IOException {
        if (aFile.exists() && aFile.isDirectory()) {
            throw new IOException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.file_exist_as_dir_EXC_, new Object[]{aFile.getAbsolutePath()}));
        }
        java.io.File parent = aFile.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(aFile);
        return new ZipStreamSaveStrategyImpl(out, forceIteration);
    }

    public void extract() throws SaveFailureException, ReopenException {
        this.extract(126, true);
    }

    public void extract(boolean preserve) throws SaveFailureException, ReopenException {
        this.extract(126, preserve);
    }

    public void extract(int expansionFlags) throws SaveFailureException, ReopenException {
        this.extract(expansionFlags, false);
    }

    public void extract(int expansionFlags, boolean preserve) throws SaveFailureException, ReopenException {
        String methodName = "extract";
        logger.logp(Level.FINER, className, methodName, "ENTRY URI [ {0} ]", this.getURI());
        this.extractNoReopen(expansionFlags, preserve);
        this.reopen();
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public void extractNoReopen() throws SaveFailureException {
        this.extractNoReopen(126, true);
    }

    public void extractNoReopen(int expansionFlags) throws SaveFailureException {
        this.extractNoReopen(expansionFlags, false);
    }

    public void extractNoReopen(boolean preserve) throws SaveFailureException {
        this.extractNoReopen(126, preserve);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractNoReopen(int expansionFlags, boolean preserve) throws SaveFailureException {
        boolean useIntermediate;
        String methodName = "extractNoReopen";
        boolean isFinerEnabled = logger.isLoggable(Level.FINER);
        String destinationUri = this.getURI();
        if (isFinerEnabled) {
            logger.logp(Level.FINER, className, methodName, "ENTER for URI [ {0} ]", destinationUri);
        }
        java.io.File finalDestinationFile = new java.io.File(destinationUri);
        LoadStrategy useLoadStrategy = this.getLoadStrategy();
        boolean isDirectory = useLoadStrategy.isDirectory();
        if (isFinerEnabled) {
            logger.logp(Level.FINER, className, methodName, "Load strategy [ {0} ]", useLoadStrategy);
            logger.logp(Level.FINER, className, methodName, "Is Directory [ {0} ]", new Boolean(isDirectory));
        }
        if (useLoadStrategy.isUsing(finalDestinationFile)) {
            if (!isDirectory) {
                if (this.getOptions().getSaveIncrementally()) {
                    logger.logp(Level.FINER, className, methodName, "Ignoring request for incremental saves for non-directory source.");
                    logger.logp(Level.FINER, className, methodName, "Setting options incremental save setting to false.");
                }
                useIntermediate = true;
                this.getOptions().setSaveIncrementally(false);
            } else {
                boolean bl = useIntermediate = !this.getOptions().getSaveIncrementally();
            }
            if (isFinerEnabled) {
                logger.logp(Level.FINER, className, methodName, "Target file is on disk [ true ]");
                logger.logp(Level.FINER, className, methodName, "Use intermedate file [ {0} ]", new Boolean(useIntermediate));
            }
        } else {
            useIntermediate = false;
            if (isFinerEnabled) {
                logger.logp(Level.FINER, className, methodName, "Target file is on disk [ false ]");
                logger.logp(Level.FINER, className, methodName, "Use intermediate file [ false ]");
            }
            if (this.getOptions().getSaveIncrementally()) {
                this.getOptions().setSaveIncrementally(false);
                if (isFinerEnabled) {
                    logger.logp(Level.FINER, className, methodName, "No intermediate; turning off incremental save");
                }
            }
        }
        try {
            java.io.File intermediateDestinationFile;
            if (useIntermediate) {
                java.io.File parentFile = finalDestinationFile.getCanonicalFile().getParentFile();
                intermediateDestinationFile = !isDirectory && preserve ? ArchiveUtil.createTempFile(destinationUri, parentFile) : ArchiveUtil.createTempDirectory(destinationUri, parentFile);
                if (isFinerEnabled) {
                    logger.logp(Level.FINER, className, methodName, "Using intermediate [ {0} ]", intermediateDestinationFile.getName());
                }
            } else {
                intermediateDestinationFile = finalDestinationFile;
            }
            SaveStrategy saveStrategy = !isDirectory && preserve ? this.createSaveStrategyForJar(intermediateDestinationFile, true) : this.createSaveStrategyForDirectory(intermediateDestinationFile, expansionFlags);
            try {
                this.save(saveStrategy);
            }
            finally {
                saveStrategy.close();
            }
            this.close();
            if (useIntermediate) {
                if (isFinerEnabled) {
                    logger.logp(Level.FINER, className, methodName, "Transferring files from intermediate to final locations");
                }
                this.cleanupAfterTempSave(destinationUri, finalDestinationFile, intermediateDestinationFile);
            }
        }
        catch (IOException ex) {
            SaveFailureException sfe = new SaveFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.error_saving_EXC_, new Object[]{this.uri}), ex);
            logger.throwing(className, methodName, sfe);
            throw sfe;
        }
        if (isFinerEnabled) {
            logger.logp(Level.FINER, className, methodName, "RETURN for URI [ {0} ]", destinationUri);
        }
    }

    public void extractTo(String destinationUri, int expansionFlags) throws SaveFailureException {
        String methodName = "extractTo";
        logger.logp(Level.FINER, className, methodName, "ENTRY URI [ {0} ]", destinationUri);
        java.io.File destinationFile = new java.io.File(destinationUri);
        if (this.getLoadStrategy().isUsing(destinationFile)) {
            throw new SaveFailureException(CommonArchiveResourceHandler.Extract_destination_is_the_EXC_);
        }
        try {
            SaveStrategy aSaveStrategy = this.createSaveStrategyForDirectory(destinationFile, expansionFlags);
            this.save(aSaveStrategy);
            aSaveStrategy.close();
        }
        catch (IOException ex) {
            logger.logp(Level.FINER, className, methodName, "RETURN Throwing SaveFailureException");
            throw new SaveFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.error_saving_EXC_, new Object[]{destinationUri}), ex);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public List filterFilesByPrefix(String prefix) {
        return this.filterFiles(prefix, null, false);
    }

    public List filterFilesByPrefix(String prefix, boolean normalize) {
        return this.filterFiles(prefix, null, normalize);
    }

    public List filterFiles(String prefix, String[] suffixes) {
        return this.filterFiles(prefix, suffixes, false);
    }

    public List filterFiles(String prefix, String[] suffixes, boolean normalize) {
        if (normalize) {
            prefix = ArchiveImpl.normalize(prefix);
        }
        ArrayList<File> subset = new ArrayList<File>();
        EList theFiles = this.getFiles();
        for (int i = 0; i < theFiles.size(); ++i) {
            File aFile = (File)theFiles.get(i);
            if (aFile.isDirectoryEntry()) continue;
            String nextURI = aFile.getURI();
            if (normalize) {
                nextURI = ArchiveImpl.normalize(nextURI);
            }
            if (!nextURI.startsWith(prefix) || suffixes != null && !this.hasSuffix(nextURI, suffixes)) continue;
            subset.add(aFile);
        }
        return subset;
    }

    public static String normalize(String path) {
        if ((path = LooseConfigRegister.normalize(path)).startsWith(java.io.File.separator)) {
            path = path.substring(1);
        }
        return path;
    }

    private boolean hasSuffix(String aUri, String[] suffixes) {
        for (int i = 0; i < suffixes.length; ++i) {
            if (!aUri.endsWith(suffixes[i])) continue;
            return true;
        }
        return false;
    }

    public List filterFilesWithoutPrefix(String[] prefixes) {
        ArrayList<File> subset = new ArrayList<File>();
        EList theFiles = this.getFiles();
        for (int i = 0; i < theFiles.size(); ++i) {
            File aFile = (File)theFiles.get(i);
            if (aFile.isDirectoryEntry()) continue;
            boolean shouldAdd = true;
            for (int j = 0; j < prefixes.length; ++j) {
                if (!aFile.getURI().startsWith(prefixes[j])) continue;
                shouldAdd = false;
                break;
            }
            if (!shouldAdd) continue;
            subset.add(aFile);
        }
        return subset;
    }

    public ClassLoader getArchiveClassLoader() {
        String methodName = "getArchiveClassLoader";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        if (this.archiveClassLoader == null) {
            this.initializeClassLoader();
        }
        logger.logp(Level.FINER, className, methodName, "RETURN archiveClassLoader = [ {0} ]", this.archiveClassLoader);
        return this.archiveClassLoader;
    }

    public List getArchiveFiles() {
        ArrayList<File> archives = new ArrayList<File>();
        EList fileList = this.getFiles();
        for (int i = 0; i < fileList.size(); ++i) {
            File aFile = (File)fileList.get(i);
            if (!aFile.isArchive()) continue;
            archives.add(aFile);
        }
        return archives;
    }

    protected ClassLoader getClassPathClassLoader(ClassLoader parentCl) {
        RuntimeClasspathEntry[] libCp;
        String extraCp;
        String methodName = "getClassPathClassLoader";
        logger.logp(Level.FINER, className, methodName, "ENTRY parent classloader = [ {0} ]", parentCl);
        ArrayList<String> classPathComponents = new ArrayList<String>();
        if (this.getManifest() != null) {
            logger.logp(Level.FINER, className, methodName, "manifest not null, adding its classpath");
            classPathComponents.addAll(Arrays.asList(this.getManifest().getClassPathTokenized()));
        }
        if ((extraCp = this.getExtraClasspath()) != null) {
            logger.logp(Level.FINER, className, methodName, "extra classpath not null, adding its classpath");
            classPathComponents.addAll(Arrays.asList(ArchiveUtil.getTokens(extraCp, ";")));
        }
        if ((libCp = this.getLibraryDirectoryClassPath(null)) != null && libCp.length > 0) {
            logger.logp(Level.FINER, className, methodName, "adding library directory classpath");
            for (int i = 0; i < libCp.length; ++i) {
                RuntimeClasspathEntry pathElement = libCp[i];
                String manifestValue = pathElement.getManifestValue();
                String pathElementLocation = pathElement.getAbsolutePath();
                if (manifestValue != null) {
                    pathElementLocation = pathElementLocation + java.io.File.separator + manifestValue;
                }
                classPathComponents.add(pathElementLocation);
            }
        }
        URL[] urlArray = ArchiveUtil.toLocalURLs(classPathComponents, this.getRootForRelativeDependentJars());
        URLClassLoader cl = new URLClassLoader(urlArray, parentCl);
        if (logger.isLoggable(Level.FINER)) {
            StringBuffer sb = new StringBuffer("Classloader classpath for [ ");
            sb.append(this.getURI()).append(" ] contains [ ").append(urlArray.length).append(" ] URLs\n");
            for (int urlNo = 0; urlNo < urlArray.length; ++urlNo) {
                sb.append("      ").append(urlArray[urlNo]).append("\n");
            }
            logger.logp(Level.FINER, className, methodName, sb.toString());
            logger.logp(Level.FINER, className, methodName, "RETURN classloader = [ {0} ]", cl);
        }
        return cl;
    }

    public ResourceSet getResourceSet() {
        return this.getLoadStrategy().getResourceSet();
    }

    public ClassLoader getParentClassLoader() {
        return this.options != null ? this.options.getParentClassLoader() : null;
    }

    public ClassLoader setParentClassLoader(ClassLoader parentClassLoader) {
        String methodName = "setParentClassLoader";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "Setting parent classloader on [ {0} ] : [ {1} ]", new Object[]{this.getURI(), parentClassLoader});
        }
        if (this.archiveClassLoader != null) {
            StringBuilder stringBuilder = new StringBuilder("setParentClassLoader attempted on archive [ ");
            stringBuilder.append(this.getURI());
            stringBuilder.append(" ]");
            stringBuilder.append(" after the archive classloader was constructed");
            IllegalArgumentException e = new IllegalArgumentException(stringBuilder.toString());
            logger.throwing(className, methodName, e);
            throw e;
        }
        ArchiveOptions useOptions = this.getOptions();
        ClassLoader priorParentClassLoader = useOptions.getParentClassLoader();
        useOptions.setParentClassLoader(parentClassLoader);
        this.setChildParentClassLoader(parentClassLoader);
        logger.logp(Level.FINER, className, methodName, "Prior classloader [ {0} ]", priorParentClassLoader);
        return priorParentClassLoader;
    }

    protected void setChildParentClassLoader(ClassLoader parentClassLoader) {
        for (File nextFile : this.getFiles()) {
            if (!nextFile.isArchive()) continue;
            ClassLoader priorClassloader = ((ArchiveImpl)nextFile).setParentClassLoader(parentClassLoader);
        }
    }

    protected ClassLoader getDefaultClassLoader() {
        String methodName = "getDefaultClassLoader";
        logger.logp(Level.FINER, className, methodName, "ENTRY for [ {0} ]", this.getURI());
        ClassLoader parentClassLoader = this.getOptions().getParentClassLoader();
        if (parentClassLoader != null) {
            logger.logp(Level.FINER, className, methodName, "RETURN with options classloader [ {0} ]", parentClassLoader);
            return parentClassLoader;
        }
        parentClassLoader = this.getClass().getClassLoader();
        if (parentClassLoader != null) {
            logger.logp(Level.FINER, className, methodName, "RETURN with class classloader [ {0} ]", parentClassLoader);
            return parentClassLoader;
        }
        parentClassLoader = ClassLoader.getSystemClassLoader();
        logger.logp(Level.FINER, className, methodName, "RETURN with system classloader [ {0} ]", parentClassLoader);
        return parentClassLoader;
    }

    public Set getDependentOpenArchives() {
        return this.getCommonArchiveFactory().getOpenArchivesDependingOn(this);
    }

    protected List getEntriesAsAbsolutePaths(String[] entries, String parentPath) {
        ArrayList<String> aList = new ArrayList<String>(entries.length);
        for (int i = 0; i < entries.length; ++i) {
            java.io.File aFile;
            String entry = entries[i];
            Archive dependentJar = this.resolveClasspathEntryInEAR(entry);
            if (dependentJar != null) {
                try {
                    aList.add(dependentJar.getAbsolutePath());
                    continue;
                }
                catch (FileNotFoundException shouldntHappenInRuntime) {
                    // empty catch block
                }
            }
            if ((aFile = new java.io.File(entry)).isAbsolute()) {
                aList.add(aFile.getAbsolutePath());
                continue;
            }
            aList.add(ArchiveUtil.getOSUri(parentPath, entry));
        }
        return aList;
    }

    public String getExtraClasspath() {
        return this.extraClasspath;
    }

    public FileIterator getFilesForSave() throws IOException {
        return this.getLoadStrategy().getFileIterator();
    }

    public InputStream primGetInputStream(String uri) throws FileNotFoundException, IOException {
        InputStream result = super.primGetInputStream(uri);
        return result;
    }

    public InputStream getInputStream(String uri) throws FileNotFoundException, IOException {
        InputStream result = super.getInputStream(uri);
        return result;
    }

    public File getFile(String uri) throws FileNotFoundException {
        File result = super.getFile(uri);
        return result;
    }

    public InputStream getInputStream() throws FileNotFoundException, IOException {
        if (this.getLoadingContainer() != null || this.getLoadStrategy() == null || this.getLoadStrategy().isDirectory()) {
            return super.getInputStream();
        }
        if (this.isModuleFile() || !this.getOptions().isSaveLibrariesAsFiles()) {
            throw new IOException("Undefined state of nested archive");
        }
        EList list = this.getFiles();
        String absolutePath = null;
        for (int i = 0; i < list.size(); ++i) {
            File aFile = (File)list.get(i);
            if (aFile.isArchive()) continue;
            absolutePath = aFile.getLoadingContainer().getAbsolutePath();
        }
        return new FileInputStream(absolutePath);
    }

    public InputStream getResourceInputStream(String aUri) throws IOException {
        return this.getLoadStrategy().getResourceInputStream(aUri);
    }

    protected JavaJDKAdapterFactory getJavaAdapterFactory() {
        String methodName = "getJavaAdapterFactory";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        JavaJDKAdapterFactory adapterFactory = null;
        LoadStrategy ls = this.getLoadStrategy();
        if (ls == null) {
            logger.logp(Level.FINER, className, methodName, "RETURN null.  LoadStrategy not found");
            return null;
        }
        logger.logp(Level.FINER, className, methodName, "LoadStrategy found [ {0} ]", ls);
        ResourceSet rs = ls.getResourceSet();
        if (rs == null) {
            logger.logp(Level.FINER, className, methodName, "RETURN null.  ResourceSet not found");
            return null;
        }
        logger.logp(Level.FINER, className, methodName, "ResourceSet found [ {0} ]", rs);
        EList factories = rs.getAdapterFactories();
        logger.logp(Level.FINER, className, methodName, "AdapterFactories found [ {0} ]", factories);
        adapterFactory = (JavaJDKAdapterFactory)EcoreUtil.getAdapterFactory(factories, "JavaReflection");
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", adapterFactory);
        return adapterFactory;
    }

    public Collection getLoadedMofResources() {
        return this.getLoadStrategy().getLoadedMofResources();
    }

    public ArchiveManifest getManifest() {
        String methodName;
        block22: {
            methodName = "getManifest";
            logger.logp(Level.FINER, className, methodName, "ENTRY archive [ {0} ]", this.getURI());
            if (this.manifest == null) {
                InputStream in = null;
                try {
                    in = this.getInputStream("META-INF/MANIFEST.MF");
                    this.makeManifest(in);
                    StringBuffer sb = new StringBuffer("Archive ").append(this.getURI()).append(" manifest contents:");
                    sb.append("\nManifest object [ ").append(this.manifest).append(" ]");
                    if (this.manifest != null) {
                        sb.append("\n  Version       [ ").append(this.manifest.getManifestVersion()).append(" ]");
                        sb.append("\n  Classpath     [ ").append(this.manifest.getClassPath()).append(" ]");
                    }
                    logger.logp(Level.FINER, className, methodName, sb.toString());
                }
                catch (FileNotFoundException ex) {
                    this.makeManifest();
                }
                catch (Resource.IOWrappedException ex) {
                    WrappedException wrapEx = new WrappedException(ex.getWrappedException());
                    if (ExtendedEcoreUtil.getFileNotFoundDetector().isFileNotFound(wrapEx)) {
                        this.makeManifest();
                        break block22;
                    }
                    throw new ManifestException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.io_ex_manifest_EXC_, new Object[]{this.getURI()}), ex);
                }
                catch (IOException ex) {
                    throw new ManifestException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.io_ex_manifest_EXC_, new Object[]{this.getURI()}), ex);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iox) {}
                    }
                    this.closeArchiveZipFile();
                }
            }
        }
        if (this.manifest.getManifestVersion() == null || this.manifest.getManifestVersion().equals("")) {
            this.manifest.setManifestVersion("1.0");
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", this.manifest);
        return this.manifest;
    }

    public Resource getMofResource(String aUri) throws FileNotFoundException, ResourceLoadException {
        return this.getLoadStrategy().getMofResource(aUri);
    }

    protected Resource getMofResourceMakeIfNecessary(String aUri) {
        if (this.getLoadStrategy() == null) {
            return null;
        }
        Resource resource = null;
        try {
            resource = this.getMofResource(aUri);
        }
        catch (FileNotFoundException ex) {
            try {
                resource = this.makeMofResource(aUri);
            }
            catch (DuplicateObjectException dox) {
                // empty catch block
            }
        }
        return resource;
    }

    public ArchiveOptions getOptions() {
        if (this.options == null) {
            this.options = new ArchiveOptions();
        }
        return this.options;
    }

    public ProtectionDomain getProtectionDomain() {
        return this.options == null ? null : this.options.getProtectionDomain();
    }

    public ProtectionDomain setProtectionDomain(ProtectionDomain protectionDomain) {
        ArchiveOptions useOptions = this.getOptions();
        ProtectionDomain priorProtectionDomain = useOptions.getProtectionDomain();
        useOptions.setProtectionDomain(protectionDomain);
        this.setChildProtectionDomains(protectionDomain);
        this.setClassLoaderProtectionDomain(protectionDomain);
        return priorProtectionDomain;
    }

    protected void setChildProtectionDomains(ProtectionDomain protectionDomain) {
        String methodName = "setChildProtectionDomains";
        logger.logp(Level.FINER, className, methodName, "ENTRY protectionDomain [ {0} ]", protectionDomain);
        for (File nextFile : this.getFiles()) {
            logger.logp(Level.FINER, className, methodName, "archive file [ {0} ]", nextFile.getURI());
            if (!nextFile.isArchive()) continue;
            ProtectionDomain childProtectionDomain = ((ArchiveImpl)nextFile).setProtectionDomain(protectionDomain);
            logger.logp(Level.FINER, className, methodName, "Set child protectionDomain [ {0} ]", childProtectionDomain);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    protected void setClassLoaderProtectionDomain(ProtectionDomain protectionDomain) {
        if (this.archiveClassLoader != null && this.archiveClassLoader instanceof ArchiveFileDynamicClassLoader) {
            ArchiveFileDynamicClassLoader useClassLoader = (ArchiveFileDynamicClassLoader)this.archiveClassLoader;
            useClassLoader.setProtectionDomain(protectionDomain);
        }
    }

    public String getRootForRelativeDependentJars() {
        String methodName = "getRootForRelativeDependentJars";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        String path = null;
        for (Container theContainer = this; theContainer != null && path == null; theContainer = theContainer.getLoadingContainer()) {
            logger.logp(Level.FINER, className, methodName, "Get absolute path of container [ {0} ]", theContainer);
            try {
                path = theContainer.getAbsolutePath();
                continue;
            }
            catch (FileNotFoundException ex) {
                logger.logp(Level.FINER, className, methodName, "Ignoring FileNotFoundException while resolving absolute path");
            }
        }
        logger.logp(Level.FINER, className, methodName, "Path [ {0} ]", path);
        if (path == null) {
            logger.logp(Level.FINER, className, methodName, "No path found, look in system property user.dir");
            path = System.getProperty("user.dir");
            if (path == null) {
                logger.logp(Level.FINER, className, methodName, "No path found, returning null");
                return "";
            }
            String root = new java.io.File(path).getAbsolutePath();
            logger.logp(Level.FINER, className, methodName, "RETURN absolute path specified by system property [ {0} ]", root);
            return root;
        }
        String root = new java.io.File(path).getParentFile().getAbsolutePath();
        logger.logp(Level.FINER, className, methodName, "RETURN absolute path of parent file [ {0} ]", root);
        return root;
    }

    public String[] getRuntimeClassPath() {
        String methodName = "getRuntimeClassPath";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        String absolutePath = this.internalGetBinariesPath();
        if (absolutePath == null) {
            return new String[0];
        }
        ArrayList<String> entries = new ArrayList<String>();
        entries.add(absolutePath);
        String parentPath = this.getParentPath(absolutePath);
        String[] mfEntries = this.getManifest().getClassPathTokenized();
        entries.addAll(this.getEntriesAsAbsolutePaths(mfEntries, parentPath));
        if (logger.isLoggable(Level.FINER)) {
            StringBuffer sb = new StringBuffer("RETURN [ ");
            sb.append(entries.size()).append(" elements");
            for (String pathElement : entries) {
                sb.append("\n  ").append(pathElement);
            }
            logger.logp(Level.FINER, className, methodName, sb.toString());
        }
        return entries.toArray(new String[entries.size()]);
    }

    public SaveFilter getSaveFilter() {
        return this.saveFilter;
    }

    public SaveStrategy getSaveStrategy() {
        return this.saveStrategy;
    }

    public String getXmlEncoding() {
        return this.xmlEncoding;
    }

    public void initializeAfterOpen() {
    }

    public void initializeClassLoader() {
        String methodName = "initializeClassLoader";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ]", this.getURI());
        if (!this.shouldUseJavaReflection()) {
            logger.logp(Level.FINER, className, methodName, "RETURN - no reflection, so class loader not necessary");
            return;
        }
        ClassLoader extraCl = null;
        ClassLoader defaultCl = this.getDefaultClassLoader();
        extraCl = this.getClassPathClassLoader(defaultCl);
        ClassLoader cl = this.createDynamicClassLoader(defaultCl, extraCl);
        this.setArchiveClassLoader(cl);
        JavaJDKAdapterFactory factory = this.getJavaAdapterFactory();
        if (factory != null) {
            factory.flushAll();
        } else {
            logger.logp(Level.FINER, className, methodName, "Java Adapter Factory was null");
        }
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public ClassLoader createDynamicClassLoader(ClassLoader parentCl, ClassLoader extraCl) {
        return new ArchiveFileDynamicClassLoader(this, parentCl, extraCl, this.getProtectionDomain());
    }

    public boolean isArchive() {
        return true;
    }

    public boolean isDuplicate(String aUri) {
        return this.containsFile(aUri) || this.isMofResourceLoaded(aUri) || "META-INF/MANIFEST.MF".equals(aUri);
    }

    public boolean isManifestSet() {
        return this.manifest != null;
    }

    public boolean isMofResourceLoaded(String aUri) {
        return this.getLoadStrategy().isMofResourceLoaded(aUri);
    }

    public boolean isNestedArchive(String aUri) {
        String methodName = "isNestedArchive";
        logger.logp(Level.FINER, className, methodName, "ENTRY URI [ {0} ]", aUri);
        if (this.getLoadStrategy().isDirectory()) {
            try {
                String path = ArchiveUtil.getOSUri(this.getAbsolutePath(), aUri);
                java.io.File ioFile = new java.io.File(path);
                if (!ioFile.exists() || ioFile.isDirectory() && aUri.startsWith("ALT-INF")) {
                    logger.logp(Level.FINER, className, methodName, "RETURN [ false ] - path does not exist [ {0} ] ", path);
                    return false;
                }
            }
            catch (IOException ex) {
                logger.logp(Level.FINER, className, methodName, "RETURN [ false ] - caught IOException");
                return false;
            }
        }
        boolean result = ArchiveTypeDiscriminatorRegistry.INSTANCE.isKnownArchiveType(aUri);
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", result);
        return result;
    }

    public boolean isOpen() {
        return this.getLoadStrategy() != null && this.getLoadStrategy().isOpen();
    }

    public ArchiveManifest makeManifest() {
        ArchiveManifestImpl mf = new ArchiveManifestImpl();
        this.setManifest(mf);
        return mf;
    }

    public ArchiveManifest makeManifest(InputStream in) throws IOException {
        ArchiveManifestImpl mf = new ArchiveManifestImpl(in);
        this.setManifest(mf);
        return mf;
    }

    public Resource makeMofResource(String aUri) throws DuplicateObjectException {
        return this.makeMofResource(aUri, null);
    }

    public Resource makeMofResource(String aUri, EList extent) throws DuplicateObjectException {
        if (this.isDuplicate(aUri)) {
            throw new DuplicateObjectException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.duplicate_entry_EXC_, new Object[]{aUri, this.getURI()}));
        }
        return this.getLoadStrategy().makeMofResource(aUri, extent);
    }

    public Archive openNestedArchive(String aUri) throws OpenFailureException {
        String methodName = "openNestedArchive - URI";
        logger.logp(Level.FINER, className, methodName, "ENTRY - URI [ {0} ]", aUri);
        Archive a = this.getCommonArchiveFactory().openNestedArchive(aUri, (Archive)this);
        logger.logp(Level.FINER, className, methodName, "RETURN Factory opened archive [ {0} ]", a);
        return a;
    }

    public Archive openNestedArchive(LooseArchive loose) throws OpenFailureException {
        String methodName = "openNestedArchive - loose";
        String looseArchiveURI = loose.getUri();
        logger.logp(Level.FINER, className, methodName, "ENTRY - loose archive URI [ {0} ]", looseArchiveURI);
        Archive a = this.getCommonArchiveFactory().openNestedArchive(loose, (Archive)this);
        logger.logp(Level.FINER, className, methodName, "RETURN Factory opened archive [ {0} ]", a);
        return a;
    }

    public void primSetExtraClasspath(String newExtraClasspath) {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, "primSetExtraClasspath", "EVENT Archive [ {0} ] Old [ {1} ] New [ {2} ]", new Object[]{this, this.extraClasspath, newExtraClasspath});
        }
        this.extraClasspath = newExtraClasspath;
    }

    public void releaseClassLoader() {
        if (this.archiveClassLoader != null) {
            this.setArchiveClassLoader(null);
            JavaJDKAdapterFactory factory = this.getJavaAdapterFactory();
            if (factory != null) {
                this.getJavaAdapterFactory().setContextClassLoader(null);
            }
        }
    }

    public void remove(File aFile) {
        this.getFiles().remove(aFile);
    }

    public void reopen() throws ReopenException {
        String methodName = "reopen";
        logger.logp(Level.FINER, className, methodName, "ENTER [ {0} ]", this.getURI());
        Container useContainer = this.getContainer();
        if (useContainer != null && !useContainer.isArchive()) {
            logger.logp(Level.FINER, className, methodName, "Ignoring non-archive container [ {0} ]", useContainer);
            useContainer = null;
        }
        this.reopen((Archive)useContainer);
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public void reopen(Archive parent) throws ReopenException {
        LoadStrategy aLoadStrategy;
        String methodName = "reopen(Archive)";
        if (logger.isLoggable(Level.FINER)) {
            String parentUri = parent == null ? null : parent.getURI();
            logger.logp(Level.FINER, className, methodName, "ENTRY URI [ {0} ] Parent [ {1} ]", new Object[]{this.getURI(), parentUri});
        }
        try {
            aLoadStrategy = this.createLoadStrategyForReopen(parent);
        }
        catch (IOException ex) {
            throw new ReopenException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.io_ex_reopen_EXC_, new Object[]{this.getURI()}), ex);
        }
        LoadStrategy current = this.getLoadStrategy();
        if (current != null) {
            aLoadStrategy.setResourceSet(current.primGetResourceSet());
            current.setResourceSet(null);
        }
        this.setLoadStrategy(aLoadStrategy);
        this.archiveClassLoader = null;
        if (!this.isIndexed()) {
            logger.logp(Level.FINER, className, methodName, "RETURN - Not indexed");
            return;
        }
        logger.logp(Level.FINER, className, methodName, "Updating (and reopening) child files");
        EList fileList = this.getFiles();
        for (int i = 0; i < fileList.size(); ++i) {
            File f = (File)fileList.get(i);
            f.setOriginalURI(f.getURI());
            f.setLoadingContainer(this);
            if (!f.isArchive()) continue;
            ((Archive)f).reopen(this);
        }
        this.getCommonArchiveFactory().archiveOpened(this);
        logger.logp(Level.FINER, className, methodName, "RETURN - Indexed case");
    }

    protected void replaceRoot(Resource aResource, EObject root) {
        if (aResource == null) {
            return;
        }
        EList extent = aResource.getContents();
        EObject existingRoot = null;
        if (!extent.isEmpty()) {
            existingRoot = (EObject)extent.get(0);
            if (existingRoot == root) {
                return;
            }
            extent.remove(0);
        }
        if (root != null) {
            extent.add(0, root);
        }
    }

    protected Archive resolveClasspathEntryInEAR(String entry) {
        String methodName = "resolveClasspathEntryInEAR";
        logger.logp(Level.FINER, className, methodName, "ENTRY: Resolving entry [ {0} ]", entry);
        Container parent = this.getContainer();
        if (parent == null || !parent.isEARFile()) {
            logger.logp(Level.FINER, className, methodName, "RETURN: Null or non-ear parent: [ null ]");
            return null;
        }
        String aUri = ArchiveUtil.deriveEARRelativeURI(entry, this);
        if (aUri == null) {
            logger.logp(Level.FINER, className, methodName, "RETURN: Null EAR relative URI: [ null ]");
            return null;
        }
        logger.logp(Level.FINER, className, methodName, "EAR relative URI: [ {0} ]", aUri);
        File aFile = null;
        try {
            aFile = parent.getFile(aUri);
            logger.logp(Level.FINER, className, methodName, "Located entry as file in parent archive.");
        }
        catch (FileNotFoundException ex) {
            logger.logp(Level.FINER, className, methodName, "RETURN: Failed to locate entry in parent archive: [ null ]");
            return null;
        }
        if (!aFile.isArchive()) {
            logger.logp(Level.FINER, className, methodName, "RETURN: Target file is not an archive: [ null ]");
            return null;
        }
        logger.logp(Level.FINER, className, methodName, "RETURN: Target file is an archive: [ {0} ]", aFile);
        return (Archive)aFile;
    }

    public void save() throws SaveFailureException, ReopenException {
        String methodName = "save";
        String uri = this.getURI();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTER URI [ {0} ] Archive [ {1} ] Strategy [ {2} ]", new Object[]{uri, this, this.getLoadStrategy()});
        }
        this.saveAs(uri);
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    protected SaveFilter pushSaveFilter(SaveStrategy aSaveStrategy) {
        String methodName = "pushSaveFilter";
        SaveFilter priorFilter = aSaveStrategy.getFilter();
        SaveFilter newFilter = this.getSaveFilter();
        if (newFilter != null) {
            if (priorFilter != null && !priorFilter.getClass().equals(SaveStrategyImpl.class)) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, className, methodName, "Using AND of filters: [ {0} ] and [ {1} ]", new Object[]{priorFilter, newFilter});
                }
                newFilter = new AndSaveFilter(priorFilter, newFilter);
            }
            aSaveStrategy.setFilter(newFilter);
        }
        return priorFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(SaveStrategy aStrategy) throws SaveFailureException {
        String methodName = "save";
        logger.logp(Level.FINER, className, methodName, "ENTRY SaveStrategy = [ {0} ]", aStrategy);
        this.setSaveStrategy(aStrategy);
        boolean oldDelivery = this.eDeliver();
        boolean isReadOnly = this.getOptions().isReadOnly();
        if (isReadOnly) {
            logger.logp(Level.FINER, className, methodName, "isReadOnly [ {0} ]", Boolean.toString(isReadOnly));
            this.eSetDeliver(false);
        }
        SaveFilter existingFilter = this.pushSaveFilter(aStrategy);
        try {
            aStrategy.save();
            try {
                aStrategy.finish();
            }
            catch (IOException iox) {
                logger.logp(Level.FINER, className, methodName, "RETURN Throwing SaveFailureException [ {0} ]", this.getURI());
                throw new SaveFailureException(this.getURI(), iox);
            }
        }
        finally {
            this.setSaveStrategy(null);
            aStrategy.setFilter(existingFilter);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public void saveAs(String aUri) throws SaveFailureException, ReopenException {
        String methodName = "saveAs";
        logger.logp(Level.FINER, className, methodName, "ENTER Current URI [ {0} ] Save URI [ {1} ]", new Object[]{this.getURI(), aUri});
        this.saveAsNoReopen(aUri);
        this.reopen();
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    protected boolean canRename(java.io.File orig) {
        String methodName = "canRename";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ]", orig);
        boolean canRename = false;
        java.io.File origCopy1 = null;
        java.io.File origCopy2 = null;
        try {
            origCopy1 = orig.getCanonicalFile();
            origCopy2 = orig.getCanonicalFile();
        }
        catch (IOException ex) {
            logger.logp(Level.FINEST, className, methodName, ex.getMessage());
            logger.logp(Level.FINER, className, methodName, "Ignoring IOException - Could not get canonicalFile for [ {0} ]", orig);
            return false;
        }
        String name = null;
        String baseName = "save.tmp";
        String parent = orig.getParent();
        if (parent != null) {
            try {
                baseName = new java.io.File(parent, baseName).getCanonicalPath();
            }
            catch (IOException ex) {
                logger.logp(Level.FINEST, className, methodName, ex.getMessage());
                logger.logp(Level.FINER, className, methodName, "Ignoring IOException - Could not get canonical path for parent [ {0} ]", parent);
                return false;
            }
        }
        java.io.File temp = null;
        int index = 0;
        do {
            name = baseName + index;
            temp = new java.io.File(name);
            ++index;
        } while (temp.exists());
        if (this.renameToWithRetry(origCopy1, temp) && this.renameToWithRetry(temp, origCopy2)) {
            canRename = true;
        }
        logger.logp(Level.FINER, className, methodName, "RETURN[ {0} ]", Boolean.toString(canRename));
        return canRename;
    }

    protected void checkWriteable(java.io.File dest) throws SaveFailureException {
        List locked = ArchiveUtil.getWriteProtectedFiles(dest, null);
        if (locked.isEmpty()) {
            return;
        }
        StringBuffer msg = new StringBuffer();
        msg.append("Cannot write to file: ");
        msg.append(dest.getAbsolutePath());
        msg.append('\n');
        msg.append("One or more files is write protected or locked:");
        msg.append('\n');
        for (int i = 0; i < locked.size(); ++i) {
            java.io.File aFile = (java.io.File)locked.get(i);
            msg.append(aFile.getAbsolutePath());
            msg.append('\n');
        }
        SaveFailureException sfe = new SaveFailureException(msg.toString());
        logger.throwing(className, "checkWritable", sfe);
        throw sfe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAsNoReopen(String aUri) throws SaveFailureException {
        java.io.File intermediateTargetFile;
        String methodName = "saveAsNoReopen";
        boolean isFinerEnabled = logger.isLoggable(Level.FINER);
        String currentUri = this.getURI();
        if (isFinerEnabled) {
            logger.logp(Level.FINER, className, methodName, "ENTER Current URI [ {0} ] Save URI [ {1} ] Archive [ {2} ] Strategy [ {3} ]", new Object[]{currentUri, this.uri, this, this.getLoadStrategy()});
        }
        java.io.File finalTargetFile = new java.io.File(aUri);
        this.checkWriteable(finalTargetFile);
        boolean fileExisted = finalTargetFile.exists();
        if (fileExisted) {
            logger.logp(Level.FINER, className, methodName, "Target exists: Save first to intermediate target file");
            try {
                intermediateTargetFile = ArchiveUtil.createTempFile(aUri, finalTargetFile.getCanonicalFile().getParentFile());
            }
            catch (IOException e) {
                String message = "Failed to create temporary file for [ " + aUri + " ]";
                logger.logp(Level.SEVERE, className, methodName, message);
                SaveFailureException sfe = new SaveFailureException(message, e);
                logger.throwing(className, methodName, sfe);
                throw sfe;
            }
            if (isFinerEnabled) {
                logger.logp(Level.FINER, className, methodName, "Using intermediate target [ {0} ]", intermediateTargetFile);
            }
        } else {
            if (isFinerEnabled) {
                logger.logp(Level.FINER, className, methodName, "Target does not exist: Save directly to target file");
            }
            intermediateTargetFile = finalTargetFile;
        }
        try {
            SaveStrategy saveStrategy;
            try {
                saveStrategy = this.createSaveStrategyForJar(intermediateTargetFile);
            }
            catch (IOException e) {
                String message = "Failed to create save strategy for [ " + aUri + " ]";
                logger.logp(Level.SEVERE, className, methodName, message);
                SaveFailureException sfe = new SaveFailureException(message, e);
                logger.throwing(className, methodName, sfe);
                throw sfe;
            }
            try {
                this.save(saveStrategy);
            }
            finally {
                try {
                    saveStrategy.close();
                }
                catch (IOException e) {
                    String message = "Failed to close save strategy for [ " + aUri + " ]";
                    logger.logp(Level.SEVERE, className, methodName, message);
                    SaveFailureException sfe = new SaveFailureException(message, e);
                    logger.throwing(className, methodName, sfe);
                    throw sfe;
                }
            }
            this.close();
            if (fileExisted) {
                if (isFinerEnabled) {
                    logger.logp(Level.FINER, className, methodName, "Transferring files from intermediate to final locations");
                }
                this.cleanupAfterTempSave(aUri, finalTargetFile, intermediateTargetFile);
            }
        }
        finally {
            if (fileExisted) {
                intermediateTargetFile.delete();
            }
        }
        if (!currentUri.equals(aUri)) {
            logger.logp(Level.FINER, className, methodName, "Now updating URI from [ {0} ] to [ {1} ]", new Object[]{currentUri, aUri});
            this.setURI(aUri);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public void saveNoReopen() throws SaveFailureException {
        this.saveAsNoReopen(this.getURI());
    }

    public void setArchiveClassLoader(ClassLoader newArchiveClassLoader) {
        this.archiveClassLoader = newArchiveClassLoader;
    }

    public void setExtraClasspath(String newExtraClasspath) {
        this.primSetExtraClasspath(newExtraClasspath);
    }

    public void setManifest(ArchiveManifest newManifest) {
        this.manifest = newManifest;
    }

    public void setManifest(Manifest aManifest) {
        this.setManifest(new ArchiveManifestImpl(aManifest));
    }

    public void setManifestClassPathAndRefresh(String classpath) {
        ArchiveManifest mf = this.getManifest();
        if (this.manifest == null) {
            this.makeManifest();
        }
        mf.setClassPath(classpath);
    }

    public void setOptions(ArchiveOptions newOptions) {
        this.options = newOptions;
    }

    public void setSaveFilter(SaveFilter newSaveFilter) {
        this.saveFilter = newSaveFilter;
    }

    public void setSaveStrategy(SaveStrategy newSaveStrategy) {
        this.saveStrategy = newSaveStrategy;
        if (newSaveStrategy != null) {
            newSaveStrategy.setArchive(this);
        }
    }

    public void setXmlEncoding(String newXmlEncoding) {
        this.xmlEncoding = newXmlEncoding;
    }

    public boolean shouldUseJavaReflection() {
        return this.getOptions().useJavaReflection() && this.getLoadStrategy().isClassLoaderNeeded();
    }

    protected void throwResourceLoadException(String resourceUri, Exception ex) throws ResourceLoadException {
        throw new ResourceLoadException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.load_resource_EXC_, new Object[]{resourceUri, this.getURI()}), ex);
    }

    public String getResourcesPath() throws FileNotFoundException {
        return this.getLoadStrategy().getResourcesPath();
    }

    protected void clearBinariesPath() {
        this._binariesPathCached = false;
        this._binariesPath = null;
    }

    public String getBinariesPath() throws FileNotFoundException {
        String altBinariesPath;
        ArchiveOptions ao;
        String methodName = "getBinariesPath";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ]", this.uri);
        if (this._binariesPathCached) {
            logger.logp(Level.FINER, className, methodName, "RETURN cached binaries path [ {0} ]", this._binariesPath);
            return this._binariesPath;
        }
        LoadStrategy ls = this.getLoadStrategy();
        String path = ls.getBinariesPath();
        if (!(ls instanceof TempZipFileLoadStrategyImpl) && (ao = this.getOptions()).isSetAltBinariesPath() && (altBinariesPath = ao.getAltBinariesPath()) != null) {
            path = this.isEARFile() ? altBinariesPath : altBinariesPath + java.io.File.separator + this.getURI();
            logger.logp(Level.FINER, className, methodName, "Replacing binariesPath [ {0} ] with altBinariesPath in archiveOptions", path);
        }
        this._binariesPath = path;
        this._binariesPathCached = true;
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ] for Archive [ {1} ]", new Object[]{path, this.getURI()});
        return path;
    }

    protected RuntimeClasspathEntry[] emptyClasspath() {
        return new RuntimeClasspathEntry[0];
    }

    protected String internalGetBinariesPath() {
        try {
            return this.getBinariesPath();
        }
        catch (FileNotFoundException ex) {
            return null;
        }
    }

    public RuntimeClasspathEntry[] getLocalRuntimeClassPath() {
        String methodName = "getLocalRuntimeClassPath";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        String absolutePath = this.internalGetBinariesPath();
        logger.logp(Level.FINER, className, methodName, "internalGetBinariesPath = [ {0} ]", absolutePath);
        if (absolutePath == null) {
            logger.logp(Level.FINER, className, methodName, "RETURN empty classpath");
            return this.emptyClasspath();
        }
        RuntimeClasspathEntry[] rceArray = new RuntimeClasspathEntry[]{this.createRuntimeClasspathEntry(absolutePath)};
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ] elements", Integer.toString(rceArray.length));
        return rceArray;
    }

    protected String getParentPath(String absolutePath) {
        String methodName = "getParentPath";
        logger.logp(Level.FINER, className, methodName, "ENTRY absolutePath = [ {0} ]", absolutePath);
        Container parentArchive = this.getContainer();
        if (this.getLoadStrategy().getLooseArchive() != null && parentArchive != null && parentArchive.isEARFile()) {
            try {
                logger.logp(Level.FINER, className, methodName, "Non-assigned loose archive with EAR parent");
                String earPath = this.getEARFile().getBinariesPath();
                logger.logp(Level.FINER, className, methodName, "EAR file binaries path = [ {0} ]", earPath);
                java.io.File virtualChildFile = new java.io.File(earPath, this.getURI());
                String parentPath = virtualChildFile.getParentFile().getAbsolutePath();
                logger.logp(Level.FINER, className, methodName, "RETURN Virtual parent path [ {0} ]", parentPath);
                return parentPath;
            }
            catch (Throwable e) {
                logger.logp(Level.FINER, className, methodName, "Ignoring Exception while calculating parent path");
            }
        }
        java.io.File parentFile = new java.io.File(absolutePath).getParentFile();
        logger.logp(Level.FINER, className, methodName, "Using absolute path of parent file named [ {0} ]", parentFile.getName());
        String parentPath = parentFile.getAbsolutePath();
        logger.logp(Level.FINER, className, methodName, "RETURN absolute parent path [ {0} ]", parentPath);
        return parentPath;
    }

    protected RuntimeClasspathEntry[] getDependencyClassPathAtThisLevel() {
        String methodName = "getDependencyClassPathAtThisLevel";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        String absolutePath = this.internalGetBinariesPath();
        if (absolutePath == null) {
            logger.logp(Level.FINER, className, methodName, "RETURN empty classpath because binaries path not found");
            return this.emptyClasspath();
        }
        String[] mfEntries = this.getManifest().getClassPathTokenized();
        if (mfEntries.length == 0) {
            logger.logp(Level.FINER, className, methodName, "RETURN empty classpath because manifest entries not found");
            return this.emptyClasspath();
        }
        String parentPath = this.getParentPath(absolutePath);
        ArrayList entries = new ArrayList();
        entries.addAll(this.createRuntimeClasspathEntries(mfEntries, parentPath));
        if (logger.isLoggable(Level.FINER)) {
            int size = entries.size();
            StringBuffer sb = new StringBuffer("Dependency classpath at this level for [ ");
            sb.append(this.getURI()).append(" ] contains [ ").append(size).append(" ] URLs\n");
            for (RuntimeClasspathEntryImpl pathElement : entries) {
                sb.append("  ").append(pathElement).append("\n");
            }
            logger.logp(Level.FINER, className, methodName, sb.toString());
            logger.logp(Level.FINER, className, methodName, "RETURN");
        }
        return entries.toArray(new RuntimeClasspathEntry[entries.size()]);
    }

    public RuntimeClasspathEntry[] getFullRuntimeClassPath() {
        String methodName = "getFullRuntimeClassPath";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        RuntimeClasspathEntry[] rceArray = this.concat(this.getLocalRuntimeClassPath(), this.getDependencyClassPath());
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ] elements", Integer.toString(rceArray.length));
        if (logger.isLoggable(Level.FINEST)) {
            String msg = "Classpath :";
            for (int i = 0; i < rceArray.length; ++i) {
                RuntimeClasspathEntry pathElement = rceArray[i];
                msg = msg + "\n  " + pathElement;
            }
            logger.logp(Level.FINER, className, methodName, msg);
        }
        return rceArray;
    }

    protected RuntimeClasspathEntry[] concat(RuntimeClasspathEntry[] array1, RuntimeClasspathEntry[] array2) {
        ArrayList<RuntimeClasspathEntry> temp = new ArrayList<RuntimeClasspathEntry>();
        temp.addAll(Arrays.asList(array1));
        temp.addAll(Arrays.asList(array2));
        return temp.toArray(new RuntimeClasspathEntry[temp.size()]);
    }

    public RuntimeClasspathEntry[] getDependencyClassPath() {
        String methodName = "getDependencyClassPath";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ]", this.getURI());
        ArrayList entries = new ArrayList();
        HashSet<ArchiveImpl> visited = new HashSet<ArchiveImpl>();
        HashSet processedEntries = new HashSet();
        visited.add(this);
        this.getDependencyClassPath(visited, entries, processedEntries, this);
        RuntimeClasspathEntry[] depEntries = entries.toArray(new RuntimeClasspathEntry[entries.size()]);
        RuntimeClasspathEntry[] libEntries = this.getLibraryDirectoryClassPath(null);
        RuntimeClasspathEntry[] rceArray = this.concat(libEntries, depEntries);
        if (logger.isLoggable(Level.FINER)) {
            int size = rceArray.length;
            StringBuffer sb = new StringBuffer("Dependency classpath for [ ");
            sb.append(this.getURI()).append(" ] contains [ ").append(size).append(" ] URLs\n");
            for (int i = 0; i < rceArray.length; ++i) {
                RuntimeClasspathEntry pathElement = rceArray[i];
                sb.append("  ").append(pathElement).append("\n");
            }
            logger.logp(Level.FINER, className, methodName, sb.toString());
            logger.logp(Level.FINER, className, methodName, "RETURN");
        }
        return rceArray;
    }

    public RuntimeClasspathEntry[] getLibraryDirectoryClassPath(Application appDDOverride) {
        EARFile earFile;
        String methodName = "getLibraryDirectoryClassPath";
        logger.logp(Level.FINER, className, methodName, "ENTRY appDDOverride [ {0} ]", appDDOverride);
        boolean openedEAR = false;
        if (this instanceof EARFile) {
            earFile = (EARFile)((Object)this);
            logger.logp(Level.FINER, className, methodName, "Getting library directory for EAR file");
        } else {
            logger.logp(Level.FINER, className, methodName, "Getting library directory for module file");
            earFile = this.getEARFile();
            logger.logp(Level.FINER, className, methodName, "EAR file for module [ {0} ]", earFile);
            if (earFile == null) {
                try {
                    logger.logp(Level.FINER, className, methodName, "Open EAR for module file");
                    String earPath = this.getOptions().getParentEarBinariesPath();
                    if (earPath == null) {
                        earPath = this.getParentPath(this.getAbsolutePath());
                    }
                    earFile = CommonarchiveFactory.eINSTANCE.openEARFile(earPath);
                    openedEAR = true;
                }
                catch (OpenFailureException e) {
                    logger.logp(Level.FINER, className, methodName, "RETURN empty array - could not open EAR File for module [ {0} ]", this.getURI());
                    return new RuntimeClasspathEntry[0];
                }
                catch (FileNotFoundException e) {
                    logger.logp(Level.FINER, className, methodName, "RETURN empty array - could not find EAR's absolute path");
                    return new RuntimeClasspathEntry[0];
                }
            }
        }
        logger.logp(Level.FINER, className, methodName, "Parent EAR [ {0} ]", earFile.getName());
        String lib = earFile.getLibraryDirectoryName();
        if (lib == null) {
            logger.logp(Level.FINER, className, methodName, "Null library directory; answering empty array");
            logger.logp(Level.FINER, className, methodName, "RETURN [ [] ]");
            if (openedEAR) {
                earFile.close();
            }
            return new RuntimeClasspathEntry[0];
        }
        ArrayList<File> jars = new ArrayList<File>();
        List archiveFilesList = earFile.getArchiveFiles();
        for (File file : archiveFilesList) {
            String earRelativePath = file.getURI();
            if (!earRelativePath.startsWith(lib) || !earRelativePath.endsWith(".jar")) continue;
            jars.add(file);
            logger.logp(Level.FINER, className, methodName, "Selected java archive [ {0} ]", earRelativePath);
        }
        int numLibDirJARs = jars.size();
        RuntimeClasspathEntry[] rce = new RuntimeClasspathEntry[numLibDirJARs];
        Iterator libjarsIterator = jars.iterator();
        int i = 0;
        while (libjarsIterator.hasNext()) {
            RuntimeClasspathEntry entry;
            ArchiveImpl a = (ArchiveImpl)libjarsIterator.next();
            rce[i] = entry = a.forceExpansionAndCreate(null);
            ++i;
        }
        if (openedEAR) {
            earFile.close();
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ] elements", String.valueOf(numLibDirJARs));
        return rce;
    }

    protected void getDependencyClassPath(Set visitedArchives, List entries, Set processedEntries, Archive current) {
        String methodName = "getDependencyClassPath";
        logger.logp(Level.FINER, className, methodName, "ENTRY current archive [ {0} ]", current.getURI());
        RuntimeClasspathEntry[] local = ((ArchiveImpl)current).getDependencyClassPathAtThisLevel();
        logger.logp(Level.FINER, className, methodName, "Current dependency classpath has [ {0} ] elements", Integer.toString(local.length));
        for (int i = 0; i < local.length; ++i) {
            RuntimeClasspathEntry entry = local[i];
            logger.logp(Level.FINER, className, methodName, "Classpath entry [ {0} ]", entry);
            if (!processedEntries.contains(entry)) {
                logger.logp(Level.FINER, className, methodName, "Not processed yet, add to lists");
                entries.add(entry);
                processedEntries.add(entry);
            }
            Archive resolved = entry.getReferencedArchive();
            logger.logp(Level.FINER, className, methodName, "Referenced archive [ {0} ]", resolved);
            if (resolved == null) {
                logger.logp(Level.FINER, className, methodName, "Archive not found, processing manifest");
                ClasspathUtil.processManifest(entry.getAbsolutePath(), entries, processedEntries);
                continue;
            }
            if (visitedArchives.contains(resolved)) continue;
            logger.logp(Level.FINER, className, methodName, "Not visited yet, get its path");
            visitedArchives.add(resolved);
            this.getDependencyClassPath(visitedArchives, entries, processedEntries, resolved);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN from archive [ {0} ]", current.getURI());
    }

    protected EARFile getEARFile() {
        String methodName = "getEARFile";
        Container parent = this.getContainer();
        if (parent == null || !(parent instanceof EARFile)) {
            Container loadingParent = this.getLoadingContainer();
            if (loadingParent == parent) {
                return null;
            }
            logger.logp(Level.WARNING, className, methodName, "Container differs from loading container");
            if (loadingParent == null || !(loadingParent instanceof EARFile)) {
                return null;
            }
            return (EARFile)loadingParent;
        }
        return (EARFile)parent;
    }

    protected Archive getResolvedArchive(String mfValue, EARFile ear) {
        String aUri = ArchiveUtil.deriveEARRelativeURI(mfValue, this);
        if (aUri == null) {
            return null;
        }
        try {
            return (Archive)ear.getFile(aUri);
        }
        catch (FileNotFoundException ex) {
            return null;
        }
        catch (ClassCastException ex2) {
            return null;
        }
    }

    public boolean hasClasspathVisibilityTo(Archive other) {
        if (other == null) {
            return false;
        }
        EARFile ear = this.getEARFile();
        if (ear == null) {
            return false;
        }
        HashSet visited = new HashSet();
        return this.hasClasspathVisibilityTo(other, visited, ear);
    }

    public boolean hasClasspathVisibilityTo(Archive other, Set visited, EARFile ear) {
        if (this == other) {
            return true;
        }
        if (visited.contains(this)) {
            return false;
        }
        visited.add(this);
        String[] mfEntries = this.getManifest().getClassPathTokenized();
        for (int i = 0; i < mfEntries.length; ++i) {
            Archive anArchive = this.getResolvedArchive(mfEntries[i], ear);
            if (anArchive == null || !anArchive.hasClasspathVisibilityTo(other, visited, ear)) continue;
            return true;
        }
        return false;
    }

    public boolean isType(String type) {
        return this.types != null && this.getTypes().contains(type);
    }

    private boolean renameToWithRetry(java.io.File source, java.io.File destination) {
        String methodName = "renameToWithRetry";
        logger.logp(Level.FINER, className, methodName, "ENTRY rename [ {0} ]", source);
        for (int i = 1; i < 21; ++i) {
            if (source.renameTo(destination)) {
                logger.logp(Level.FINER, className, methodName, "RETURN true");
                return true;
            }
            System.gc();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (i != 1 && i % 10 != 0) continue;
            logger.logp(Level.FINER, className, methodName, "Garbage collection forced.  Slept {0} times.", Integer.toString(i));
        }
        this.displayFileData(source);
        logger.logp(Level.FINER, className, methodName, "RETURN false");
        return false;
    }

    public void displayFileData(java.io.File source) {
        if (!logger.isLoggable(Level.FINEST)) {
            return;
        }
        String methodName = "displayFileData";
        boolean isDir = source.isDirectory();
        boolean exists = source.exists();
        StringBuffer sb = new StringBuffer("\n\nDisplaying data for file [ ");
        sb.append(source).append(" ]\n   File path [ ").append(source.getPath());
        sb.append(" ]\n   File absolute path [ ").append(source.getAbsolutePath());
        sb.append(" ]\n   File canonical file [ ");
        try {
            sb.append(source.getCanonicalFile());
        }
        catch (IOException e) {
            sb.append("unknown");
        }
        sb.append(" ]\n   File parent file [ ").append(source.getParentFile());
        sb.append(" ]");
        if (!exists) {
            sb.append("\n   ERROR: File does not exist");
        } else {
            sb.append("\n   File exists");
            if (isDir) {
                sb.append("\n   File is a directory");
                int numScanned = this.scanFilesInDirectory(source);
                sb.append("\n   Scanned a total of [ ").append(numScanned).append(" ] files");
            } else {
                sb.append("\n   File is NOT a directory");
                this.checkFile(source);
            }
        }
        LoadStrategy loadStrategy = this.getLoadStrategy();
        sb.append("\n   Load Strategy [ ").append(loadStrategy).append(" ]");
        if (loadStrategy instanceof ZipFileLoadStrategyImpl) {
            ZipFileLoadStrategyImpl zipStrategy = (ZipFileLoadStrategyImpl)loadStrategy;
            java.io.File f = zipStrategy.getFile();
            sb.append("\n     File [ ").append(f).append(" ]");
            if (f != null) {
                sb.append("\n     File absolute path [ ").append(f.getAbsolutePath()).append(" ]");
                sb.append("\n     File exists [ ").append(f.exists()).append(" ]");
            }
        }
        logger.logp(Level.FINER, className, methodName, sb.toString());
    }

    private int scanFilesInDirectory(java.io.File currentDirectory) {
        boolean isReadable = currentDirectory.canRead();
        boolean isWritable = currentDirectory.canWrite();
        if (!isReadable || !isWritable) {
            // empty if block
        }
        int numScanned = 1;
        java.io.File[] srcFiles = currentDirectory.listFiles(new NonDirectoryFileFilter());
        for (int i = 0; i < srcFiles.length; ++i) {
            this.checkFile(srcFiles[i]);
            ++numScanned;
        }
        java.io.File[] subDirs = currentDirectory.listFiles(new DirectoryFileFilter());
        for (int j = 0; j < subDirs.length; ++j) {
            numScanned += this.scanFilesInDirectory(subDirs[j]);
        }
        return numScanned;
    }

    private void checkFile(java.io.File original) {
        boolean isReadable = original.canRead();
        boolean isWritable = original.canWrite();
        String baseName = "";
        try {
            baseName = original.getCanonicalPath();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (!isReadable || !isWritable) {
            return;
        }
        String modifiedName = baseName + ".tmp";
        java.io.File newFile = new java.io.File(modifiedName);
        boolean renamed = original.renameTo(newFile);
        if (!renamed || !(renamed = newFile.renameTo(original))) {
            // empty if block
        }
    }

    public boolean isExpanded() {
        LoadStrategy ls = this.getLoadStrategy();
        return !(ls instanceof NestedArchiveLoadStrategyImpl);
    }

    public boolean isSimpleJavaArchive() {
        return !this.isModuleFile();
    }

    public RuntimeClasspathEntry forceExpansionAndCreate(String entry) {
        ZipFileLoadStrategy loadStrategy;
        String methodName = "forceExpansionAndCreate";
        logger.logp(Level.FINER, className, methodName, "ENTER");
        if (this.isExpanded()) {
            logger.logp(Level.FINER, className, methodName, "RETURN: Already expanded");
            try {
                return this.createRuntimeClasspathEntry(this.getBinariesPath(), entry);
            }
            catch (FileNotFoundException e) {
                logger.logp(Level.FINER, className, methodName, "RETURN null - FileNotFoundException for [ {0} ]", entry);
                return null;
            }
        }
        logger.logp(Level.FINER, className, methodName, "Old load strategy [ {0} ]", this.getLoadStrategy());
        try {
            loadStrategy = ArchiveUtil.createExpandedZipFileLoadStrategy(this.getURI(), this.getEARFile());
        }
        catch (ArchiveException e) {
            logger.throwing(className, methodName, e);
            logger.logp(Level.WARNING, className, methodName, "RETURN null - ArchiveException for [ {0} ]", entry);
            return null;
        }
        this.setLoadStrategy(loadStrategy);
        try {
            return this.createRuntimeClasspathEntry(this.getBinariesPath(), null);
        }
        catch (FileNotFoundException e) {
            logger.throwing(className, methodName, e);
            logger.logp(Level.WARNING, className, methodName, "RETURN null - FileNotFoundException for [ {0} ]", entry);
            return null;
        }
    }

    public void closeArchiveZipFile() {
        String methodName = "closeArchiveZipFile";
        LoadStrategy ls = this.getLoadStrategy();
        if (ls instanceof ZipFileLoadStrategyImpl) {
            ZipFileLoadStrategyImpl zfls = (ZipFileLoadStrategyImpl)ls;
            try {
                zfls.closeZipFile();
            }
            catch (IOException e) {
                logger.logp(Level.WARNING, className, methodName, "IOException from zipfile close [ {0} ]", e);
            }
        }
    }

    public void closeChildArchiveZipFiles() {
        if (!this.isIndexed()) {
            return;
        }
        List archiveList = this.getArchiveFiles();
        for (Archive a : archiveList) {
            a.closeArchiveZipFile();
        }
    }

    public void setCanImportAs(boolean canImport) {
        this.isSetCanImportModuleVersion = EnumSet.allOf(Archive.ModuleVersionEnum.class);
        this.canImportModuleVersion = canImport ? EnumSet.allOf(Archive.ModuleVersionEnum.class) : EnumSet.noneOf(Archive.ModuleVersionEnum.class);
    }

    public boolean isSetCanImportAs(Archive.ModuleVersionEnum type) {
        String methodName = "isSetCanImportAs";
        logger.logp(Level.FINEST, className, methodName, "ENTRY type [ {0} ]", (Object)type);
        boolean result = this.isSetCanImportModuleVersion.contains((Object)type);
        logger.logp(Level.FINEST, className, methodName, "RETURN [ {0} ]", new Boolean(result));
        return result;
    }

    public boolean getCanImportAs(Archive.ModuleVersionEnum type) {
        String methodName = "getCanImportAs";
        logger.logp(Level.FINEST, className, methodName, "ENTRY type [ {0} ]", (Object)type);
        boolean result = this.canImportModuleVersion.contains((Object)type);
        logger.logp(Level.FINEST, className, methodName, "RETURN [ {0} ]", new Boolean(result));
        return result;
    }

    public void setCanImportAs(Archive.ModuleVersionEnum type, boolean canImport) {
        String methodName = "setCanImportAs";
        logger.logp(Level.FINEST, className, methodName, "ENTRY type [ {0} ]", (Object)type);
        this.isSetCanImportModuleVersion.add(type);
        if (canImport) {
            this.canImportModuleVersion.add(type);
            logger.logp(Level.FINEST, className, methodName, "RETURN can import as [ {0} ]", (Object)type);
        } else {
            this.canImportModuleVersion.remove((Object)type);
            logger.logp(Level.FINEST, className, methodName, "RETURN cannot import as [ {0} ]", (Object)type);
        }
    }

    public boolean isSetCanImportAs(Archive.ModuleTypeEnum type) {
        boolean result;
        String methodName = "getCanImportAs";
        logger.logp(Level.FINEST, className, methodName, "ENTRY type [ {0} ]", (Object)type);
        if (type == Archive.ModuleTypeEnum.EAR) {
            result = this.isSetCanImportAs(Archive.ModuleVersionEnum.EAR12) && this.isSetCanImportAs(Archive.ModuleVersionEnum.EAR50);
        } else if (type == Archive.ModuleTypeEnum.EJB) {
            result = this.isSetCanImportAs(Archive.ModuleVersionEnum.EJB11) && this.isSetCanImportAs(Archive.ModuleVersionEnum.EJB30);
        } else if (type == Archive.ModuleTypeEnum.CLIENT) {
            result = this.isSetCanImportAs(Archive.ModuleVersionEnum.CLIENT12) && this.isSetCanImportAs(Archive.ModuleVersionEnum.CLIENT50);
        } else if (type == Archive.ModuleTypeEnum.WAR) {
            result = this.isSetCanImportAs(Archive.ModuleVersionEnum.WAR22) && this.isSetCanImportAs(Archive.ModuleVersionEnum.WAR25);
        } else if (type == Archive.ModuleTypeEnum.RAR) {
            result = this.isSetCanImportAs(Archive.ModuleVersionEnum.RAR);
        } else {
            result = false;
            logger.logp(Level.WARNING, className, methodName, "Unknown module type [ {0} ]", (Object)type);
        }
        logger.logp(Level.FINEST, className, methodName, "RETURN [ {0} ]", new Boolean(result));
        return result;
    }

    public void setCanImportAs(Archive.ModuleTypeEnum type, boolean canImport) {
        String methodName = "setCanImportAs";
        logger.logp(Level.FINEST, className, methodName, "ENTRY type [ {0} ]", (Object)type);
        if (type == Archive.ModuleTypeEnum.EAR) {
            this.setCanImportAs(Archive.ModuleVersionEnum.EAR12, canImport);
            this.setCanImportAs(Archive.ModuleVersionEnum.EAR50, canImport);
        } else if (type == Archive.ModuleTypeEnum.EJB) {
            this.setCanImportAs(Archive.ModuleVersionEnum.EJB11, canImport);
            this.setCanImportAs(Archive.ModuleVersionEnum.EJB30, canImport);
        } else if (type == Archive.ModuleTypeEnum.CLIENT) {
            this.setCanImportAs(Archive.ModuleVersionEnum.CLIENT12, canImport);
            this.setCanImportAs(Archive.ModuleVersionEnum.CLIENT50, canImport);
        } else if (type == Archive.ModuleTypeEnum.WAR) {
            this.setCanImportAs(Archive.ModuleVersionEnum.WAR22, canImport);
            this.setCanImportAs(Archive.ModuleVersionEnum.WAR25, canImport);
        } else if (type == Archive.ModuleTypeEnum.RAR) {
            this.setCanImportAs(Archive.ModuleVersionEnum.RAR, canImport);
        } else {
            logger.logp(Level.WARNING, className, methodName, "Unknown module type [ {0} ]", (Object)type);
        }
        logger.logp(Level.FINEST, className, methodName, "RETURN");
    }

    public boolean getCanImportAs(Archive.ModuleTypeEnum type) {
        boolean result;
        String methodName = "getCanImportAs";
        logger.logp(Level.FINEST, className, methodName, "ENTRY type [ {0} ]", (Object)type);
        if (type == Archive.ModuleTypeEnum.EAR) {
            result = this.getCanImportAs(Archive.ModuleVersionEnum.EAR12) || this.getCanImportAs(Archive.ModuleVersionEnum.EAR50);
        } else if (type == Archive.ModuleTypeEnum.EJB) {
            result = this.getCanImportAs(Archive.ModuleVersionEnum.EJB11) || this.getCanImportAs(Archive.ModuleVersionEnum.EJB30);
        } else if (type == Archive.ModuleTypeEnum.CLIENT) {
            result = this.getCanImportAs(Archive.ModuleVersionEnum.CLIENT12) || this.getCanImportAs(Archive.ModuleVersionEnum.CLIENT50);
        } else if (type == Archive.ModuleTypeEnum.WAR) {
            result = this.getCanImportAs(Archive.ModuleVersionEnum.WAR22) || this.getCanImportAs(Archive.ModuleVersionEnum.WAR25);
        } else if (type == Archive.ModuleTypeEnum.RAR) {
            result = this.getCanImportAs(Archive.ModuleVersionEnum.RAR);
        } else {
            result = false;
            logger.logp(Level.WARNING, className, methodName, "Unknown module type [ {0} ]", (Object)type);
        }
        logger.logp(Level.FINEST, className, methodName, "RETURN [ {0} ]", new Boolean(result));
        return result;
    }

    class NonDirectoryFileFilter
    implements FileFilter {
        NonDirectoryFileFilter() {
        }

        public boolean accept(java.io.File file) {
            return !file.isDirectory();
        }
    }

    class DirectoryFileFilter
    implements FileFilter {
        DirectoryFileFilter() {
        }

        public boolean accept(java.io.File file) {
            return file.isDirectory();
        }
    }
}

