/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.j2ee.commonarchivecore.internal.AnnotationsProcessor;
import org.eclipse.jst.j2ee.commonarchivecore.internal.AnnotationsProcessorFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.AnnotationsProcessorException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AnnotationsProcessorFactoryImpl
implements AnnotationsProcessorFactory {
    private static AnnotationsProcessorFactory instance = new AnnotationsProcessorFactoryImpl();
    private Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp", "commonarchive");
    private final String CLASS_NAME = AnnotationsProcessorFactoryImpl.class.getName();
    private final String ANP_EXTENSION = "com.ibm.ws.wccmbase.anp-defs";
    private final String ANP_DEFINITIONS = "anpDefinitions";
    private final String ANP_DEFINITIONS_CLASS = "class";

    public static AnnotationsProcessorFactory getInstance() {
        return instance;
    }

    public AnnotationsProcessor create() throws AnnotationsProcessorException {
        String anpClassName = null;
        if (this.isRunningEclipse()) {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.logp(Level.FINER, this.CLASS_NAME, "create", "OSGI detected");
            }
            anpClassName = this.readUsingOSGI();
        } else {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.logp(Level.FINER, this.CLASS_NAME, "create", "OSGI not detected, parsing");
            }
            anpClassName = this.readFromXML();
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.logp(Level.FINER, this.CLASS_NAME, "create", "Annotations Processor class name to be used: " + anpClassName);
        }
        if (anpClassName != null) {
            try {
                Class<?> annotationsProcessorClass = Class.forName(anpClassName);
                AnnotationsProcessor processor = (AnnotationsProcessor)annotationsProcessorClass.newInstance();
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.logp(Level.FINER, this.CLASS_NAME, "create", "Annotations Processor call instaniated");
                }
                return processor;
            }
            catch (Exception e) {
                if (this.logger.isLoggable(Level.SEVERE)) {
                    this.logger.logp(Level.SEVERE, this.CLASS_NAME, "create", CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.AnnotationsProcessorFactoryImpl_Error_0, new Object[]{anpClassName, e}));
                }
                throw new AnnotationsProcessorException("The AnnotationsProcessor Implementation could not be loaded.", e);
            }
        }
        if (this.logger.isLoggable(Level.SEVERE)) {
            this.logger.logp(Level.SEVERE, this.CLASS_NAME, "create", CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.AnnotationsProcessorFactoryImpl_Error_0, new Object[]{anpClassName, null}));
        }
        throw new AnnotationsProcessorException("The AnnotationsProcessor Implementation could not be loaded.");
    }

    private String readUsingOSGI() {
        String className;
        block7: {
            className = null;
            try {
                IExtension[] anpDefs;
                IExtensionRegistry extRegistry = Platform.getExtensionRegistry();
                IExtensionPoint anpDefsPoint = extRegistry.getExtensionPoint("com.ibm.ws.wccmbase.anp-defs");
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.logp(Level.FINE, this.CLASS_NAME, "readUsingOSGI", "found extension point: [" + anpDefsPoint + "]");
                }
                for (IExtension anpDef : anpDefs = anpDefsPoint.getExtensions()) {
                    IConfigurationElement[] elems;
                    for (IConfigurationElement elem : elems = anpDef.getConfigurationElements()) {
                        if (this.logger.isLoggable(Level.FINER)) {
                            this.logger.logp(Level.FINE, this.CLASS_NAME, "readUsingOSGI", "looking at element: " + elem.getName());
                        }
                        if (!elem.getName().equals("anpDefinitions")) continue;
                        className = elem.getAttribute("class");
                        if (this.logger.isLoggable(Level.FINER)) {
                            this.logger.logp(Level.FINE, this.CLASS_NAME, "readUsingOSGI", "looking at class name: " + className);
                        }
                        if (className == null || !className.equals("")) continue;
                        className = null;
                    }
                }
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.WARNING)) break block7;
                this.logger.logp(Level.WARNING, this.CLASS_NAME, "readUsingOSGI", "unable to read ANP extension point", e);
            }
        }
        return className;
    }

    private String readFromXML() {
        String className;
        block7: {
            DocumentBuilder parser2;
            block6: {
                parser2 = null;
                className = null;
                try {
                    parser2 = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                }
                catch (Throwable e) {
                    if (!this.logger.isLoggable(Level.SEVERE)) break block6;
                    this.logger.logp(Level.SEVERE, this.CLASS_NAME, "readFromXML", "unable to create XML parser", e);
                }
            }
            try {
                InputStream input;
                Enumeration<URL> plugins = this.getClass().getClassLoader().getResources("plugin.xml");
                Enumeration<URL> fragments = this.getClass().getClassLoader().getResources("fragment.xml");
                while (plugins.hasMoreElements() && className == null) {
                    input = plugins.nextElement().openStream();
                    className = this.readUsingParser(parser2, input);
                    input.close();
                }
                while (fragments.hasMoreElements() && className == null) {
                    input = fragments.nextElement().openStream();
                    className = this.readUsingParser(parser2, input);
                    input.close();
                }
            }
            catch (Throwable e) {
                if (!this.logger.isLoggable(Level.SEVERE)) break block7;
                this.logger.logp(Level.SEVERE, this.CLASS_NAME, "readFromXML", "unable to read ANP definitions from XML file", e);
            }
        }
        return className;
    }

    private String readUsingParser(DocumentBuilder p, InputStream input) throws Exception {
        Element root = p.parse(input).getDocumentElement();
        NodeList children = root.getChildNodes();
        String result = null;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.logp(Level.FINE, this.CLASS_NAME, "readUsingParser", "reading ANP definitions as XML from plugin with ID: [" + root.getAttribute("id") + "]");
        }
        for (int i = 0; i < children.getLength() && result == null; ++i) {
            Element elem;
            String extPoint;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || (extPoint = (elem = (Element)child).getAttribute("point")) == null || !extPoint.equals("com.ibm.ws.wccmbase.anp-defs")) continue;
            NodeList anpDefsChildren = elem.getChildNodes();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.logp(Level.FINE, this.CLASS_NAME, "readUsingParser", "found ANP definitions extension point");
            }
            for (int j = 0; j < anpDefsChildren.getLength() && result == null; ++j) {
                Element anpDefsElem;
                String elemName;
                Node anpDefsChild = anpDefsChildren.item(j);
                if (anpDefsChild.getNodeType() != 1 || (elemName = (anpDefsElem = (Element)anpDefsChild).getNodeName()) == null || !elemName.equals("anpDefinitions")) continue;
                result = anpDefsElem.getAttribute("class");
            }
        }
        return result;
    }

    private boolean isRunningEclipse() {
        boolean result;
        block3: {
            result = false;
            try {
                Class<?> extRegistryFactoryClass = Class.forName("com.ibm.wsspi.extension.ExtensionRegistryFactory");
                Method instanceMethod = extRegistryFactoryClass.getMethod("instance", new Class[0]);
                Method isEclipseMethod = extRegistryFactoryClass.getMethod("isEclipse", new Class[0]);
                Object factoryObj = instanceMethod.invoke(null, new Object[0]);
                Boolean runningEclipse = (Boolean)isEclipseMethod.invoke(factoryObj, new Object[0]);
                result = runningEclipse;
            }
            catch (Throwable e) {
                if (!this.logger.isLoggable(Level.WARNING)) break block3;
                this.logger.logp(Level.WARNING, this.CLASS_NAME, "isRunningEclipse", "unable to determine if AMM is running in an OSGi environment; assuming false", e);
            }
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.logp(Level.FINE, this.CLASS_NAME, "isRunningEclipse", "is AMM running in an OSGi environment? [" + result + "]");
        }
        return result;
    }
}

