/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.helpers;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIteratorImpl;

public class NestedArchiveIterator
extends FileIteratorImpl {
    protected ZipInputStream zipInputStream;
    protected ZipEntry currentEntry;

    public NestedArchiveIterator(List theFiles, ZipInputStream stream) {
        super(theFiles);
        this.zipInputStream = stream;
    }

    public InputStream getInputStream(File aFile) throws IOException {
        if (!aFile.getURI().equals(this.currentEntry.getName())) {
            throw new IOException(CommonArchiveResourceHandler.Internal_Error__Iterator_o_EXC_);
        }
        return new WrapperInputStream(this.zipInputStream);
    }

    public File next() {
        File next = super.next();
        try {
            do {
                this.currentEntry = this.zipInputStream.getNextEntry();
            } while (this.currentEntry.isDirectory());
        }
        catch (IOException ex) {
            throw new ArchiveRuntimeException(CommonArchiveResourceHandler.Error_iterating_the_archiv_EXC_, ex);
        }
        return next;
    }

    static class WrapperInputStream
    extends FilterInputStream {
        public WrapperInputStream(InputStream in) {
            super(in);
        }

        public void close() throws IOException {
        }
    }
}

