/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.helpers;

import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;

public class ArchiveOptions
implements Cloneable {
    private static final Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    private static String className = ArchiveOptions.class.getName();
    public static final int SAX = 1;
    public static final int DOM = 2;
    public static final int DEFAULT = 3;
    private int rendererType = 3;
    public static final int LOAD_MODE_COMPAT = 0;
    public static final int LOAD_MODE_SPEC = 1;
    private int classLoadingMode = 0;
    private LoadStrategy loadStrategy;
    private boolean useJavaReflection = true;
    private boolean isReadOnly;
    private boolean saveLibrariesAsFiles = true;
    private boolean saveOnlyDirtyMofResources = true;
    private boolean discriminateNestedArchives = false;
    private Map readOnlyFlags;
    private ProtectionDomain protectionDomain;
    private ClassLoader parentClassLoader;
    private boolean isBinariesBasedArchive;
    private boolean childrenUseParentFilters;
    private boolean saveIncrementally;
    private EARFile parentEarFile;
    private String ParentEarBinariesPath = null;
    private String altBinariesPath;
    private boolean isSetAltBinariesPath = false;

    public Object clone() {
        return this.cloneWith(null);
    }

    public ArchiveOptions cloneWith(LoadStrategy aLoadStrategy) {
        try {
            ArchiveOptions result = (ArchiveOptions)super.clone();
            result.setLoadStrategy(aLoadStrategy);
            result.readOnlyFlags = null;
            return result;
        }
        catch (CloneNotSupportedException ignore) {
            return null;
        }
    }

    public ArchiveOptions cloneWith(LoadStrategy aLoadStrategy, String uri) {
        ArchiveOptions result = this.cloneWith(aLoadStrategy);
        result.setIsReadOnly(this.isReadOnly(uri));
        return result;
    }

    public LoadStrategy getLoadStrategy() {
        return this.loadStrategy;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean saveOnlyDirtyMofResources() {
        return this.saveOnlyDirtyMofResources;
    }

    public void setIsReadOnly(boolean newIsReadOnly) {
        this.isReadOnly = newIsReadOnly;
    }

    public void setIsReadOnly(boolean readOnly, String uri) {
        if (this.readOnlyFlags == null) {
            this.readOnlyFlags = new HashMap();
        }
        this.readOnlyFlags.put(uri, new Boolean(readOnly));
    }

    public boolean isReadOnly(String uri) {
        Boolean bool;
        if (this.readOnlyFlags != null && (bool = (Boolean)this.readOnlyFlags.get(uri)) != null) {
            return bool;
        }
        return this.isReadOnly;
    }

    public void setLoadStrategy(LoadStrategy newLoadStrategy) {
        this.loadStrategy = newLoadStrategy;
        this.loadStrategy.setReadOnly(this.isReadOnly());
        this.loadStrategy.setRendererType(this.getRendererType());
    }

    public void setSaveOnlyDirtyMofResources(boolean newSaveOnlyDirtyMofResources) {
        this.saveOnlyDirtyMofResources = newSaveOnlyDirtyMofResources;
    }

    public void setUseJavaReflection(boolean newUseJavaReflection) {
        this.useJavaReflection = newUseJavaReflection;
    }

    public boolean useJavaReflection() {
        return this.useJavaReflection;
    }

    public boolean isSaveLibrariesAsFiles() {
        return this.saveLibrariesAsFiles;
    }

    public void setSaveLibrariesAsFiles(boolean saveLibrariesAsFiles) {
        this.saveLibrariesAsFiles = saveLibrariesAsFiles;
    }

    public boolean shouldDiscriminateNestedArchives() {
        return this.discriminateNestedArchives;
    }

    public void setDiscriminateNestedArchives(boolean discriminateNestedArchives) {
        this.discriminateNestedArchives = discriminateNestedArchives;
    }

    public int getRendererType() {
        return this.rendererType;
    }

    public void setRendererType(int rendererType) {
        this.rendererType = rendererType;
    }

    public int getClassLoadingMode() {
        return this.classLoadingMode;
    }

    public void setClassLoadingMode(int classLoadingMode) {
        this.classLoadingMode = classLoadingMode;
    }

    public void setProtectionDomain(ProtectionDomain protectionDomain) {
        this.protectionDomain = protectionDomain;
    }

    public ProtectionDomain getProtectionDomain() {
        return this.protectionDomain;
    }

    public void setParentClassLoader(ClassLoader parentClassLoader) {
        String methodName = "setParentClassLoader";
        logger.logp(Level.FINER, className, methodName, "Set parent classloader [ {0} ]", parentClassLoader);
        this.parentClassLoader = parentClassLoader;
    }

    public ClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    public String getParentEarBinariesPath() {
        String methodName = "getParentEarBinariesPath";
        logger.logp(Level.FINER, className, methodName, "ENTRY/RETURN [ {0} ]", this.ParentEarBinariesPath);
        return this.ParentEarBinariesPath;
    }

    public void setParentEarBinariesPath(String path) {
        String methodName = "setParentEarBinariesPath";
        logger.logp(Level.FINER, className, methodName, "ENTRY/RETURN [ {0} ]", path);
        this.ParentEarBinariesPath = path;
    }

    public String getAltBinariesPath() {
        String methodName = "getAltBinariesPath";
        logger.logp(Level.FINER, className, methodName, "ENTRY/RETURN [ {0} ]", this.altBinariesPath);
        return this.altBinariesPath;
    }

    public void setAltBinariesPath(String path) {
        String methodName = "setAltBinariesPath";
        logger.logp(Level.FINER, className, methodName, "Set [ {0} ]", path);
        this.altBinariesPath = path;
        this.isSetAltBinariesPath = true;
    }

    public void unsetAltBinariesPath() {
        String methodName = "unsetAltBinariesPath";
        logger.logp(Level.FINER, className, methodName, "ENTRY/RETURN");
        this.isSetAltBinariesPath = false;
    }

    public boolean isSetAltBinariesPath() {
        String methodName = "isSetAltBinariesPath";
        logger.logp(Level.FINER, className, methodName, "ENTRY/RETURN [ {0} ]", Boolean.toString(this.isSetAltBinariesPath));
        return this.isSetAltBinariesPath;
    }

    public boolean isBinariesBasedArchive() {
        return this.isBinariesBasedArchive;
    }

    public void setIsBinariesBasedArchive(boolean isBinariesBasedArchive) {
        this.isBinariesBasedArchive = isBinariesBasedArchive;
    }

    public boolean getChildrenUseParentFilters() {
        return this.childrenUseParentFilters;
    }

    public void setChildrenUseParentFilters(boolean childrenUseParentFilters) {
        this.childrenUseParentFilters = childrenUseParentFilters;
    }

    public boolean getSaveIncrementally() {
        return this.saveIncrementally;
    }

    public void setSaveIncrementally(boolean saveIncrementally) {
        this.saveIncrementally = saveIncrementally;
    }

    public void setParentEarFile(EARFile parentEarFile) {
        this.parentEarFile = parentEarFile;
    }

    public EARFile getParentEarFile() {
        return this.parentEarFile;
    }
}

