/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.application.internal.operations.ClasspathElement;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ManifestException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.CommonarchiveFactoryImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipFileLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.internal.archive.operations.ComponentLoadStrategyImpl;
import org.eclipse.jst.j2ee.internal.archive.operations.EARComponentLoadStrategyImpl;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class ClassPathSelection {
    protected Archive archive;
    protected IProject earProject;
    protected IVirtualComponent earComponent;
    protected List classpathElements;
    protected Map urisToElements;
    protected boolean modified;
    private String targetProjectName;
    protected Map ejbToClientJARs = null;
    protected Map clientToEJBJARs = null;
    public static final int FILTER_EJB_SERVER_JARS = 0;
    public static final int FILTER_EJB_CLIENT_JARS = 1;
    public static final int FILTER_NONE = 2;
    protected int filterLevel = 2;
    protected static Comparator comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            Archive a1 = (Archive)o1;
            Archive a2 = (Archive)o2;
            return a1.getURI().compareTo(a2.getURI());
        }
    };

    public ClassPathSelection(Archive anArchive, String targetProjectName, EARFile earFile) {
        this.archive = anArchive;
        this.targetProjectName = targetProjectName;
        this.initializeEARProject(earFile);
        this.initializeElements();
    }

    public ClassPathSelection(Archive anArchive, EARFile earFile) {
        this.archive = anArchive;
        this.initializeEARProject(earFile);
        this.initializeElements();
    }

    public ClassPathSelection() {
    }

    protected ClasspathElement createElement(Archive referencingArchive, Archive referencedArchive, String cpEntry) {
        ClasspathElement element = new ClasspathElement(referencingArchive);
        element.setValid(true);
        String uriString = referencedArchive.getURI();
        URI uri = URI.createURI(uriString);
        boolean hasAbsolutePath = uri.hasAbsolutePath();
        if (hasAbsolutePath) {
            uriString = uri.lastSegment();
        }
        element.setText(uriString);
        element.setTargetArchive(referencedArchive);
        element.setEarProject(this.earProject);
        if (this.earComponent != null) {
            IContainer earConentFolder = this.earComponent.getRootFolder().getUnderlyingFolder();
            if (earConentFolder.getType() == 2) {
                element.setEarContentFolder(earConentFolder.getName());
            } else {
                element.setEarContentFolder("");
            }
        }
        this.setProjectValues(element, referencedArchive);
        if (cpEntry != null) {
            element.setValuesSelected(cpEntry);
        }
        this.setType(element, referencedArchive);
        return element;
    }

    protected ClasspathElement createInvalidElement(String cpEntry) {
        ClasspathElement element = new ClasspathElement(this.archive);
        element.setValid(false);
        element.setSelected(true);
        element.setRelativeText(cpEntry);
        element.setText(cpEntry);
        element.setEarProject(this.earProject);
        this.setInvalidProject(element);
        return element;
    }

    public ClasspathElement createProjectElement(IProject project) {
        ClasspathElement element = new ClasspathElement(project);
        element.setValid(true);
        element.setSelected(true);
        element.setText(project.getName());
        element.setProject(project);
        this.addClasspathElement(element, element.getProjectName());
        return element;
    }

    public ClasspathElement createProjectElement(IProject project, boolean existingEntry) {
        ClasspathElement element = new ClasspathElement(project);
        element.setValid(true);
        element.setSelected(existingEntry);
        element.setText(project.getName());
        element.setProject(project);
        this.addClasspathElement(element, element.getProjectName());
        return element;
    }

    public ClasspathElement createArchiveElement(URI uri, String name, String cpEntry) {
        ClasspathElement element = new ClasspathElement(uri);
        element.setValid(false);
        element.setRelativeText(name);
        if (cpEntry != null) {
            element.setValuesSelected(cpEntry);
        }
        element.setText(name);
        element.setEarProject(this.earProject);
        return element;
    }

    /*
     * Exception decompiling
     */
    private void setInvalidProject(ClasspathElement element) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 97->101)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List getClasspathElements() {
        if (this.classpathElements == null) {
            this.classpathElements = new ArrayList();
        }
        return this.classpathElements;
    }

    public List getSelectedClasspathElements() {
        ArrayList<ClasspathElement> list = new ArrayList<ClasspathElement>();
        Iterator it = this.getClasspathElements().iterator();
        while (it.hasNext()) {
            ClasspathElement element = (ClasspathElement)it.next();
            if (!element.isSelected()) continue;
            list.add(element);
        }
        return list;
    }

    protected IClasspathEntry[] getClasspathEntries(boolean filterSelected) {
        ArrayList<IClasspathEntry> result = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] array = null;
        ClasspathElement element = null;
        if (this.classpathElements != null) {
            int i = 0;
            while (i < this.classpathElements.size()) {
                element = (ClasspathElement)this.classpathElements.get(i);
                if ((!filterSelected || element.isSelected()) && (array = ((ClasspathElement)this.classpathElements.get(i)).newClasspathEntries()) != null) {
                    int j = 0;
                    while (j < array.length) {
                        if (!result.contains(array[j])) {
                            result.add(array[j]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return result.toArray(new IClasspathEntry[result.size()]);
        }
        return null;
    }

    public IClasspathEntry[] getClasspathEntriesForAll() {
        return this.getClasspathEntries(false);
    }

    public IClasspathEntry[] getClasspathEntriesForSelected() {
        return this.getClasspathEntries(true);
    }

    protected EARFile getEARFile() {
        if (this.archive == null) {
            return null;
        }
        Container parent = this.archive.getContainer();
        if (parent != null && parent.isEARFile()) {
            return (EARFile)parent;
        }
        return null;
    }

    protected static IProject getEARProject(Archive anArchive) {
        Container c = anArchive.getContainer();
        if (!c.isEARFile()) {
            return null;
        }
        EARFile ear = (EARFile)c;
        LoadStrategy loader = ear.getLoadStrategy();
        if (!(loader instanceof EARComponentLoadStrategyImpl)) {
            return null;
        }
        return ((EARComponentLoadStrategyImpl)loader).getComponent().getProject();
    }

    public Archive getArchive() {
        return this.archive;
    }

    protected IProject getProject(Archive anArchive) {
        LoadStrategy loader = anArchive.getLoadStrategy();
        if (loader instanceof ComponentLoadStrategyImpl) {
            return ((ComponentLoadStrategyImpl)loader).getComponent().getProject();
        }
        return null;
    }

    public String getText() {
        return this.archive.getURI();
    }

    protected Archive getArchive(String uri, List archives) {
        int i = 0;
        while (i < archives.size()) {
            Archive anArchive = (Archive)archives.get(i);
            String archiveURIString = anArchive.getURI();
            URI archiveURI = URI.createURI(archiveURIString);
            boolean hasAbsolutePath = archiveURI.hasAbsolutePath();
            if (hasAbsolutePath) {
                archiveURIString = archiveURI.lastSegment();
            }
            if (archiveURIString.equals(uri)) {
                return anArchive;
            }
            ++i;
        }
        return null;
    }

    protected void initializeElements() {
        this.ejbToClientJARs = J2EEProjectUtilities.collectEJBClientJARs(this.getEARFile());
        this.clientToEJBJARs = this.reverse(this.ejbToClientJARs);
        this.classpathElements = new ArrayList();
        this.urisToElements = new HashMap();
        String[] cp = new String[]{};
        try {
            cp = this.archive.getManifest().getClassPathTokenized();
        }
        catch (ManifestException ex) {
            Logger.getLogger().logError(ex);
        }
        List archives = this.getEARFile().getArchiveFiles();
        Archive other = null;
        ClasspathElement element = null;
        int i = 0;
        while (i < cp.length) {
            String cpEntry = cp[i];
            String uri = ArchiveUtil.deriveEARRelativeURI(cpEntry, this.archive);
            other = this.getArchive(uri, archives);
            if (other != null && ArchiveUtil.isValidDependency(other, this.archive)) {
                element = this.createElement(this.archive, other, cpEntry);
                archives.remove(other);
            } else {
                String projectName;
                IProject project;
                int index;
                element = this.createInvalidElement(cpEntry);
                if (element.representsImportedJar()) {
                    element.setValid(true);
                    element.setProject(this.getProject(this.archive));
                }
                if (other != null) {
                    element.setProject(this.getProject(other));
                }
                if (other == null && element.getProject() == null && (index = cpEntry.indexOf(".jar")) > 0 && (project = ProjectUtilities.getProject(projectName = cpEntry.substring(0, index))) != null && project.exists()) {
                    element.setProject(project);
                }
            }
            this.addClasspathElement(element, uri);
            ++i;
        }
        Collections.sort(archives, comparator);
        i = 0;
        while (i < archives.size()) {
            other = (Archive)archives.get(i);
            if (other != this.archive && ArchiveUtil.isValidDependency(other, this.archive)) {
                IProject project = this.getProject(other);
                if (this.targetProjectName == null || project == null || !project.getName().equals(this.targetProjectName)) {
                    element = this.createElement(this.archive, other, null);
                    element.setProject(this.getProject(other));
                    this.addClasspathElement(element, other.getURI());
                }
            }
            ++i;
        }
        if (this.earComponent != null) {
            IVirtualReference[] newrefs = this.earComponent.getReferences();
            int i2 = 0;
            while (i2 < newrefs.length) {
                IVirtualReference ref = newrefs[i2];
                IVirtualComponent referencedComponent = ref.getReferencedComponent();
                boolean isBinary = referencedComponent.isBinary();
                if (isBinary) {
                    String unresolvedURI = "";
                    try {
                        unresolvedURI = ModuleURIUtil.getArchiveName((URI)URI.createURI(ModuleURIUtil.getHandleString((IVirtualComponent)referencedComponent)));
                    }
                    catch (UnresolveableURIException e) {
                        e.printStackTrace();
                    }
                    URI archiveURI = URI.createURI(unresolvedURI);
                    boolean alreadyInList = false;
                    Iterator iter = this.getClasspathElements().iterator();
                    while (iter.hasNext()) {
                        ClasspathElement tmpelement = (ClasspathElement)iter.next();
                        if (!tmpelement.getText().equals(archiveURI.lastSegment())) continue;
                        alreadyInList = true;
                        break;
                    }
                    if (!alreadyInList) {
                        if (this.inManifest(cp, archiveURI.lastSegment())) {
                            element = this.createArchiveElement(URI.createURI(ModuleURIUtil.getHandleString((IVirtualComponent)referencedComponent)), archiveURI.lastSegment(), archiveURI.lastSegment());
                            this.addClasspathElement(element, unresolvedURI);
                        } else {
                            element = this.createArchiveElement(URI.createURI(ModuleURIUtil.getHandleString((IVirtualComponent)referencedComponent)), archiveURI.lastSegment(), null);
                            this.addClasspathElement(element, unresolvedURI);
                        }
                    }
                }
                ++i2;
            }
        }
    }

    boolean inManifest(String[] cp, String archiveName) {
        boolean result = false;
        String cpEntry = "";
        int i = 0;
        while (i < cp.length) {
            cpEntry = cp[i];
            if (archiveName.equals(cpEntry)) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    protected List loadClassPathArchives() {
        ArrayList<Archive> archives = new ArrayList<Archive>();
        if (this.earComponent != null) {
            IVirtualReference[] newrefs = this.earComponent.getReferences();
            int i = 0;
            while (i < newrefs.length) {
                IVirtualReference ref = newrefs[i];
                IVirtualComponent referencedComponent = ref.getReferencedComponent();
                boolean isBinary = referencedComponent.isBinary();
                if (isBinary) {
                    String uri = J2EEProjectUtilities.getResolvedPathForArchiveComponent(referencedComponent.getName()).toString();
                    try {
                        ZipFileLoadStrategyImpl strat = this.createLoadStrategy(uri);
                        Archive archive = null;
                        try {
                            archive = CommonarchiveFactoryImpl.getActiveFactory().primOpenArchive(strat, uri);
                        }
                        catch (OpenFailureException e) {
                            Logger.getLogger().logError(e);
                        }
                        archives.add(archive);
                    }
                    catch (FileNotFoundException e) {
                        Logger.getLogger().logError(e);
                    }
                    catch (IOException e) {
                        Logger.getLogger().logError(e);
                    }
                }
                ++i;
            }
        }
        return archives;
    }

    Archive getClassPathArchive(String uri, List archives) {
        int i = 0;
        while (i < archives.size()) {
            Archive anArchive = (Archive)archives.get(i);
            String archiveURIString = anArchive.getURI();
            URI archiveURI = URI.createURI(archiveURIString);
            boolean hasAbsolutePath = archiveURI.hasAbsolutePath();
            if (hasAbsolutePath) {
                archiveURIString = archiveURI.lastSegment();
            }
            if (archiveURIString.equals(uri)) {
                return anArchive;
            }
            ++i;
        }
        return null;
    }

    boolean isClassPathArchive(String uri, List archives) {
        int i = 0;
        while (i < archives.size()) {
            Archive anArchive = (Archive)archives.get(i);
            String archiveURIString = anArchive.getURI();
            URI archiveURI = URI.createURI(archiveURIString);
            if (archiveURI.lastSegment().equals(uri)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ZipFileLoadStrategyImpl createLoadStrategy(String uri) throws FileNotFoundException, IOException {
        String filename = uri.replace('/', File.separatorChar);
        File file = new File(filename);
        if (!file.exists()) {
            throw new FileNotFoundException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.file_not_found_EXC_, new Object[]{uri, file.getAbsolutePath()}));
        }
        if (file.isDirectory()) {
            throw new FileNotFoundException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.file_not_found_EXC_, new Object[]{uri, file.getAbsolutePath()}));
        }
        return new ZipFileLoadStrategyImpl(file);
    }

    private void initializeEARProject(EARFile earFile) {
        LoadStrategy loadStrat = earFile.getLoadStrategy();
        if (loadStrat instanceof EARComponentLoadStrategyImpl) {
            this.earComponent = ((EARComponentLoadStrategyImpl)loadStrat).getComponent();
            this.earProject = ((EARComponentLoadStrategyImpl)loadStrat).getComponent().getProject();
        }
    }

    private void setType(ClasspathElement element, Archive other) {
        if (other == null) {
            return;
        }
        if (this.clientToEJBJARs.containsKey(other)) {
            element.setJarType(2);
        } else if (other.isEJBJarFile()) {
            element.setJarType(1);
        }
    }

    private Map reverse(Map localejbToClientJARs) {
        if (localejbToClientJARs == null || localejbToClientJARs.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap result = new HashMap();
        Iterator iter = localejbToClientJARs.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            result.put(entry.getValue(), entry.getKey());
        }
        return result;
    }

    public void addClasspathElement(ClasspathElement element, String uri) {
        this.getClasspathElements().add(element);
        this.getUrisToElements().put(uri, element);
        element.setParentSelection(this);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean newModified) {
        this.modified = newModified;
    }

    protected void setProjectValues(ClasspathElement element, Archive referencedArchive) {
        IProject p = this.getProject(referencedArchive);
        if (p == null) {
            return;
        }
        element.setProject(p);
        String[] cp = null;
        try {
            cp = referencedArchive.getManifest().getClassPathTokenized();
        }
        catch (ManifestException mfEx) {
            Logger.getLogger().logError(mfEx);
            cp = new String[]{};
        }
        ArrayList<IPath> paths = new ArrayList<IPath>(cp.length);
        int i = 0;
        while (i < cp.length) {
            block8: {
                IFile file = null;
                try {
                    file = p.getFile(cp[i]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    break block8;
                }
                if (file.exists()) {
                    paths.add(file.getFullPath());
                }
            }
            ++i;
        }
        if (!paths.isEmpty()) {
            element.setImportedJarPaths(paths);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.classpathElements.size()) {
            ClasspathElement element = (ClasspathElement)this.classpathElements.get(i);
            if (element.isSelected()) {
                sb.append(element.getRelativeText());
                sb.append(" ");
            }
            ++i;
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public void setAllSelected(boolean selected) {
        this.setAllSelected(this.classpathElements, selected);
    }

    public void setAllSelected(List elements, boolean selected) {
        int i = 0;
        while (i < elements.size()) {
            ClasspathElement elmt = (ClasspathElement)elements.get(i);
            elmt.setSelected(selected);
            ++i;
        }
    }

    protected List moveUp(List elements, List move) {
        int nElements = elements.size();
        ArrayList res = new ArrayList(nElements);
        Object floating = null;
        int i = 0;
        while (i < nElements) {
            Object curr = elements.get(i);
            if (move.contains(curr)) {
                res.add(curr);
            } else {
                if (floating != null) {
                    res.add(floating);
                }
                floating = curr;
            }
            ++i;
        }
        if (floating != null) {
            res.add(floating);
        }
        return res;
    }

    public void moveUp(List toMoveUp) {
        this.setModifiedIfAnySelected(toMoveUp);
        if (toMoveUp.size() > 0) {
            this.classpathElements = this.moveUp(this.classpathElements, toMoveUp);
        }
    }

    public void moveDown(List toMoveDown) {
        this.setModifiedIfAnySelected(toMoveDown);
        if (toMoveDown.size() > 0) {
            this.classpathElements = this.reverse(this.moveUp(this.reverse(this.classpathElements), toMoveDown));
        }
    }

    protected List reverse(List p) {
        ArrayList reverse = new ArrayList(p.size());
        int i = p.size() - 1;
        while (i >= 0) {
            reverse.add(p.get(i));
            --i;
        }
        return reverse;
    }

    public ClasspathElement getClasspathElement(String uri) {
        if (this.urisToElements == null) {
            return null;
        }
        return (ClasspathElement)this.urisToElements.get(uri);
    }

    public ClasspathElement getClasspathElement(IProject archiveProject) {
        if (archiveProject != null) {
            int i = 0;
            while (i < this.classpathElements.size()) {
                ClasspathElement elmnt = (ClasspathElement)this.classpathElements.get(i);
                if (archiveProject.equals((Object)elmnt.getProject())) {
                    return elmnt;
                }
                ++i;
            }
        }
        return null;
    }

    public boolean hasDirectOrIndirectDependencyTo(IProject archiveProject) {
        ClasspathElement element = this.getClasspathElement(archiveProject);
        if (element == null) {
            return false;
        }
        Archive anArchive = null;
        if (element.isValid()) {
            try {
                anArchive = (Archive)this.getEARFile().getFile(element.getText());
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return anArchive != null && this.archive.hasClasspathVisibilityTo(anArchive);
    }

    public boolean hasDirectOrIndirectDependencyTo(String jarName) {
        ClasspathElement element = this.getClasspathElement(jarName);
        if (element == null) {
            return false;
        }
        Archive anArchive = null;
        if (element.isValid()) {
            try {
                anArchive = (Archive)this.getEARFile().getFile(element.getText());
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return anArchive != null && this.archive.hasClasspathVisibilityTo(anArchive);
    }

    public boolean isAnyJarSelected(int type) {
        if (this.classpathElements != null) {
            int i = 0;
            while (i < this.classpathElements.size()) {
                ClasspathElement element = (ClasspathElement)this.classpathElements.get(i);
                if (element.getJarType() == type && element.isSelected()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isAnyEJBJarSelected() {
        return this.isAnyJarSelected(1);
    }

    public boolean isAnyEJBClientJARSelected() {
        return this.isAnyJarSelected(2);
    }

    public int getFilterLevel() {
        return this.filterLevel;
    }

    public void setFilterLevel(int i) {
        this.filterLevel = i;
    }

    public void selectFilterLevel(int level) {
        this.setFilterLevel(level);
        switch (level) {
            case 1: {
                this.invertClientJARSelections(2);
                break;
            }
            case 0: {
                this.invertClientJARSelections(1);
                break;
            }
        }
    }

    public void invertClientJARSelection(IProject aProject, IProject opposite) {
        ClasspathElement oppositeElement;
        ClasspathElement element = this.getClasspathElement(aProject);
        ClasspathElement classpathElement = oppositeElement = opposite == null ? null : this.getClasspathElement(opposite);
        if (element.isSelected()) {
            this.invertSelectionIfPossible(element, oppositeElement);
        }
    }

    private void invertClientJARSelections(int elementType) {
        if (this.classpathElements == null) {
            return;
        }
        int i = 0;
        while (i < this.classpathElements.size()) {
            ClasspathElement element = (ClasspathElement)this.classpathElements.get(i);
            if (element.getJarType() == elementType && element.isSelected()) {
                this.invertSelectionIfPossible(element, null);
            }
            ++i;
        }
    }

    private void invertSelectionIfPossible(ClasspathElement element, ClasspathElement opposite) {
        if (element == null) {
            return;
        }
        if (opposite == null) {
            opposite = this.getOppositeElement(element);
        }
        if (opposite != null) {
            opposite.setSelected(true);
            element.setSelected(false);
        }
    }

    public ClasspathElement getOppositeElement(ClasspathElement element) {
        String uri = element.getText();
        Archive target = element.getTargetArchive();
        if (uri == null || target == null) {
            return null;
        }
        org.eclipse.jst.j2ee.commonarchivecore.internal.File oppositeJAR = null;
        switch (element.getJarType()) {
            case 2: {
                oppositeJAR = (Archive)this.clientToEJBJARs.get(target);
                break;
            }
            case 1: {
                oppositeJAR = (Archive)this.ejbToClientJARs.get(target);
                break;
            }
        }
        if (oppositeJAR != null) {
            return this.getClasspathElement(oppositeJAR.getURI());
        }
        return null;
    }

    private void setModifiedIfAnySelected(List elements) {
        int i = 0;
        while (i < elements.size()) {
            ClasspathElement element = (ClasspathElement)elements.get(i);
            if (element.isSelected()) {
                this.setModified(true);
            }
            ++i;
        }
    }

    public boolean isMyClientJAR(ClasspathElement element) {
        if (element == null || this.ejbToClientJARs == null) {
            return false;
        }
        Archive myClientJar = (Archive)this.ejbToClientJARs.get(this.archive);
        return myClientJar != null && myClientJar == element.getTargetArchive();
    }

    public Map getUrisToElements() {
        if (this.urisToElements == null) {
            this.urisToElements = new HashMap();
        }
        return this.urisToElements;
    }
}

