/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.impl;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.ApplicationPackage;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.common.internal.impl.CompatibilityDescriptionGroupImpl;
import org.eclipse.jst.j2ee.common.internal.util.CommonUtil;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionResource;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.wst.common.internal.emf.utilities.StringUtil;

public class ApplicationImpl
extends CompatibilityDescriptionGroupImpl
implements Application {
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    private static String className = ApplicationImpl.class.getName();
    private boolean _J2EEVersionIDStored = false;
    private int _storedJ2EEVersionID;
    protected static final String VERSION_EDEFAULT = null;
    protected String version = VERSION_EDEFAULT;
    protected EList securityRoles = null;
    protected EList modules = null;
    protected static final String LIBRARY_DIRECTORY_EDEFAULT = null;
    protected String libraryDirectory = LIBRARY_DIRECTORY_EDEFAULT;
    protected boolean libraryDirectoryESet = false;

    protected EClass eStaticClass() {
        return ApplicationPackage.Literals.APPLICATION;
    }

    public boolean containsSecurityRole(String name) {
        return this.getSecurityRoleNamed(name) != null;
    }

    public Module getModule(String uri) {
        return this.getFirstModule(uri);
    }

    public Module getModule(String uri, String altDD) {
        EList allModules = this.getModules();
        for (int i = 0; i < allModules.size(); ++i) {
            Module aModule = (Module)allModules.get(i);
            if (!StringUtil.stringsEqual(uri, aModule.getUri()) || !StringUtil.stringsEqual(altDD, aModule.getAltDD())) continue;
            return aModule;
        }
        return null;
    }

    public Module getFirstModule(String uri) {
        if (uri == null) {
            return null;
        }
        for (Module aModule : this.getModules()) {
            if (!uri.equals(aModule.getUri())) continue;
            return aModule;
        }
        return null;
    }

    public Module getModuleHavingAltDD(String uri) {
        if (uri == null) {
            return null;
        }
        EList aModules = this.getModules();
        for (int i = 0; i < aModules.size(); ++i) {
            Module aModule = (Module)aModules.get(i);
            if (!uri.equals(aModule.getAltDD())) continue;
            return aModule;
        }
        return null;
    }

    public SecurityRole getSecurityRoleNamed(String roleName) {
        EList tempRoles = this.getSecurityRoles();
        for (int i = 0; i < tempRoles.size(); ++i) {
            SecurityRole role = (SecurityRole)tempRoles.get(i);
            if (!role.getRoleName().equals(roleName)) continue;
            return role;
        }
        return null;
    }

    public boolean isVersion1_2Descriptor() {
        CommonUtil.checkDDObjectForVersion(this);
        String systemId = ((XMLResource)this.eResource()).getSystemId();
        return systemId == null ? false : systemId.equals("http://java.sun.com/j2ee/dtds/application_1_2.dtd");
    }

    public boolean isVersion1_3Descriptor() {
        CommonUtil.checkDDObjectForVersion(this);
        String systemId = ((XMLResource)this.eResource()).getSystemId();
        return systemId == null ? false : systemId.equals("http://java.sun.com/dtd/application_1_3.dtd");
    }

    public void setDisplayName(String newDisplayName) {
        super.setDisplayName(newDisplayName);
    }

    public String getVersion() {
        return this.version;
    }

    public int getVersionID() throws IllegalStateException {
        J2EEVersionResource res = (J2EEVersionResource)((Object)this.eResource());
        if (res == null) {
            throw new IllegalStateException();
        }
        return res.getModuleVersionID();
    }

    public void setVersion(String newVersion) {
        String oldVersion = this.version;
        this.version = newVersion;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldVersion, (Object)this.version));
        }
    }

    public EList getSecurityRoles() {
        if (this.securityRoles == null) {
            this.securityRoles = new EObjectContainmentEList(SecurityRole.class, this, 8);
        }
        return this.securityRoles;
    }

    public EList getModules() {
        if (this.modules == null) {
            this.modules = new EObjectContainmentWithInverseEList(Module.class, this, 9, 2);
        }
        return this.modules;
    }

    public String getLibraryDirectory() {
        return this.libraryDirectory;
    }

    public void setLibraryDirectory(String newLibraryDirectory) {
        String oldLibraryDirectory = this.libraryDirectory;
        this.libraryDirectory = newLibraryDirectory;
        boolean oldLibraryDirectoryESet = this.libraryDirectoryESet;
        this.libraryDirectoryESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldLibraryDirectory, (Object)this.libraryDirectory, !oldLibraryDirectoryESet));
        }
    }

    public void unsetLibraryDirectory() {
        String oldLibraryDirectory = this.libraryDirectory;
        boolean oldLibraryDirectoryESet = this.libraryDirectoryESet;
        this.libraryDirectory = LIBRARY_DIRECTORY_EDEFAULT;
        this.libraryDirectoryESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 2, 10, (Object)oldLibraryDirectory, (Object)LIBRARY_DIRECTORY_EDEFAULT, oldLibraryDirectoryESet));
        }
    }

    public boolean isSetLibraryDirectory() {
        return this.libraryDirectoryESet;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 9: {
                return ((InternalEList)this.getModules()).basicAdd(otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 8: {
                return ((InternalEList)this.getSecurityRoles()).basicRemove(otherEnd, msgs);
            }
            case 9: {
                return ((InternalEList)this.getModules()).basicRemove(otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 7: {
                return this.getVersion();
            }
            case 8: {
                return this.getSecurityRoles();
            }
            case 9: {
                return this.getModules();
            }
            case 10: {
                return this.getLibraryDirectory();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 7: {
                this.setVersion((String)newValue);
                return;
            }
            case 8: {
                this.getSecurityRoles().clear();
                this.getSecurityRoles().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.getModules().clear();
                this.getModules().addAll((Collection)newValue);
                return;
            }
            case 10: {
                this.setLibraryDirectory((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 7: {
                this.setVersion(VERSION_EDEFAULT);
                return;
            }
            case 8: {
                this.getSecurityRoles().clear();
                return;
            }
            case 9: {
                this.getModules().clear();
                return;
            }
            case 10: {
                this.unsetLibraryDirectory();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 7: {
                return VERSION_EDEFAULT == null ? this.version != null : !VERSION_EDEFAULT.equals(this.version);
            }
            case 8: {
                return this.securityRoles != null && !this.securityRoles.isEmpty();
            }
            case 9: {
                return this.modules != null && !this.modules.isEmpty();
            }
            case 10: {
                return this.isSetLibraryDirectory();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer("\n\nEAR File deployment descriptor   [ ");
        result.append(this.getClass().getName() + '@' + Integer.toHexString(this.hashCode())).append(" ]\n\n");
        result.append("  *Resource           [ " + this.eResource() + " ]\n");
        result.append("  Version             [ " + this.version + " ]\n");
        try {
            result.append("  Version ID          [ " + this.getVersionID() + " ]\n");
        }
        catch (IllegalStateException e) {
            result.append("  Version ID          [ ERROR: cannot be calculated - IllegalStateException ]\n");
        }
        result.append("  Library Directory   [ ");
        if (this.libraryDirectoryESet) {
            result.append(this.libraryDirectory);
        } else {
            result.append("<unset>");
        }
        result.append(" ]\n");
        if (this.securityRoles != null) {
            result.append("\n  EAR contains [ " + this.securityRoles.size() + " ] security roles\n");
            for (SecurityRole sr : this.securityRoles) {
                if (sr != null) {
                    result.append(sr);
                    continue;
                }
                result.append("  Security Role        [ " + sr + " ]\n");
            }
        } else {
            result.append("\n  EAR contains no security roles\n");
        }
        if (this.modules != null) {
            result.append("\n  EAR contains [ " + this.modules.size() + " ] modules\n");
            for (Module m : this.modules) {
                if (m != null) {
                    result.append(m);
                    continue;
                }
                result.append("  Module               [ " + m + " ]\n");
            }
        } else {
            result.append("\n  EAR contains no modules\n");
        }
        result.append("\n");
        return result.toString();
    }

    public void storeJ2EEVersionID() throws IllegalStateException {
        String methodName = "storeJ2EEVersionID";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        if (this._J2EEVersionIDStored) {
            logger.logp(Level.FINER, className, methodName, "RETURN J2EE version ID value already stored [ {0} ]", this._storedJ2EEVersionID);
            return;
        }
        J2EEVersionResource res = (J2EEVersionResource)((Object)this.eResource());
        if (res == null) {
            logger.logp(Level.FINER, className, methodName, "RETURN Throwing IllegalStateException as resource is null");
            throw new IllegalStateException("XMLResource is null");
        }
        this._storedJ2EEVersionID = res.getJ2EEVersionID();
        this._J2EEVersionIDStored = true;
        logger.logp(Level.FINER, className, methodName, "RETURN Stored [ {0} ]", this._storedJ2EEVersionID);
    }

    public int getJ2EEVersionID() throws IllegalStateException {
        if (!this._J2EEVersionIDStored) {
            this.storeJ2EEVersionID();
        }
        return this._storedJ2EEVersionID;
    }
}

