/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.util;

import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class EContentsEList
extends AbstractSequentialList
implements EList,
InternalEList {
    public static final EContentsEList EMPTY_CONTENTS_ELIST = new EContentsEList(null, null){

        public List basicList() {
            return this;
        }
    };
    protected final EObject eObject;
    protected final EStructuralFeature[] eStructuralFeatures;

    public static EContentsEList createEContentsEList(EObject eObject) {
        EStructuralFeature[] eStructuralFeatures = ((EClassImpl.FeatureSubsetSupplier)((Object)eObject.eClass().getEAllStructuralFeatures())).containments();
        return eStructuralFeatures == null ? EMPTY_CONTENTS_ELIST : new EContentsEList(eObject, eStructuralFeatures);
    }

    public EContentsEList(EObject eObject) {
        this.eObject = eObject;
        this.eStructuralFeatures = ((EClassImpl.FeatureSubsetSupplier)((Object)eObject.eClass().getEAllStructuralFeatures())).containments();
    }

    public EContentsEList(EObject eObject, List eStructuralFeatures) {
        this.eObject = eObject;
        this.eStructuralFeatures = new EStructuralFeature[eStructuralFeatures.size()];
        eStructuralFeatures.toArray(this.eStructuralFeatures);
    }

    public EContentsEList(EObject eObject, EStructuralFeature[] eStructuralFeatures) {
        this.eObject = eObject;
        this.eStructuralFeatures = eStructuralFeatures;
    }

    protected ListIterator newListIterator() {
        return this.resolve() ? this.newResolvingListIterator() : this.newNonResolvingListIterator();
    }

    protected ListIterator newResolvingListIterator() {
        return new ResolvingFeatureIteratorImpl(this.eObject, this.eStructuralFeatures);
    }

    protected ListIterator newNonResolvingListIterator() {
        return new FeatureIteratorImpl(this.eObject, this.eStructuralFeatures);
    }

    protected Iterator newIterator() {
        return this.newListIterator();
    }

    protected boolean useIsSet() {
        return true;
    }

    protected boolean resolve() {
        return true;
    }

    protected boolean isIncluded(EStructuralFeature eStructuralFeature) {
        return true;
    }

    protected boolean isIncludedEntry(EStructuralFeature eStructuralFeature) {
        return eStructuralFeature instanceof EReference && ((EReference)eStructuralFeature).isContainment();
    }

    public ListIterator listIterator(int index) {
        if (this.eStructuralFeatures == null) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("index=" + index + ", size=0");
            }
            return FeatureIteratorImpl.EMPTY_ITERATOR;
        }
        ListIterator result = this.newListIterator();
        int i = 0;
        while (i < index) {
            result.next();
            ++i;
        }
        return result;
    }

    public Iterator iterator() {
        if (this.eStructuralFeatures == null) {
            return FeatureIteratorImpl.EMPTY_ITERATOR;
        }
        Iterator result = this.newIterator();
        return result;
    }

    public int size() {
        int result = 0;
        if (this.eStructuralFeatures != null) {
            int i = 0;
            while (i < this.eStructuralFeatures.length) {
                EStructuralFeature feature = this.eStructuralFeatures[i];
                if (this.isIncluded(feature) && (!this.useIsSet() || this.eObject.eIsSet(feature))) {
                    Object value = this.eObject.eGet(feature, false);
                    if (FeatureMapUtil.isFeatureMap(feature)) {
                        FeatureMap featureMap = (FeatureMap)value;
                        int j = 0;
                        int size = featureMap.size();
                        while (j < size) {
                            if (this.isIncludedEntry(featureMap.getEStructuralFeature(j)) && featureMap.getValue(j) != null) {
                                ++result;
                            }
                            ++j;
                        }
                    } else if (feature.isMany()) {
                        result += ((Collection)value).size();
                    } else if (value != null) {
                        ++result;
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public boolean isEmpty() {
        if (this.eStructuralFeatures != null) {
            int i = 0;
            while (i < this.eStructuralFeatures.length) {
                EStructuralFeature feature = this.eStructuralFeatures[i];
                if (this.isIncluded(feature) && (!this.useIsSet() || this.eObject.eIsSet(feature))) {
                    Object value = this.eObject.eGet(feature, false);
                    if (FeatureMapUtil.isFeatureMap(feature)) {
                        FeatureMap featureMap = (FeatureMap)value;
                        int j = 0;
                        int size = featureMap.size();
                        while (j < size) {
                            if (this.isIncludedEntry(featureMap.getEStructuralFeature(j)) && featureMap.getValue(j) != null) {
                                return false;
                            }
                            ++j;
                        }
                    } else if (feature.isMany() ? !((Collection)value).isEmpty() : value != null) {
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    public void move(int newPosition, Object o) {
        throw new UnsupportedOperationException();
    }

    public Object move(int newPosition, int oldPosition) {
        throw new UnsupportedOperationException();
    }

    public Object basicGet(int index) {
        return this.basicList().get(index);
    }

    public List basicList() {
        return new EContentsEList(this.eObject, this.eStructuralFeatures){

            protected boolean resolve() {
                return false;
            }
        };
    }

    public Iterator basicIterator() {
        if (this.eStructuralFeatures == null) {
            return FeatureIteratorImpl.EMPTY_ITERATOR;
        }
        return this.newNonResolvingListIterator();
    }

    public ListIterator basicListIterator() {
        if (this.eStructuralFeatures == null) {
            return FeatureIteratorImpl.EMPTY_ITERATOR;
        }
        return this.newNonResolvingListIterator();
    }

    public ListIterator basicListIterator(int index) {
        if (this.eStructuralFeatures == null) {
            if (index < 0 || index > 1) {
                throw new IndexOutOfBoundsException("index=" + index + ", size=0");
            }
            return FeatureIteratorImpl.EMPTY_ITERATOR;
        }
        ListIterator result = this.newNonResolvingListIterator();
        int i = 0;
        while (i < index) {
            result.next();
            ++i;
        }
        return result;
    }

    public NotificationChain basicRemove(Object object, NotificationChain notifications) {
        throw new UnsupportedOperationException();
    }

    public NotificationChain basicAdd(Object object, NotificationChain notifications) {
        throw new UnsupportedOperationException();
    }

    public void addUnique(Object object) {
        throw new UnsupportedOperationException();
    }

    public void addUnique(int index, Object object) {
        throw new UnsupportedOperationException();
    }

    public Object setUnique(int index, Object object) {
        throw new UnsupportedOperationException();
    }

    public static interface FeatureIterator
    extends Iterator {
        public EStructuralFeature feature();
    }

    public static interface FeatureListIterator
    extends FeatureIterator,
    ListIterator {
    }

    public static class FeatureIteratorImpl
    implements FeatureListIterator {
        protected final EObject eObject;
        protected final EStructuralFeature[] eStructuralFeatures;
        protected int featureCursor;
        protected int cursor;
        protected int prepared;
        protected Object preparedResult;
        protected EStructuralFeature preparedFeature;
        protected EStructuralFeature feature;
        protected boolean isHandlingFeatureMap;
        protected ListIterator values;
        protected InternalEList valueInternalEList;
        protected List valueList;
        protected int valueListSize;
        protected int valueListIndex;
        public static final ListIterator EMPTY_ITERATOR = new FeatureIteratorImpl(null, null){

            public boolean hasNext() {
                return false;
            }

            public boolean hasPrevious() {
                return false;
            }
        };

        public FeatureIteratorImpl(EObject eObject, List eStructuralFeatures) {
            this.eObject = eObject;
            this.eStructuralFeatures = new EStructuralFeature[eStructuralFeatures.size()];
            eStructuralFeatures.toArray(this.eStructuralFeatures);
        }

        public FeatureIteratorImpl(EObject eObject, EStructuralFeature[] eStructuralFeatures) {
            this.eObject = eObject;
            this.eStructuralFeatures = eStructuralFeatures;
        }

        protected boolean resolve() {
            return false;
        }

        protected boolean useIsSet() {
            return true;
        }

        protected boolean isIncluded(EStructuralFeature eStructuralFeature) {
            return true;
        }

        protected boolean isIncludedEntry(EStructuralFeature eStructuralFeature) {
            return eStructuralFeature instanceof EReference && ((EReference)eStructuralFeature).isContainment();
        }

        public EStructuralFeature feature() {
            return this.feature;
        }

        public boolean hasNext() {
            switch (this.prepared) {
                case 2: 
                case 3: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case -3: {
                    if (this.values == null) {
                        ++this.valueListIndex;
                        break;
                    }
                    this.values.next();
                }
            }
            if (this.valueList == null || (this.values == null ? !this.scanNext() : !this.scanNext(this.values))) {
                while (this.featureCursor < this.eStructuralFeatures.length) {
                    EStructuralFeature feature;
                    if (!this.isIncluded(feature = this.eStructuralFeatures[this.featureCursor++]) || this.useIsSet() && !this.eObject.eIsSet(feature)) continue;
                    Object value = this.eObject.eGet(feature, this.resolve());
                    this.isHandlingFeatureMap = FeatureMapUtil.isFeatureMap(feature);
                    if (this.isHandlingFeatureMap || feature.isMany()) {
                        List list;
                        if (this.resolve()) {
                            list = (List)value;
                        } else {
                            list = (InternalEList)value;
                            this.valueInternalEList = this.valueInternalEList;
                        }
                        this.valueList = list;
                        if (this.valueList instanceof RandomAccess) {
                            this.values = null;
                            this.valueListSize = this.valueList.size();
                            this.valueListIndex = 0;
                        } else {
                            ListIterator listIterator = this.values = this.valueInternalEList == null ? this.valueList.listIterator() : this.valueInternalEList.basicListIterator();
                        }
                        if (!(this.values == null ? this.scanNext() : this.scanNext(this.values))) continue;
                        Object object = this.values == null ? (this.valueInternalEList == null ? this.valueList.get(this.valueListIndex++) : this.valueInternalEList.basicGet(this.valueListIndex++)) : (this.preparedResult = this.values.next());
                        if (this.isHandlingFeatureMap) {
                            FeatureMap.Entry entry = (FeatureMap.Entry)this.preparedResult;
                            this.preparedFeature = entry.getEStructuralFeature();
                            this.preparedResult = entry.getValue();
                        } else {
                            this.preparedFeature = feature;
                        }
                        this.prepared = 3;
                        return true;
                    }
                    if (value == null) continue;
                    this.valueList = null;
                    this.values = null;
                    this.preparedResult = value;
                    this.preparedFeature = feature;
                    this.prepared = 2;
                    return true;
                }
                this.valueList = null;
                this.values = null;
                this.isHandlingFeatureMap = false;
                this.prepared = 1;
                return false;
            }
            Object object = this.values == null ? (this.valueInternalEList == null ? this.valueList.get(this.valueListIndex++) : this.valueInternalEList.basicGet(this.valueListIndex++)) : (this.preparedResult = this.values.next());
            if (this.isHandlingFeatureMap) {
                FeatureMap.Entry entry = (FeatureMap.Entry)this.preparedResult;
                this.preparedFeature = entry.getEStructuralFeature();
                this.preparedResult = entry.getValue();
            }
            this.prepared = 3;
            return true;
        }

        protected boolean scanNext(ListIterator values) {
            if (this.isHandlingFeatureMap) {
                while (values.hasNext()) {
                    FeatureMap.Entry entry = (FeatureMap.Entry)values.next();
                    EStructuralFeature entryFeature = entry.getEStructuralFeature();
                    if (!this.isIncludedEntry(entryFeature) || entry.getValue() == null) continue;
                    values.previous();
                    return true;
                }
                return false;
            }
            return values.hasNext();
        }

        protected boolean scanNext() {
            if (this.isHandlingFeatureMap) {
                while (this.valueListIndex < this.valueListSize) {
                    FeatureMap.Entry entry = (FeatureMap.Entry)this.valueList.get(this.valueListIndex);
                    EStructuralFeature entryFeature = entry.getEStructuralFeature();
                    if (this.isIncludedEntry(entryFeature) && entry.getValue() != null) {
                        return true;
                    }
                    ++this.valueListIndex;
                }
                return false;
            }
            return this.valueListIndex < this.valueListSize;
        }

        public Object next() {
            if (this.prepared > 1 || this.hasNext()) {
                ++this.cursor;
                this.prepared = 0;
                this.feature = this.preparedFeature;
                Object result = this.preparedResult;
                this.hasNext();
                return result;
            }
            throw new NoSuchElementException();
        }

        public int nextIndex() {
            return this.cursor;
        }

        public boolean hasPrevious() {
            switch (this.prepared) {
                case -3: 
                case -2: {
                    return true;
                }
                case -1: {
                    return false;
                }
                case 3: {
                    if (this.values == null) {
                        --this.valueListIndex;
                        break;
                    }
                    this.values.previous();
                }
            }
            if (this.valueList == null || (this.values == null ? !this.scanPrevious() : !this.scanPrevious(this.values))) {
                while (this.featureCursor > 0) {
                    EStructuralFeature feature;
                    if (!this.isIncluded(feature = this.eStructuralFeatures[--this.featureCursor]) || this.useIsSet() && !this.eObject.eIsSet(feature)) continue;
                    Object value = this.eObject.eGet(feature, this.resolve());
                    this.isHandlingFeatureMap = FeatureMapUtil.isFeatureMap(feature);
                    if (this.isHandlingFeatureMap || feature.isMany()) {
                        List list;
                        if (this.resolve()) {
                            list = (List)value;
                        } else {
                            list = (InternalEList)value;
                            this.valueInternalEList = this.valueInternalEList;
                        }
                        this.valueList = list;
                        if (this.valueList instanceof RandomAccess) {
                            this.valueListIndex = this.valueListSize = this.valueList.size();
                        } else {
                            ListIterator listIterator = this.values = this.valueInternalEList == null ? this.valueList.listIterator(this.valueList.size()) : this.valueInternalEList.basicListIterator(this.valueList.size());
                        }
                        if (!(this.values == null ? this.scanPrevious() : this.scanPrevious(this.values))) continue;
                        Object object = this.values == null ? (this.valueInternalEList == null ? this.valueList.get(--this.valueListIndex) : this.valueInternalEList.basicGet(--this.valueListIndex)) : (this.preparedResult = this.values.previous());
                        if (this.isHandlingFeatureMap) {
                            FeatureMap.Entry entry = (FeatureMap.Entry)this.preparedResult;
                            this.preparedFeature = entry.getEStructuralFeature();
                            this.preparedResult = entry.getValue();
                        } else {
                            this.preparedFeature = feature;
                        }
                        this.prepared = -3;
                        return true;
                    }
                    if (value == null) continue;
                    this.valueList = null;
                    this.values = null;
                    this.preparedResult = value;
                    this.preparedFeature = feature;
                    this.prepared = -2;
                    return true;
                }
                this.valueList = null;
                this.values = null;
                this.prepared = -1;
                return false;
            }
            Object object = this.values == null ? (this.valueInternalEList == null ? this.valueList.get(--this.valueListIndex) : this.valueInternalEList.basicGet(--this.valueListIndex)) : (this.preparedResult = this.values.previous());
            if (this.isHandlingFeatureMap) {
                FeatureMap.Entry entry = (FeatureMap.Entry)this.preparedResult;
                this.preparedFeature = entry.getEStructuralFeature();
                this.preparedResult = entry.getValue();
            }
            this.prepared = -3;
            return true;
        }

        protected boolean scanPrevious(ListIterator values) {
            if (this.isHandlingFeatureMap) {
                while (values.hasPrevious()) {
                    FeatureMap.Entry entry = (FeatureMap.Entry)values.previous();
                    EStructuralFeature entryFeature = entry.getEStructuralFeature();
                    if (!this.isIncludedEntry(entryFeature) || entry.getValue() == null) continue;
                    values.next();
                    return true;
                }
                return false;
            }
            return values.hasPrevious();
        }

        protected boolean scanPrevious() {
            if (this.isHandlingFeatureMap) {
                while (this.valueListIndex > 0) {
                    FeatureMap.Entry entry = (FeatureMap.Entry)this.valueList.get(this.valueListIndex - 1);
                    EStructuralFeature entryFeature = entry.getEStructuralFeature();
                    if (this.isIncludedEntry(entryFeature) && entry.getValue() != null) {
                        return true;
                    }
                    --this.valueListIndex;
                }
                return false;
            }
            return this.valueListIndex > 0;
        }

        public Object previous() {
            if (this.prepared < -1 || this.hasPrevious()) {
                --this.cursor;
                this.prepared = 0;
                this.feature = this.preparedFeature;
                Object result = this.preparedResult;
                this.hasPrevious();
                return result;
            }
            throw new NoSuchElementException();
        }

        public int previousIndex() {
            return this.cursor - 1;
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    public static class ResolvingFeatureIteratorImpl
    extends FeatureIteratorImpl {
        public ResolvingFeatureIteratorImpl(EObject eObject, List eStructuralFeatures) {
            super(eObject, eStructuralFeatures);
        }

        public ResolvingFeatureIteratorImpl(EObject eObject, EStructuralFeature[] eStructuralFeatures) {
            super(eObject, eStructuralFeatures);
        }

        protected boolean resolve() {
            return true;
        }
    }
}

