/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.resource.impl;

import java.io.InputStream;
import java.io.OutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.eclipse.emf.ecore.resource.URIConverter;

public class CryptoCipherImpl
implements URIConverter.Cipher {
    protected static final String ENCRYPTION_SCHEME = "DES";
    protected static final String UNICODE_FORMAT = "UTF-8";
    protected String key;

    public CryptoCipherImpl() {
        this(null);
    }

    public CryptoCipherImpl(String key) {
        this.key = key;
    }

    public OutputStream encrypt(OutputStream outputStream) throws Exception {
        Cipher cipher = Cipher.getInstance(ENCRYPTION_SCHEME);
        cipher.init(1, this.getKey());
        return new CipherOutputStream(outputStream, cipher);
    }

    public void finish(OutputStream outputStream) throws Exception {
        if (outputStream instanceof LocalCipherOutputStream) {
            ((LocalCipherOutputStream)outputStream).finish();
        }
    }

    public InputStream decrypt(InputStream inputStream) throws Exception {
        Cipher cipher = Cipher.getInstance(ENCRYPTION_SCHEME);
        cipher.init(2, this.getKey());
        return new CipherInputStream(inputStream, cipher);
    }

    public void finish(InputStream inputStream) throws Exception {
    }

    protected SecretKey getKey() throws Exception {
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ENCRYPTION_SCHEME);
        DESKeySpec keySpec = new DESKeySpec(this.key.getBytes(UNICODE_FORMAT));
        return keyFactory.generateSecret(keySpec);
    }

    public static class LocalCipherOutputStream
    extends CipherOutputStream {
        protected Cipher cipher;

        public LocalCipherOutputStream(OutputStream os2, Cipher cipher) {
            super(os2, cipher);
            this.cipher = cipher;
        }

        public void finish() throws Exception {
            this.write(this.cipher.doFinal());
            this.flush();
        }
    }
}

