/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.xml;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.soap.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMWriter {
    public static String nodeToString(Node node) {
        StringWriter stringWriter = new StringWriter();
        DOMWriter.serializeAsXML(node, stringWriter);
        return stringWriter.toString();
    }

    public static void serializeAsXML(Node node, Writer writer) {
        DOMWriter.print(node, new PrintWriter(writer));
    }

    private static void print(Node node, PrintWriter printWriter) {
        if (node == null) {
            return;
        }
        boolean bl = false;
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                printWriter.println("<?xml version=\"1.0\"?>");
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    DOMWriter.print(nodeList.item(i), printWriter);
                }
                break;
            }
            case 1: {
                printWriter.print('<' + node.getNodeName());
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = namedNodeMap != null ? namedNodeMap.getLength() : 0;
                for (int i = 0; i < n; ++i) {
                    Attr attr = (Attr)namedNodeMap.item(i);
                    printWriter.print(' ' + attr.getNodeName() + "=\"" + DOMWriter.normalize(attr.getValue()) + '\"');
                }
                NodeList nodeList = node.getChildNodes();
                if (nodeList != null) {
                    int n2 = nodeList.getLength();
                    boolean bl2 = bl = n2 > 0;
                    if (bl) {
                        printWriter.print('>');
                    }
                    for (int i = 0; i < n2; ++i) {
                        DOMWriter.print(nodeList.item(i), printWriter);
                    }
                } else {
                    bl = false;
                }
                if (bl) break;
                printWriter.print("/>");
                break;
            }
            case 5: {
                printWriter.print('&');
                printWriter.print(node.getNodeName());
                printWriter.print(';');
                break;
            }
            case 4: {
                printWriter.print("<![CDATA[");
                printWriter.print(node.getNodeValue());
                printWriter.print("]]>");
                break;
            }
            case 3: {
                printWriter.print(DOMWriter.normalize(node.getNodeValue()));
                break;
            }
            case 8: {
                printWriter.print("<!--");
                printWriter.print(node.getNodeValue());
                printWriter.print("-->");
                break;
            }
            case 7: {
                printWriter.print("<?");
                printWriter.print(node.getNodeName());
                String string = node.getNodeValue();
                if (string != null && string.length() > 0) {
                    printWriter.print(' ');
                    printWriter.print(string);
                }
                printWriter.println("?>");
            }
        }
        if (s == 1 && bl) {
            printWriter.print("</");
            printWriter.print(node.getNodeName());
            printWriter.print('>');
            bl = false;
        }
    }

    private static String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\n': {
                    if (i > 0) {
                        char c2 = stringBuffer.charAt(stringBuffer.length() - 1);
                        if (c2 != '\r') {
                            stringBuffer.append(StringUtils.lineSeparator);
                            continue block7;
                        }
                        stringBuffer.append('\n');
                        continue block7;
                    }
                    stringBuffer.append(StringUtils.lineSeparator);
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

