/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.mail.MessagingException;
import org.apache.soap.SOAPException;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.transport.TransportMessage;
import org.apache.soap.util.mime.ByteArrayDataSource;
import org.apache.soap.util.net.SSLUtils;

public class HTTPUtils {
    private static final String HTTP_VERSION = "1.0";
    private static final int HTTP_DEFAULT_PORT = 80;
    private static final int HTTPS_DEFAULT_PORT = 443;
    public static final int DEFAULT_OUTPUT_BUFFER_SIZE = 512;
    public static boolean traceEnabled = SSLUtils.traceEnabled;
    public static boolean nonProxyTraceEnabled = false;
    static /* synthetic */ Class class$java$lang$String;

    public static boolean shouldUseProxy(String string, String string2) {
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.HTTPUtils.shouldUseProxy > Entry");
            System.out.println("org.apache.soap.util.net.HTTPUtils.shouldUseProxy: host=" + string + " nonProxyHosts=" + string2);
        }
        if (string2 == null || string == null) {
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.HTTPUtils.shouldUseProxy returns true < Exit");
            }
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|\"");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!HTTPUtils.match(string3, string, false, nonProxyTraceEnabled)) continue;
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.HTTPUtils.shouldUseProxy returns false < Exit");
            }
            return false;
        }
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.HTTPUtils.shouldUseProxy returns true < Exit");
        }
        return true;
    }

    private static Socket buildSocket(URL uRL, int n, String string, int n2, String string2, String string3, Boolean bl) throws Exception {
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.buildSocket > Entry");
            System.out.println("org.apache.soap.util.net.buildSocket: url=" + uRL + " targetPort=" + n + " httpProxyHost=" + string + " httpProxyPort=" + n2 + " httpProxyUserName=" + string2 + " httpProxyPassword=***** tcpNoDelay=" + bl);
        }
        Socket socket = null;
        String string4 = null;
        int n3 = n;
        string4 = uRL.getHost();
        if (uRL.getProtocol().equalsIgnoreCase("HTTPS")) {
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.buildSocket: protocol is HTTPS");
            }
            Class<?> clazz = Class.forName("org.apache.soap.util.net.SSLUtils");
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = HTTPUtils.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE, class$java$lang$String == null ? (class$java$lang$String = HTTPUtils.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE, class$java$lang$String == null ? (class$java$lang$String = HTTPUtils.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = HTTPUtils.class$("java.lang.String")) : class$java$lang$String};
            Method method2 = clazz.getMethod("buildSSLSocket", classArray);
            Object[] objectArray = new Object[]{string4, new Integer(n3), string, new Integer(n2), string2, string3};
            socket = (Socket)method2.invoke(null, objectArray);
        } else {
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.buildSocket: protocol is HTTP");
            }
            if (string != null && HTTPUtils.shouldUseProxy(string4, System.getProperty("http.nonProxyHosts"))) {
                string4 = string;
                n3 = n2;
            }
            socket = new Socket(string4, n3);
        }
        if (bl != null && socket != null) {
            socket.setTcpNoDelay(bl);
        }
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.buildSocket < Exit");
        }
        return socket;
    }

    private static int getPort(URL uRL) throws IOException {
        int n;
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.getPort > Entry");
            System.out.println("org.apache.soap.util.net.getPort: url=" + uRL);
        }
        if ((n = uRL.getPort()) < 0) {
            n = uRL.getProtocol().equalsIgnoreCase("HTTPS") ? 443 : 80;
        }
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.getPort returns " + n + " < Exit");
        }
        return n;
    }

    public static TransportMessage post(URL uRL, TransportMessage transportMessage, int n, String string, int n2) throws IllegalArgumentException, IOException, SOAPException {
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.post (url,request,timeout,httpProxyHost,httpProxyPort)> Entry");
        }
        TransportMessage transportMessage2 = HTTPUtils.post(uRL, transportMessage, n, string, n2, null, null, 512, null);
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.post (url,request,timeout,httpProxyHost,httpProxyPort)< Exit");
        }
        return transportMessage2;
    }

    public static TransportMessage post(URL uRL, TransportMessage transportMessage, int n, String string, int n2, int n3) throws IllegalArgumentException, IOException, SOAPException {
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.post (url,request,timeout,httpProxyHost,httpProxyPort,outputBufferSize) > Entry");
        }
        TransportMessage transportMessage2 = HTTPUtils.post(uRL, transportMessage, n, string, n2, null, null, n3, null);
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.post (url,request,timeout,httpProxyHost,httpProxyPort,outputBufferSize)< Exit");
        }
        return transportMessage2;
    }

    public static TransportMessage post(URL uRL, TransportMessage transportMessage, int n, String string, int n2, String string2, String string3, int n3, Boolean bl) throws IllegalArgumentException, IOException, SOAPException {
        Object object;
        Object object2;
        int n4;
        Object object3;
        Object object4;
        Object object5;
        String string4;
        Socket socket;
        int n5;
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.post (url,request,timeout,httpProxyHost,httpProxyPort,outputBufferSize,tcpNoDelay)> Entry");
            System.out.println("org.apache.soap.util.net.post: url=" + uRL + " timeout=" + n + " httpProxyHost=" + string + " httpProxyPort=" + n2 + " outputBufferSize=" + n3 + " tcpNoDelay=" + bl);
        }
        OutputStream outputStream = null;
        InputStream inputStream = null;
        Object var11_11 = null;
        try {
            n5 = HTTPUtils.getPort(uRL);
            socket = HTTPUtils.buildSocket(uRL, n5, string, n2, string2, string3, bl);
            if (uRL.getProtocol().equalsIgnoreCase("HTTPS")) {
                if (traceEnabled) {
                    System.out.println("org.apache.soap.util.net.post: protocol is HTTPS, Ignore proxy from now on. Buildsocket takes handles it");
                }
                string = null;
            }
            if (n > 0) {
                socket.setSoTimeout(n);
            }
            outputStream = socket.getOutputStream();
            inputStream = socket.getInputStream();
        }
        catch (Exception exception) {
            Throwable throwable = exception;
            if (throwable instanceof InvocationTargetException) {
                throwable = ((InvocationTargetException)throwable).getTargetException();
            }
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.post: Caught exception " + exception.toString());
                if (throwable != exception) {
                    System.out.println("org.apache.soap.util.net.post: Target exception " + throwable.toString());
                }
                exception.printStackTrace();
                System.out.println("org.apache.soap.util.net.post: Throwing IllegalArgumentException");
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Error opening socket: " + throwable);
            illegalArgumentException.initCause(throwable);
            throw illegalArgumentException;
        }
        String string5 = string4 = string == null ? uRL.getFile() : uRL.toString();
        if (string4.length() == 0) {
            string4 = "/";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("POST").append(' ').append(string4).append(" HTTP/").append(HTTP_VERSION).append("\r\n").append("Host").append(": ").append(uRL.getHost()).append(':').append(n5).append("\r\n").append("Content-Type").append(": ").append(transportMessage.getContentType()).append("\r\n").append("Content-Length").append(": ").append(transportMessage.getContentLength()).append("\r\n");
        Object object6 = transportMessage.getHeaderNames();
        while (object6.hasMoreElements()) {
            object5 = object6.nextElement();
            stringBuffer.append(object5).append(": ").append(transportMessage.getHeader((String)object5)).append("\r\n");
        }
        stringBuffer.append("\r\n");
        object6 = new BufferedOutputStream(outputStream, n3);
        ((FilterOutputStream)object6).write(stringBuffer.toString().getBytes("iso-8859-1"));
        transportMessage.writeTo((OutputStream)object6);
        ((BufferedOutputStream)object6).flush();
        outputStream.flush();
        object5 = new BufferedInputStream(inputStream);
        int n6 = 0;
        String string6 = null;
        StringBuffer stringBuffer2 = new StringBuffer();
        int n7 = 0;
        while (n7 != 10 && n7 != -1) {
            n7 = ((BufferedInputStream)object5).read();
            if (n7 == 10 || n7 == 13 || n7 == -1) continue;
            stringBuffer2.append((char)n7);
        }
        String string7 = stringBuffer2.toString();
        try {
            object4 = new StringTokenizer(string7);
            ((StringTokenizer)object4).nextToken();
            n6 = Integer.parseInt(((StringTokenizer)object4).nextToken());
            object3 = new StringBuffer();
            while (((StringTokenizer)object4).hasMoreTokens()) {
                ((StringBuffer)object3).append(((StringTokenizer)object4).nextToken());
                if (!((StringTokenizer)object4).hasMoreTokens()) continue;
                ((StringBuffer)object3).append(" ");
            }
            string6 = ((StringBuffer)object3).toString();
        }
        catch (Exception exception) {
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.post: Caught exception " + exception.toString());
                exception.printStackTrace();
                System.out.println("org.apache.soap.util.net.post: Throwing IllegalArgumentException");
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Error parsing HTTP status line \"" + string7 + "\": " + exception);
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
        object4 = new ByteArrayDataSource((InputStream)object5, "iso-8859-1");
        object3 = ((ByteArrayDataSource)object4).toByteArray();
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        int n8 = -1;
        Object object7 = null;
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        boolean bl2 = true;
        for (n4 = 0; n4 < ((Object)object3).length; ++n4) {
            if (object3[n4] == 10) {
                if (stringBuffer3.length() == 0) break;
                object2 = stringBuffer3.toString();
                int n9 = stringBuffer4.length();
                if (n9 > 0 && stringBuffer4.charAt(n9 - 1) == ';') {
                    stringBuffer4.deleteCharAt(n9 - 1);
                }
                object = stringBuffer4.toString();
                if (((String)object2).equalsIgnoreCase("Content-Length")) {
                    n8 = Integer.parseInt(((String)object).trim());
                } else if (((String)object2).equalsIgnoreCase("Content-Type")) {
                    object7 = object;
                } else {
                    Object object8 = hashtable.put(object2, object);
                    if (object8 != null && (((String)object2).equalsIgnoreCase("Set-Cookie") || ((String)object2).equalsIgnoreCase("Set-Cookie2"))) {
                        hashtable.put(object2, (String)object8 + "," + (String)object);
                    }
                }
                stringBuffer3 = new StringBuffer();
                stringBuffer4 = new StringBuffer();
                bl2 = true;
                continue;
            }
            if (object3[n4] == 13) continue;
            if (bl2) {
                if (object3[n4] == 58) {
                    bl2 = false;
                    if (n4 == ((Object)object3).length - 1 || object3[n4 + 1] != 32) continue;
                    ++n4;
                    continue;
                }
                stringBuffer3.append((char)object3[n4]);
                continue;
            }
            stringBuffer4.append((char)object3[n4]);
        }
        object2 = ((ByteArrayDataSource)object4).getInputStream();
        ((InputStream)object2).skip(n4 + 1);
        if (n8 < 0) {
            n8 = ((ByteArrayDataSource)object4).getSize() - n4 - 1;
        }
        try {
            SOAPContext sOAPContext = new SOAPContext();
            object = new TransportMessage((InputStream)object2, n8, (String)object7, sOAPContext, hashtable);
            ((TransportMessage)object).read();
        }
        catch (MessagingException messagingException) {
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.post: Caught exception " + messagingException.toString());
                messagingException.printStackTrace();
                System.out.println("org.apache.soap.util.net.post: Throwing IllegalArgumentException");
            }
            throw new IllegalArgumentException("Error parsing response: " + messagingException);
        }
        ((InputStream)object2).close();
        ((FilterOutputStream)object6).close();
        outputStream.close();
        ((BufferedInputStream)object5).close();
        inputStream.close();
        socket.close();
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.post (url,request,timeout,httpProxyHost,httpProxyPort,outputBufferSize,tcpNoDelay)< Exit");
        }
        return object;
    }

    private static boolean match(String string, String string2, boolean bl, boolean bl2) {
        char c;
        int n;
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        int n2 = 0;
        int n3 = cArray.length - 1;
        int n4 = 0;
        int n5 = cArray2.length - 1;
        boolean bl3 = false;
        if (bl2) {
            System.out.println("org.apache.soap.util.net.HTTPUtils.match: pattern=" + string + " str=" + string2 + " isCaseSensitive=" + bl);
        }
        for (n = 0; n < cArray.length; ++n) {
            if (cArray[n] != '*') continue;
            bl3 = true;
            break;
        }
        if (!bl3) {
            if (n3 != n5) {
                if (bl2) {
                    System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. Pattern and string are not the same size");
                }
                return false;
            }
            for (n = 0; n <= n3; ++n) {
                char c2 = cArray[n];
                if (bl && c2 != cArray2[n]) {
                    if (bl2) {
                        System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. Case sensitive character mismatch");
                    }
                    return false;
                }
                if (bl || Character.toUpperCase(c2) == Character.toUpperCase(cArray2[n])) continue;
                if (bl2) {
                    System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. Case insensitive character mismatch");
                }
                return false;
            }
            if (bl2) {
                System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning true.  Pattern matches.");
            }
            return true;
        }
        if (n3 == 0) {
            if (bl2) {
                System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning true.  Pattern contains only star.");
            }
            return true;
        }
        if (bl2) {
            System.out.println("org.apache.soap.util.net.HTTPUtils.match: Processing chars before first star");
        }
        while ((c = cArray[n2]) != '*' && n4 <= n5) {
            if (bl && c != cArray2[n4]) {
                if (bl2) {
                    System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. Case sensitive character mismatch with chars before first star.");
                }
                return false;
            }
            if (!bl && Character.toUpperCase(c) != Character.toUpperCase(cArray2[n4])) {
                if (bl2) {
                    System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. Case insensitive character mismatch with chars before first star.");
                }
                return false;
            }
            ++n2;
            ++n4;
        }
        if (n4 > n5) {
            for (n = n2; n <= n3; ++n) {
                if (cArray[n] == '*') continue;
                if (bl2) {
                    System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. All characters in the string are used, non-stars left in pattern (1).");
                }
                return false;
            }
            if (bl2) {
                System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning true. All characters in the string are used, only-stars left in pattern (1).");
            }
            return true;
        }
        if (bl2) {
            System.out.println("org.apache.soap.util.net.HTTPUtils.match: Processing chars after last star");
        }
        while ((c = cArray[n3]) != '*' && n4 <= n5) {
            if (bl && c != cArray2[n5]) {
                if (bl2) {
                    System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. Case sensitive character mismatch with chars after last star.");
                }
                return false;
            }
            if (!bl && Character.toUpperCase(c) != Character.toUpperCase(cArray2[n5])) {
                if (bl2) {
                    System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. Case insensitive character mismatch with chars after last star.");
                }
                return false;
            }
            --n3;
            --n5;
        }
        if (n4 > n5) {
            for (n = n2; n <= n3; ++n) {
                if (cArray[n] == '*') continue;
                if (bl2) {
                    System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. All characters in the string are used, non-stars left in pattern (2).");
                }
                return false;
            }
            if (bl2) {
                System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning true. All characters in the string are used, only-stars left in pattern (2).");
            }
            return true;
        }
        if (bl2) {
            System.out.println("org.apache.soap.util.net.HTTPUtils.match: Processing between stars");
        }
        while (n2 != n3 && n4 <= n5) {
            int n6;
            n = -1;
            for (n6 = n2 + 1; n6 <= n3; ++n6) {
                if (cArray[n6] != '*') continue;
                n = n6;
                break;
            }
            if (n == n2 + 1) {
                ++n2;
                continue;
            }
            n6 = n - n2 - 1;
            int n7 = n5 - n4 + 1;
            int n8 = -1;
            block8: for (int i = 0; i <= n7 - n6; ++i) {
                for (int j = 0; j < n6; ++j) {
                    c = cArray[n2 + j + 1];
                    if (bl && c != cArray2[n4 + i + j] || !bl && Character.toUpperCase(c) != Character.toUpperCase(cArray2[n4 + i + j])) continue block8;
                }
                n8 = n4 + i;
                break;
            }
            if (n8 == -1) {
                if (bl2) {
                    System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false");
                }
                return false;
            }
            n2 = n;
            n4 = n8 + n6;
        }
        for (n = n2; n <= n3; ++n) {
            if (cArray[n] == '*') continue;
            if (bl2) {
                System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning false. All characters in the string are used, non-stars left in pattern (3).");
            }
            return false;
        }
        if (bl2) {
            System.out.println("org.apache.soap.util.net.HTTPUtils.match: Returning true. All characters in the string are used, only-stars left in pattern (3).");
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = "org.apache.soap.nonProxy.debug";
        try {
            String string2 = System.getProperty(string);
            boolean bl = SSLUtils.isTrueExplicitly(string2);
            if (bl) {
                nonProxyTraceEnabled = true;
            }
            if (nonProxyTraceEnabled) {
                String string3 = bl ? "enabled" : "disabled";
                System.out.println(string + " is " + string3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

