/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.providers;

import java.io.StringWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpSession;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.RPCRouter;
import org.apache.soap.server.ServiceManager;
import org.apache.soap.server.http.ServerHTTPUtils;
import org.apache.soap.util.Provider;

public class RPCJavaProvider
implements Provider {
    protected DeploymentDescriptor dd;
    protected Envelope envelope;
    protected Call call;
    protected String methodName;
    protected String targetObjectURI;
    protected HttpServlet servlet;
    protected HttpSession session;
    protected Object targetObject;

    public void locate(DeploymentDescriptor deploymentDescriptor, Envelope envelope, Call call, String string, String string2, SOAPContext sOAPContext) throws SOAPException {
        HttpServlet httpServlet = (HttpServlet)sOAPContext.getProperty(Constants.BAG_HTTPSERVLET);
        HttpSession httpSession = (HttpSession)sOAPContext.getProperty(Constants.BAG_HTTPSESSION);
        this.dd = deploymentDescriptor;
        this.envelope = envelope;
        this.call = call;
        this.methodName = string;
        this.targetObjectURI = string2;
        this.servlet = httpServlet;
        this.session = httpSession;
        ServletConfig servletConfig = null;
        ServletContext servletContext = null;
        if (httpServlet != null) {
            servletConfig = httpServlet.getServletConfig();
        }
        if (servletConfig != null) {
            servletContext = servletConfig.getServletContext();
        }
        ServiceManager serviceManager = ServerHTTPUtils.getServiceManagerFromContext(servletContext);
        if (!RPCRouter.validCall(deploymentDescriptor, call)) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Method '" + call.getMethodName() + "' is not supported.");
        }
        this.targetObject = ServerHTTPUtils.getTargetObject(serviceManager, deploymentDescriptor, string2, httpServlet, httpSession, sOAPContext, servletContext);
    }

    public void invoke(SOAPContext sOAPContext, SOAPContext sOAPContext2) throws SOAPException {
        try {
            Response response = RPCRouter.invoke(this.dd, this.call, this.targetObject, sOAPContext, sOAPContext2);
            Envelope envelope = response.buildEnvelope();
            StringWriter stringWriter = new StringWriter();
            envelope.marshall(stringWriter, this.call.getSOAPMappingRegistry(), sOAPContext2);
            sOAPContext2.setRootPart(stringWriter.toString(), "text/xml;charset=utf-8");
        }
        catch (Exception exception) {
            if (exception instanceof SOAPException) {
                throw (SOAPException)exception;
            }
            throw new SOAPException(Constants.FAULT_CODE_SERVER, exception.toString());
        }
    }
}

