/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.rpc;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;

class FactoryFinder {
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$javax$xml$rpc$FactoryFinder;

    FactoryFinder() {
    }

    private static ClassLoader findClassLoader() throws ConfigurationError {
        try {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IllegalAccessException, InvocationTargetException {
                    Method m = null;
                    try {
                        m = (class$java$lang$Thread == null ? (class$java$lang$Thread = FactoryFinder.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", null);
                    }
                    catch (NoSuchMethodException e) {
                        FFDCFilter.processException(e, "javax.xml.rpc.FactoryFinder.findClassLoader", "100");
                        return (class$javax$xml$rpc$FactoryFinder == null ? (class$javax$xml$rpc$FactoryFinder = FactoryFinder.class$("javax.xml.rpc.FactoryFinder")) : class$javax$xml$rpc$FactoryFinder).getClassLoader();
                    }
                    return m.invoke((Object)Thread.currentThread(), null);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            String exceptionString = e instanceof IllegalAccessException ? "Unexpected IllegalAccessException" : (e instanceof InvocationTargetException ? "Unexpected InvocationTargetException" : "Unexpected Exception");
            FFDCFilter.processException(e, "javax.xml.rpc.FactoryFinder.findClassLoader", "140");
            throw new ConfigurationError(exceptionString, e);
        }
    }

    private static Object newInstance(String className, ClassLoader classLoader) throws ConfigurationError {
        try {
            if (classLoader != null) {
                try {
                    return classLoader.loadClass(className).newInstance();
                }
                catch (ClassNotFoundException x) {
                    FFDCFilter.processException(x, "javax.xml.rpc.FactoryFinder.newInstance", "133");
                }
            }
            return Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException x) {
            FFDCFilter.processException(x, "javax.xml.rpc.FactoryFinder.newInstance", "138");
            throw new ConfigurationError("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            FFDCFilter.processException(x, "javax.xml.rpc.FactoryFinder.newInstance", "142");
            throw new ConfigurationError("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    static Object find(String factoryId, String fallbackClassName) throws ConfigurationError {
        ClassLoader classLoader;
        block12: {
            classLoader = FactoryFinder.findClassLoader();
            try {
                String systemProp = System.getProperty(factoryId);
                if (systemProp != null) {
                    return FactoryFinder.newInstance(systemProp, classLoader);
                }
            }
            catch (SecurityException se) {
                FFDCFilter.processException(se, "javax.xml.rpc.FactoryFinder.find", "179");
            }
            try {
                String javah = System.getProperty("java.home");
                final String configFile = javah + File.separator + "lib" + File.separator + "jaxrpc.properties";
                FileInputStream fileInput = (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws FileNotFoundException {
                        File file = new File(configFile);
                        if (file.exists()) {
                            return new FileInputStream(file);
                        }
                        return null;
                    }
                });
                if (fileInput != null) {
                    Properties props = new Properties();
                    props.load(fileInput);
                    String factoryClassName = props.getProperty(factoryId);
                    return FactoryFinder.newInstance(factoryClassName, classLoader);
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException(ex, "javax.xml.rpc.FactoryFinder.find", "196");
            }
            String serviceId = "META-INF/services/" + factoryId;
            try {
                BufferedReader rd;
                InputStream is = null;
                is = classLoader == null ? ClassLoader.getSystemResourceAsStream(serviceId) : classLoader.getResourceAsStream(serviceId);
                if (is == null) break block12;
                try {
                    rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    FFDCFilter.processException(e, "javax.xml.rpc.FactoryFinder.find", "233");
                    rd = new BufferedReader(new InputStreamReader(is));
                }
                String factoryClassName = rd.readLine();
                rd.close();
                if (factoryClassName != null && !"".equals(factoryClassName)) {
                    return FactoryFinder.newInstance(factoryClassName, classLoader);
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException(ex, "javax.xml.rpc.FactoryFinder.find", "247");
            }
        }
        if (fallbackClassName == null) {
            throw new ConfigurationError("Provider for " + factoryId + " cannot be found", null);
        }
        return FactoryFinder.newInstance(fallbackClassName, classLoader);
    }

    static class ConfigurationError
    extends Error {
        private Exception exception;

        ConfigurationError(String msg, Exception x) {
            super(msg);
            this.exception = x;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

