/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.webapp;

import javax.el.ValueExpression;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.webapp.UIComponentClassicTagBase;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

public class ValidatorTag
extends TagSupport {
    private static final long serialVersionUID = -5562623615418158868L;
    private String validatorId = null;
    private String binding = null;

    public void setValidatorId(String validatorId) {
        this.validatorId = validatorId;
    }

    public void setBinding(String binding) throws JspException {
        if (binding != null && !UIComponentTag.isValueReference(binding)) {
            throw new JspException("Invalid Expression:" + binding);
        }
        this.binding = binding;
    }

    @Override
    public int doStartTag() throws JspException {
        UIComponentClassicTagBase tag = UIComponentClassicTagBase.getParentUIComponentClassicTagBase(this.pageContext);
        if (tag == null) {
            throw new JspException("Not nested in a UIComponentTag Error for tag with handler class:" + this.getClass().getName());
        }
        if (!tag.getCreated()) {
            return 0;
        }
        UIComponent component2 = tag.getComponentInstance();
        if (component2 == null) {
            throw new JspException("Can't create Component from tag.");
        }
        if (!(component2 instanceof EditableValueHolder)) {
            throw new JspException("Not nested in a tag of proper type. Error for tag with handler class:" + this.getClass().getName());
        }
        Validator validator = this.createValidator();
        if (validator == null) {
            String validateError = null;
            if (this.binding != null) {
                validateError = this.binding;
            }
            if (this.validatorId != null) {
                validateError = validateError != null ? validateError + " or " + this.validatorId : this.validatorId;
            }
            throw new JspException("Can't create class of type:javax.faces.validator.Validator from:" + validateError);
        }
        ((EditableValueHolder)((Object)component2)).addValidator(validator);
        return 0;
    }

    @Override
    public void release() {
        this.id = null;
    }

    protected Validator createValidator() throws JspException {
        FacesContext context = FacesContext.getCurrentInstance();
        Validator validator = null;
        ValueExpression vb = null;
        if (this.binding != null) {
            try {
                vb = context.getApplication().getExpressionFactory().createValueExpression(context.getELContext(), this.binding, Object.class);
                if (vb != null && (validator = (Validator)vb.getValue(context.getELContext())) != null) {
                    return validator;
                }
            }
            catch (Exception e) {
                throw new JspException(e);
            }
        }
        if (this.validatorId != null) {
            try {
                String validatorIdVal = this.validatorId;
                if (UIComponentTag.isValueReference(this.validatorId)) {
                    ValueExpression idBinding = context.getApplication().getExpressionFactory().createValueExpression(context.getELContext(), this.validatorId, Object.class);
                    validatorIdVal = (String)idBinding.getValue(context.getELContext());
                }
                if ((validator = context.getApplication().createValidator(validatorIdVal)) != null && vb != null) {
                    vb.setValue(context.getELContext(), validator);
                }
            }
            catch (Exception e) {
                throw new JspException(e);
            }
        }
        return validator;
    }
}

