/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soap.transport;

import com.ibm.trl.util.Logger;
import com.ibm.ws.security.util.AccessController;
import com.ibm.xml.soap.transport.EditorComponent;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.PrivilegedAction;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.soap.SOAPException;
import org.apache.soap.transport.EnvelopeEditorAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class PluggableEnvelopeEditor
extends EnvelopeEditorAdapter {
    public static final String ENVELOPE_EDITOR_HOME = "EnvelopeEditorHome";
    static final String INCOMING = "incoming";
    static final String OUTGOING = "outgoing";
    static final String EDITOR_CLASS = "class";
    static final String PARAM_NAME = "param-name";
    static final String PARAM_VALUE = "param-value";
    private final EditorComponent incomingEditor;
    private final EditorComponent outgoingEditor;
    private static final PrivilegedAction getCtxClassLoader = new PrivilegedAction(){

        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };

    public PluggableEnvelopeEditor(InputSource config, String home) throws ParserConfigurationException, IOException, SAXException, SOAPException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(config);
        this.incomingEditor = this.createEditor(doc, INCOMING, home);
        this.outgoingEditor = this.createEditor(doc, OUTGOING, home);
    }

    public EditorComponent createEditor(Document doc, String key, String home) throws SOAPException {
        try {
            Properties props = new Properties();
            Element editorComp = (Element)doc.getElementsByTagName(key).item(0);
            if (editorComp == null) {
                System.out.println("key(" + key + ") not found");
                return null;
            }
            String compName = editorComp.getAttribute(EDITOR_CLASS);
            Logger.normal("EditorComponent class name: " + compName);
            NodeList list = editorComp.getChildNodes();
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                if (list.item(i).getNodeType() != 1) continue;
                Element param = (Element)list.item(i);
                NodeList list1 = param.getChildNodes();
                int length1 = list1.getLength();
                String name = null;
                String value = null;
                for (int j = 0; j < length1; ++j) {
                    if (list1.item(j).getNodeType() != 1) continue;
                    Element el = (Element)list1.item(j);
                    if (el.getTagName().equals(PARAM_NAME)) {
                        name = el.getFirstChild().getNodeValue();
                        continue;
                    }
                    if (el.getTagName().equals(PARAM_VALUE)) {
                        value = el.getFirstChild().getNodeValue();
                        continue;
                    }
                    throw new Exception("Wrong tag name in editor conf file: " + el.getTagName());
                }
                props.setProperty(name, value);
            }
            props.setProperty(ENVELOPE_EDITOR_HOME, home);
            EditorComponent comp = null;
            if (compName != null) {
                ClassLoader cl = (ClassLoader)AccessController.doPrivileged(getCtxClassLoader);
                comp = cl != null ? (EditorComponent)cl.loadClass(compName).newInstance() : (EditorComponent)Class.forName(compName).newInstance();
                Logger.normal(props.toString());
                Logger.normal(props.getProperty("filename"));
                comp.init(props);
            }
            return comp;
        }
        catch (Exception ex) {
            throw new SOAPException("ServerEroor", "Editor Conf Problem", ex);
        }
    }

    public void editIncoming(Reader in, Writer out) throws SOAPException {
        if (this.incomingEditor == null) {
            this.passThrough(in, out);
            return;
        }
        this.incomingEditor.edit(in, out);
    }

    public void editOutgoing(Reader in, Writer out) throws SOAPException {
        if (this.outgoingEditor == null) {
            this.passThrough(in, out);
            return;
        }
        this.outgoingEditor.edit(in, out);
    }

    public static void main(String[] args) throws Exception {
        PluggableEnvelopeEditor editor = new PluggableEnvelopeEditor(new InputSource(args[0]), ".");
        OutputStreamWriter out = new OutputStreamWriter(System.out);
        editor.editOutgoing(new FileReader(args[1]), out);
        ((Writer)out).flush();
        System.out.flush();
    }
}

