/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soap.transport;

import com.ibm.trl.util.Logger;
import com.ibm.trl.util.xml.XPathProcessor;
import com.ibm.xml.soap.transport.EditorComponent;
import com.ibm.xml.soap.transport.ErrorHandlerImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractSOAPHandler
implements EditorComponent {
    private static final String URL_PREFIX_FOR_FILE_PATH = "file:///";
    private static final String CURRENT_DIRECTORY = ".";
    private static final String[] TRUE_VALUES = new String[]{"yes", "on", "true"};
    static final String CONFIG_FILE = "filename";
    protected String home = ".";
    protected final DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();

    protected AbstractSOAPHandler() {
        this.builderFactory.setNamespaceAware(true);
    }

    public void init(Properties props) throws SOAPException {
        String configFilePath = props.getProperty(CONFIG_FILE);
        if (configFilePath == null) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Property 'filename' must be specified");
        }
        Logger.normal(this.getClass().getName() + ": Configuration file path: " + configFilePath, 3);
        this.home = props.getProperty("EnvelopeEditorHome");
        this.home = this.home == null ? CURRENT_DIRECTORY : this.home;
        this.initialize(new InputSource(URL_PREFIX_FOR_FILE_PATH + new File(this.home, configFilePath).getAbsolutePath()));
    }

    public abstract void initialize(InputSource var1) throws SOAPException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document loadDocument(InputSource in, boolean validating) throws SOAPException {
        try {
            DocumentBuilder builder;
            DocumentBuilderFactory documentBuilderFactory = this.builderFactory;
            synchronized (documentBuilderFactory) {
                this.builderFactory.setValidating(validating);
                builder = this.builderFactory.newDocumentBuilder();
            }
            ErrorHandlerImpl errorHandler = new ErrorHandlerImpl();
            builder.setErrorHandler(errorHandler);
            builder.setEntityResolver(new JarEntityResolver());
            Document doc = builder.parse(in);
            if (errorHandler.getErrorCount() > 0) {
                throw new SAXException("Parsing error(s) occured: " + errorHandler.getErrorCount());
            }
            return doc;
        }
        catch (ParserConfigurationException e) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "JAXP error: Coundn't create a document builder due to parser configuration error", e);
        }
        catch (IOException e) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "IO error occured while reading an XML file", e);
        }
        catch (SAXException e) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Parsing error occured while reading an XML file", e);
        }
    }

    public static NodeList processXPath(Node node, String xpath) throws SOAPException {
        try {
            return XPathProcessor.process(node, xpath);
        }
        catch (SAXException e) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Invalid XPath expression: " + xpath, e);
        }
    }

    public static boolean evalFlag(Document config, String xpath) throws SOAPException {
        Node attr = AbstractSOAPHandler.processXPath(config, xpath + "/@flag").item(0);
        if (attr == null) {
            return false;
        }
        return AbstractSOAPHandler.isTrue(attr.getNodeValue());
    }

    public static boolean isTrue(String flag) {
        flag = flag.trim();
        for (int i = 0; i < TRUE_VALUES.length; ++i) {
            if (!TRUE_VALUES[i].equalsIgnoreCase(flag)) continue;
            return true;
        }
        return false;
    }

    public static class JarEntityResolver
    implements EntityResolver {
        public InputSource resolveEntity(String publicId, String systemId) {
            String localResourceName = null;
            if (systemId == null) {
                return null;
            }
            try {
                int ind = systemId.lastIndexOf(47);
                localResourceName = ind < 0 ? systemId : systemId.substring(ind + 1);
                ClassLoader loader = this.getClass().getClassLoader();
                InputStream in = loader == null ? ClassLoader.getSystemResourceAsStream(localResourceName) : loader.getResourceAsStream(localResourceName);
                if (in == null) {
                    return null;
                }
                return new InputSource(in);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

