/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soap.security.dsig;

import com.ibm.trl.soapimpl.SOAPDocumentImpl;
import com.ibm.trl.util.Logger;
import com.ibm.trl.util.xml.DOMHandler;
import com.ibm.trl.util.xml.QName;
import com.ibm.trl.util.xml.XPathProcessor;
import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.xml.soap.security.dsig.SOAPSignatureHandler;
import com.ibm.xml.soap.security.util.SwingPasswordHandler;
import com.ibm.xml.soap.security.util.UnknownAliasException;
import java.io.Reader;
import java.io.Writer;
import java.rmi.server.UID;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class SOAPSigner
extends SOAPSignatureHandler {
    private static final String ELEM_VALUEOFTS = "ValueOfTimestamp";
    private static final String ELEM_VALUEOFNONCE = "ValueOfNonce";
    private static final String ELEM_TS = "timestamp";
    private static final String ELEM_NONCE = "nonce";
    private static final String XPATH_CONFIG = "/" + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "SOAPSignerConfig");
    private static final String XPATH_ACTOR = XPATH_CONFIG + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "SOAPActor");
    private static final String XPATH_KEYSTORE = XPATH_CONFIG + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "KeyStore");
    private static final String XPATH_POLICY = XPATH_CONFIG + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "Policy");
    private static final String XPATH_PRIVATEKEY = XPATH_POLICY + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "PrivateKey");
    private static final String XPATH_PUBLICKEY = XPATH_POLICY + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "PublicKey");
    private static final String XPATH_INCLUDEKEYNAME = XPATH_PUBLICKEY + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "IncludeKeyName");
    private static final String XPATH_INCLUDEKEYVALUE = XPATH_PUBLICKEY + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "IncludeKeyValue");
    private static final String XPATH_INCLUDEX509DATA = XPATH_PUBLICKEY + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "IncludeX509Data");
    private static final String XPATH_TEMPLATE = XPATH_POLICY + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "Template");
    private static final String XPATH_TEMPLATE1 = XPATH_TEMPLATE + "/*[position()=1]";
    private static final String XPATH_SIGNATURE = XPATH_TEMPLATE + '/' + XPathProcessor.getXPath("http://www.w3.org/2000/09/xmldsig#", "Signature");
    private static final String XPATH_KEYINFO = XPATH_SIGNATURE + '/' + XPathProcessor.getXPath("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
    private static final QName QNAME_VALUEOFTS = new QName("http://www.ibm.com/xml/soap/#SOAPSignature", "ValueOfTimestamp");
    private static final QName QNAME_VALUEOFNONCE = new QName("http://www.ibm.com/xml/soap/#SOAPSignature", "ValueOfNonce");
    private SwingPasswordHandler passwordHandler = new SwingPasswordHandler();
    private Key privateKey;
    private KeyInfo keyInfo;
    private Element template;
    private String verifierActorURI;

    public void initialize(InputSource in) throws SOAPException {
        Document config = this.loadDocument(in, false);
        this.verifierActorURI = this.getActorURI(config);
        Logger.normal("Verifier actor URI: " + this.verifierActorURI, 3);
        KeyStore keyStore = this.getKeyStore((Element)SOAPSigner.processXPath(config, XPATH_KEYSTORE).item(0));
        this.privateKey = this.getPrivateKey(config, keyStore);
        this.keyInfo = this.getKeyInfo(config, keyStore);
        this.template = this.getTemplate(config);
    }

    private String getActorURI(Document config) throws SOAPException {
        NodeList actors = SOAPSigner.processXPath(config, XPATH_ACTOR);
        if (actors == null || actors.getLength() < 1) {
            return "";
        }
        Element elem = (Element)actors.item(0);
        if (elem == null) {
            return "";
        }
        return elem.getAttribute("URI");
    }

    private Key getPrivateKey(Document config, KeyStore keyStore) throws SOAPException {
        Element elem = (Element)SOAPSigner.processXPath(config, XPATH_PRIVATEKEY).item(0);
        String alias = elem.getAttribute("alias");
        char[] keypass = elem.getAttribute("keypass").toCharArray();
        if (keypass.length == 0) {
            try {
                keypass = this.passwordHandler.query(alias);
            }
            catch (UnknownAliasException e) {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Couldn't get a key from the key store: alias='" + alias + "': Please check the key password", e);
            }
        }
        Logger.normal("Key alias: " + alias, 3);
        Logger.normal("Key password: " + new String(keypass), 3);
        try {
            return keyStore.getKey(alias, keypass);
        }
        catch (UnrecoverableKeyException e) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Couldn't get a key from the key store: alias='" + alias + "': Please check the key password", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Encountered unknown algorithm while loading a key", e);
        }
        catch (KeyStoreException e) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Couldn't get a key(alias='" + alias + "') from the key store due to a key store exception", e);
        }
    }

    private KeyInfo getKeyInfo(Document config, KeyStore keyStore) throws SOAPException {
        if (SOAPSigner.processXPath(config, XPATH_KEYINFO).item(0) != null) {
            return null;
        }
        Element elem = null;
        elem = (Element)SOAPSigner.processXPath(config, XPATH_PRIVATEKEY).item(0);
        String alias = elem.getAttribute("alias");
        Certificate cert = null;
        try {
            cert = keyStore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Couldn't get a certificate(alias='" + alias + "') from the key store due to a key store exception", e);
        }
        if (cert == null) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "No such key alias: " + alias);
        }
        KeyInfo keyInfo = null;
        if (SOAPSigner.evalFlag(config, XPATH_INCLUDEKEYNAME)) {
            if (keyInfo == null) {
                keyInfo = new KeyInfo();
            }
            Logger.normal("Include KeyName", 3);
            keyInfo.setKeyNames(new String[]{alias});
        }
        if (SOAPSigner.evalFlag(config, XPATH_INCLUDEKEYVALUE)) {
            if (keyInfo == null) {
                keyInfo = new KeyInfo();
            }
            Logger.normal("Include KeyValue", 3);
            keyInfo.setKeyValue((Key)cert.getPublicKey());
        }
        if (SOAPSigner.evalFlag(config, XPATH_INCLUDEX509DATA)) {
            if (keyInfo == null) {
                keyInfo = new KeyInfo();
            }
            Logger.normal("Include X509Data", 3);
            KeyInfo.X509Data x509data = new KeyInfo.X509Data();
            x509data.setCertificate((X509Certificate)cert);
            keyInfo.setX509Data(new KeyInfo.X509Data[]{x509data});
        }
        return keyInfo;
    }

    private Element getTemplate(Document config) throws SOAPException {
        Element elem = (Element)SOAPSigner.processXPath(config, XPATH_TEMPLATE1).item(0);
        Logger.normal("Raw Template:\n" + new String(XPathCanonicalizer.serializeSubset((Node)elem, (boolean)true)), 3);
        return elem;
    }

    public void edit(Reader in, Writer out) throws SOAPException {
        try {
            SOAPDocumentImpl doc = new SOAPDocumentImpl(this.loadDocument(new InputSource(in), false));
            Element template = (Element)doc.getDocument().importNode(this.template, true);
            this.processTimestamp(template);
            this.soapSignature.sign(doc, template, this.privateKey, this.keyInfo, this.verifierActorURI);
            XPathCanonicalizer.serializeAll((Document)doc.getDocument(), (boolean)true, (Writer)out);
        }
        catch (Exception e) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "An exception occured while processing the signature", e);
        }
    }

    private void processTimestamp(Element elem) {
        Element m;
        while ((m = this.findElement(elem, QNAME_VALUEOFTS)) != null) {
            this.replacedBy(m, this.createTimestamp(m.getOwnerDocument()));
        }
    }

    private void processNonce(Element elem) {
        Element m;
        while ((m = this.findElement(elem, QNAME_VALUEOFNONCE)) != null) {
            this.replacedBy(m, this.createNonce(m.getOwnerDocument()));
        }
    }

    private Element createTimestamp(Document fac) {
        Element ts = fac.createElementNS("http://www.ibm.com/xml/soap/#SOAPSignature", ELEM_TS);
        String value = new Date().toString();
        Logger.normal("Timestamp: " + value, 3);
        ts.appendChild(fac.createTextNode(value));
        return ts;
    }

    private Element createNonce(Document fac) {
        Element nonce = fac.createElementNS("http://www.ibm.com/xml/soap/#SOAPSignature", ELEM_NONCE);
        nonce.appendChild(fac.createTextNode(new UID().toString()));
        return nonce;
    }

    private Element findElement(Node node, QName qname) {
        if (DOMHandler.isNodeNamedNS(node, qname)) {
            return (Element)node;
        }
        NodeList list = node.getChildNodes();
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            Element elem = this.findElement(list.item(i), qname);
            if (elem == null) continue;
            return elem;
        }
        return null;
    }

    private void replacedBy(Element me, Element replacement) {
        me.getParentNode().replaceChild(replacement, me);
    }
}

