/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soap.security.dsig;

import com.ibm.trl.soapimpl.SOAPDocumentImpl;
import com.ibm.trl.util.xml.XPathProcessor;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.xml.soap.security.dsig.SOAPSignatureHandler;
import com.ibm.xml.soap.transport.AbstractSOAPHandler;
import java.util.Hashtable;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

final class AuthenticatedPartsChecker {
    private static final String XPATH_SIGNEDINFO = "./" + XPathProcessor.getXPath("http://www.w3.org/2000/09/xmldsig#", "SignedInfo");
    private static final String XPATH_REFERENCE = XPATH_SIGNEDINFO + '/' + XPathProcessor.getXPath("http://www.w3.org/2000/09/xmldsig#", "Reference");
    private static final String XPATH_TRANSFORMS = "./" + XPathProcessor.getXPath("http://www.w3.org/2000/09/xmldsig#", "Transforms");
    private static final String XPATH_TRANSFORM = XPATH_TRANSFORMS + '/' + XPathProcessor.getXPath("http://www.w3.org/2000/09/xmldsig#", "Transform");
    private static final String XPATH_ALGORITHM = XPATH_TRANSFORM + "/@Algorithm";
    private static final int FLAG_BODY = 0;
    private static final int FLAG_ROOT = 1;
    private static final Hashtable table = new Hashtable();
    private boolean[] flags = new boolean[]{false, false};

    AuthenticatedPartsChecker() {
    }

    void setFlag(String part) throws SOAPException {
        Integer partCode = (Integer)table.get(part.trim());
        if (partCode == null) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Unsupported part: '" + part + "', please check <Reference part=\"...\"> in the configuration file");
        }
        int flag = partCode;
        switch (flag) {
            case 0: 
            case 1: {
                this.flags[flag] = true;
                break;
            }
            default: {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Unsupported part: '" + part + "', please check <Reference part=\"...\"> in the configuration file");
            }
        }
    }

    void check(IDResolver idResolver, Element sig) throws SOAPException {
        SOAPDocumentImpl doc = new SOAPDocumentImpl(sig.getOwnerDocument());
        Element envelope = doc.getEnvelope().getDOMEntity();
        Element body = doc.getEnvelope().getBody().getDOMEntity();
        NodeList refs = AbstractSOAPHandler.processXPath(sig, XPATH_REFERENCE);
        this.checkReference(refs);
        if (this.flags[1]) {
            this.checkReference(idResolver, refs, envelope, "http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        }
        if (this.flags[0]) {
            this.checkReference(idResolver, refs, body, null);
        }
    }

    void checkReference(NodeList refs) throws SOAPException {
        int length = refs.getLength();
        for (int i = 0; i < length; ++i) {
            Element ref = (Element)refs.item(i);
            if (!ref.hasAttribute("URI")) {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Reference without URI attribute is not supported.");
            }
            String uri = ref.getAttribute("URI");
            if ("".equals(uri) || uri.startsWith("#")) continue;
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "External Reference is not supported: '" + uri + "'");
        }
    }

    void checkReference(IDResolver idResolver, NodeList refs, Element element, String algorithmURI) throws SOAPException {
        int length = refs.getLength();
        for (int i = 0; i < length; ++i) {
            Element target;
            Element ref = (Element)refs.item(i);
            String id = ref.getAttribute("URI");
            if ("".equals(id)) {
                target = element.getOwnerDocument().getDocumentElement();
            } else {
                if (!id.startsWith("#")) continue;
                id = id.substring(1);
                target = idResolver.resolveID(ref.getOwnerDocument(), id);
            }
            if (target == null || target != element) continue;
            if (algorithmURI == null) {
                return;
            }
            NodeList algos = SOAPSignatureHandler.processXPath(ref, XPATH_ALGORITHM);
            if (algos.getLength() != 1 || !algorithmURI.equals(algos.item(0).getNodeValue())) continue;
            return;
        }
        throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Authenticated Part '" + element.getNodeName() + "' required");
    }

    public String toString() {
        return "AuthenticatedpartsChecker(flag[FLAG_BODY]=" + this.flags[0] + " flag[FLAG_ROOT]=" + this.flags[1] + ")";
    }

    static {
        table.put("body", new Integer(0));
        table.put("root", new Integer(1));
    }
}

