/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.token;

import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.ws.webservices.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.PropertyCallback;
import com.ibm.wsspi.wssecurity.auth.callback.X509BSCallback;
import com.ibm.wsspi.wssecurity.auth.token.TokenId;
import com.ibm.wsspi.wssecurity.auth.token.X509BSToken;
import com.ibm.wsspi.wssecurity.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.token.TokenGeneratorComponent;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Hex;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class X509TokenGenerator
implements TokenGeneratorComponent {
    private static final TraceComponent tc = Tr.register(X509TokenGenerator.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = X509TokenGenerator.class.getName();
    private static final String VALUE_TYPE = "ValueType".intern();
    private static final String ENCODING_TYPE = "EncodingType".intern();
    private static final int ITSHA1_OCTETS = 20;
    private static final int IT60SHA1_OCTETS = 8;
    private static final String OID_KEYIDENTIFIER = "2.5.29.14";
    private static final byte BER_SEQUENCE = 48;
    private static final byte BER_BITSTRING = 3;
    private static final int STATUS_OK = 0;
    private static final int STATUS_CERT_ERROR = 1;
    private static final int STATUS_KEYID_ERROR = 2;
    private static final int STATUS_KEY_ERROR = 4;
    private final Map _cert2info = new Hashtable();
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(Document doc, Element parent, Map context) throws SoapSecurityException {
        CertInformation cinfo;
        Object v;
        boolean isKeyName;
        boolean isKeyId;
        boolean isStrref;
        boolean isEmb;
        boolean isX509;
        QName vtype;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "Map context)"));
        }
        if (parent == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s03", "null");
        }
        TokenGeneratorConfig config = (TokenGeneratorConfig)context.remove("com.ibm.wsspi.wssecurity.config.tokenGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TokenGeneratorConfig [" + config + "]."));
        }
        if (!(com.ibm.ws.webservices.wssecurity.Constants.X509V3.equals(vtype = config.getType()) || com.ibm.ws.webservices.wssecurity.Constants.X509V3_OLD.equals(vtype) || com.ibm.ws.webservices.wssecurity.Constants.PKI_PATH.equals(vtype) || com.ibm.ws.webservices.wssecurity.Constants.PKCS7.equals(vtype))) {
            throw new SoapSecurityException("Unsupported value type: " + vtype);
        }
        SOAPMessageContext messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        int wssVersion = 0;
        Object v2 = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        if (v2 != null && v2 instanceof Integer) {
            wssVersion = (Integer)v2;
        }
        boolean isStandAlone = config.isStandAlone();
        String keyInfoType = (String)context.remove(Constants.WSSECURITY_KEYINFO_TYPE);
        if (keyInfoType == null) {
            isX509 = false;
            isEmb = false;
            isStrref = false;
            isKeyId = false;
            isKeyName = false;
        } else {
            isKeyName = ConfigUtil.isKeyInfoKeyname((String)keyInfoType);
            isKeyId = ConfigUtil.isKeyInfoKeyid((String)keyInfoType);
            isStrref = ConfigUtil.isKeyInfoStrref((String)keyInfoType);
            isEmb = ConfigUtil.isKeyInfoEmb((String)keyInfoType);
            isX509 = ConfigUtil.isKeyInfoX509issuer((String)keyInfoType);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("KeyInfoType: isKeyName, isKeyId, isStrref, isEmb, isX509: " + isKeyName + ", " + isKeyId + ", " + isStrref + ", " + isEmb + ", " + isX509 + "."));
        }
        CallbackHandlerConfig cbhconf = config.getCallbackHandler();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CallbackHandlerConfig [" + config + "]."));
        }
        boolean identityAssertion = false;
        if (cbhconf != null && (v = cbhconf.getProperties().get(Constants.WSSECURITY_USE_IDASSERTION)) != null) {
            identityAssertion = ConfigUtil.isTrue((String)v.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("identityAssertion is [" + identityAssertion + "]."));
        }
        X509Certificate cert = null;
        String binary = null;
        String kspath = null;
        String alias = null;
        if (identityAssertion) {
            Object object;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Checking the cert of initial sender...");
            }
            if (messageContext != null && (object = messageContext.getProperty("com.ibm.wsspi.wssecurity.username.initialSenderCert")) != null && object instanceof X509Certificate) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The cert of initial sender is used.");
                }
                cert = (X509Certificate)object;
                alias = "Initial sender certificate";
            }
        }
        if (cert == null && cbhconf != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Invoking callback handler...");
            }
            HashMap<String, Object> properties = new HashMap<String, Object>();
            String cbhname = cbhconf.getClassName();
            CallbackHandler handler = cbhconf.getInstance();
            if (handler == null) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Instantiating the callback handler [" + cbhname + "]..."));
                    }
                    ClassLoader loader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return Thread.currentThread().getContextClassLoader();
                        }
                    });
                    Class<?> cls = null;
                    cls = loader != null ? loader.loadClass(cbhname) : Class.forName(cbhname);
                    if (!CallbackHandler.class.isAssignableFrom(cls)) throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s17", cbhname, CallbackHandler.class.getName());
                    properties.put("com.ibm.wsspi.wssecurity.config.callbackHandler.configKey", cbhconf);
                    Constructor<?> con = cls.getConstructor(Map.class);
                    handler = (CallbackHandler)con.newInstance(properties);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Succeeded to Instantiate the callback handler [" + cbhname + "]."));
                    }
                }
                catch (SoapSecurityException e) {
                    throw e;
                }
                catch (Exception e) {
                    Tr.processException((Throwable)e, (String)(clsName + ".invoke"), (String)"312");
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.X509TokenGenerator.s01", (Object)new Object[]{cbhname, e});
                    throw SoapSecurityException.format("security.wssecurity.X509TokenGenerator.s01", cbhname, (Throwable)e);
                }
                cbhconf.setInstance(handler);
            }
            String knameRef = null;
            if (isStandAlone) {
                knameRef = "com.ibm.wsspi.wssecurity.token.standAlone";
            } else {
                String kn;
                knameRef = (String)context.remove(Constants.WSSECURITY_KEY_NAMEREF);
                if (knameRef != null && (kn = KeyInfo.X509Data.encodeDName((String)knameRef)) != null && kn.length() > 0) {
                    knameRef = kn;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Reference name of a key[" + knameRef + "]."));
            }
            properties = new HashMap();
            if (messageContext != null) {
                properties.put("com.ibm.wsspi.wssecurity.core.messageContext", messageContext);
            }
            properties.put(Constants.WSSECURITY_KEY_NAMEREF, knameRef);
            if (config.getProvider() != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Provider is " + config.getProvider() + "."));
                }
                properties.put("com.ibm.wsspi.wssecurity.token.x509.provider", config.getProvider());
            }
            if (config.getCertStores() != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("A list of cert stores are " + config.getCertStores() + "."));
                }
                properties.put("com.ibm.wsspi.wssecurity.token.x509.certStores", config.getCertStores());
            }
            Callback[] callbacks = new Callback[]{new X509BSCallback(), new PropertyCallback(properties)};
            try {
                handler.handle(callbacks);
            }
            catch (UnsupportedCallbackException e) {
                Tr.processException((Throwable)e, (String)(clsName + ".invoke"), (String)"380");
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.X509TokenGenerator.s02", (Object)new Object[]{cbhname, e});
                SoapSecurityException soapSecurityException = SoapSecurityException.format("security.wssecurity.X509TokenGenerator.s02", cbhname, (Throwable)e);
                soapSecurityException.initCause(e);
                throw soapSecurityException;
            }
            catch (IOException e) {
                void var28_46;
                IOException iOException = e;
                if (e.getCause() != null) {
                    Throwable throwable = e.getCause();
                }
                Tr.processException((Throwable)e, (String)(clsName + ".invoke"), (String)"389");
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.X509TokenGenerator.s02", (Object)new Object[]{cbhname, var28_46});
                SoapSecurityException sse = SoapSecurityException.format("security.wssecurity.X509TokenGenerator.s02", cbhname, (Throwable)var28_46);
                sse.initCause(e);
                throw sse;
            }
            X509BSCallback callback = (X509BSCallback)callbacks[0];
            cert = callback.getCert();
            if (callback.getBinary() != null) {
                binary = Base64.encode((byte[])callback.getBinary());
            }
            kspath = callback.getKeyStorePath();
            alias = callback.getAlias();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Succeeded to invoke the callback handler [" + cbhname + "]."));
            }
        }
        if ((cinfo = X509TokenGenerator.getInfo(this._cert2info, kspath, alias, cert, binary)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WARNING: Can't get necessary information about the certificate");
            }
        } else if (binary == null) {
            binary = cinfo.getBinary();
        }
        if (cert == null || binary == null) {
            throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.setCertToSubject01");
        }
        X509BSToken existToken = X509TokenGenerator.checkToken(context, config, keyInfoType, cert);
        boolean requireParent = false;
        boolean createElem = true;
        boolean insertElem = false;
        boolean insertToken = true;
        Object var28_47 = null;
        String tokenId = null;
        String reference = null;
        String keyId = null;
        String subjectDN = null;
        String issuerDN = null;
        String issuerSerial = null;
        if (isStandAlone || isStrref || isEmb) {
            boolean createId = true;
            if (existToken != null) {
                if (isStandAlone || isStrref) {
                    createId = false;
                    createElem = false;
                    insertToken = false;
                } else if (isEmb) {
                    createElem = false;
                    insertToken = true;
                }
            }
            if (!createId) {
                tokenId = existToken.getId();
            } else {
                Object object;
                if (messageContext != null && (object = messageContext.getProperty(Constants.WSSECURITY_TOKEN_PROPERGATION)) != null && object instanceof Set) {
                    for (Object e : (Set)object) {
                        if (!(e instanceof TokenId)) continue;
                        TokenId tid = (TokenId)e;
                        if (!config.getType().equals(tid.getType())) continue;
                        if (tokenId == null) {
                            tokenId = tid.getId();
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("More than one TokenId objects are found. Since the runtime tentatively uses the first identifier + \"" + tokenId + "\"," + " it neglects the identifier \"" + tid.getId() + "\"."));
                    }
                }
                if (tokenId == null) {
                    tokenId = IdUtil.getInstance().makeUniqueId(doc, "x509bst_");
                }
                requireParent = true;
                insertElem = true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("TokenIdentifier [" + tokenId + "]."));
            }
            if (isStrref) {
                String string = tokenId;
                reference = "#" + tokenId;
            } else if (isStandAlone) {
                String string = tokenId;
            }
        } else if (isKeyId) {
            if (cinfo == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"WARNING: Can't get necessary information about the certificate");
                }
            } else {
                QName etype = (QName)context.remove(Constants.WSSECURITY_KEY_ENCODING);
                QName idtype = (QName)context.remove(Constants.WSSECURITY_KEY_IDTYPE);
                if (etype == null || NamespaceUtil.equals(etype, com.ibm.ws.webservices.wssecurity.Constants.BASE64_BINARY)) {
                    if (idtype == null || NamespaceUtil.equals(idtype, com.ibm.ws.webservices.wssecurity.Constants.ITSHA1)) {
                        tokenId = cinfo.getB64KeyId();
                    } else {
                        if (!NamespaceUtil.equals(idtype, com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1)) throw new SoapSecurityException(ConfigUtil.getMessage((String)"security.wssecurityKeyStoreKeyLocator.generateIdentifier01") + ": " + idtype);
                        tokenId = cinfo.getB64KeyId60();
                    }
                } else {
                    if (!NamespaceUtil.equals(etype, com.ibm.ws.webservices.wssecurity.Constants.HEX_BINARY)) throw SoapSecurityException.format("security.wssecurity.BinaryTokenReceiver.token15", etype.toString());
                    if (idtype == null || NamespaceUtil.equals(idtype, com.ibm.ws.webservices.wssecurity.Constants.ITSHA1)) {
                        tokenId = cinfo.getHexKeyId();
                    } else {
                        if (!NamespaceUtil.equals(idtype, com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1)) throw new SoapSecurityException(ConfigUtil.getMessage((String)"security.wssecurityKeyStoreKeyLocator.generateIdentifier01") + ": " + idtype);
                        tokenId = cinfo.getHexKeyId60();
                    }
                }
                keyId = tokenId;
                if (existToken != null && tokenId.equals(existToken.getId())) {
                    createElem = false;
                    insertToken = false;
                }
            }
        } else if (isKeyName) {
            if (cinfo == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"WARNING: Can't get necessary information about the certificate");
                }
            } else {
                subjectDN = tokenId = cinfo.getSubjectName();
            }
            if (existToken != null && tokenId.equals(existToken.getId())) {
                createElem = false;
                insertToken = false;
            }
        } else if (isX509) {
            if (cinfo == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"WARNING: Can't get necessary information about the certificate");
                }
            } else {
                tokenId = cinfo.getIssuerName() + ":" + cinfo.getIssuerSerial();
                issuerDN = cinfo.getIssuerName();
                issuerSerial = cinfo.getIssuerSerial();
            }
            if (existToken != null && tokenId.equals(existToken.getId())) {
                createElem = false;
                insertToken = false;
            }
        }
        if (isEmb) {
            context.put(Constants.WSSECURITY_KEY_EMBID, tokenId);
        } else {
            context.remove(Constants.WSSECURITY_KEY_EMBID);
        }
        if (reference != null) {
            context.put(Constants.WSSECURITY_KEY_REFERENCE, reference);
        } else {
            context.remove(Constants.WSSECURITY_KEY_REFERENCE);
        }
        if (keyId != null) {
            context.put(Constants.WSSECURITY_KEY_ID, keyId);
        } else {
            context.remove(Constants.WSSECURITY_KEY_ID);
        }
        if (subjectDN != null) {
            context.put(Constants.WSSECURITY_KEY_NAME, subjectDN);
        } else {
            context.remove(Constants.WSSECURITY_KEY_NAME);
        }
        if (issuerDN != null) {
            context.put(Constants.WSSECURITY_KEY_ISSUERNAME, issuerDN);
        } else {
            context.remove(Constants.WSSECURITY_KEY_ISSUERNAME);
        }
        if (issuerSerial != null) {
            context.put(Constants.WSSECURITY_KEY_ISSUERSERIAL, issuerSerial);
        } else {
            context.remove(Constants.WSSECURITY_KEY_ISSUERSERIAL);
        }
        Element elem = null;
        if (insertElem || insertToken) {
            if (createElem) {
                void var28_50;
                Element p = requireParent ? parent : null;
                elem = X509TokenGenerator.createTokenElement(doc, p, config.getType(), binary, (String)var28_50, wssVersion);
            } else if (existToken != null) {
                elem = (Element)existToken.getElement().cloneNode(true);
            }
        }
        if (insertElem) {
            elem = (Element)parent.insertBefore(elem, parent.getFirstChild());
        }
        if (insertToken) {
            X509TokenGenerator.setTokenToSubject(context, config, cert, tokenId, keyInfoType, elem);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"invoke(Document doc,Element parent,Map context)");
    }

    private static X509BSToken checkToken(Map context, TokenGeneratorConfig config, String keyInfoType, X509Certificate cert) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkToken(Map context,TokenGeneratorConfig config,String keyInfoType[" + keyInfoType + "]," + "X509Certificate cert)"));
        }
        X509BSToken ret = null;
        Set tokens = TokenManager.getTokens(context);
        if (tokens != null && tokens.size() > 0) {
            for (Object o : tokens) {
                X509BSToken t;
                if (!(o instanceof X509BSToken) || !(t = (X509BSToken)o).getUsedTokenGenerator().equals(config) || !t.getKeyInfoType().equals(keyInfoType) || !t.getCert().equals(cert)) continue;
                ret = t;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkToken(Map context,TokenGeneratorConfig config,String keyInfoType,X509Certificate cert) returns X509BSToken[" + ret + "]"));
        }
        return ret;
    }

    protected static Element createTokenElement(Document doc, Element parent, QName valueType, String binary, String insertId, int wssVersion) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createTokenElement(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "QName tokenType[" + valueType + "]," + "String binary," + "String insertId[" + insertId + "]," + "int wssVersion[" + wssVersion + "])"));
        }
        String nsWsse = com.ibm.ws.webservices.wssecurity.Constants.NAMESPACES[0][wssVersion];
        String nsWsu = com.ibm.ws.webservices.wssecurity.Constants.NAMESPACES[1][wssVersion];
        boolean isDecl = false;
        String pWsse = null;
        if (parent != null) {
            pWsse = DOMUtil.getNamespacePrefix((Element)parent, (String)nsWsse);
        }
        if (pWsse == null) {
            isDecl = true;
            pWsse = "wsse:";
        } else if (pWsse.length() > 0) {
            pWsse = pWsse + ":";
        }
        Element tokenElem = doc.createElementNS(nsWsse, pWsse + "BinarySecurityToken");
        if (isDecl) {
            tokenElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", nsWsse);
        }
        if (insertId != null) {
            isDecl = false;
            String pWsu = DOMUtil.getNamespacePrefix((Element)parent, (String)nsWsu);
            if (pWsu == null) {
                isDecl = true;
                pWsu = "wsu:";
            } else if (pWsu.length() > 0) {
                pWsu = pWsu + ":";
            }
            if (isDecl) {
                tokenElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", nsWsu);
            }
            tokenElem.setAttributeNS(nsWsu, pWsu + "Id", insertId);
        }
        DOMUtil.setQNameAttr(tokenElem, null, ENCODING_TYPE, com.ibm.ws.webservices.wssecurity.Constants.BASE64_BINARY, wssVersion);
        DOMUtil.setQNameAttr(tokenElem, null, VALUE_TYPE, valueType, wssVersion);
        if (binary != null) {
            tokenElem.appendChild(doc.createTextNode(binary));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createTokenElement(Document doc,Element parent,QName valueType,byte[] binary,String insertId,int wssVersion) returns Element[" + DOMUtil.getDisplayName((Node)tokenElem) + "]"));
        }
        return tokenElem;
    }

    private static void setTokenToSubject(Map context, TokenGeneratorConfig config, X509Certificate cert, String tokenId, String keyInfoType, Element elem) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setTokenToSubject(Map context,TokenGeneratorConfig config,X509Certificate cert,String tokenId[" + tokenId + "]," + "String keyInfoType[" + keyInfoType + "]," + "Element elem[" + DOMUtil.getDisplayName((Node)elem) + "])"));
        }
        X509BSToken token = new X509BSToken(tokenId, cert, config.getType());
        token.setElement(elem);
        token.setReferenced(!config.isStandAlone());
        token.setUsedTokenGenerator(config);
        token.setKeyInfoType(keyInfoType);
        TokenManager.setToken(context, token);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setTokenToSubject(Map context,TokenGeneratorConfig config,X509Certificate cert,String tokenId,Element elem)");
        }
    }

    private static CertInformation getInfo(Map cert2info, String kspath, String alias, X509Certificate x509, String binary) throws SoapSecurityException {
        CertInformation cinfo;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getInfo(Map cert2info,String kspath[" + kspath + "]," + "String alias[" + alias + "]," + "X509Certificate x509," + "String binary)"));
        }
        if ((cinfo = (CertInformation)cert2info.get(x509)) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The cached information corresponding the specified certficate is found.");
            }
        } else if (x509 != null) {
            int status = 0;
            String errorMes = null;
            String subjectDN = x509.getSubjectDN().getName();
            String encSubjectDN = KeyInfo.X509Data.encodeDName((String)subjectDN);
            String issuerDN = x509.getIssuerDN().getName();
            String encIssuerDN = KeyInfo.X509Data.encodeDName((String)issuerDN);
            String issuerSerial = x509.getSerialNumber().toString();
            long expiration = x509.getNotAfter().getTime();
            try {
                if (binary == null) {
                    binary = Base64.encode((byte[])x509.getEncoded());
                }
                x509.checkValidity();
            }
            catch (CertificateEncodingException e) {
                ++status;
                errorMes = ConfigUtil.getMessage((String)"security.wssecurity.X509BSToken.getBytes01", (String[])new String[]{alias});
            }
            catch (CertificateExpiredException e) {
                ++status;
                errorMes = ConfigUtil.getMessage((String)"security.wssecurity.WSEC5181E", (String[])new String[]{subjectDN, alias, kspath, e.getClass().getName() + ": " + e.getMessage()});
            }
            catch (CertificateException e) {
                ++status;
                errorMes = ConfigUtil.getMessage((String)"security.wssecurity.WSEC5182E", (String[])new String[]{subjectDN, alias, kspath, e.getClass().getName() + ": " + e.getMessage()});
            }
            String b64KeyId = null;
            String b64KeyId60 = null;
            String hexKeyId = null;
            String hexKeyId60 = null;
            if (status == 0) {
                try {
                    byte[] keyid = X509TokenGenerator.makeIdentifier(x509, null);
                    b64KeyId = Base64.encode((byte[])keyid);
                    hexKeyId = Hex.encode((byte[])keyid);
                    keyid = X509TokenGenerator.makeIdentifier(x509, com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1);
                    b64KeyId60 = Base64.encode((byte[])keyid);
                    hexKeyId60 = Hex.encode((byte[])keyid);
                }
                catch (NoSuchAlgorithmException e) {
                    status += 2;
                    errorMes = ConfigUtil.getMessage((String)"security.wssecurity.KeyStoreKeyLocator.generateIdentifier01") + ": " + e.getClass().getName() + ": " + e.getMessage();
                }
                catch (InvalidAlgorithmParameterException e) {
                    status += 2;
                    errorMes = ConfigUtil.getMessage((String)"security.wssecurity.KeyStoreKeyLocator.generateIdentifier01") + ": " + e.getClass() + ": " + e.getMessage();
                }
            }
            cinfo = new CertInformation(kspath, alias, binary, subjectDN, encSubjectDN, issuerDN, encIssuerDN, issuerSerial, b64KeyId, b64KeyId60, hexKeyId, hexKeyId60, expiration, status, errorMes);
            cert2info.put(x509, cinfo);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Added Certificate information: " + cinfo + "."));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getInfo(Map cert2info,String kspath,String alias,X509Certificate x509,byte[] binary) returns CertInformation[" + cinfo + "]"));
        }
        return cinfo;
    }

    private static byte[] certToIdentifier(Certificate cert) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"certToIdentifier(Certificate cert)");
        }
        if (!(cert instanceof X509Certificate)) {
            return null;
        }
        byte[] der = ((X509Certificate)cert).getExtensionValue(OID_KEYIDENTIFIER);
        if (der == null) {
            return null;
        }
        byte[] ki = new byte[der.length - 4];
        System.arraycopy(der, 4, ki, 0, der.length - 4);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"certToIdentifier(Certificate cert)");
        }
        return ki;
    }

    private static byte[] pubkeyToIdentifier(Certificate cert, QName idty) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("pubkeyToIdentifier(Certificate cert,QName idty[" + idty + "])"));
        }
        byte[] bits = null;
        if (cert != null) {
            byte[] key = cert.getPublicKey().getEncoded();
            if (key[0] != 48) {
                throw new RuntimeException("Unknown encoded key: " + Hex.encode((byte[])key));
            }
            int len = key[1] & 0xFF;
            int offset = (len & 0x80) == 0 ? 2 : 2 + (len & 0x7F);
            len = key[offset + 1] & 0xFF;
            if ((len & 0x80) == 0) {
                offset += 2;
            } else {
                int lenoff = offset + 2;
                offset += 2 + (len & 0x7F);
                switch (len & 0x7F) {
                    case 1: {
                        len = key[lenoff] & 0xFF;
                        break;
                    }
                    case 2: {
                        len = ((key[lenoff] & 0xFF) << 8) + (key[lenoff + 1] & 0xFF);
                        break;
                    }
                    case 3: {
                        len = ((key[lenoff] & 0xFF) << 16) + ((key[lenoff + 1] & 0xFF) << 8) + (key[lenoff + 2] & 0xFF);
                        break;
                    }
                    case 4: {
                        len = ((key[lenoff] & 0xFF) << 24) + ((key[lenoff + 1] & 0xFF) << 16) + ((key[lenoff + 2] & 0xFF) << 8) + (key[lenoff + 3] & 0xFF);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Integer overflow: " + Hex.encode((byte[])key));
                    }
                }
            }
            if (key[offset += len] != 3) {
                throw new RuntimeException("Non BIT STRING: 0x" + Integer.toString(key[offset] & 0xFF, 16));
            }
            offset += ((len = key[offset + 1] & 0xFF) & 0x80) == 0 ? 3 : 3 + (len & 0x7F);
            AlgorithmFactory factory = AlgorithmFactory.getInstance();
            MessageDigest digester = factory.getMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", null);
            if (NamespaceUtil.equals(idty, com.ibm.ws.webservices.wssecurity.Constants.ITSHA1) || idty == null) {
                digester.update(key, offset, key.length - offset);
                bits = digester.digest();
                factory.releaseMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", digester);
            } else if (NamespaceUtil.equals(idty, com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1)) {
                digester.update(key, offset, key.length - offset);
                byte[] digest = digester.digest();
                factory.releaseMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", digester);
                bits = new byte[8];
                bits[0] = (byte)(64 + (digest[digest.length - 8] & 0xF));
                System.arraycopy(digest, digest.length - 8 + 1, bits, 1, bits.length - 1);
            } else {
                factory.releaseMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", digester);
                throw new IllegalArgumentException("Internal Error: " + idty);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"pubkeyToIdentifier(Certificate cert,QName idty)");
        }
        return bits;
    }

    private static byte[] makeIdentifier(Certificate cert, QName idty) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("makeIdentifier(Certificate cert,QName idty[" + idty + "])"));
        }
        byte[] bits = null;
        if (cert != null && ((bits = X509TokenGenerator.certToIdentifier(cert)) == null || idty != null)) {
            if (idty == null || NamespaceUtil.equals(idty, com.ibm.ws.webservices.wssecurity.Constants.ITSHA1)) {
                if (bits == null || bits.length != 20) {
                    bits = X509TokenGenerator.pubkeyToIdentifier(cert, idty);
                }
            } else if (NamespaceUtil.equals(idty, com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1)) {
                if (bits == null || bits.length != 8) {
                    bits = X509TokenGenerator.pubkeyToIdentifier(cert, idty);
                }
            } else {
                throw new IllegalArgumentException("Internal Error: " + idty);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"makeIdentifier(Certificate cert,QName idty)");
        }
        return bits;
    }

    private static class CertInformation {
        private String _kspath;
        private String _alias;
        private String _binary;
        private String _subjectDN;
        private String _encSubjectDN;
        private String _issuerDN;
        private String _encIssuerDN;
        private String _issuerSerial;
        private String _b64KeyId;
        private String _b64KeyId60;
        private String _hexKeyId;
        private String _hexKeyId60;
        private int _status;
        private long _expiration;
        private String _errorMes;

        private CertInformation(String kspath, String alias, String binary, String subjectDN, String encSubjectDN, String issuerDN, String encIssuerDN, String issuerSerial, String b64KeyId, String b64KeyId60, String hexKeyId, String hexKeyId60, long expiration, int status, String errorMes) {
            this._kspath = kspath;
            this._alias = alias;
            this._binary = binary;
            this._subjectDN = subjectDN;
            this._encSubjectDN = encSubjectDN;
            this._issuerDN = issuerDN;
            this._encIssuerDN = encIssuerDN;
            this._issuerSerial = issuerSerial;
            this._b64KeyId = b64KeyId;
            this._b64KeyId60 = b64KeyId60;
            this._hexKeyId = hexKeyId;
            this._hexKeyId60 = hexKeyId60;
            this._expiration = expiration;
            this._status = status;
            this._errorMes = errorMes;
        }

        private String getBinary() throws SoapSecurityException {
            if ((this._status & 1) == 1) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._binary;
        }

        private String getSubjectName() throws SoapSecurityException {
            if ((this._status & 1) == 1) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._encSubjectDN;
        }

        private String getIssuerName() throws SoapSecurityException {
            if ((this._status & 1) == 1) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._encIssuerDN;
        }

        private String getIssuerSerial() throws SoapSecurityException {
            if ((this._status & 1) == 1) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._issuerSerial;
        }

        private String getB64KeyId() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 4) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._b64KeyId;
        }

        private String getB64KeyId60() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 4) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._b64KeyId60;
        }

        private String getHexKeyId() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 4) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._hexKeyId;
        }

        private String getHexKeyId60() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 4) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._hexKeyId60;
        }

        private void checkExpiration() throws SoapSecurityException {
            long millisBeforeExpiration;
            if (this._expiration >= 0L && (millisBeforeExpiration = this._expiration - System.currentTimeMillis()) < 0L) {
                ++this._status;
                this._errorMes = ConfigUtil.getMessage((String)"security.wssecurity.WSEC5181E", (String[])new String[]{this._subjectDN, this._alias, this._kspath, "expiration time - current system time = " + millisBeforeExpiration + " ms."});
                throw new SoapSecurityException(this._errorMes);
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("keystorePath=[").append(this._kspath).append("], ");
            buf.append("alias=[").append(this._alias).append("], ");
            buf.append("status=[").append(this._status).append("], ");
            buf.append(")");
            return buf.toString();
        }
    }
}

