/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.token;

import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditEventGeneratorImpl;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditService;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditServiceImpl;
import com.ibm.ws.webservices.wssecurity.token.CertCacheManager;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.WSCallbackHandlerFactoryImpl;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.wsspi.wssecurity.auth.token.X509BSToken;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.keyinfo.KeyLocator;
import com.ibm.wsspi.wssecurity.token.TokenConsumerComponent;
import com.ibm.wsspi.wssecurity.token.X509TokenGenerator;
import com.ibm.xml.soapsec.token.UserRegistry;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class X509TokenConsumer
implements TokenConsumerComponent {
    private static final TraceComponent tc = Tr.register(X509TokenConsumer.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = X509TokenConsumer.class.getName();
    private static final String DEFAULT_CACHE_NAME = "WSSCertCache";
    private static final int DEFAULT_CACHE_SIZE = 100;
    private static final int DEFAULT_CACHE_TIMEOUT = 900;
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public void invoke(Node target, Map context) throws SoapSecurityException {
        boolean isNone;
        boolean isKeyName;
        boolean isKeyId;
        boolean isStrref;
        boolean isEmb;
        boolean isX509;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Node target[" + DOMUtil.getDisplayName((Node)target) + "]," + "Map context)"));
        }
        TokenConsumerConfig config = (TokenConsumerConfig)context.remove("com.ibm.wsspi.wssecurity.config.tokenConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TokenConsumerConfig [" + config + "]."));
        }
        CertCacheManager cmanager = (CertCacheManager)context.get(CertCacheManager.class);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The CertCacheManager is " + (cmanager == null ? "null." : "not null,")));
        }
        SOAPMessageContext messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        String keyInfoType = (String)context.remove(Constants.WSSECURITY_KEYINFO_TYPE);
        if (keyInfoType == null) {
            isX509 = false;
            isEmb = false;
            isStrref = false;
            isKeyId = false;
            isKeyName = false;
        } else {
            isKeyName = ConfigUtil.isKeyInfoKeyname((String)keyInfoType);
            isKeyId = ConfigUtil.isKeyInfoKeyid((String)keyInfoType);
            isStrref = ConfigUtil.isKeyInfoStrref((String)keyInfoType);
            isEmb = ConfigUtil.isKeyInfoEmb((String)keyInfoType);
            isX509 = ConfigUtil.isKeyInfoX509issuer((String)keyInfoType);
        }
        boolean bl = isNone = !isKeyName && !isKeyId && !isStrref && !isEmb && !isX509;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("KeyInfoType [" + keyInfoType + "]."));
        }
        if (target.getNodeType() == 9) {
            if (isEmb) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("WARNING: Unexpected KeyInfo's type [" + keyInfoType + "] was found."));
                }
            } else if (isNone) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"WARNING: The element to be consumed was not found.");
                }
            } else {
                X509TokenConsumer.invoke((Document)target, config, cmanager, messageContext, keyInfoType, isKeyName, isKeyId, isStrref, isX509, context);
            }
        } else if (target.getNodeType() == 1) {
            if (isKeyName || isKeyId || isStrref || isX509) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("WARNING: Unexpected KeyInfo's type [" + keyInfoType + "] was found."));
                }
            } else {
                X509TokenConsumer.invoke((Element)target, config, cmanager, messageContext, isNone, isEmb, context);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WARNING: Unsupported node type: " + target.getNodeName()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Element target,Map context)");
        }
    }

    private static void invoke(Document doc, TokenConsumerConfig config, CertCacheManager cmanager, SOAPMessageContext messageContext, String keyInfoType, boolean isKeyName, boolean isKeyId, boolean isStrref, boolean isX509, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Document doc,TokenConsumerConfig config,CertCacheManager cmanager,SOAPMessageContext messageContext,String keyInfoType[" + keyInfoType + "]," + "boolean isKeyName[" + isKeyName + "]," + "boolean isKeyId[" + isKeyId + "]," + "boolean isStrref[" + isStrref + "]," + "boolean isX509[" + isX509 + "]," + "Map context)"));
        }
        int wssVersion = 0;
        Object obj = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        if (isStrref) {
            Token token;
            String tokenId = (String)context.remove(Constants.WSSECURITY_KEY_REFERENCE);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Token identifier is [" + tokenId + "]"));
            }
            if ((token = TokenManager.getToken(context, config, tokenId)) == null) {
                Tr.debug((TraceComponent)tc, (String)("WARNING: X509BSToken whose identifier is \"" + tokenId + "\" was not found in the Subject."));
            } else {
                Tr.debug((TraceComponent)tc, (String)"There was the token that this X509TokenConsumer processed before in the Subject.");
            }
        } else {
            X509BSToken token;
            HashMap<String, Object> type = new HashMap<String, Object>();
            type.put(Constants.WSSECURITY_KEYINFO_TYPE, keyInfoType);
            String tokenId = null;
            if (isKeyId) {
                tokenId = (String)context.remove(Constants.WSSECURITY_KEY_ID);
                type.put(Constants.WSSECURITY_KEY_ID, tokenId);
                QName idtype = (QName)context.remove(Constants.WSSECURITY_KEY_IDTYPE);
                QName etype = (QName)context.remove(Constants.WSSECURITY_KEY_ENCODING);
                QName vtype = (QName)context.remove(Constants.WSSECURITY_KEY_VALUETYPE);
                type.put(Constants.WSSECURITY_KEY_IDTYPE, idtype);
                type.put(Constants.WSSECURITY_KEY_ENCODING, etype);
                type.put(Constants.WSSECURITY_KEY_VALUETYPE, vtype);
            } else if (isKeyName) {
                tokenId = (String)context.remove(Constants.WSSECURITY_KEY_NAME);
                type.put(Constants.WSSECURITY_KEY_NAME, tokenId);
            } else if (isX509) {
                String issuerName = (String)context.remove(Constants.WSSECURITY_KEY_ISSUERNAME);
                String issuerSerial = (String)context.remove(Constants.WSSECURITY_KEY_ISSUERSERIAL);
                type.put(Constants.WSSECURITY_KEY_ISSUERNAME, issuerName);
                type.put(Constants.WSSECURITY_KEY_ISSUERSERIAL, issuerSerial);
                if (issuerName != null && issuerSerial != null) {
                    tokenId = issuerName + ":" + issuerSerial;
                }
            }
            String keyType = (String)context.remove(Constants.WSSECURITY_KEY_TYPE);
            type.put(Constants.WSSECURITY_KEY_TYPE, keyType);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Token identifier is [" + tokenId + "]"));
                Tr.debug((TraceComponent)tc, (String)("The type of a key is [" + keyType + "]."));
            }
            if ((token = (X509BSToken)TokenManager.getToken(context, config, tokenId)) == null) {
                final X509BSToken tokenPrivSetUsedTokenConsumer = token = new X509BSToken(tokenId, null, config.getType());
                final TokenConsumerConfig configPriv = config;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        tokenPrivSetUsedTokenConsumer.setUsedTokenConsumer(configPriv);
                        return null;
                    }
                });
                X509TokenConsumer.setTokenToSubject(context, token);
                QName vtype = config.getType();
                if (!(com.ibm.ws.webservices.wssecurity.Constants.X509V3.equals(vtype) || com.ibm.ws.webservices.wssecurity.Constants.X509V3_OLD.equals(vtype) || com.ibm.ws.webservices.wssecurity.Constants.PKI_PATH.equals(vtype) || com.ibm.ws.webservices.wssecurity.Constants.PKCS7.equals(vtype))) {
                    throw new SoapSecurityException("Unsupported value type: " + vtype);
                }
                if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.SUCCESS) || WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.DENIED)) {
                    WSSAuditEventGeneratorImpl.getInstance().setExtendedAuditData(context, "TokenId", tokenId);
                }
                X509Certificate x509 = null;
                if (cmanager != null) {
                    Certificate cert;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Checking the cached X509Certificate object with the key[" + tokenId + "]."));
                    }
                    if ((cert = cmanager.getCachedCert(tokenId)) == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"There is no cached certificiate.");
                        }
                    } else if (cert instanceof X509Certificate) {
                        x509 = (X509Certificate)cert;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("The X509Certificate [" + x509.getSubjectDN().getName() + "] was found."));
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("WARNING: The certificate [" + cert.getClass().getName() + "] was found, but it's not the X509Certificate object."));
                    }
                }
                if (x509 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Getting the X509Certificate object through the LoginModule.");
                    }
                    KeyLocator klocator = (KeyLocator)context.remove("com.ibm.wsspi.wssecurity.token.x509.keyLocator");
                    klocator.getKey(type, context);
                    x509 = (X509Certificate)context.remove("com.ibm.wsspi.wssecurity.token.x509.certificate");
                    if (x509 == null) {
                        throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.setCertToSubject01");
                    }
                    X509TokenConsumer.invokeLoginModule(config, x509, null, messageContext, context);
                    if (cmanager != null) {
                        cmanager.cacheCert(tokenId, x509);
                    }
                }
                final X509BSToken tokenPriv = token;
                final X509Certificate x509Priv = x509;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        tokenPriv.setCert(x509Priv);
                        return null;
                    }
                });
                byte[] bytes = (byte[])AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return tokenPriv.getBytes();
                    }
                });
                String binary = Base64.encode((byte[])bytes);
                Element elem = X509TokenGenerator.createTokenElement(doc, null, config.getType(), binary, null, wssVersion);
                token.setElement(elem);
                if (config.getTrustedIDEvaluator() != null) {
                    String securityName = X509TokenConsumer.getSecurityName(x509);
                    final boolean trusted = config.getTrustedIDEvaluator().evaluate(securityName);
                    if (trusted) {
                        Tr.debug((TraceComponent)tc, (String)("SecurityName[" + securityName + "] is trusted."));
                    } else {
                        Tr.warning((TraceComponent)tc, (String)"security.wssecurity.UsernameTokenConsumer.s02", (Object)new Object[]{securityName});
                    }
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            tokenPriv.setTrusted(trusted);
                            return null;
                        }
                    });
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Acquired token is " + token + "."));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Document doc,TokenConsumerConfig config,CertCacheManager cmanager,SOAPMessageContext messageContext,String keyInfoType,boolean isKeyName,boolean isKeyId,boolean isStrref,boolean isX509,Map context)");
        }
    }

    private static void invoke(Element target, TokenConsumerConfig config, CertCacheManager cmanager, SOAPMessageContext messageContext, boolean isNone, boolean isEmb, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Element target,TokenConsumerConfig config,CertCacheManager cmanager,SOAPMessageContext messageContext,boolean isNone[" + isNone + "]," + "boolean isEmb[" + isEmb + "]," + "Map context)"));
        }
        String tokenId = null;
        if (isNone) {
            String idattr = IdUtil.getInstance().getIdAttributeName(target);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The identifier attribute of the target element is [" + idattr + "]."));
            }
            if (idattr != null) {
                tokenId = target.getAttribute(idattr);
            }
        } else if (isEmb) {
            tokenId = (String)context.remove(Constants.WSSECURITY_KEY_EMBID);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Its token identifier is [" + tokenId + "]"));
        }
        X509BSToken token = new X509BSToken(tokenId, null, config.getType());
        Boolean decouple = (Boolean)config.getProperties().get("com.ibm.wsspi.wssecurity.token.decouple");
        boolean decoupleToken = true;
        if (decouple != null) {
            decoupleToken = decouple;
        }
        Element n = null;
        n = !decoupleToken ? target : DOMUtil.clone(target);
        token.setElement(n);
        final X509BSToken tokenPrivSetUsedTokenConsumer = token;
        final TokenConsumerConfig configPriv = config;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                tokenPrivSetUsedTokenConsumer.setUsedTokenConsumer(configPriv);
                return null;
            }
        });
        X509TokenConsumer.setTokenToSubject(context, token);
        if (!isNone && tokenId == null) {
            throw SoapSecurityException.format("security.wssecurity.EmbeddedContentConsumer.getEmbeddedToken02");
        }
        QName vtype = config.getType();
        if (!(com.ibm.ws.webservices.wssecurity.Constants.X509V3.equals(vtype) || com.ibm.ws.webservices.wssecurity.Constants.X509V3_OLD.equals(vtype) || com.ibm.ws.webservices.wssecurity.Constants.PKI_PATH.equals(vtype) || com.ibm.ws.webservices.wssecurity.Constants.PKCS7.equals(vtype))) {
            throw new SoapSecurityException("Unsupported value type: " + vtype);
        }
        if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.SUCCESS) || WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.DENIED)) {
            WSSAuditEventGeneratorImpl.getInstance().setExtendedAuditData(context, "TokenId", tokenId);
        }
        String encoded = DOMUtil.getStringValue((Node)target);
        X509Certificate x509 = null;
        if (cmanager != null) {
            Certificate cert;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Checking the cached X509Certificate object with the key[" + tokenId + "]."));
            }
            if ((cert = cmanager.getCachedCert(encoded)) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"There is no cached certificiate.");
                }
            } else if (cert instanceof X509Certificate) {
                x509 = (X509Certificate)cert;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The X509Certificate [" + x509.getSubjectDN().getName() + "] was found."));
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The certificate [" + cert.getClass().getName() + "] was found, but it's not the X509Certificate object."));
            }
        }
        if (x509 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Getting the X509Certificate object through the LoginModule.");
            }
            byte[] binary = null;
            if (encoded != null) {
                binary = Base64.decode((String)encoded);
            }
            if (binary == null) {
                throw SoapSecurityException.format("security.wssecurity.PkiPathCallbackHandler.s02");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Base64-decoded binary [" + binary + "]"));
            }
            if ((x509 = X509TokenConsumer.invokeLoginModule(config, null, binary, messageContext, context)) == null) {
                throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.setCertToSubject01");
            }
            if (cmanager != null) {
                cmanager.cacheCert(encoded, x509);
            }
        }
        final X509BSToken tokenPriv = token;
        final X509Certificate x509Priv = x509;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                tokenPriv.setCert(x509Priv);
                return null;
            }
        });
        if (config.getTrustedIDEvaluator() != null) {
            String securityName = X509TokenConsumer.getSecurityName(x509);
            final boolean trusted = config.getTrustedIDEvaluator().evaluate(securityName);
            if (trusted) {
                Tr.debug((TraceComponent)tc, (String)("SecurityName[" + securityName + "] is trusted."));
            } else {
                Tr.warning((TraceComponent)tc, (String)"security.wssecurity.UsernameTokenConsumer.s02", (Object)new Object[]{securityName});
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    tokenPriv.setTrusted(trusted);
                    return null;
                }
            });
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Acquired token is " + token + "."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Element target,TokenConsumerConfig config,CertCacheManager cmanager,SOAPMessageContext messageContext,boolean isNone,boolean isEmb,Map context)");
        }
    }

    private static X509Certificate invokeLoginModule(TokenConsumerConfig config, X509Certificate cert, byte[] binary, SOAPMessageContext messageContext, final Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"invokeLoginModule(TokenConsumerConfig config,X509Certificate cert,byte[] binary,SOAPMessageContext messageContext,Map context)");
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (messageContext != null) {
            properties.put("com.ibm.wsspi.wssecurity.core.messageContext", messageContext);
        }
        if (config.isTrustAnyCertificate()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Trusts any certificates.");
            }
            properties.put("com.ibm.wsspi.wssecurity.token.x509.trustAny", "true");
        }
        if (config.getProvider() != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Provider is " + config.getProvider() + "."));
            }
            properties.put("com.ibm.wsspi.wssecurity.token.x509.provider", config.getProvider());
        }
        if (config.getPKIXBuilderParameters() != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("PKIXBuilderParameters is " + config.getPKIXBuilderParameters() + "."));
            }
            properties.put("com.ibm.wsspi.wssecurity.token.x509.pkixBuilderParam", config.getPKIXBuilderParameters());
        }
        if (config.getJAASConfigProperties() != null) {
            properties.putAll(config.getJAASConfigProperties());
        }
        if (cert != null) {
            properties.put("com.ibm.wsspi.wssecurity.token.x509.certificate", cert);
        }
        final String jconfig = config.getJAASConfig();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("JAAS config name is " + jconfig + "."));
        }
        if (jconfig == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurityJAAS Config entry is missing. Check your configuration.");
        }
        WSCallbackHandlerFactoryImpl factory = new WSCallbackHandlerFactoryImpl();
        factory.setTokenBytes(binary);
        factory.setProperties(properties);
        final CallbackHandler handler = factory.newCallbackHandler();
        if (tc.isDebugEnabled()) {
            if (handler != null) {
                Tr.debug((TraceComponent)tc, (String)("Callback handler (" + handler.getClass().getName() + ") " + handler + "."));
            } else {
                Tr.debug((TraceComponent)tc, (String)"Callback handler is null.");
            }
        }
        LoginContext lcontext = null;
        try {
            lcontext = (LoginContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws LoginException {
                    Subject subject = (Subject)context.get("com.ibm.wsspi.wssecurity.core.subject");
                    return new LoginContext(jconfig, subject, handler);
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Succeed to construct the login context.");
            }
            lcontext.login();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Succeed to login.");
            }
        }
        catch (PrivilegedActionException pae) {
            if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.ERROR)) {
                Map<String, Object> auditContext = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.ERROR, WSSAuditService.WSSAuditReason.AUTHN_PRIVILEDGE_ACTION_EXCEPTION, pae.toString());
                WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "AuthnType", config.getType().toString());
                WSSAuditEventGeneratorImpl.getInstance().addProviderData(auditContext, jconfig, "FAILURE");
                WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, messageContext, context);
            }
            LoginException le = (LoginException)pae.getCause();
            throw SoapSecurityException.format(com.ibm.ws.webservices.wssecurity.Constants.FAILED_AUTHENTICATION, "security.wssecurity.X509TokenConsumer.s01", (Throwable)le);
        }
        catch (LoginException le) {
            if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.DENIED)) {
                Map<String, Object> auditContext = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.AUTHN_LOGIN_EXCEPTION, le.toString());
                WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "AuthnType", config.getType().toString());
                WSSAuditEventGeneratorImpl.getInstance().addProviderData(auditContext, jconfig, "SUCCESS");
                WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, messageContext, context);
            }
            throw SoapSecurityException.format(com.ibm.ws.webservices.wssecurity.Constants.FAILED_AUTHENTICATION, "security.wssecurity.X509TokenConsumer.s02", (Throwable)le);
        }
        if (cert == null) {
            cert = (X509Certificate)properties.get(Constants.WSSECURITY_TOKEN_LOGININFO);
        }
        if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.SUCCESS)) {
            Map<String, Object> auditContext = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.SUCCESS, WSSAuditService.WSSAuditReason.AUTHN_SUCCESS, null);
            WSSAuditEventGeneratorImpl.getInstance().setExtendedAuditData(context, "AuthnType", config.getType().toString());
            String encoded = null;
            try {
                encoded = Base64.encode((byte[])cert.getEncoded());
            }
            catch (CertificateEncodingException e) {
                Tr.debug((TraceComponent)tc, (String)"CertificateEncodingException caught while processing cert for audit record");
            }
            WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "X509Cert", encoded);
            WSSAuditEventGeneratorImpl.getInstance().addProviderData(auditContext, jconfig, "SUCCESS");
            WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, messageContext, context);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Auditing SECURITY_AUTHN event not enabled.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invokeLoginModule(TokenConsumerConfig config,X509Certificate cert,byte[] binary,SOAPMessageContext messageContext,Map context)");
        }
        return cert;
    }

    private static void setTokenToSubject(Map context, X509BSToken token) {
        TokenManager.setToken(context, token);
    }

    private static String getSecurityName(final X509Certificate cert) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSecurityName(X509Certificate cert)");
        }
        String mappedName = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String name = UserRegistry.getInstance().mapCertificate(cert);
                return name;
            }
        });
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("mappedName: " + mappedName));
        }
        if (mappedName == null || mappedName.length() == 0) {
            mappedName = KeyInfo.X509Data.encodeDName((String)cert.getSubjectDN().getName());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("mappedName is null, so used the DN in the certificate: " + mappedName));
            }
        } else {
            String encoded = KeyInfo.X509Data.encodeDName((String)mappedName);
            if (encoded != null && encoded.length() != 0) {
                mappedName = encoded;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getSecurityName(X509Certificate cert) returns " + mappedName));
        }
        return mappedName;
    }
}

