/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.token;

import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SecurityCache;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditEventGeneratorImpl;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditService;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditServiceImpl;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.token.LoginProcessor;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.wsspi.security.token.SingleSignonToken;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.TokenPropagationCallbackHandler;
import com.ibm.wsspi.wssecurity.auth.token.LTPAToken;
import com.ibm.wsspi.wssecurity.auth.token.LTPATokenWrapper;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.token.TokenConsumerComponent;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LTPATokenConsumer
implements TokenConsumerComponent {
    private static final TraceComponent tc = Tr.register(LTPATokenConsumer.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = LTPATokenConsumer.class.getName();
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public void invoke(Node target, Map context) throws SoapSecurityException {
        QName configTokenType;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Node target[" + DOMUtil.getDisplayName((Node)target) + "], " + "Map context)"));
        }
        TokenConsumerConfig config = (TokenConsumerConfig)context.remove("com.ibm.wsspi.wssecurity.config.tokenConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TokenConsumerConfig [" + config + "]."));
        }
        if ((configTokenType = config.getType()) == null) {
            configTokenType = Constants.LTPA_TOKEN;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No token value type defined in the Token Consumer configuration, defualt [" + Constants.LTPA_TOKEN.toString() + "] is used."));
            }
        } else if (!configTokenType.equals(Constants.LTPA_TOKEN) && !configTokenType.equals(Constants.LTPA_TOKEN_PROPAGATION)) {
            String tmp = Constants.LTPA_TOKEN.toString() + ", " + Constants.LTPA_TOKEN_PROPAGATION.toString();
            throw SoapSecurityException.format("security.wssecurity.WSEC0162E", new String[]{configTokenType.toString(), clsName, tmp});
        }
        if (target.getNodeType() == 1) {
            Element targetElem = (Element)target;
            String tokenId = null;
            String idattr = IdUtil.getInstance().getIdAttributeName(targetElem);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The identifier attribute of the target element is [" + idattr + "]."));
            }
            if (idattr != null) {
                tokenId = targetElem.getAttribute(idattr);
            }
            byte[] cred = Base64.decode((String)DOMUtil.getStringValue((Node)target));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Base64-decoded binary credential [" + cred + "]"));
            }
            if (cred == null || cred.length == 0) {
                throw SoapSecurityException.format("security.wssecurity.WSEC0163E");
            }
            int wssVersion = 0;
            Object objVersion = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
            if (objVersion != null && objVersion instanceof Integer) {
                wssVersion = (Integer)objVersion;
            }
            QName tokenType = DOMUtil.getQName(targetElem, targetElem.getAttribute("ValueType"), wssVersion);
            boolean tokenPropagation = false;
            if (tokenType == null) {
                throw SoapSecurityException.format("security.wssecurity.WSEC0164E", new String[]{configTokenType.toString()});
            }
            if (!Constants.LTPA_TOKEN.equals(tokenType)) {
                if (Constants.LTPA_TOKEN_PROPAGATION.equals(tokenType)) {
                    tokenPropagation = true;
                } else {
                    String tmp = Constants.LTPA_TOKEN.toString() + ", " + Constants.LTPA_TOKEN_PROPAGATION.toString();
                    throw SoapSecurityException.format("security.wssecurity.WSEC0165E", new String[]{configTokenType.toString(), clsName, tmp});
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("token propagation is " + tokenPropagation));
            }
            LTPAToken token = null;
            if (tokenPropagation) {
                WSCredentialTokenMapperInterface wsCredTokenMapper;
                ArrayList tokenList;
                SecurityCache cache;
                String cacheKeyString;
                Object[] returned_objects;
                Subject subject;
                block81: {
                    subject = null;
                    returned_objects = null;
                    cacheKeyString = null;
                    cache = null;
                    tokenList = null;
                    wsCredTokenMapper = null;
                    wsCredTokenMapper = _wsCredToken._wsCredTokenMapper;
                    cache = ContextManagerFactory.getInstance().getSecurityCache();
                    try {
                        tokenList = WSOpaqueTokenHelper.getInstance().createTokenHolderListFromOpaqueToken(cred);
                        returned_objects = this.getSubjectFromTokenHolderCacheKey(null, tokenList);
                    }
                    catch (WSSecurityException e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Caught WSSecurityException trying to get cached Subject: " + e));
                        }
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block81;
                        Tr.debug((TraceComponent)tc, (String)("Caught Exception trying to get cached Subject: " + e));
                    }
                }
                if (returned_objects != null) {
                    subject = (Subject)returned_objects[0];
                    cacheKeyString = (String)returned_objects[1];
                }
                WSCredential credential = null;
                WSPrincipal principal = null;
                if (subject != null) {
                    credential = SubjectHelper.getWSCredentialFromSubject(subject);
                    principal = SubjectHelper.getPrincipalFromSubject(subject);
                    if (credential != null) {
                        boolean is_destroyed = credential.isDestroyed();
                        boolean is_forwardable = false;
                        try {
                            is_forwardable = credential.isForwardable();
                        }
                        catch (Exception e) {
                            is_destroyed = true;
                        }
                        boolean isSubjectValid = false;
                        if (cache != null && wsCredTokenMapper != null) {
                            isSubjectValid = wsCredTokenMapper.checkCushionValidityOfAllTokens(subject, cache.getCushion());
                        }
                        if (tc.isDebugEnabled()) {
                            if (is_forwardable) {
                                Tr.debug((TraceComponent)tc, (String)("credential is forwardable, subject valid = " + isSubjectValid));
                            } else {
                                Tr.debug((TraceComponent)tc, (String)"non-forwardable Subject");
                            }
                        }
                        if (is_destroyed || is_forwardable && !isSubjectValid) {
                            subject = null;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Credential has expired or is destroyed, logging in again.");
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Cached subject is valid.");
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"No WSCredential in Subject, logging in again.");
                        }
                        subject = null;
                    }
                }
                if (subject == null) {
                    Subject loginSubject;
                    Map<String, Object> auditContext;
                    credential = null;
                    principal = null;
                    String jaasConfig = config.getJAASConfig();
                    if (jaasConfig == null || jaasConfig.length() == 0) {
                        jaasConfig = "system.WSS_INBOUND";
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Using JAAS config: " + jaasConfig));
                    }
                    int tokenListSize = 0;
                    if (tokenList != null) {
                        tokenListSize = tokenList.size();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("tokenList size = " + tokenListSize));
                    }
                    byte[] credBytes = null;
                    for (int i = 0; i < tokenListSize; ++i) {
                        Object obj = tokenList.get(i);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("tokenList object [" + i + "] = " + obj.getClass().getName()));
                        }
                        if (!(obj instanceof TokenHolder)) continue;
                        TokenHolder th = (TokenHolder)obj;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("th[" + i + "].name = " + th.getName()));
                            Tr.debug((TraceComponent)tc, (String)("th[" + i + "].version = " + th.getVersion()));
                        }
                        if (!"com.ibm.ws.security.token.AuthorizationTokenImpl".equals(th.getName())) continue;
                        credBytes = th.getBytes();
                        if (!tc.isDebugEnabled()) continue;
                        if (credBytes != null && credBytes.length > 0) {
                            Tr.debug((TraceComponent)tc, (String)"Got cred bytes from authz TokenHolder");
                            continue;
                        }
                        Tr.debug((TraceComponent)tc, (String)"Cred bytes from authz TokenHolder was null or zero-length");
                    }
                    LoginContext lc = null;
                    try {
                        TokenPropagationCallbackHandler cbh = new TokenPropagationCallbackHandler(context, tokenList, credBytes);
                        lc = new LoginContext(jaasConfig, cbh);
                        lc.login();
                    }
                    catch (LoginException e) {
                        if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.DENIED)) {
                            auditContext = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.AUTHN_LOGIN_EXCEPTION, e.toString());
                            WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "AuthnType", configTokenType.toString());
                            WSSAuditEventGeneratorImpl.getInstance().addProviderData(auditContext, jaasConfig, "SUCCESS");
                            SOAPMessageContext messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                            WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, messageContext, context);
                        }
                        Tr.processException((Throwable)e, (String)(LTPATokenConsumer.class.getName() + ".invoke()"), (String)"387", (Object)this);
                        throw new SoapSecurityException("Error logging in: " + e.getClass().getName() + ": " + e.getMessage());
                    }
                    subject = loginSubject = lc.getSubject();
                    if (cacheKeyString == null || cacheKeyString.length() == 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"No cache key string found in token list; will not cache new subject.");
                        }
                    } else if (cache != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Caching new subject with cache key string: " + cacheKeyString));
                        }
                        cache.insert(loginSubject, new Object[]{cacheKeyString});
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Not caching new subject because Securitycache instance is null.");
                    }
                    credential = SubjectHelper.getWSCredentialFromSubject(loginSubject);
                    principal = SubjectHelper.getPrincipalFromSubject(loginSubject);
                    token = new LTPATokenWrapper(tokenId, null, credential, principal);
                    if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.SUCCESS)) {
                        auditContext = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.SUCCESS, WSSAuditService.WSSAuditReason.AUTHN_SUCCESS, null);
                        WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "AuthnType", config.getType().toString());
                        WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "TokenId", token.getId());
                        WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "Username", principal.getName());
                        WSSAuditEventGeneratorImpl.getInstance().addProviderData(auditContext, jaasConfig, "SUCCESS");
                        SOAPMessageContext messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                        WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, messageContext, context);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Auditing SECURITY_AUTHN event not enabled.");
                    }
                }
                final LTPAToken tokenPrivSetUsedTokenConsumer = token;
                final TokenConsumerConfig configPriv = config;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        tokenPrivSetUsedTokenConsumer.setUsedTokenConsumer(configPriv);
                        return null;
                    }
                });
                LTPATokenConsumer.setTokenToSubject(context, token);
                if (subject != null) {
                    LoginProcessor.addToSubject(context, subject);
                }
            } else {
                token = new LTPAToken(tokenId, null);
                Boolean decouple = (Boolean)config.getProperties().get("com.ibm.wsspi.wssecurity.token.decouple");
                boolean decoupleToken = true;
                if (decouple != null) {
                    decoupleToken = decouple;
                }
                Element n = null;
                n = !decoupleToken ? targetElem : DOMUtil.clone(targetElem);
                token.setElement(n);
                final LTPAToken tokenPrivSetUsedTokenConsumer = token;
                final TokenConsumerConfig configPriv = config;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        tokenPrivSetUsedTokenConsumer.setUsedTokenConsumer(configPriv);
                        return null;
                    }
                });
                LTPATokenConsumer.setTokenToSubject(context, token);
                final LTPAToken tokenSetBytesPriv = token;
                final byte[] credPriv = cred;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        tokenSetBytesPriv.setBytes(credPriv);
                        return null;
                    }
                });
                WSSConsumerConfig cconfig = (WSSConsumerConfig)context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
                Set callers = cconfig.getCallers();
                boolean isCaller = false;
                if (callers != null) {
                    for (WSSConsumerConfig.CallerConfig cconf : callers) {
                        QName type = cconf.getTokenType();
                        if (!type.equals(tokenType)) continue;
                        isCaller = true;
                        break;
                    }
                }
                if (!isCaller) {
                    Object ret = null;
                    try {
                        Method m = getLTPAMethod._validateLTPATokenMethod;
                        Object o = getLTPAMethod._ltpaServerObject;
                        if (m != null && o != null) {
                            ret = m.invoke(o, new Object[]{cred});
                        }
                        if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.SUCCESS)) {
                            Map<String, Object> auditContext = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.SUCCESS, WSSAuditService.WSSAuditReason.AUTHN_SUCCESS, null);
                            WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "AuthnType", config.getType().toString());
                            WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "TokenId", tokenId);
                            WSSAuditEventGeneratorImpl.getInstance().addProviderData(auditContext, config.getJAASConfig(), "SUCCESS");
                            SOAPMessageContext messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                            WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, messageContext, context);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Auditing SECURITY_AUTHN event not enabled.");
                        }
                    }
                    catch (Exception ex) {
                        if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.ERROR)) {
                            Map<String, Object> auditContext = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.ERROR, WSSAuditService.WSSAuditReason.AUTHN_LOGIN_EXCEPTION, ex.toString());
                            WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "AuthnType", config.getType().toString());
                            WSSAuditEventGeneratorImpl.getInstance().addProviderData(auditContext, config.getJAASConfig(), "FAILURE");
                            SOAPMessageContext messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                            WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, messageContext, context);
                        }
                        throw new SoapSecurityException("security.wssecurityLTPA Token validation failed");
                    }
                    if (ret == null) {
                        if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.DENIED)) {
                            Map<String, Object> auditContext = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.AUTHN_LOGIN_EXCEPTION, null);
                            WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "AuthnType", configTokenType.toString());
                            WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "TokenId", token.getId());
                            WSSAuditEventGeneratorImpl.getInstance().addProviderData(auditContext, config.getJAASConfig(), "SUCCESS");
                            SOAPMessageContext messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                            WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, messageContext, context);
                        }
                        throw new SoapSecurityException("security.wssecurityLTPA Token validation failed");
                    }
                }
            }
            String jconfig = config.getJAASConfig();
            if (jconfig != null && !tokenPropagation && tc.isDebugEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"security.wssecurity.LTPATokenConsumer.s01", (Object)jconfig);
            }
            if (config.getTrustedIDEvaluator() != null) {
                final boolean trusted = config.getTrustedIDEvaluator().evaluate("***");
                final LTPAToken tokenPriv = token;
                if (!trusted) {
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.UsernameTokenConsumer.s02", (Object)new Object[]{tokenId});
                }
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        tokenPriv.setTrusted(trusted);
                        return null;
                    }
                });
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Acquired token is [" + token + "]."));
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WARNING: Unsupported node type: " + target.getNodeName()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Node target,Map context)");
        }
    }

    private static void setTokenToSubject(Map context, LTPAToken token) {
        TokenManager.setToken(context, token);
    }

    private Object[] getSubjectFromTokenHolderCacheKey(byte[] token, List tokenHolderList) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSubjectFromTokenHolderCacheKey", (Object)new Object[]{token, tokenHolderList});
        }
        Subject subject = null;
        String cacheKeyString = null;
        if (tokenHolderList != null) {
            for (int i = 0; i < tokenHolderList.size(); ++i) {
                boolean tokenMatches;
                TokenHolder th = (TokenHolder)tokenHolderList.get(i);
                if (!th.getName().equals("com.ibm.wsspi.security.cred.cacheKey")) continue;
                byte[] cacheKeyBytes = th.getBytes();
                if (cacheKeyBytes != null) {
                    cacheKeyString = StringBytesConversion.getConvertedString(cacheKeyBytes);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Found cache key from token holder list: " + cacheKeyString));
                    }
                    SecurityCache cache = ContextManagerFactory.getInstance().getSecurityCache();
                    subject = cache.getSubject(cacheKeyString);
                }
                if (subject == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Found Subject using cacheKey from prop token.");
                }
                if (token == null) continue;
                WSCredential wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
                SingleSignonToken ssoToken = SubjectHelper.getDefaultSSOTokenFromSubject(subject);
                boolean bl = tokenMatches = wsCred != null && Arrays.equals(token, wsCred.getCredentialToken()) || ssoToken != null && Arrays.equals(token, ssoToken.getBytes());
                if (tokenMatches) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Subject found from cacheKey does not have matching LTPA token.");
                }
                subject = null;
            }
        }
        Object[] return_objects = null;
        if (subject != null || cacheKeyString != null) {
            return_objects = new Object[]{subject, cacheKeyString};
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSubjectFromTokenHolderCacheKey", return_objects);
        }
        return return_objects;
    }

    private static class _wsCredToken {
        static WSCredentialTokenMapperInterface _wsCredTokenMapper = null;

        private _wsCredToken() {
        }

        static {
            try {
                Class<?> wrapperClass = Class.forName("com.ibm.ws.security.token.WSCredentialTokenMapper");
                Object wrapperObj = wrapperClass.newInstance();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Got instance of WSCredTokenMapper.");
                }
                _wsCredTokenMapper = (WSCredentialTokenMapperInterface)wrapperObj;
            }
            catch (Exception ex) {
                FFDCFilter.processException(ex, clsName + "init", "788");
            }
        }
    }

    private static class getLTPAMethod {
        private static final String LTPA_SERVER_OBJECT_CLASS = "com.ibm.ws.security.ltpa.LTPAServerObject";
        private static Class _ltpaServerObjectClass = null;
        private static Method _validateLTPATokenMethod = null;
        private static Method _getLTPAServerMethod = null;
        private static Object _ltpaServerObject = null;

        private getLTPAMethod() {
        }

        static {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (_ltpaServerObjectClass == null) {
                        Class<?> clazz = null;
                        try {
                            ClassLoader cl = Thread.currentThread().getContextClassLoader();
                            clazz = cl != null ? cl.loadClass(getLTPAMethod.LTPA_SERVER_OBJECT_CLASS) : Class.forName(getLTPAMethod.LTPA_SERVER_OBJECT_CLASS);
                            _ltpaServerObjectClass = clazz;
                        }
                        catch (Exception e) {
                            throw new UndeclaredThrowableException(e);
                        }
                    }
                    if (_getLTPAServerMethod == null && _ltpaServerObjectClass != null) {
                        try {
                            _getLTPAServerMethod = _ltpaServerObjectClass.getMethod("getLTPAServer", new Class[0]);
                            if (_getLTPAServerMethod != null) {
                                _ltpaServerObject = _getLTPAServerMethod.invoke(null, new Object[0]);
                            }
                        }
                        catch (Exception e) {
                            throw new UndeclaredThrowableException(e);
                        }
                    }
                    if (_validateLTPATokenMethod == null && _ltpaServerObjectClass != null) {
                        try {
                            _validateLTPATokenMethod = _ltpaServerObjectClass.getMethod("validateToken", byte[].class);
                        }
                        catch (Exception e) {
                            throw new UndeclaredThrowableException(e);
                        }
                    }
                    return null;
                }
            });
        }
    }
}

