/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.wssecurity.auth.token.WSSToken;
import java.util.HashMap;

public class KRBMappedIdentityToken
extends WSSToken {
    private static TraceComponent tc = null;
    private String principal = "";
    private String uniqueID = "";
    private boolean valid = true;
    private boolean readOnly = false;
    private long expiration = -1L;

    public KRBMappedIdentityToken(HashMap properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KRBMappedIdentityToken");
        }
        if (properties != null) {
            this.principal = (String)properties.get("WASPrincipal");
            this.uniqueID = (String)properties.get("uniqueID");
            String valueType = (String)properties.get("ValueType");
            if (valueType == null || valueType.equals("")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "valueType is not passed.");
                }
                valueType = "http://www.ibm.com/WebSphere#KerberosMappedToken";
            }
            this.setType("", valueType);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "principal:" + this.principal);
            Tr.debug(tc, "uniqueID:" + this.uniqueID);
            Tr.debug(tc, "tokenID:" + this._tokenId);
            Tr.debug(tc, "valueType:" + this.getType().toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "KRBMappedIdentityToken");
        }
    }

    public String getPrincipal() {
        return this.principal;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getUniqueID() {
        return this.uniqueID;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public long getExpiration() {
        return this.expiration;
    }

    static {
        tc = Tr.register(KRBMappedIdentityToken.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    }
}

