/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.wssecurity.auth.token.WSSToken;
import java.util.HashMap;
import javax.xml.namespace.QName;

public class KRBDerivedKeyToken
extends WSSToken {
    private static TraceComponent tc = Tr.register(KRBDerivedKeyToken.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private String tokenId = "";
    private String algorithm = "";
    private int generation = 0;
    private int offset = 0;
    private int length = 0;
    private String label = "";
    private String nonce = "";
    private String keyType = "";
    private HashMap securityTokenReference = null;
    private QName valueType = null;
    private String principal = "";
    private String uniqueID = "";
    private boolean valid = true;
    private boolean readOnly = false;
    private long expiration = -1L;

    public KRBDerivedKeyToken(HashMap properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KRBDerivedKeyToken");
        }
        if (properties != null) {
            this.tokenId = (String)properties.get("tokenID");
            this.algorithm = (String)properties.get("Algorithm");
            this.generation = Integer.parseInt((String)properties.get("Generation"));
            this.length = Integer.parseInt((String)properties.get("Length"));
            this.label = (String)properties.get("Label");
            this.nonce = (String)properties.get("Nonce");
            this.keyType = (String)properties.get("KeyType");
            this.securityTokenReference = (HashMap)properties.get("SecurityTokenReference");
            String valueType = (String)properties.get("ValueType");
            if (valueType == null || valueType.equals("")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "valueType is not passed.");
                }
                this.setType("http://schemas.xmlsoap.org/ws/2005/02/sc", "DerivedKeyToken");
            } else {
                this.setType("", valueType);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Id:" + this.tokenId);
            Tr.debug(tc, "algorithm:" + this.algorithm);
            Tr.debug(tc, "generation:" + this.generation);
            Tr.debug(tc, "length:" + this.length);
            Tr.debug(tc, "label:" + this.label);
            Tr.debug(tc, "nonce:" + this.nonce);
            Tr.debug(tc, "keyType:" + this.keyType);
            Tr.debug(tc, "securityTokenReference:" + this.securityTokenReference);
            Tr.debug(tc, "valueType:" + this.getType().toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "KRBDerivedKeyToken");
        }
    }

    public String getId() {
        return this.tokenId;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public int getGeneration() {
        return this.generation;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public String getLabel() {
        return this.label;
    }

    public byte[] getNonce() {
        return this.nonce.getBytes();
    }

    public String getKeyType() {
        return this.keyType;
    }

    public HashMap getSecurityTokenReference() {
        return this.securityTokenReference;
    }

    public QName getType() {
        return this.valueType;
    }

    public void setType(String uri, String localName) {
        this.valueType = new QName(uri, localName);
    }

    public String getPrincipal() {
        return this.principal;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getUniqueID() {
        return this.uniqueID;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public long getExpiration() {
        return this.expiration;
    }
}

