/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.keyinfo;

import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.wsspi.wssecurity.auth.token.X509BSToken;
import com.ibm.wsspi.wssecurity.config.KeyLocatorConfig;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.keyinfo.KeyLocator;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Hex;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class KeyStoreKeyLocator
implements KeyLocator {
    private static final TraceComponent tc = Tr.register(KeyStoreKeyLocator.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = KeyStoreKeyLocator.class.getName();
    private static final int ITSHA1_OCTETS = 20;
    private static final int IT60SHA1_OCTETS = 8;
    private static final String OID_KEYIDENTIFIER = "2.5.29.14";
    private static final byte BER_SEQUENCE = 48;
    private static final byte BER_BITSTRING = 3;
    private static final long DAYS_IN_MS = 86400000L;
    private static final long DEFAULT_DAYS_IN_MS_BEFORE_EXPIRE_WARNING = 5184000000L;
    private KeyLocatorConfig _config = null;
    private long _daysInMSBeforeExpireWarning = 5184000000L;
    protected final Map _keylist = new HashMap();
    private final Map _b64KeyId2KeyName = new HashMap();
    private final Map _b64KeyId602KeyName = new HashMap();
    private final Map _hexKeyId2KeyName = new HashMap();
    private final Map _hexKeyId602KeyName = new HashMap();
    private final Map _subject2KeyName = new HashMap();
    private final Map _issuer2KeyName = new HashMap();
    private final Map _cert2KeyName = new HashMap();
    protected volatile boolean _initialized = false;
    private static final int STATUS_OK = 0;
    private static final int STATUS_CERT_ERROR = 1;
    private static final int STATUS_KEYID_ERROR = 2;
    private static final int STATUS_KEY_ERROR = 4;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        this._config = (KeyLocatorConfig)map.get("com.ibm.wsspi.wssecurity.config.keyLocator.configKey");
        if (this._config.getProperties() != null) {
            String value = ConfigUtil.trim((String)((String)this._config.getProperties().get(Constants.WSSECURITY_DAYS_BEFORE_EXPIRE_WARNING_KEYS)));
            if (value != null && value.length() > 0) {
                long tmpval = 0L;
                try {
                    tmpval = Long.parseLong(value);
                    this._daysInMSBeforeExpireWarning = tmpval * 86400000L;
                }
                catch (NumberFormatException e) {
                    Tr.processException((Throwable)e, (String)(clsName + ".init"), (String)"148", (Object)this);
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC5190W", (Object)new Object[]{Constants.WSSECURITY_DAYS_BEFORE_EXPIRE_WARNING_KEYS, value, new Long(60L)});
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No value define for: " + Constants.WSSECURITY_DAYS_BEFORE_EXPIRE_WARNING_KEYS));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    protected synchronized void doInit() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"doInit()");
        }
        if (this._initialized) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"doInit()");
            }
            return;
        }
        KeyLocatorConfig.KeyStoreConfig ksconfig = this._config.getKeyStore();
        Set keyinfo = this._config.getKeyInformationList();
        if (ksconfig != null && keyinfo != null) {
            KeyStore kstore = KeyStoreKeyLocator.loadKeyStore(ksconfig);
            Iterator it = keyinfo.iterator();
            try {
                while (it.hasNext()) {
                    KeyLocatorConfig.KeyInformationConfig kiconfig = (KeyLocatorConfig.KeyInformationConfig)it.next();
                    String keyName = KeyInfo.X509Data.encodeDName((String)kiconfig.getName());
                    if (keyName == null || keyName.length() == 0) {
                        keyName = kiconfig.getName();
                    }
                    Certificate cert = kstore.getCertificate(kiconfig.getAlias());
                    String subjectDN = null;
                    String encSubjectDN = null;
                    String issuerDN = null;
                    String encIssuerDN = null;
                    String issuerSerial = null;
                    String b64KeyId = null;
                    String b64KeyId60 = null;
                    String hexKeyId = null;
                    String hexKeyId60 = null;
                    Key publickey = null;
                    Key privatekey = null;
                    int status = 0;
                    long expiration = -1L;
                    String errorMes = null;
                    if (cert != null && cert instanceof X509Certificate) {
                        X509Certificate x509 = (X509Certificate)cert;
                        this._cert2KeyName.put(cert, keyName);
                        subjectDN = x509.getSubjectDN().getName();
                        encSubjectDN = KeyInfo.X509Data.encodeDName((String)subjectDN);
                        this._subject2KeyName.put(encSubjectDN, keyName);
                        issuerDN = x509.getIssuerDN().getName();
                        encIssuerDN = KeyInfo.X509Data.encodeDName((String)issuerDN);
                        issuerSerial = x509.getSerialNumber().toString();
                        this._issuer2KeyName.put(encIssuerDN + ":" + issuerSerial, keyName);
                        try {
                            x509.checkValidity();
                        }
                        catch (CertificateExpiredException e) {
                            ++status;
                            Tr.processException((Throwable)e, (String)(clsName + ".doInit"), (String)"220", (Object)this);
                            Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5181E", (Object)new Object[]{subjectDN, kiconfig.getAlias(), ksconfig.getPath(), e});
                            errorMes = ConfigUtil.getMessage((String)"security.wssecurity.WSEC5181E", (String[])new String[]{subjectDN, kiconfig.getAlias(), ksconfig.getPath(), e.getClass().getName() + ": " + e.getMessage()});
                        }
                        catch (CertificateException e) {
                            ++status;
                            Tr.processException((Throwable)e, (String)(clsName + ".doInit"), (String)"227", (Object)this);
                            Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5182E", (Object)new Object[]{subjectDN, kiconfig.getAlias(), ksconfig.getPath(), e});
                            errorMes = ConfigUtil.getMessage((String)"security.wssecurity.WSEC5182E", (String[])new String[]{subjectDN, kiconfig.getAlias(), ksconfig.getPath(), e.getClass().getName() + ": " + e.getMessage()});
                        }
                        expiration = x509.getNotAfter().getTime();
                        if (errorMes == null && expiration - System.currentTimeMillis() < this._daysInMSBeforeExpireWarning) {
                            long millisBeforeExpiration = expiration - System.currentTimeMillis();
                            long daysLeft = millisBeforeExpiration / 86400000L;
                            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC5189W", (Object)new Object[]{subjectDN, kiconfig.getAlias(), ksconfig.getPath(), new Long(daysLeft)});
                        }
                        if (status == 0) {
                            try {
                                byte[] keyid = KeyStoreKeyLocator.makeIdentifier(cert, null);
                                b64KeyId = Base64.encode((byte[])keyid);
                                this._b64KeyId2KeyName.put(b64KeyId, keyName);
                                hexKeyId = Hex.encode((byte[])keyid);
                                this._hexKeyId2KeyName.put(hexKeyId, keyName);
                                keyid = KeyStoreKeyLocator.makeIdentifier(cert, com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1);
                                b64KeyId60 = Base64.encode((byte[])keyid);
                                this._b64KeyId602KeyName.put(b64KeyId60, keyName);
                                hexKeyId60 = Hex.encode((byte[])keyid);
                                this._hexKeyId602KeyName.put(hexKeyId60, keyName);
                            }
                            catch (NoSuchAlgorithmException e) {
                                status += 2;
                                Tr.processException((Throwable)e, (String)(clsName + ".doInit"), (String)"256", (Object)this);
                                Tr.error((TraceComponent)tc, (String)"security.wssecurity.KeyStoreKeyLocator.generateIdentifier01", (Object)new Object[]{e});
                                errorMes = ConfigUtil.getMessage((String)"security.wssecurity.KeyStoreKeyLocator.generateIdentifier01") + ": " + e.getClass().getName() + ": " + e.getMessage();
                            }
                            catch (InvalidAlgorithmParameterException e) {
                                status += 2;
                                Tr.processException((Throwable)e, (String)(clsName + ".doInit"), (String)"262", (Object)this);
                                Tr.error((TraceComponent)tc, (String)"security.wssecurity.KeyStoreKeyLocator.generateIdentifier01", (Object)new Object[]{e});
                                errorMes = ConfigUtil.getMessage((String)"security.wssecurity.KeyStoreKeyLocator.generateIdentifier01") + ":" + e.getClass().getName() + ": " + e.getMessage();
                            }
                            catch (Exception e) {
                                status += 2;
                                Tr.processException((Throwable)e, (String)(clsName + ".doInit"), (String)"268", (Object)this);
                                Tr.error((TraceComponent)tc, (String)"security.wssecurity.KeyStoreKeyLocator.generateIdentifier01", (Object)new Object[]{e});
                                errorMes = ConfigUtil.getMessage((String)"security.wssecurity.KeyStoreKeyLocator.generateIdentifier01") + ":" + e.getClass().getName() + ": " + e.getMessage();
                            }
                            publickey = cert.getPublicKey();
                            if (kiconfig.getKeyPass() != null) {
                                try {
                                    privatekey = kstore.getKey(kiconfig.getAlias(), kiconfig.getKeyPass().toCharArray());
                                    if (privatekey == null && tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("The key with alias \"" + kiconfig.getAlias() + "\" of keystore \"" + ksconfig.getPath() + "\" is not key entry."));
                                        Tr.debug((TraceComponent)tc, (String)("Or alias \"" + kiconfig.getAlias() + "\" is not found in keystore \"" + ksconfig.getPath() + "\"."));
                                    }
                                }
                                catch (NoSuchAlgorithmException e) {
                                    status += 4;
                                    Tr.processException((Throwable)e, (String)(clsName + ".doInit"), (String)"286", (Object)this);
                                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5183E", (Object)new Object[]{kiconfig.getAlias(), ksconfig.getPath(), e});
                                    errorMes = ConfigUtil.getMessage((String)"security.wssecurity.WSEC5183E", (String[])new String[]{kiconfig.getAlias(), ksconfig.getPath(), e.getClass().getName() + ": " + e.getMessage()});
                                }
                                catch (UnrecoverableKeyException e) {
                                    status += 4;
                                    Tr.processException((Throwable)e, (String)(clsName + ".doInit"), (String)"293", (Object)this);
                                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5184E", (Object)new Object[]{kiconfig.getAlias(), ksconfig.getPath(), e});
                                    errorMes = ConfigUtil.getMessage((String)"security.wssecurity.WSEC5184E", (String[])new String[]{kiconfig.getAlias(), ksconfig.getPath(), e.getClass().getName() + ": " + e.getMessage()});
                                }
                            }
                        }
                        this._keylist.put(keyName, new KeyInformation(ksconfig.getPath(), kiconfig.getAlias(), kiconfig.getName(), publickey, privatekey, cert, subjectDN, encSubjectDN, issuerDN, encIssuerDN, issuerSerial, b64KeyId, b64KeyId60, hexKeyId, hexKeyId60, status, expiration, this._daysInMSBeforeExpireWarning, errorMes));
                        continue;
                    }
                    if (kiconfig.getKeyPass() == null) continue;
                    subjectDN = keyName;
                    encSubjectDN = KeyInfo.X509Data.encodeDName((String)subjectDN);
                    if (encSubjectDN == null || encSubjectDN.length() == 0) {
                        encSubjectDN = subjectDN;
                    }
                    this._subject2KeyName.put(encSubjectDN, keyName);
                    try {
                        publickey = privatekey = kstore.getKey(kiconfig.getAlias(), kiconfig.getKeyPass().toCharArray());
                    }
                    catch (NoSuchAlgorithmException e) {
                        status += 4;
                        Tr.processException((Throwable)e, (String)(clsName + ".doInit"), (String)"323", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5183E", (Object)new Object[]{kiconfig.getAlias(), ksconfig.getPath(), e});
                        errorMes = ConfigUtil.getMessage((String)"security.wssecurity.WSEC5183E", (String[])new String[]{kiconfig.getAlias(), ksconfig.getPath(), e.getMessage()});
                    }
                    catch (UnrecoverableKeyException e) {
                        status = 4;
                        Tr.processException((Throwable)e, (String)(clsName + ".init"), (String)"329", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5184E", (Object)new Object[]{kiconfig.getAlias(), ksconfig.getPath(), e});
                        errorMes = ConfigUtil.getMessage((String)"security.wssecurity.WSEC5184E", (String[])new String[]{kiconfig.getAlias(), ksconfig.getPath(), e.getMessage()});
                    }
                    this._keylist.put(keyName, new KeyInformation(ksconfig.getPath(), kiconfig.getAlias(), kiconfig.getName(), publickey, privatekey, cert, subjectDN, encSubjectDN, issuerDN, encIssuerDN, issuerSerial, b64KeyId, b64KeyId60, hexKeyId, hexKeyId60, status, expiration, this._daysInMSBeforeExpireWarning, errorMes));
                }
            }
            catch (KeyStoreException e) {
                Tr.processException((Throwable)e, (String)(clsName + ".init"), (String)"345", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.KeyStoreKeyLocator.exception", (Object)new Object[]{ksconfig.getPath(), e});
                throw new SoapSecurityException(e);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("KeyLocatorConfig [" + this._config + "], " + "KeyInformationList [" + this._keylist + "]."));
        }
        this._initialized = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"doInit()");
        }
    }

    private static KeyStore loadKeyStore(KeyLocatorConfig.KeyStoreConfig config) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadKeyStore(KeyStoreConfig config)");
        }
        KeyStore kstore = null;
        String type = config.getType();
        String path = config.getPath();
        String storepass = config.getPassword();
        String ksRef = config.getKsRef();
        if (ksRef != null && ksRef.length() != 0) {
            kstore = ConfigUtil.getKeyStore((String)ksRef);
        } else if (type != null && path != null && storepass != null) {
            kstore = ConfigUtil.getKeyStore((String)type, (String)path, (char[])storepass.toCharArray());
        }
        if (kstore == null) {
            throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.loadKeyStore01");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("loadKeyStore(KeyStoreConfig config) returns KeyStore[" + kstore + "]"));
        }
        return kstore;
    }

    public Key getKey(Map type, Map context) throws SoapSecurityException {
        String kn;
        boolean isSigning;
        boolean isVerifying;
        boolean isEncrypting;
        boolean isDecrypting;
        boolean isKeyName;
        boolean isKeyId;
        boolean isStrref;
        boolean isEmb;
        boolean isX509;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getKey(Map type,Map context)");
        }
        if (!this._initialized) {
            this.doInit();
        }
        SOAPMessageContext messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        String keyInfoType = (String)type.get(Constants.WSSECURITY_KEYINFO_TYPE);
        if (keyInfoType == null) {
            isX509 = false;
            isEmb = false;
            isStrref = false;
            isKeyId = false;
            isKeyName = false;
        } else {
            isKeyName = ConfigUtil.isKeyInfoKeyname((String)keyInfoType);
            isKeyId = ConfigUtil.isKeyInfoKeyid((String)keyInfoType);
            isStrref = ConfigUtil.isKeyInfoStrref((String)keyInfoType);
            isEmb = ConfigUtil.isKeyInfoEmb((String)keyInfoType);
            isX509 = ConfigUtil.isKeyInfoX509issuer((String)keyInfoType);
        }
        String keyType = (String)type.get(Constants.WSSECURITY_KEY_TYPE);
        if (keyType == null) {
            isDecrypting = false;
            isEncrypting = false;
            isVerifying = false;
            isSigning = false;
        } else {
            isSigning = "SigningKey".equals(keyType);
            isVerifying = "VerifyingKey".equals(keyType);
            isEncrypting = "EncryptingKey".equals(keyType);
            isDecrypting = "DecryptingKey".equals(keyType);
        }
        String knameRef = (String)type.get(Constants.WSSECURITY_KEY_NAMEREF);
        if (knameRef != null && (kn = KeyInfo.X509Data.encodeDName((String)knameRef)) != null && kn.length() > 0) {
            knameRef = kn;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("KeyInfoType [" + keyInfoType + "]."));
            Tr.debug((TraceComponent)tc, (String)("KeyInfoType: isKeyName, isKeyId, isStrref, isEmb, isX509: " + isKeyName + ", " + isKeyId + ", " + isStrref + ", " + isEmb + ", " + isX509 + "."));
            Tr.debug((TraceComponent)tc, (String)("KeyType [" + keyType + "]."));
            Tr.debug((TraceComponent)tc, (String)("keyType: isSigning, isVerifying, isEncrypting, isDecrypting: " + isSigning + ", " + isVerifying + ", " + isEncrypting + ", " + isDecrypting + "."));
            Tr.debug((TraceComponent)tc, (String)("Reference name of a key [" + knameRef + "]."));
        }
        Key key = null;
        if (isSigning) {
            if (knameRef == null) {
                throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.getKey01");
            }
            key = this.getSigningKey(knameRef, isKeyName, isKeyId, isStrref, isEmb, isX509, type, context);
        } else if (isVerifying) {
            key = this.getVerifyingKey(isKeyName, isKeyId, isStrref, isEmb, isX509, type, context);
        } else if (isEncrypting) {
            if (knameRef == null) {
                throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.getKey01");
            }
            key = this.getEncryptingKey(knameRef, isKeyName, isKeyId, isStrref, isEmb, isX509, type, context);
        } else if (isDecrypting) {
            key = this.getDecryptingKey(isKeyName, isKeyId, isStrref, isEmb, isX509, type, context);
        } else {
            throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.getKey02", keyType);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getKey(Map type,Map context) returns Key[" + key + "]"));
        }
        return key;
    }

    private Key getSigningKey(String knameRef, boolean isKeyName, boolean isKeyId, boolean isStrref, boolean isEmb, boolean isX509, Map type, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getSigningKey(String  keyNameRef[" + knameRef + "]," + "boolean isKeyName[" + isKeyName + "]," + "boolean isKeyId[" + isKeyId + "]," + "boolean isStrref[" + isStrref + "]," + "boolean isEmb[" + isEmb + "]," + "boolean isX509[" + isX509 + "]," + "Map type," + "Map context)"));
        }
        Key key = null;
        Token token = KeyStoreKeyLocator.getToken(isKeyName, isKeyId, isStrref, isEmb, isX509, type, context);
        KeyInformation kinfo = (KeyInformation)this._keylist.get(knameRef);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Key information [" + kinfo + "]"));
        }
        if (kinfo == null) {
            if (knameRef != null) {
                throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.getPrivateKey02", knameRef);
            }
            throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.getPrivateKey03");
        }
        key = kinfo.getPrivateOrSecretKey();
        if (key == null) {
            throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.getPrivateKey01");
        }
        if (token == null) {
            KeyStoreKeyLocator.setInfo(isKeyName, isKeyId, isStrref, isEmb, isX509, kinfo, context);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getSigningKey(String knameRef,boolean isKeyName,boolean isKeyId,boolean isStrref,boolean isEmb,boolean isX509,Map type,Map context) returns Key[" + key + "]"));
        }
        return key;
    }

    private Key getVerifyingKey(boolean isKeyName, boolean isKeyId, boolean isStrref, boolean isEmb, boolean isX509, Map type, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getVerifyingKey(boolean isKeyName[" + isKeyName + "]," + "boolean isKeyId[" + isKeyId + "]," + "boolean isStrref[" + isStrref + "]," + "boolean isEmb[" + isEmb + "]," + "boolean isX509[" + isX509 + "]," + "Map type," + "Map context)"));
        }
        TokenConsumerConfig tconfig = (TokenConsumerConfig)type.remove(Constants.WSSECURITY_KEYINFO_TOKEN_REFERENCE);
        Key key = (Key)context.remove(this.getClass());
        if (key == null) {
            KeyInformation kinfo = this.getInfo(tconfig, isKeyName, isKeyId, isStrref, isEmb, isX509, type, context);
            key = kinfo.getPublicOrSecretKey();
            context.put("com.ibm.wsspi.wssecurity.token.x509.certificate", kinfo.getCertificate());
            if (kinfo.getCertificate() != null) {
                context.put(key, kinfo.getCertificate());
                if (tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"(key, certificate) from kinfo put in context");
                }
            }
            context.put(this.getClass(), key);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getVerifyingKey(boolean isKeyName,boolean isKeyId,boolean isStrref,boolean isEmb,boolean isX509,Map type,Map context) returns Key[" + key + "]"));
        }
        return key;
    }

    private Key getEncryptingKey(String knameRef, boolean isKeyName, boolean isKeyId, boolean isStrref, boolean isEmb, boolean isX509, Map type, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getEncryptingKey(String knameRef[" + knameRef + "]," + "boolean isKeyName[" + isKeyName + "]," + "boolean isKeyId[" + isKeyId + "]," + "boolean isStrref[" + isStrref + "]," + "boolean isEmb[" + isEmb + "]," + "boolean isX509[" + isX509 + "]," + "Map type," + "Map context)"));
        }
        Key key = null;
        Token token = KeyStoreKeyLocator.getToken(isKeyName, isKeyId, isStrref, isEmb, isX509, type, context);
        KeyInformation kinfo = (KeyInformation)this._keylist.get(knameRef);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Key information [" + kinfo + "]"));
        }
        if (kinfo == null) {
            if (knameRef != null) {
                throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.getPrivateKey02", knameRef);
            }
            throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.getPrivateKey03");
        }
        key = kinfo.getPublicOrSecretKey();
        if (key == null) {
            throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.getPrivateKey01");
        }
        Certificate cert = null;
        if (token == null) {
            KeyStoreKeyLocator.setInfo(isKeyName, isKeyId, isStrref, isEmb, isX509, kinfo, context);
        } else if (token instanceof X509BSToken) {
            cert = ((X509BSToken)token).getCert();
        }
        if (cert == null) {
            cert = kinfo.getCertificate();
        }
        if (cert != null) {
            context.put(key, cert);
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"(key, certificate) put in context");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEncryptingKey(String knameRef,boolean isKeyName,boolean isKeyId,boolean isStrref,boolean isEmb,boolean isX509,Map type,Map context) returns Key[" + key + "]"));
        }
        return key;
    }

    private Key getDecryptingKey(boolean isKeyName, boolean isKeyId, boolean isStrref, boolean isEmb, boolean isX509, Map type, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getDecryptingKey(boolean isKeyName[" + isKeyName + "]," + "boolean isKeyId[" + isKeyId + "]," + "boolean isStrref[" + isStrref + "]," + "boolean isEmb[" + isEmb + "]," + "boolean isX509[" + isX509 + "]," + "Map type," + "Map context)"));
        }
        TokenConsumerConfig tconfig = (TokenConsumerConfig)type.remove(Constants.WSSECURITY_KEYINFO_TOKEN_REFERENCE);
        Key key = (Key)context.remove(this.getClass());
        if (key == null) {
            KeyInformation kinfo = this.getInfo(tconfig, isKeyName, isKeyId, isStrref, isEmb, isX509, type, context);
            key = kinfo.getPrivateOrSecretKey();
            context.put("com.ibm.wsspi.wssecurity.token.x509.certificate", kinfo.getCertificate());
            context.put(this.getClass(), key);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getDecryptingKey(boolean isKeyName,boolean isKeyId,boolean isStrref,boolean isEmb,boolean isX509,Map type,Map context) returns Key[" + key + "]"));
        }
        return key;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private KeyInformation getInfo(TokenConsumerConfig tconfig, boolean isKeyName, boolean isKeyId, boolean isStrref, boolean isEmb, boolean isX509, Map type, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getInfo(TokenConsumerConfig tconfig[" + tconfig + "]," + "boolean isKeyName[" + isKeyName + "]," + "boolean isKeyId[" + isKeyId + "]," + "boolean isStrref[" + isStrref + "]," + "boolean isEmb[" + isEmb + "]," + "boolean isX509[" + isX509 + "]," + "Map type," + "Map context)"));
        }
        String keyName = null;
        if (isKeyName) {
            String subjectDN = (String)type.get(Constants.WSSECURITY_KEY_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SubjectDN is [" + subjectDN + "]."));
            }
            if (subjectDN == null) {
                throw SoapSecurityException.format("security.wssecurity.KeyNameContentConsumer.getKeyName01");
            }
            keyName = (String)this._subject2KeyName.get(subjectDN);
        } else if (isKeyId) {
            String keyId = (String)type.get(Constants.WSSECURITY_KEY_ID);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The key identifier is [" + keyId + "]"));
            }
            if (keyId == null) {
                throw SoapSecurityException.format("security.wssecurity.KeyIdContentConsumer.getKey01");
            }
            QName idtype = (QName)type.get(Constants.WSSECURITY_KEY_IDTYPE);
            QName etype = (QName)type.get(Constants.WSSECURITY_KEY_ENCODING);
            QName vtype = (QName)type.get(Constants.WSSECURITY_KEY_VALUETYPE);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Calcuration method of key identifier is [" + idtype + "]."));
                Tr.debug((TraceComponent)tc, (String)("Encoding type of key identifier is [" + etype + "]."));
                Tr.debug((TraceComponent)tc, (String)("Value type of key identifier is [" + vtype + "]."));
            }
            if (vtype == null) {
                throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.generateIdentifier02");
            }
            if (!com.ibm.ws.webservices.wssecurity.Constants.X509_SKI.equals(vtype) && !com.ibm.ws.webservices.wssecurity.Constants.X509_SKI_OLD.equals(vtype)) {
                throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.generateIdentifier03", com.ibm.ws.webservices.wssecurity.Constants.X509_SKI.toString() + ", " + com.ibm.ws.webservices.wssecurity.Constants.X509_SKI_OLD.toString(), vtype.toString());
            }
            if (etype == null || NamespaceUtil.equals(etype, com.ibm.ws.webservices.wssecurity.Constants.BASE64_BINARY)) {
                if (idtype == null || NamespaceUtil.equals(idtype, com.ibm.ws.webservices.wssecurity.Constants.ITSHA1)) {
                    keyName = (String)this._b64KeyId2KeyName.get(keyId);
                } else {
                    if (!NamespaceUtil.equals(idtype, com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1)) throw new SoapSecurityException(ConfigUtil.getMessage((String)"security.wssecurityKeyStoreKeyLocator.generateIdentifier01") + ": " + idtype);
                    keyName = (String)this._b64KeyId602KeyName.get(keyId);
                }
            } else {
                if (!NamespaceUtil.equals(etype, com.ibm.ws.webservices.wssecurity.Constants.HEX_BINARY)) throw SoapSecurityException.format("security.wssecurity.BinaryTokenReceiver.token15", etype.toString());
                if (idtype == null || NamespaceUtil.equals(idtype, com.ibm.ws.webservices.wssecurity.Constants.ITSHA1)) {
                    keyName = (String)this._hexKeyId2KeyName.get(keyId);
                } else {
                    if (!NamespaceUtil.equals(idtype, com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1)) throw new SoapSecurityException(ConfigUtil.getMessage((String)"security.wssecurityKeyStoreKeyLocator.generateIdentifier01") + ": " + idtype);
                    keyName = (String)this._hexKeyId602KeyName.get(keyId);
                }
            }
        } else if (isStrref) {
            String reference = (String)type.get(Constants.WSSECURITY_KEY_REFERENCE);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The referene URI to a token is [" + reference + "]."));
            }
            if (reference == null) {
                throw SoapSecurityException.format("security.wssecurity.STRReferenceContentConsumer.getKey01");
            }
            Token token = TokenManager.getToken(context, tconfig, reference);
            if (token == null || !(token instanceof X509BSToken)) {
                throw SoapSecurityException.format("security.wssecurity.SignatureReceiver.dsig10", reference);
            }
            X509Certificate cert = ((X509BSToken)token).getCert();
            if (cert == null) {
                throw new SoapSecurityException(ConfigUtil.getMessage((String)"security.wssecurity.WSSConsumer.s32") + ": " + token);
            }
            keyName = (String)this._cert2KeyName.get(cert);
        } else if (isEmb) {
            String embId = (String)type.get(Constants.WSSECURITY_KEY_EMBID);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The embedded token identifier is [" + embId + "]."));
            }
            if (embId == null) {
                throw SoapSecurityException.format("security.wssecurity.EmbeddedContentConsumer.getEmbeddedToken02");
            }
            Token token = TokenManager.getToken(context, tconfig, embId);
            if (token == null || !(token instanceof X509BSToken)) {
                throw SoapSecurityException.format("security.wssecurity.SignatureReceiver.dsig10", embId);
            }
            X509Certificate cert = ((X509BSToken)token).getCert();
            if (cert == null) {
                throw new SoapSecurityException(ConfigUtil.getMessage((String)"security.wssecurity.WSSConsumer.s32") + ": " + token);
            }
            keyName = (String)this._cert2KeyName.get(cert);
        } else if (isX509) {
            String issuerName = (String)type.get(Constants.WSSECURITY_KEY_ISSUERNAME);
            String issuerSerial = (String)type.get(Constants.WSSECURITY_KEY_ISSUERSERIAL);
            if ((issuerName == null || issuerSerial == null) && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WARNING: Unable to get issuer name or issuer serial.");
            }
            String id = issuerName + ":" + issuerSerial;
            keyName = (String)this._issuer2KeyName.get(id);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The key name is [" + keyName + "]."));
        }
        KeyInformation kinfo = null;
        if (keyName != null) {
            kinfo = (KeyInformation)this._keylist.get(keyName);
        }
        if (kinfo == null) {
            if (keyName == null) throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.getPrivateKey03");
            throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.getPrivateKey02", keyName);
        }
        if (!tc.isEntryEnabled()) return kinfo;
        Tr.exit((TraceComponent)tc, (String)("getInfo(TokenConsumerConfig tconfig,boolean isKeyName,boolean isKeyId,boolean isStrref,boolean isEmb,boolean isX509,Map type,Map context) returns KeyInformation[" + kinfo + "]"));
        return kinfo;
    }

    protected static Token getToken(boolean isKeyName, boolean isKeyId, boolean isStrref, boolean isEmb, boolean isX509, Map type, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getToken(boolean isKeyName[" + isKeyName + "]," + "boolean isKeyId[" + isKeyId + "]," + "boolean isStrref[" + isStrref + "]," + "boolean isEmb[" + isEmb + "]," + "boolean isX509[" + isX509 + "]," + "Map type," + "Map context)"));
        }
        Token token = null;
        String tokenId = null;
        if (isKeyName) {
            tokenId = (String)type.get(Constants.WSSECURITY_KEY_NAME);
        } else if (isKeyId) {
            tokenId = (String)type.get(Constants.WSSECURITY_KEY_ID);
        } else if (isStrref) {
            tokenId = (String)type.get(Constants.WSSECURITY_KEY_REFERENCE);
        } else if (isEmb) {
            tokenId = (String)type.get(Constants.WSSECURITY_KEY_EMBID);
        } else if (isX509) {
            String issuerName = (String)type.get(Constants.WSSECURITY_KEY_ISSUERNAME);
            String issuerSerial = (String)type.get(Constants.WSSECURITY_KEY_ISSUERSERIAL);
            if (issuerName != null && issuerSerial != null) {
                tokenId = issuerName + ":" + issuerSerial;
            }
        }
        if (tokenId != null) {
            token = TokenManager.getToken(context, tokenId);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getToken(boolean isKeyName[" + isKeyName + "]," + "boolean isKeyId[" + isKeyId + "]," + "boolean isStrref[" + isStrref + "]," + "boolean isEmb[" + isEmb + "]," + "boolean isX509[" + isX509 + "]," + "Map type," + "Map context)" + " returns Token[" + token + "]"));
        }
        return token;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setInfo(boolean isKeyName, boolean isKeyId, boolean isStrref, boolean isEmb, boolean isX509, KeyInformation kinfo, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setInfo(boolean isKeyName[" + isKeyName + "]," + "boolean isKeyId[" + isKeyId + "]," + "boolean isStrref[" + isStrref + "]," + "boolean isEmb[" + isEmb + "]," + "boolean isX509[" + isX509 + "]," + "KeyInformation kinfo[" + kinfo + "]," + "Map context)"));
        }
        String subjectDN = null;
        String keyId = null;
        String issuerDN = null;
        String issuerSerial = null;
        if (isKeyName) {
            subjectDN = kinfo.getSubjectDN();
        } else if (isKeyId) {
            QName etype = (QName)context.remove(Constants.WSSECURITY_KEY_ENCODING);
            QName idtype = (QName)context.remove(Constants.WSSECURITY_KEY_IDTYPE);
            if (etype == null || NamespaceUtil.equals(etype, com.ibm.ws.webservices.wssecurity.Constants.BASE64_BINARY)) {
                if (idtype == null || NamespaceUtil.equals(idtype, com.ibm.ws.webservices.wssecurity.Constants.ITSHA1)) {
                    keyId = kinfo.getB64KeyId();
                } else {
                    if (!NamespaceUtil.equals(idtype, com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1)) throw new SoapSecurityException(ConfigUtil.getMessage((String)"security.wssecurityKeyStoreKeyLocator.generateIdentifier01") + ": " + idtype);
                    keyId = kinfo.getB64KeyId60();
                }
            } else {
                if (!NamespaceUtil.equals(etype, com.ibm.ws.webservices.wssecurity.Constants.HEX_BINARY)) throw SoapSecurityException.format("security.wssecurity.BinaryTokenReceiver.token15", etype.toString());
                if (idtype == null || NamespaceUtil.equals(idtype, com.ibm.ws.webservices.wssecurity.Constants.ITSHA1)) {
                    keyId = kinfo.getHexKeyId();
                } else {
                    if (!NamespaceUtil.equals(idtype, com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1)) throw new SoapSecurityException(ConfigUtil.getMessage((String)"security.wssecurityKeyStoreKeyLocator.generateIdentifier01") + ": " + idtype);
                    keyId = kinfo.getHexKeyId60();
                }
            }
        } else if (isStrref) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WARNING: TokenGenerator is responsible to set a X509 token to the Subject in case of STRREF.");
            }
        } else if (isEmb) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WARNING: TokenGenerator is responsible to set a X509 token to the Subject in case of EMB.");
            }
        } else if (isX509) {
            issuerDN = kinfo.getIssuerDN();
            issuerSerial = kinfo.getIssuerSerial();
        }
        if (subjectDN != null) {
            context.put(Constants.WSSECURITY_KEY_NAME, subjectDN);
        } else {
            context.remove(Constants.WSSECURITY_KEY_NAME);
        }
        if (keyId != null) {
            context.put(Constants.WSSECURITY_KEY_ID, keyId);
        } else {
            context.remove(Constants.WSSECURITY_KEY_ID);
        }
        if (issuerDN != null) {
            context.put(Constants.WSSECURITY_KEY_ISSUERNAME, issuerDN);
        } else {
            context.remove(Constants.WSSECURITY_KEY_ISSUERNAME);
        }
        if (issuerSerial != null) {
            context.put(Constants.WSSECURITY_KEY_ISSUERSERIAL, issuerSerial);
        } else {
            context.remove(Constants.WSSECURITY_KEY_ISSUERSERIAL);
        }
        context.remove(Constants.WSSECURITY_KEY_EMBID);
        context.remove(Constants.WSSECURITY_KEY_REFERENCE);
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"setInfo(boolean isKeyName,boolean isKeyId,boolean isStrref,boolean isEmb,boolean isX509,KeyInformation kinfo,Map context)");
    }

    private static byte[] certToIdentifier(Certificate cert) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"certToIdentifier(Certificate cert)");
        }
        if (!(cert instanceof X509Certificate)) {
            return null;
        }
        byte[] der = ((X509Certificate)cert).getExtensionValue(OID_KEYIDENTIFIER);
        if (der == null) {
            return null;
        }
        byte[] ki = new byte[der.length - 4];
        System.arraycopy(der, 4, ki, 0, der.length - 4);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"certToIdentifier(Certificate cert)");
        }
        return ki;
    }

    private static byte[] pubkeyToIdentifier(Certificate cert, QName idty) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("pubkeyToIdentifier(Certificate cert,QName idty[" + idty + "])"));
        }
        byte[] bits = null;
        if (cert != null) {
            byte[] key = cert.getPublicKey().getEncoded();
            if (key[0] != 48) {
                throw new RuntimeException("Unknown encoded key: " + Hex.encode((byte[])key));
            }
            int len = key[1] & 0xFF;
            int offset = (len & 0x80) == 0 ? 2 : 2 + (len & 0x7F);
            len = key[offset + 1] & 0xFF;
            if ((len & 0x80) == 0) {
                offset += 2;
            } else {
                int lenoff = offset + 2;
                offset += 2 + (len & 0x7F);
                switch (len & 0x7F) {
                    case 1: {
                        len = key[lenoff] & 0xFF;
                        break;
                    }
                    case 2: {
                        len = ((key[lenoff] & 0xFF) << 8) + (key[lenoff + 1] & 0xFF);
                        break;
                    }
                    case 3: {
                        len = ((key[lenoff] & 0xFF) << 16) + ((key[lenoff + 1] & 0xFF) << 8) + (key[lenoff + 2] & 0xFF);
                        break;
                    }
                    case 4: {
                        len = ((key[lenoff] & 0xFF) << 24) + ((key[lenoff + 1] & 0xFF) << 16) + ((key[lenoff + 2] & 0xFF) << 8) + (key[lenoff + 3] & 0xFF);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Integer overflow: " + Hex.encode((byte[])key));
                    }
                }
            }
            if (key[offset += len] != 3) {
                throw new RuntimeException("Non BIT STRING: 0x" + Integer.toString(key[offset] & 0xFF, 16));
            }
            offset += ((len = key[offset + 1] & 0xFF) & 0x80) == 0 ? 3 : 3 + (len & 0x7F);
            AlgorithmFactory factory = AlgorithmFactory.getInstance();
            MessageDigest digester = factory.getMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", null);
            if (NamespaceUtil.equals(idty, com.ibm.ws.webservices.wssecurity.Constants.ITSHA1) || idty == null) {
                digester.update(key, offset, key.length - offset);
                bits = digester.digest();
                factory.releaseMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", digester);
            } else if (NamespaceUtil.equals(idty, com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1)) {
                digester.update(key, offset, key.length - offset);
                byte[] digest = digester.digest();
                factory.releaseMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", digester);
                bits = new byte[8];
                bits[0] = (byte)(64 + (digest[digest.length - 8] & 0xF));
                System.arraycopy(digest, digest.length - 8 + 1, bits, 1, bits.length - 1);
            } else {
                factory.releaseMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", digester);
                throw new IllegalArgumentException("Internal Error: " + idty);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"pubkeyToIdentifier(Certificate cert,QName idty)");
        }
        return bits;
    }

    private static byte[] makeIdentifier(Certificate cert, QName idty) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("makeIdentifier(Certificate cert,QName idty[" + idty + "])"));
        }
        byte[] bits = null;
        if (cert != null && ((bits = KeyStoreKeyLocator.certToIdentifier(cert)) == null || idty != null)) {
            if (idty == null || NamespaceUtil.equals(idty, com.ibm.ws.webservices.wssecurity.Constants.ITSHA1)) {
                if (bits == null || bits.length != 20) {
                    bits = KeyStoreKeyLocator.pubkeyToIdentifier(cert, idty);
                }
            } else if (NamespaceUtil.equals(idty, com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1)) {
                if (bits == null || bits.length != 8) {
                    bits = KeyStoreKeyLocator.pubkeyToIdentifier(cert, idty);
                }
            } else {
                throw new IllegalArgumentException("Internal Error: " + idty);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"makeIdentifier(Certificate cert,QName idty)");
        }
        return bits;
    }

    protected static class KeyInformation {
        private String _kspath;
        private String _alias;
        private String _name;
        private Key _publicOrSecretKey;
        private Key _privateOrSecretKey;
        private Certificate _certificate;
        private String _subjectDN;
        private String _encSubjectDN;
        private String _issuerDN;
        private String _encIssuerDN;
        private String _issuerSerial;
        private String _b64KeyId;
        private String _b64KeyId60;
        private String _hexKeyId;
        private String _hexKeyId60;
        private int _status;
        private long _expiration;
        private long _daysInMSBeforeExpireWarning;
        private String _errorMes;

        protected KeyInformation(String kspath, String alias, String name, Key publicOrSecretKey, Key privateOrSecretKey, Certificate certificate, String subjectDN, String encSubjectDN, String issuerDN, String encIssuerDN, String issuerSerial, String b64KeyId, String b64KeyId60, String hexKeyId, String hexKeyId60, int status, long expiration, long daysInMSBeforeExpireWarning, String errorMes) {
            this._kspath = kspath;
            this._alias = alias;
            this._name = name;
            this._publicOrSecretKey = publicOrSecretKey;
            this._privateOrSecretKey = privateOrSecretKey;
            this._certificate = certificate;
            this._subjectDN = subjectDN;
            this._encSubjectDN = encSubjectDN;
            this._issuerDN = issuerDN;
            this._encIssuerDN = encIssuerDN;
            this._issuerSerial = issuerSerial;
            this._b64KeyId = b64KeyId;
            this._b64KeyId60 = b64KeyId60;
            this._hexKeyId = hexKeyId;
            this._hexKeyId60 = hexKeyId60;
            this._status = status;
            this._expiration = expiration;
            this._daysInMSBeforeExpireWarning = daysInMSBeforeExpireWarning;
            this._errorMes = errorMes;
        }

        protected String getName() {
            return this._name;
        }

        protected Key getPublicOrSecretKey() throws SoapSecurityException {
            if ((this._status & 1) == 1) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._publicOrSecretKey;
        }

        protected Key getPrivateOrSecretKey() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 4) == 4) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._privateOrSecretKey;
        }

        protected Certificate getCertificate() throws SoapSecurityException {
            if ((this._status & 1) == 1) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._certificate;
        }

        protected String getSubjectDN() throws SoapSecurityException {
            if ((this._status & 1) == 1) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._encSubjectDN;
        }

        protected String getIssuerDN() throws SoapSecurityException {
            if ((this._status & 1) == 1) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._encIssuerDN;
        }

        protected String getIssuerSerial() throws SoapSecurityException {
            if ((this._status & 1) == 1) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._issuerSerial;
        }

        protected String getB64KeyId() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 4) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._b64KeyId;
        }

        protected String getB64KeyId60() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 4) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._b64KeyId60;
        }

        protected String getHexKeyId() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 4) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._hexKeyId;
        }

        protected String getHexKeyId60() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 4) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._hexKeyId60;
        }

        private void checkExpiration() throws SoapSecurityException {
            if (this._expiration >= 0L) {
                long millisBeforeExpiration = this._expiration - System.currentTimeMillis();
                if (millisBeforeExpiration < 0L) {
                    ++this._status;
                    this._errorMes = ConfigUtil.getMessage((String)"security.wssecurity.WSEC5181E", (String[])new String[]{this._subjectDN, this._alias, this._kspath, "expiration time - current system time = " + millisBeforeExpiration + " ms."});
                    throw new SoapSecurityException(this._errorMes);
                }
                if (millisBeforeExpiration < this._daysInMSBeforeExpireWarning) {
                    long daysLeft = millisBeforeExpiration / 86400000L;
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC5189W", (Object)new Object[]{this._subjectDN, this._alias, this._kspath, new Long(daysLeft)});
                }
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("keystorePath=[").append(this._kspath).append("], ");
            buf.append("alias=[").append(this._alias).append("], ");
            buf.append("name=[").append(this._name).append("], ");
            buf.append("status=[").append(this._status).append("], ");
            buf.append(")");
            return buf.toString();
        }
    }
}

