/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.keyinfo;

import com.ibm.crypto.provider.AESKeySpec;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.wssecurity.KRBConstants;
import com.ibm.ws.webservices.wssecurity.config.EncryptionConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.EncryptionGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.confimpl.PrivateCommonConfig;
import com.ibm.ws.webservices.wssecurity.confimpl.PrivateConsumerConfig;
import com.ibm.ws.webservices.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.util.DerivedKeyUtil;
import com.ibm.ws.webservices.wssecurity.util.KRB5Util;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.keyinfo.KeyLocator;
import com.ibm.wsspi.wssecurity.token.KRBDerivedKeyToken;
import com.ibm.wsspi.wssecurity.token.KRBTokenInfo;
import java.security.Key;
import java.security.MessageDigest;
import java.security.spec.KeySpec;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public class KRBKeyLocator
implements KeyLocator {
    private static final String comp = "auth.KRBKeyLocator";
    private static boolean _debug = false;
    private static TraceComponent tc;
    private static String HMACSHA1;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    public Key getKey(Map type, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKey()");
        }
        String keyType = (String)type.get(Constants.WSSECURITY_KEY_TYPE);
        String refuri = (String)type.get(Constants.WSSECURITY_KEY_REFERENCE);
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "Context : " + context);
            Tr.debug(tc, "Type    : " + type);
            Tr.debug(tc, "Key type: " + keyType);
            Tr.debug(tc, "Ref uri : " + refuri);
        }
        boolean keyUsedForEncrypting = false;
        boolean keyUsedForDecrypting = false;
        boolean keyUsedForSigning = false;
        boolean keyUsedForVerifying = false;
        KRBDerivedKeyToken derivedKeyTokenUsed = null;
        MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "MessageContext: " + messageContext);
        }
        if (keyType != null) {
            if ("SigningKey".equals(keyType)) {
                keyUsedForSigning = true;
                derivedKeyTokenUsed = (KRBDerivedKeyToken)messageContext.getProperty("com.ibm.wsspi.wssecurity.derivedKeyToken.SigningKey");
            } else if ("VerifyingKey".equals(keyType)) {
                keyUsedForVerifying = true;
                derivedKeyTokenUsed = (KRBDerivedKeyToken)messageContext.getProperty("com.ibm.wsspi.wssecurity.derivedKeyToken.VerifyingKey");
            } else if ("EncryptingKey".equals(keyType)) {
                keyUsedForEncrypting = true;
                derivedKeyTokenUsed = (KRBDerivedKeyToken)messageContext.getProperty("com.ibm.wsspi.wssecurity.derivedKeyToken.EncryptingKey");
            } else if ("DecryptingKey".equals(keyType)) {
                keyUsedForDecrypting = true;
                derivedKeyTokenUsed = (KRBDerivedKeyToken)messageContext.getProperty("com.ibm.wsspi.wssecurity.derivedKeyToken.DecryptingKey");
            }
        }
        SecretKey key = (SecretKey)context.remove(this.getClass() + keyType);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cached secret key: " + key);
        }
        if (key == null) {
            try {
                KRBTokenInfo krbTokenUsed = (KRBTokenInfo)messageContext.getProperty("com.ibm.wsspi.wssecurity.kerberosTokenInfo");
                if (krbTokenUsed == null) {
                    Tr.error(tc, "Cannot locate the previously stored Kerberos token.");
                    throw SoapSecurityException.format("Cannot locate the previously stored Kerberos token from ." + messageContext);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Kerberos token is available.");
                }
                byte[] keyBytes = null;
                if (derivedKeyTokenUsed != null) {
                    keyBytes = DerivedKeyUtil.createDerivedKeyByte(krbTokenUsed.getSessionSubKey(), derivedKeyTokenUsed.getLabel(), Base64Coder.base64Decode(derivedKeyTokenUsed.getNonce()), derivedKeyTokenUsed.getLength(), derivedKeyTokenUsed.getOffset(), derivedKeyTokenUsed.getGeneration(), HMACSHA1);
                    if (_debug && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Key bytes using PSHA1   : " + KRB5Util.showHex(keyBytes));
                    }
                } else {
                    keyBytes = krbTokenUsed.getSessionSubKey();
                    if (_debug && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Key bytes using session : " + KRB5Util.showHex(keyBytes));
                    }
                    if (keyUsedForSigning || keyUsedForEncrypting) {
                        MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
                        sha1.update(krbTokenUsed.getKerberosToken());
                        byte[] sha1Result = sha1.digest();
                        if (sha1Result != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "SHA-1 is computed for the key identifier.");
                            }
                            context.put(Constants.WSSECURITY_KEY_ID, new String(Base64Coder.base64Encode(sha1Result)));
                            context.put(Constants.WSSECURITY_KEY_ENCODING_LN, KRBConstants.STR_BASE64_ENCODING);
                        }
                    }
                }
                if (keyUsedForSigning || keyUsedForVerifying) {
                    AESKeySpec aesKeySpec = new AESKeySpec(keyBytes);
                    SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("AES", "IBMJCE");
                    key = keyFactory.generateSecret((KeySpec)aesKeySpec);
                } else {
                    String algorithm = null;
                    algorithm = keyUsedForDecrypting ? KRBKeyLocator.getAlgorithmFromConsumerConfig((PrivateConsumerConfig)context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey")) : KRBKeyLocator.getAlgorithmFromGeneratorConfig((PrivateGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey"));
                    if (algorithm == null || algorithm.endsWith("aes256-cbc") || algorithm.endsWith("aes192-cbc") || algorithm.endsWith("aes128-cbc")) {
                        AESKeySpec aesKeySpec = new AESKeySpec(keyBytes);
                        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("AES", "IBMJCE");
                        key = keyFactory.generateSecret((KeySpec)aesKeySpec);
                    } else {
                        DESKeySpec desKeySpec = new DESKeySpec(keyBytes);
                        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES", "IBMJCE");
                        key = keyFactory.generateSecret(desKeySpec);
                    }
                }
            }
            catch (SoapSecurityException sse) {
                throw sse;
            }
            catch (Throwable t) {
                Tr.error(tc, "security.wssecurity.kerberos.unexpected.exception", KRB5Util.stackToString(t));
                throw SoapSecurityException.format(KRB5Util.stackToString(t));
            }
        }
        context.put(this.getClass() + keyType, key);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKey()" + key);
        }
        return key;
    }

    private static String getAlgorithmFromConsumerConfig(PrivateConsumerConfig config) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAlgorithmFromConsumerConfig()");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Config  :" + config);
        }
        String algorithm = null;
        if (config != null) {
            for (Object obj : config.getEncryptionConsumers()) {
                if (!(obj instanceof EncryptionConsumerConfig)) continue;
                PrivateConsumerConfig.EncryptionConsumerConfImpl eConfig = (PrivateConsumerConfig.EncryptionConsumerConfImpl)obj;
                PrivateCommonConfig.AlgorithmConfImpl aConfig = eConfig._dataEncryptionMethod;
                algorithm = aConfig._algorithm;
                break;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Decryption algorithm :" + algorithm);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAlgorithmFromConsumerConfig()");
        }
        return algorithm;
    }

    private static String getAlgorithmFromGeneratorConfig(PrivateGeneratorConfig config) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAlgorithmFromGeneratorConfig()");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Config  :" + config);
        }
        String algorithm = null;
        if (config != null) {
            for (Object obj : config.getOperationGenerators()) {
                if (!(obj instanceof EncryptionGeneratorConfig)) continue;
                PrivateGeneratorConfig.EncryptionGeneratorConfImpl eConfig = (PrivateGeneratorConfig.EncryptionGeneratorConfImpl)obj;
                PrivateCommonConfig.AlgorithmConfImpl aConfig = eConfig._dataEncryptionMethod;
                algorithm = aConfig._algorithm;
                break;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Encryption algorithm :" + algorithm);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAlgorithmFromGeneratorConfig()");
        }
        return algorithm;
    }

    static {
        HMACSHA1 = "HmacSHA1";
        tc = Tr.register(KRBKeyLocator.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    }
}

