/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.id;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.id.TrustedIDEvaluator;
import com.ibm.wsspi.wssecurity.id.TrustedIDEvaluatorException;
import com.ibm.xml.soapsec.token.UserRegistry;
import java.util.HashSet;
import java.util.Map;

public class TrustedIDEvaluatorImpl
implements TrustedIDEvaluator {
    protected static UserRegistry registry = UserRegistry.getInstance();
    protected HashSet list = new HashSet();
    protected String currentRealm = null;
    private static final TraceComponent tc = Tr.register(TrustedIDEvaluatorImpl.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = TrustedIDEvaluator.class.getName();

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        for (Object key : map.keySet()) {
            if (!(key instanceof String) || !((String)key).startsWith("trustedId_")) continue;
            String value = (String)map.get(key);
            String encoded = KeyInfo.X509Data.encodeDName((String)value);
            if (encoded == null || encoded.length() == 0) {
                this.list.add(value);
                continue;
            }
            this.list.add(encoded);
        }
        this.currentRealm = registry.getRealm();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    public boolean evaluate(String id) throws TrustedIDEvaluatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "evaluate(String id[" + id + "])");
        }
        if (id == null) {
            return false;
        }
        for (String trustedId : this.list) {
            int atmark = trustedId.indexOf(64);
            if (atmark >= 0) {
                String username = trustedId.substring(0, atmark);
                String realm = trustedId.substring(atmark + 1);
                if (!this.currentRealm.equals(realm) || !id.equals(username)) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "evaluate(String id): return true");
                }
                return true;
            }
            if (!id.equals(trustedId)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "evaluate(String id): return true");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "evaluate(String id): return false");
        }
        return false;
    }
}

