/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.config;

import com.ibm.ws.webservices.wssecurity.util.CORBAHelper;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocatorException;
import com.ibm.wsspi.wssecurity.config.KeyStoreKeyLocator;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;

public class WSIdKeyStoreMapKeyLocator
extends KeyStoreKeyLocator {
    private static final TraceComponent tc = Tr.register(WSIdKeyStoreMapKeyLocator.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private Map secName2KeyName = new HashMap();

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(map)");
        }
        super.init(map);
        for (String name : map.keySet()) {
            if (!name.startsWith("id_")) continue;
            String secName = (String)map.get(name);
            String keyName = (String)map.get("mappedName_" + name.substring("id_".length()));
            this.secName2KeyName.put(secName, keyName);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("init() - " + name + ": secName \"" + secName + "\" maps to keyName \"" + keyName + "\""));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init()");
        }
    }

    public Key getEncryptionKey(String name, Object context) throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getEncryptionKey(" + name + "," + context + ")"));
        }
        Key key = super.getEncryptionKey(this.getKeyName(), context);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEncryptionKey(String name, Object context) returns " + key));
        }
        return key;
    }

    public Certificate getCertificate(String name) throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getCertificate(" + name + ")"));
        }
        Certificate cert = super.getCertificate(this.getKeyName());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCertificate(String name) returns " + cert));
        }
        return cert;
    }

    private String getKeyName() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getKeyName()");
        }
        String secName = WSIdKeyStoreMapKeyLocator.unqualifySecurityName(CORBAHelper.getSecurityName());
        String keyName = null;
        if (this.secName2KeyName.containsKey(secName)) {
            keyName = (String)this.secName2KeyName.get(secName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getKeyName() returns " + keyName));
        }
        return keyName;
    }

    private static String unqualifySecurityName(String qualifiedSecurityName) {
        int idx;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Qualified security name: " + qualifiedSecurityName));
        }
        String securityName = qualifiedSecurityName;
        if (qualifiedSecurityName != null && qualifiedSecurityName.length() != 0 && (idx = qualifiedSecurityName.indexOf("/")) != -1) {
            securityName = qualifiedSecurityName.substring(idx + 1);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Security name: " + securityName));
        }
        return securityName;
    }
}

